/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.infomap;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.wadmin.transforms.infomap.InfoMapFiltersPanel;
import com.sas.wadmin.transforms.infomap.InfoMapHandler;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.visuals.GroupSelectorDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class InfoMapOptionsPanel
extends WAPanel {
    private static WAdminResource bundle = new WAdminResource(InfoMapFiltersPanel.class);
    protected Root m_metadata = null;
    private JPanel _namePanel = null;
    private JLabel m_lblInfoMapName = null;
    private WATextField m_txtInfoMapName = null;
    private JLabel m_lblInfoMapPath = null;
    private WATextField m_txtInfoMapPath = null;
    private WsAbstractAction m_actBrowse = null;
    private JButton m_browseBtn = null;
    private String _oldInfoMapNameValue = "";
    private String _oldInfoMapPathValue = "";

    public InfoMapOptionsPanel(CMetadata metaObject) {
        this.m_metadata = (Root)metaObject;
        this.initialize();
        this.layoutWidgets();
    }

    public void initialize() {
        this.createActions();
        this.m_lblInfoMapName = new JLabel(bundle.getString("InfoMapOptionsPanel.Label.InfoMapName.txt"));
        this.m_lblInfoMapName.setDisplayedMnemonic(bundle.getString("InfoMapOptionsPanel.Label.InfoMapName.mnem").charAt(0));
        this.m_txtInfoMapName = new WATextField();
        this.m_txtInfoMapName.setMaxCharacters(50);
        this.m_lblInfoMapName.setLabelFor((Component)this.m_txtInfoMapName);
        this.m_lblInfoMapPath = new JLabel(bundle.getString("InfoMapOptionsPanel.Label.InfoMapPath.txt"));
        this.m_lblInfoMapPath.setDisplayedMnemonic(bundle.getString("InfoMapOptionsPanel.Label.InfoMapPath.mnem").charAt(0));
        this.m_txtInfoMapPath = new WATextField();
        this.m_txtInfoMapPath.setBehavior(2);
        this.m_lblInfoMapPath.setLabelFor((Component)this.m_txtInfoMapPath);
        this.createNamePanelNew();
    }

    protected void createActions() {
        this.m_actBrowse = new BrowseAction();
    }

    private void createNamePanelNew() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this._namePanel = new JPanel(gridBagLayout);
        this.m_browseBtn = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actBrowse);
        this.m_lblInfoMapPath.setDisplayedMnemonic(bundle.getString("InfoMapOptionsPanel.Label.InfoMapPath.mnem").charAt(0));
        this._namePanel.add((Component)this.m_lblInfoMapName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this._namePanel.add((Component)this.m_txtInfoMapName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this._namePanel.add((Component)this.m_lblInfoMapPath, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this._namePanel.add((Component)this.m_txtInfoMapPath, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this._namePanel.add((Component)this.m_browseBtn, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
    }

    protected void layoutWidgets() {
        this.setLayout(new BorderLayout());
        this.add(this._namePanel, "North");
    }

    public boolean validateData() {
        String name = this.m_txtInfoMapName.getText().trim();
        if (name.length() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), bundle.getString("InfoMapOptionsPanel.NoInfoMapName.msg.txt"), bundle.getString("InfoMapOptionsPanel.EnterValue.msg.txt"), 1);
            this.m_txtInfoMapName.requestFocus();
            return false;
        }
        String path = this.m_txtInfoMapPath.getText().trim();
        if (path.length() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), bundle.getString("InfoMapOptionsPanel.NoInfoMapPath.msg.txt"), bundle.getString("InfoMapOptionsPanel.SelectPath.msg.txt"), 1);
            this.m_browseBtn.requestFocus();
            return false;
        }
        return true;
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        Vector<String> lAssociations = new Vector<String>();
        lAssociations.add("PropertySets");
        Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.m_metadata, null, lAssociations, null, 8, true);
        this.setStorePopulated(true);
    }

    public void moveDataToView() throws MdException, RemoteException {
        int i;
        this.setListeningForChanges(false);
        AssociationList alPropertySets = this.m_metadata.getPropertySets();
        AssociationList allProperties = null;
        for (i = 0; i < alPropertySets.size(); ++i) {
            PropertySet propertySet = (PropertySet)alPropertySets.get(i);
            if (!propertySet.getSetRole().equalsIgnoreCase(InfoMapHandler.PROPERTYSET_ROLE_OPTION)) continue;
            allProperties = propertySet.getProperties();
            break;
        }
        this.m_txtInfoMapName.setText("");
        this.m_txtInfoMapPath.setText("");
        if (allProperties != null) {
            for (i = 0; i < allProperties.size(); ++i) {
                Property oProperty = (Property)allProperties.get(i);
                if (oProperty.getName().trim().equalsIgnoreCase(InfoMapHandler.INFOMAP_NAME)) {
                    this._oldInfoMapNameValue = oProperty.getDefaultValue().trim();
                    this.m_txtInfoMapName.setText(this._oldInfoMapNameValue);
                    continue;
                }
                if (!oProperty.getName().trim().equalsIgnoreCase(InfoMapHandler.INFOMAP_PATH)) continue;
                this._oldInfoMapPathValue = oProperty.getDefaultValue().trim();
                this.m_txtInfoMapPath.setText(this._oldInfoMapPathValue);
            }
        }
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (!this.hasDataChanged()) {
            return;
        }
        String infoMapNameValue = this.m_txtInfoMapName.getText().trim();
        String infoMapPathValue = this.m_txtInfoMapPath.getText().trim();
        AssociationList allPropertySets = this.m_metadata.getPropertySets(false);
        PropertySet optionsPropertySet = null;
        for (int i = 0; i < allPropertySets.size() && !(optionsPropertySet = (PropertySet)allPropertySets.get(i)).getSetRole().equalsIgnoreCase(InfoMapHandler.PROPERTYSET_ROLE_OPTION); ++i) {
            optionsPropertySet = null;
        }
        if (optionsPropertySet == null) {
            optionsPropertySet = (PropertySet)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_metadata.getObjectStore(), InfoMapHandler.PROPERTYSET_ROLE_OPTION, "PropertySet", this.m_metadata.getRepositoryID());
            optionsPropertySet.setSetRole(InfoMapHandler.PROPERTYSET_ROLE_OPTION);
            AssociationList allProperties = optionsPropertySet.getProperties();
            Property nameProperty = (Property)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_metadata.getObjectStore(), InfoMapHandler.INFOMAP_NAME, "Property", this.m_metadata.getRepositoryID());
            PropertyType namePropertyType = (PropertyType)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_metadata.getObjectStore(), "String", "PropertyType", this.m_metadata.getRepositoryID());
            namePropertyType.setSQLType(12);
            nameProperty.setName(InfoMapHandler.INFOMAP_NAME);
            nameProperty.setDefaultValue(infoMapNameValue);
            nameProperty.setOwningType(namePropertyType);
            Property pathProperty = (Property)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_metadata.getObjectStore(), InfoMapHandler.INFOMAP_PATH, "Property", this.m_metadata.getRepositoryID());
            PropertyType pathPropertyType = (PropertyType)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_metadata.getObjectStore(), "String", "PropertyType", this.m_metadata.getRepositoryID());
            pathPropertyType.setSQLType(12);
            pathProperty.setName(InfoMapHandler.INFOMAP_PATH);
            pathProperty.setDefaultValue(infoMapPathValue);
            pathProperty.setOwningType(pathPropertyType);
            allProperties.add((Object)nameProperty);
            allProperties.add((Object)pathProperty);
            optionsPropertySet.setProperties(allProperties);
            allPropertySets.add((Object)optionsPropertySet);
            this.m_metadata.setPropertySets(allPropertySets);
        } else {
            AssociationList allProperties = optionsPropertySet.getProperties();
            int nProperties = allProperties.size();
            for (int i = 0; i < nProperties; ++i) {
                Property oProperty = (Property)allProperties.get(i);
                if (oProperty.getName().trim().equalsIgnoreCase(InfoMapHandler.INFOMAP_NAME)) {
                    oProperty.setDefaultValue(infoMapNameValue);
                }
                if (!oProperty.getName().trim().equalsIgnoreCase(InfoMapHandler.INFOMAP_PATH)) continue;
                oProperty.setDefaultValue(infoMapPathValue);
            }
        }
        this._oldInfoMapNameValue = infoMapPathValue;
        this._oldInfoMapPathValue = infoMapPathValue;
    }

    public boolean hasDataChanged() {
        boolean hasDataChanged = false;
        String infoMapNameValue = this.m_txtInfoMapName.getText().trim();
        String infoMapPathValue = this.m_txtInfoMapPath.getText().trim();
        if (!this._oldInfoMapNameValue.equals(infoMapNameValue)) {
            hasDataChanged = true;
        } else if (!this._oldInfoMapPathValue.equals(infoMapPathValue)) {
            hasDataChanged = true;
        }
        return hasDataChanged;
    }

    class BrowseAction
    extends WsAbstractAction {
        public BrowseAction() {
            super(bundle, "InfoMapOptionsPanel.Browse");
        }

        public void actionPerformed(ActionEvent ae) {
            GroupSelectorDialog dialog = new GroupSelectorDialog();
            dialog.show();
            if (dialog.getReturnValue() == 1) {
                Tree selectedTree = dialog.getSelectedTree();
                this.setCustomTreePath(selectedTree);
            }
        }

        protected void setCustomTreePath(Tree m_oTree) {
            StringBuffer sbPath = new StringBuffer();
            String separator = "/";
            if (m_oTree != null) {
                try {
                    for (Tree oTree = m_oTree; oTree != null; oTree = oTree.getParentTree()) {
                        sbPath.insert(0, oTree.getName());
                        sbPath.insert(0, separator);
                    }
                }
                catch (MdException e) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
            InfoMapOptionsPanel.this.m_txtInfoMapPath.setText(sbPath.toString());
        }
    }
}

