/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.hpf;

import com.sas.workspace.WAdminResource;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;

public class NameValueComboBoxModel
extends DefaultComboBoxModel {
    private static WAdminResource bundle = WAdminResource.getBundle(NameValueComboBoxModel.class);
    private String m_bundleKey;
    private boolean m_bSorted = false;

    public NameValueComboBoxModel(String bundleKey, boolean sorted) {
        this.m_bundleKey = bundleKey;
        this.m_bSorted = sorted;
    }

    public NameValueComboBoxModel addItem(String value) {
        String name = bundle.getRawString(this.m_bundleKey + "." + value + ".desc.txt");
        if (name == null) {
            name = "";
        }
        NameValueObject object = new NameValueObject(value, name);
        if (this.m_bSorted) {
            int x;
            int iElement;
            String sObject = object.toString();
            int nElements = this.getSize();
            for (iElement = 0; iElement < nElements && (x = sObject.compareToIgnoreCase(this.getElementAt(iElement).toString())) >= 0; ++iElement) {
            }
            super.insertElementAt(object, iElement);
        } else {
            super.addElement(object);
        }
        return this;
    }

    public String getSelectedValue() {
        if (this.getSelectedItem() instanceof NameValueObject) {
            return ((NameValueObject)this.getSelectedItem()).getValue();
        }
        return this.getSelectedItem().toString();
    }

    public void setSelectedValue(String value) {
        String strValue = value;
        for (int i = 0; i < this.getSize(); ++i) {
            NameValueObject n = (NameValueObject)this.getElementAt(i);
            if (!strValue.equals(n.getValue())) continue;
            super.setSelectedItem(n);
            return;
        }
    }

    public List getValueList() {
        ArrayList<String> valueList = new ArrayList<String>();
        for (int i = 0; i < this.getSize(); ++i) {
            valueList.add(((NameValueObject)this.getElementAt(i)).getValue());
        }
        return valueList;
    }

    public String getBundleKey() {
        return this.m_bundleKey;
    }

    public void setBundleKey(String key) {
        this.m_bundleKey = key;
    }

    private class NameValueObject {
        private String m_name;
        private String m_value;

        public NameValueObject(String value, String name) {
            this.m_name = !value.equals(name) && name.length() > 0 ? name + " (" + value + ")" : value;
            this.m_value = value;
        }

        public String toString() {
            return this.m_name;
        }

        public String getName() {
            return this.m_name;
        }

        public String getValue() {
            return this.m_value;
        }
    }
}

