/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.hpf;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IDocument;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.hpf.HPFTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.wadmin.app.AppPropertiesDialogFactory;
import com.sas.wadmin.transforms.hpf.HPFDualListSelector;
import com.sas.wadmin.transforms.hpf.NameValueListModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.metadata.WsMetadataNameUtil;
import com.sas.workspace.models.SimpleObject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.JTextComponent;

public class HPFPropertyTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(HPFPropertyTab.class);
    private HPFTransformModel m_hpf;
    private JLabel m_lblLead;
    private WAIntTextField m_txtLead;
    private JLabel m_lblBack;
    private WAIntTextField m_txtBack;
    private JLabel m_lblSeasonality;
    private WAIntTextField m_txtSeasonality;
    private JCheckBox m_chkSortnames;
    private JPanel m_panPrinting;
    private TitledBorder m_titledBorder;
    private DualListSelector m_dlsPrint;
    private NameValueListModel m_lstPrintSource;
    private NameValueListModel m_lstPrintTarget;
    private DualListSelector m_dlsPlot;
    private NameValueListModel m_lstPlotSource;
    private NameValueListModel m_lstPlotTarget;
    private JCheckBox m_chkPrintDetails;
    private JCheckBox m_chkPrinttoOutput;
    private JButton m_butReportProps;
    private JButton m_butReset;
    private boolean m_Cancel = false;
    private IModelListener m_lsnrModel;
    private ListDataListener lsnrItemsChanged;
    private FocusListener lsnrFocus;
    private cResetDefaultsAction m_resetDefaultsAction;
    private WsAbstractToggleAction m_actSortNames;
    private WsAbstractToggleAction m_actPrintDetails;
    private WsAbstractToggleAction m_actPrintToOutput;
    private boolean m_bEditHappening;

    public HPFPropertyTab(HPFTransformModel hpf) {
        this.m_hpf = hpf;
        this.setHelpTopic("hpf_tab");
        this.setName(bundle.getString("HPFPropertyTab.Name.txt"));
        this.m_lsnrModel = new ModelListener();
        hpf.getModel().addModelListener(this.m_lsnrModel);
        this.initialize();
        this.setPreferredSize(new Dimension(200, 200));
    }

    protected void initialize() {
        this.m_lstPrintSource = new NameValueListModel("HPFPropertyTab.Print", true);
        this.m_lstPrintTarget = new NameValueListModel("HPFPropertyTab.Print", true);
        this.m_lstPlotSource = new NameValueListModel("HPFPropertyTab.Plot", true);
        this.m_lstPlotTarget = new NameValueListModel("HPFPropertyTab.Plot", true);
        this.setupPrintSourceModels();
        this.setupPlotSourceModels();
        this.lsnrItemsChanged = new cItemsChangedListener();
        this.m_lstPrintTarget.addListDataListener(this.lsnrItemsChanged);
        this.m_lstPlotTarget.addListDataListener(this.lsnrItemsChanged);
        this.m_lstPrintSource.addListDataListener(this.lsnrItemsChanged);
        this.m_lstPlotSource.addListDataListener(this.lsnrItemsChanged);
        this.lsnrFocus = new cFocusListener();
        this.createActions();
        this.m_txtLead = new WAIntTextField();
        this.m_lblLead = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtLead, (WAdminResource)bundle, (String)"HPFPropertyTab.Lead");
        this.listenForDataChangesTo((JTextComponent)this.m_txtLead);
        this.m_txtLead.setMaxCharacters(10);
        this.m_txtLead.addFocusListener(this.lsnrFocus);
        this.m_txtBack = new WAIntTextField();
        this.m_lblBack = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtBack, (WAdminResource)bundle, (String)"HPFPropertyTab.Back");
        this.listenForDataChangesTo((JTextComponent)this.m_txtBack);
        this.m_txtBack.setMaxCharacters(10);
        this.m_txtBack.addFocusListener(this.lsnrFocus);
        this.m_txtSeasonality = new WAIntTextField();
        this.m_lblSeasonality = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtSeasonality, (WAdminResource)bundle, (String)"HPFPropertyTab.Seasonality");
        this.listenForDataChangesTo((JTextComponent)this.m_txtSeasonality);
        this.m_txtSeasonality.addFocusListener(this.lsnrFocus);
        this.m_chkSortnames = WsUIUtilities.createCheckBox((WsAbstractToggleAction)this.m_actSortNames);
        this.listenForDataChangesTo(this.m_chkSortnames);
        this.m_panPrinting = new JPanel();
        this.m_titledBorder = WsUIUtilities.createTitledBorder((String)bundle.getString("HPFPropertyTab.PrintPanel.title.txt"));
        this.m_panPrinting.setBorder(this.m_titledBorder);
        this.m_dlsPrint = new HPFDualListSelector(this.m_hpf.getModel());
        this.m_dlsPrint.setSourceLabel(bundle.getString("HPFPropertyTab.PrintListSource.txt"));
        this.m_dlsPrint.getSourceComponent().setToolTipText(bundle.getString("HPFPropertyTab.PrintListSource.tip"));
        ((JLabel)this.m_dlsPrint.getSourceLabelComponent()).setDisplayedMnemonic(bundle.getString("HPFPropertyTab.PrintListSource.mnem").charAt(0));
        this.m_dlsPrint.setTargetLabel(bundle.getString("HPFPropertyTab.PrintListTarget.txt"));
        this.m_dlsPrint.getTargetComponent().setToolTipText(bundle.getString("HPFPropertyTab.PrintListTarget.tip"));
        ((JLabel)this.m_dlsPrint.getTargetLabelComponent()).setDisplayedMnemonic(bundle.getString("HPFPropertyTab.PrintListTarget.mnem").charAt(0));
        this.m_dlsPrint.setPreferredSize(new Dimension(100, 125));
        this.m_dlsPrint.setDragAndDropEnabled(false);
        this.m_dlsPrint.setAlternatingSingleButtonStyle(false);
        this.m_dlsPlot = new HPFDualListSelector(this.m_hpf.getModel());
        this.m_dlsPlot.setSourceLabel(bundle.getString("HPFPropertyTab.PlotListSource.txt"));
        this.m_dlsPlot.getSourceComponent().setToolTipText(bundle.getString("HPFPropertyTab.PlotListSource.tip"));
        ((JLabel)this.m_dlsPlot.getSourceLabelComponent()).setDisplayedMnemonic(bundle.getString("HPFPropertyTab.PlotListSource.mnem").charAt(0));
        this.m_dlsPlot.setTargetLabel(bundle.getString("HPFPropertyTab.PlotListTarget.txt"));
        this.m_dlsPlot.getTargetComponent().setToolTipText(bundle.getString("HPFPropertyTab.PlotListTarget.tip"));
        ((JLabel)this.m_dlsPlot.getTargetLabelComponent()).setDisplayedMnemonic(bundle.getString("HPFPropertyTab.PlotListTarget.mnem").charAt(0));
        this.m_dlsPlot.setPreferredSize(new Dimension(100, 125));
        this.m_dlsPlot.setDragAndDropEnabled(false);
        this.m_dlsPlot.setAlternatingSingleButtonStyle(false);
        this.m_chkPrintDetails = WsUIUtilities.createCheckBox((WsAbstractToggleAction)this.m_actPrintDetails);
        this.listenForDataChangesTo(this.m_chkPrintDetails);
        this.m_chkPrinttoOutput = WsUIUtilities.createCheckBox((WsAbstractToggleAction)this.m_actPrintToOutput);
        this.listenForDataChangesTo(this.m_chkPrinttoOutput);
        this.m_butReportProps = WsUIUtilities.createTextButton((WsAbstractAction)new cReportAction());
        this.m_butReset = WsUIUtilities.createTextButton((WsAbstractAction)this.m_resetDefaultsAction);
        this.setLayout(new GridBagLayout());
        this.m_panPrinting.setLayout(new GridBagLayout());
        this.add(this.m_lblLead, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.m_txtLead, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add(this.m_lblBack, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)this.m_txtBack, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_lblSeasonality, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)this.m_txtSeasonality, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_chkSortnames, new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_panPrinting, new GridBagConstraints(0, 4, 4, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 10, 0), 0, 0));
        this.m_panPrinting.add((Component)this.m_dlsPrint, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_panPrinting.add((Component)this.m_dlsPlot, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_panPrinting.add((Component)this.m_chkPrintDetails, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.m_panPrinting.add((Component)this.m_chkPrinttoOutput, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.m_panPrinting.add((Component)this.m_butReportProps, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 14, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_butReset, new GridBagConstraints(0, 5, 4, 1, 0.0, 0.0, 14, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.m_bEditHappening = false;
    }

    protected void createActions() {
        this.m_resetDefaultsAction = new cResetDefaultsAction();
        this.m_actSortNames = new cSortNamesCheckBoxAction();
        this.m_actPrintDetails = new cPrintDetailsCheckBoxAction();
        this.m_actPrintToOutput = new cPrintToOutputCheckBoxAction();
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_txtLead.setText(Integer.toString(this.m_hpf.getLead()));
        this.m_txtBack.setText(Integer.toString(this.m_hpf.getBack()));
        this.m_txtSeasonality.setText(this.m_hpf.getSeasonality());
        this.m_chkSortnames.setSelected(this.m_hpf.isSortedVariables());
        this.m_lstPrintTarget.removeAllElements();
        String[] printList = this.m_hpf.getSelectedPrintOptions();
        for (int i = 0; i < printList.length; ++i) {
            this.m_lstPrintTarget.addItem(printList[i]);
            this.m_lstPrintSource.removeItem(printList[i]);
        }
        this.m_dlsPrint.setModel((ListModel)this.m_lstPrintSource);
        this.m_dlsPrint.setTargetModel((ListModel)this.m_lstPrintTarget);
        this.m_lstPlotTarget.removeAllElements();
        String[] plotList = this.m_hpf.getSelectedPlotOptions();
        for (int i = 0; i < plotList.length; ++i) {
            this.m_lstPlotTarget.addItem(plotList[i]);
            this.m_lstPlotSource.removeItem(plotList[i]);
        }
        this.m_dlsPlot.setModel((ListModel)this.m_lstPlotSource);
        this.m_dlsPlot.setTargetModel((ListModel)this.m_lstPlotTarget);
        this.setPrintPlotEnabled();
        this.m_chkPrintDetails.setSelected(this.m_hpf.isGreaterDetails());
        this.m_chkPrinttoOutput.setSelected(this.m_hpf.isOutputWindow());
        this.setListeningForChanges(true);
        this.setDataChanged(false);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        try {
            this.m_hpf.setLead(this.m_txtLead.getValue2());
            this.m_hpf.setBack(this.m_txtBack.getValue2());
            this.m_hpf.setSeasonality(this.m_txtSeasonality.getText());
        }
        catch (WAIntTextField.IllegalIntegerException illegalIntegerException) {
            // empty catch block
        }
    }

    private void setupPrintSourceModels() {
        this.m_lstPrintSource.addItem("ESTIMATES");
        this.m_lstPrintSource.addItem("FORECASTS");
        this.m_lstPrintSource.addItem("PERFORMANCE");
        this.m_lstPrintSource.addItem("PERFORMANCEOVERALL");
        this.m_lstPrintSource.addItem("PERFORMANCESUMMARY");
        this.m_lstPrintSource.addItem("SEASONS");
        this.m_lstPrintSource.addItem("STATES");
        this.m_lstPrintSource.addItem("STATISTICS");
        this.m_lstPrintSource.addItem("SUMMARY");
        this.m_lstPrintSource.addItem("TRENDS");
    }

    private void setupPlotSourceModels() {
        this.m_lstPlotSource.addItem("ACF");
        this.m_lstPlotSource.addItem("ERRORS");
        this.m_lstPlotSource.addItem("FORECASTS");
        this.m_lstPlotSource.addItem("FORECASTSONLY");
        this.m_lstPlotSource.addItem("IACF");
        this.m_lstPlotSource.addItem("LEVELS");
        this.m_lstPlotSource.addItem("MODELS");
        this.m_lstPlotSource.addItem("MODELFORECASTS");
        this.m_lstPlotSource.addItem("PACF");
        this.m_lstPlotSource.addItem("SEASONS");
        this.m_lstPlotSource.addItem("TRENDS");
        this.m_lstPlotSource.addItem("WN");
    }

    public boolean validateData() {
        try {
            this.m_txtLead.getValue2();
        }
        catch (WAIntTextField.IllegalIntegerException e) {
            MessageUtil.displayMessage((String)bundle.formatString("Common.Decimal.Error.txt", (Object)this.m_txtLead.getText()), (int)0);
            this.m_txtLead.requestFocus();
            return false;
        }
        try {
            this.m_txtBack.getValue2();
        }
        catch (WAIntTextField.IllegalIntegerException e) {
            MessageUtil.displayMessage((String)bundle.formatString("Common.Decimal.Error.txt", (Object)this.m_txtBack.getText()), (int)0);
            this.m_txtBack.requestFocus();
            return false;
        }
        return true;
    }

    public void onParentApply() {
        if (this.hasBeenShown()) {
            this.updateDocument();
        }
    }

    public void onParentCancel() {
        this.m_Cancel = true;
    }

    public void saveSettingsAndCleanUp() {
        if (!this.m_Cancel && this.hasBeenShown()) {
            this.updateDocument();
        }
        this.m_hpf.getModel().removeModelListener(this.m_lsnrModel);
        this.m_lstPrintTarget.removeListDataListener(this.lsnrItemsChanged);
        this.m_lstPlotTarget.removeListDataListener(this.lsnrItemsChanged);
        this.m_lstPrintSource.removeListDataListener(this.lsnrItemsChanged);
        this.m_lstPlotSource.removeListDataListener(this.lsnrItemsChanged);
        this.m_txtLead.removeFocusListener(this.lsnrFocus);
        this.m_txtBack.removeFocusListener(this.lsnrFocus);
        this.m_txtSeasonality.removeFocusListener(this.lsnrFocus);
        this.m_chkSortnames.removeActionListener((ActionListener)this.m_actSortNames);
        this.m_chkPrintDetails.removeActionListener((ActionListener)this.m_actPrintDetails);
        this.m_chkPrinttoOutput.removeActionListener((ActionListener)this.m_actPrintToOutput);
        super.saveSettingsAndCleanUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDocument() {
        boolean bNeedDoc = this.m_hpf.getSelectedPlotOptions().length > 0 || this.m_hpf.getSelectedPrintOptions().length > 0;
        IDocument doc = this.m_hpf.getHPFDocument();
        if (bNeedDoc && doc == null) {
            String sDocumentName = "";
            sDocumentName = WsMetadataNameUtil.getUniqueNameForType((String)"Document", (String)bundle.getString("HPF.DefaultReportName.txt"));
            this.m_hpf.getModel().startCompoundUndoable();
            try {
                doc = this.m_hpf.createHPFDocument(sDocumentName);
                this.m_hpf.addDataTarget((IDataObject)doc);
            }
            finally {
                this.m_hpf.getModel().endCompoundUndoable();
            }
        } else if (!bNeedDoc && doc != null) {
            this.m_hpf.removeDataTarget((IDataObject)doc);
        }
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.m_txtLead.setEnabled(editable);
        this.m_txtBack.setEnabled(editable);
        this.m_txtSeasonality.setEnabled(editable);
        this.m_chkSortnames.setEnabled(editable);
        this.m_dlsPrint.setEnabled(editable);
        this.m_dlsPlot.setEnabled(editable);
        this.m_chkPrintDetails.setEnabled(editable);
        this.m_chkPrinttoOutput.setEnabled(editable);
        this.m_butReset.setEnabled(editable);
        this.m_resetDefaultsAction.setEnabled(editable);
    }

    private void setPrintPlotEnabled() {
        if (this.isEditable() && (this.m_lstPlotTarget.size() > 0 || this.m_lstPrintTarget.size() > 0)) {
            if (this.m_lstPrintTarget.size() > 0) {
                this.m_chkPrintDetails.setEnabled(true);
                this.m_chkPrinttoOutput.setEnabled(true);
            } else {
                this.m_chkPrintDetails.setSelected(false);
                this.m_chkPrinttoOutput.setSelected(false);
                this.m_chkPrintDetails.setEnabled(false);
                this.m_chkPrinttoOutput.setEnabled(false);
            }
            IDocument iDoc = this.m_hpf.getHPFDocument();
            if (iDoc != null) {
                this.m_butReportProps.setEnabled(true);
            } else {
                this.m_butReportProps.setEnabled(false);
            }
        } else {
            if (this.isEditable()) {
                this.m_chkPrintDetails.setSelected(false);
                this.m_chkPrinttoOutput.setSelected(false);
            }
            this.m_chkPrintDetails.setEnabled(false);
            this.m_chkPrinttoOutput.setEnabled(false);
            this.m_butReportProps.setEnabled(false);
        }
    }

    private void resetToDefaultValues() {
        this.m_hpf.getModel().startCompoundUndoable();
        try {
            String sOption;
            int i;
            this.m_hpf.setLead(12);
            this.m_hpf.setBack(0);
            this.m_hpf.setSeasonality("");
            this.m_hpf.setSortedVariables(false);
            this.m_hpf.setGreaterDetails(false);
            this.m_hpf.setOutputWindow(false);
            for (i = this.m_lstPrintTarget.size(); i > 0; --i) {
                sOption = this.m_lstPrintTarget.getValue(i - 1);
                this.m_hpf.removePrintOption(sOption);
            }
            for (i = this.m_lstPlotTarget.size(); i > 0; --i) {
                sOption = this.m_lstPlotTarget.getValue(i - 1);
                this.m_hpf.removePlotOption(sOption);
            }
        }
        finally {
            this.m_hpf.getModel().endCompoundUndoable();
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            if (sType.compareToIgnoreCase("HPFTransform:LeadChanged") == 0) {
                HPFPropertyTab.this.m_txtLead.setText(Integer.toString(HPFPropertyTab.this.m_hpf.getLead()));
            } else if (sType.compareToIgnoreCase("HPFTransform:BackChanged") == 0) {
                HPFPropertyTab.this.m_txtBack.setText(Integer.toString(HPFPropertyTab.this.m_hpf.getBack()));
            } else if (sType.compareToIgnoreCase("HPFTransform:SeasonalityChanged") == 0) {
                HPFPropertyTab.this.m_txtSeasonality.setText(HPFPropertyTab.this.m_hpf.getSeasonality());
            } else if (sType.compareToIgnoreCase("HPFTransform:SortedVariablesChanged") == 0) {
                HPFPropertyTab.this.m_chkSortnames.setSelected(HPFPropertyTab.this.m_hpf.isSortedVariables());
            } else if (sType.compareToIgnoreCase("HPFTransform:GreaterDetailsChanged") == 0) {
                HPFPropertyTab.this.m_chkPrintDetails.setSelected(HPFPropertyTab.this.m_hpf.isGreaterDetails());
            } else if (sType.compareToIgnoreCase("HPFTransform:OutputWindowChanged") == 0) {
                HPFPropertyTab.this.m_chkPrinttoOutput.setSelected(HPFPropertyTab.this.m_hpf.isOutputWindow());
            } else if (sType.compareToIgnoreCase("HPFTransform:PlotOptionAdded") == 0) {
                if (HPFPropertyTab.this.m_bEditHappening) {
                    return;
                }
                String sOpt = (String)ev.getData();
                HPFPropertyTab.this.m_lstPlotSource.removeItem(sOpt);
                HPFPropertyTab.this.m_lstPlotTarget.addItem(sOpt);
            } else if (sType.compareToIgnoreCase("HPFTransform:PlotOptionRemoved") == 0) {
                if (HPFPropertyTab.this.m_bEditHappening) {
                    return;
                }
                String sOpt = (String)ev.getData();
                HPFPropertyTab.this.m_lstPlotSource.addItem(sOpt);
                HPFPropertyTab.this.m_lstPlotTarget.removeItem(sOpt);
            } else if (sType.compareToIgnoreCase("HPFTransform:PrintOptionAdded") == 0) {
                if (HPFPropertyTab.this.m_bEditHappening) {
                    return;
                }
                String sOpt = (String)ev.getData();
                HPFPropertyTab.this.m_lstPrintSource.removeItem(sOpt);
                HPFPropertyTab.this.m_lstPrintTarget.addItem(sOpt);
            } else if (sType.compareToIgnoreCase("HPFTransform:PrintOptionRemoved") == 0) {
                if (HPFPropertyTab.this.m_bEditHappening) {
                    return;
                }
                String sOpt = (String)ev.getData();
                HPFPropertyTab.this.m_lstPrintSource.addItem(sOpt);
                HPFPropertyTab.this.m_lstPrintTarget.removeItem(sOpt);
            }
        }
    }

    private class cItemsChangedListener
    implements ListDataListener {
        private cItemsChangedListener() {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void intervalAdded(ListDataEvent e) {
            HPFPropertyTab.this.setDataChanged(true);
            HPFPropertyTab.this.m_hpf.getModel().startCompoundUndoable();
            try {
                HPFPropertyTab.this.m_bEditHappening = true;
                if (HPFPropertyTab.this.m_lstPlotTarget == e.getSource()) {
                    for (int i = e.getIndex0(); i <= e.getIndex1(); ++i) {
                        String sOption = HPFPropertyTab.this.m_lstPlotTarget.getValue(i);
                        HPFPropertyTab.this.m_hpf.addPlotOption(sOption);
                    }
                } else if (HPFPropertyTab.this.m_lstPrintTarget == e.getSource()) {
                    for (int i = e.getIndex0(); i <= e.getIndex1(); ++i) {
                        String sOption = HPFPropertyTab.this.m_lstPrintTarget.getValue(i);
                        HPFPropertyTab.this.m_hpf.addPrintOption(sOption);
                    }
                } else if (HPFPropertyTab.this.m_lstPlotSource == e.getSource()) {
                    for (int i = e.getIndex0(); i <= e.getIndex1(); ++i) {
                        String sOption = HPFPropertyTab.this.m_lstPlotSource.getValue(i);
                        HPFPropertyTab.this.m_hpf.removePlotOption(sOption);
                    }
                } else if (HPFPropertyTab.this.m_lstPrintSource == e.getSource()) {
                    for (int i = e.getIndex0(); i <= e.getIndex1(); ++i) {
                        String sOption = HPFPropertyTab.this.m_lstPrintSource.getValue(i);
                        HPFPropertyTab.this.m_hpf.removePrintOption(sOption);
                    }
                }
            }
            finally {
                HPFPropertyTab.this.m_hpf.getModel().endCompoundUndoable();
                HPFPropertyTab.this.m_bEditHappening = false;
            }
            HPFPropertyTab.this.setPrintPlotEnabled();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            HPFPropertyTab.this.setDataChanged(true);
            HPFPropertyTab.this.setPrintPlotEnabled();
        }
    }

    private class cFocusListener
    implements FocusListener {
        private cFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent arg0) {
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            try {
                if (arg0.getComponent() == HPFPropertyTab.this.m_txtLead) {
                    HPFPropertyTab.this.m_hpf.setLead(HPFPropertyTab.this.m_txtLead.getValue2());
                } else if (arg0.getComponent() == HPFPropertyTab.this.m_txtBack) {
                    HPFPropertyTab.this.m_hpf.setBack(HPFPropertyTab.this.m_txtBack.getValue2());
                } else if (arg0.getComponent() == HPFPropertyTab.this.m_txtSeasonality) {
                    HPFPropertyTab.this.m_hpf.setSeasonality(HPFPropertyTab.this.m_txtSeasonality.getText());
                }
            }
            catch (WAIntTextField.IllegalIntegerException illegalIntegerException) {
                // empty catch block
            }
        }
    }

    private class cReportAction
    extends WsAbstractAction {
        public cReportAction() {
            super(bundle, "HPFPropertyTab.ReportProperties");
        }

        public void actionPerformed(ActionEvent event) {
            IDocument iDoc = HPFPropertyTab.this.m_hpf.getHPFDocument();
            if (iDoc != null) {
                AppPropertiesDialogFactory.getInstance().showPropertiesDialog((Window)Workspace.getWorkspace(), (SimpleObject)iDoc);
            }
        }
    }

    private class cResetDefaultsAction
    extends WsAbstractAction {
        public cResetDefaultsAction() {
            super(bundle, "PropertyTab.Reset");
        }

        public void actionPerformed(ActionEvent event) {
            HPFPropertyTab.this.resetToDefaultValues();
        }
    }

    protected class cSortNamesCheckBoxAction
    extends WsAbstractToggleAction {
        public cSortNamesCheckBoxAction() {
            super(bundle, "HPFPropertyTab.Sortnames", 0);
        }

        public void actionPerformed(ActionEvent event) {
            HPFPropertyTab.this.m_hpf.setSortedVariables(HPFPropertyTab.this.m_chkSortnames.isSelected());
        }
    }

    protected class cPrintDetailsCheckBoxAction
    extends WsAbstractToggleAction {
        public cPrintDetailsCheckBoxAction() {
            super(bundle, "HPFPropertyTab.PrintDetails", 0);
        }

        public void actionPerformed(ActionEvent event) {
            HPFPropertyTab.this.m_hpf.setGreaterDetails(HPFPropertyTab.this.m_chkPrintDetails.isSelected());
        }
    }

    protected class cPrintToOutputCheckBoxAction
    extends WsAbstractToggleAction {
        public cPrintToOutputCheckBoxAction() {
            super(bundle, "HPFPropertyTab.PrinttoOutput", 0);
        }

        public void actionPerformed(ActionEvent event) {
            HPFPropertyTab.this.m_hpf.setOutputWindow(HPFPropertyTab.this.m_chkPrinttoOutput.isSelected());
        }
    }
}

