/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.hpf;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.workspace.PropertyHandler;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HPFPropertyHandler
extends PropertyHandler {
    public static String HPF_PROPERTY_SET_NAME = "HPFOptions";
    public static String ID_PROPERTY_SET_NAME = "IDOptions";
    public static String FORECAST_PROPERTY_SET_NAME = "FORECASTOptions";
    public static String PRINT_PROPERTY_SET_NAME = "PRINTOptions";
    public static String PLOT_PROPERTY_SET_NAME = "PLOTOptions";
    public static String SORTNAMES = "sortnames";
    public static String LEAD = "lead";
    public static String BACK = "back";
    public static String SEASONALITY = "seasonality";
    public static String PRINTDETAILS = "printdetails";
    public static String USEOUTPUTWINDOW = "useoutputwindow";
    public static String ACCUMULATE = "accumulate";
    public static String NOTSORTED = "notsorted";
    public static String INTERVAL = "interval";
    public static String SETMISSING = "setmissing";
    public static String ZEROMISS = "zeromiss";
    public static String START = "start";
    public static String END = "end";
    public static String INTERVALFORMAT = "intervalformat";
    public static String ALPHA = "alpha";
    public static String MODEL = "model";
    public static String HOLDOUT = "holdout";
    public static String HOLDOUTPCT = "holdoutpct";
    public static String MEDIAN = "median";
    public static String REPLACEMISSING = "replacemissing";
    public static String USE = "use";
    public static String SELECT = "select";
    public static String TRANSFORM = "transform";
    public static String INTERMITTENT = "intermittent";
    public static String ID_VARIABLE_PROPERTY_NAME = "IDVARIABLE";
    public static String FORECAST_VARIABLE_PROPERTY_NAME = "FORECASTVARIABLES";

    public HPFPropertyHandler(Root meta, String setRole) throws MdException, RemoteException {
        super(meta, setRole, true);
    }

    public void deleteProperties() throws MdException, RemoteException {
        AssociationList props;
        if (this.m_propSet != null && (props = this.getPropertyList()) != null) {
            for (int i = props.size() - 1; i >= 0; --i) {
                ((Property)props.get(i)).delete();
            }
        }
    }

    public List getPropertyListValues() throws MdException, RemoteException {
        AssociationList props;
        ArrayList<String> arrList = new ArrayList<String>();
        if (this.m_propSet != null && (props = this.getPropertyList()) != null) {
            for (int i = 0; i < props.size(); ++i) {
                arrList.add(((Property)props.get(i)).getDefaultValue());
            }
        }
        return arrList;
    }

    public String getPropertyNameValue(String propertyName) throws MdException, RemoteException {
        String strValue = "";
        Property prop = this.getSpecificProperty(propertyName);
        if (prop != null) {
            strValue = prop.getUseValueOnly() == 1 ? prop.getDefaultValue() : prop.getPropertyName() + " " + prop.getDelimiter() + " " + prop.getDefaultValue();
        }
        return strValue;
    }

    public void setPropertyColumns(MdObjectStore mdStore, String option, List inColumns) throws MdException, RemoteException {
        if (inColumns != null) {
            this.setSpecificProperty(option, option, "", "", 1, null);
            Property prop = this.getSpecificProperty(option);
            Transformation trans = null;
            if (prop != null) {
                for (int i = 0; i < prop.getSpecTargetTransformations().size() && trans == null; ++i) {
                    Transformation t;
                    if (!((CMetadata)prop.getSpecTargetTransformations().get(i)).getCMetadataType().equals("Transformation") || !(t = (Transformation)prop.getSpecTargetTransformations().get(i)).getTransformRole().equals(option)) continue;
                    trans = t;
                }
                if (trans == null) {
                    trans = (Transformation)Workspace.getMdFactory().createComplexMetadataObject(mdStore, option, "Transformation", prop.getRepositoryID());
                    trans.setTransformRole(option);
                    prop.getSpecTargetTransformations().add((Object)trans);
                }
                trans.getSourceSpecifications().removeAllElements();
                trans.getSourceSpecifications().addAll((Collection)inColumns);
            }
        }
    }

    public Column getPropertyColumn(String optionRole) throws MdException, RemoteException {
        Column col = null;
        List colList = this.getPropertyColumns(optionRole);
        if (colList != null && colList.size() > 0) {
            col = (Column)colList.get(0);
        }
        return col;
    }

    public List getPropertyColumns(String optionRole) throws MdException, RemoteException {
        ArrayList colList = null;
        Property prop = this.getSpecificProperty(optionRole);
        if (prop != null) {
            for (int i = 0; i < prop.getSpecTargetTransformations().size(); ++i) {
                Transformation trans;
                if (!((Root)prop.getSpecTargetTransformations().get(i)).getCMetadataType().equals("Transformation") || !(trans = (Transformation)prop.getSpecTargetTransformations().get(i)).getTransformRole().equals(optionRole)) continue;
                colList = new ArrayList();
                colList.addAll(trans.getSourceSpecifications());
            }
        }
        return colList;
    }
}

