/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.hpf;

import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.ColumnCG;
import com.sas.codegen.WorkTableCG;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Select;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.transforms.hpf.HPFPropertyHandler;
import com.sas.wadmin.transforms.hpf.HPFUtil;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class HPFCodegen {
    private static WAdminResource bundle = WAdminResource.getBundle(HPFCodegen.class);
    private static String m_strIndent;

    public static void executeUtility(CodegenRequest cgReq, ClassifierMap classifierMap) throws MdException, RemoteException {
        String model;
        AssociationList sources = classifierMap.getClassifierSources();
        if (sources.size() <= 0) {
            throw new CodegenException(bundle.getString("HPFCodegen.NoSources.msg.txt"));
        }
        cgReq.checkTargetsForExternalTable(classifierMap);
        cgReq.checkSourcesForExternalTable(classifierMap);
        cgReq.genSystemOptions((AbstractTransformation)classifierMap);
        Document cDoc = HPFUtil.getHPFDocument((TransformationStep)classifierMap.getSteps(false).get(0));
        HPFPropertyHandler printHandler = new HPFPropertyHandler((Root)classifierMap, HPFPropertyHandler.PRINT_PROPERTY_SET_NAME);
        HPFPropertyHandler plotHandler = new HPFPropertyHandler((Root)classifierMap, HPFPropertyHandler.PLOT_PROPERTY_SET_NAME);
        HPFPropertyHandler hpfHandler = new HPFPropertyHandler((Root)classifierMap, HPFPropertyHandler.HPF_PROPERTY_SET_NAME);
        ArrayList lstPrint = new ArrayList();
        if (printHandler.getPropertySet() != null) {
            lstPrint.addAll(printHandler.getPropertyList());
        }
        ArrayList lstPlot = new ArrayList();
        if (plotHandler.getPropertySet() != null) {
            lstPlot.addAll(plotHandler.getPropertyList());
        }
        boolean enablePrint = cDoc != null && (!lstPrint.isEmpty() || !lstPlot.isEmpty());
        m_strIndent = HPFCodegen.buildIndent(9);
        if (enablePrint) {
            String docPath = cDoc.getURI();
            String directory = "";
            String frameFile = "";
            if (docPath.indexOf(47) > -1) {
                directory = docPath.substring(0, docPath.lastIndexOf(47) + 1);
                frameFile = docPath.substring(docPath.lastIndexOf(47) + 1);
            } else if (docPath.indexOf(92) > -1) {
                directory = docPath.substring(0, docPath.lastIndexOf(92) + 1);
                frameFile = docPath.substring(docPath.lastIndexOf(92) + 1);
            } else {
                directory = "";
                frameFile = docPath;
            }
            String contentFile = "";
            String bodyFile = "";
            int dot = frameFile.lastIndexOf(46);
            if (dot <= -1 || dot == frameFile.length() - 1) {
                throw new CodegenException(bundle.messageString("HPFCodegen.DocumentExtensionInvalid.msg.txt", (Object)cDoc.getName()));
            }
            String baseName = frameFile.substring(0, dot);
            String extension = frameFile.substring(dot);
            contentFile = baseName + "_c" + extension;
            bodyFile = baseName + "_b" + extension;
            if (hpfHandler.getSpecificOptionValue(HPFPropertyHandler.USEOUTPUTWINDOW).length() == 0) {
                cgReq.addSourceCode("ods listing close;\n");
            }
            if (!lstPlot.isEmpty()) {
                cgReq.addSourceCode("ods graphics on / imagefmt = JAVA;\n");
            }
            cgReq.addSourceCode("ods html path = \"" + directory + "\" (url = none)\n");
            cgReq.addSourceCode(m_strIndent + "frame = \"" + frameFile + "\"\n");
            cgReq.addSourceCode(m_strIndent + "contents = \"" + contentFile + "\"\n");
            cgReq.addSourceCode(m_strIndent + "body = \"" + bodyFile + "\"\n");
            cgReq.addSourceCode(";\n\n");
        }
        cgReq.addSourceCode("proc hpf data = &SYSLAST\n");
        PhysicalTable outTable = HPFUtil.getHPFWorkTable(classifierMap, "OUT");
        PhysicalTable outestTable = HPFUtil.getHPFWorkTable(classifierMap, "OUTEST");
        PhysicalTable outforTable = HPFUtil.getHPFWorkTable(classifierMap, "OUTFOR");
        PhysicalTable outseasonTable = HPFUtil.getHPFWorkTable(classifierMap, "OUTSEASON");
        PhysicalTable outstatTable = HPFUtil.getHPFWorkTable(classifierMap, "OUTSTAT");
        PhysicalTable outsumTable = HPFUtil.getHPFWorkTable(classifierMap, "OUTSUM");
        PhysicalTable outtrendTable = HPFUtil.getHPFWorkTable(classifierMap, "OUTTREND");
        if (HPFUtil.isOutputActive(outTable)) {
            HPFCodegen.generateOutStatement(cgReq, outTable);
        }
        if (HPFUtil.isOutputActive(outestTable)) {
            HPFCodegen.generateOutStatement(cgReq, outestTable);
        }
        if (HPFUtil.isOutputActive(outforTable)) {
            HPFCodegen.generateOutStatement(cgReq, outforTable);
        }
        if (HPFUtil.isOutputActive(outseasonTable)) {
            HPFCodegen.generateOutStatement(cgReq, outseasonTable);
        }
        if (HPFUtil.isOutputActive(outstatTable)) {
            HPFCodegen.generateOutStatement(cgReq, outstatTable);
        }
        if (HPFUtil.isOutputActive(outsumTable)) {
            HPFCodegen.generateOutStatement(cgReq, outsumTable);
        }
        if (HPFUtil.isOutputActive(outtrendTable)) {
            HPFCodegen.generateOutStatement(cgReq, outtrendTable);
        }
        HPFCodegen.generateOption(cgReq, hpfHandler, HPFPropertyHandler.BACK, Integer.toString(0));
        HPFCodegen.generateOption(cgReq, hpfHandler, HPFPropertyHandler.LEAD, Integer.toString(12));
        HPFCodegen.generateOption(cgReq, hpfHandler, HPFPropertyHandler.SEASONALITY);
        HPFCodegen.generateOption(cgReq, hpfHandler, HPFPropertyHandler.SORTNAMES);
        HPFCodegen.generateOption(cgReq, hpfHandler, HPFPropertyHandler.PRINTDETAILS);
        if (!(lstPrint.isEmpty() || hpfHandler.getSpecificOptionValue(HPFPropertyHandler.USEOUTPUTWINDOW).length() <= 0 && cDoc == null)) {
            cgReq.addSourceCode(m_strIndent + "print=(\n");
            for (int i = 0; i < lstPrint.size(); ++i) {
                cgReq.addSourceCode(m_strIndent + "      " + ((Property)lstPrint.get(i)).getDefaultValue() + "\n");
            }
            cgReq.addSourceCode(m_strIndent + "      )\n");
        }
        if (enablePrint && !lstPlot.isEmpty()) {
            cgReq.addSourceCode(m_strIndent + "plot=(\n");
            for (int i = 0; i < lstPlot.size(); ++i) {
                cgReq.addSourceCode(m_strIndent + "     " + ((Property)lstPlot.get(i)).getDefaultValue() + "\n");
            }
            cgReq.addSourceCode(m_strIndent + "     )\n");
        }
        cgReq.addSourceCode(";\n");
        cgReq.indent();
        String byStatement = cgReq.makeByStatement((Select)classifierMap);
        if (byStatement != null && byStatement.length() > 0) {
            cgReq.addSourceCode(byStatement).addSourceCode(";\n");
        }
        HPFPropertyHandler idHandler = new HPFPropertyHandler((Root)classifierMap, HPFPropertyHandler.ID_PROPERTY_SET_NAME);
        Column idColumn = idHandler.getPropertyColumn(HPFPropertyHandler.ID_VARIABLE_PROPERTY_NAME);
        List sourceNumericColumns = HPFUtil.getSourceNumericColumns(classifierMap);
        if (idColumn != null && sourceNumericColumns != null && sourceNumericColumns.contains(idColumn)) {
            ColumnCG columnCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)idColumn);
            cgReq.addSourceCode("id " + columnCG.getColumnName(cgReq) + "\n");
            m_strIndent = HPFCodegen.buildIndent(3);
            HPFCodegen.generateOption(cgReq, idHandler, HPFPropertyHandler.INTERVAL);
            HPFCodegen.generateOption(cgReq, idHandler, HPFPropertyHandler.ACCUMULATE, "NONE");
            HPFCodegen.generateOption(cgReq, idHandler, HPFPropertyHandler.NOTSORTED);
            HPFCodegen.generateOption(cgReq, idHandler, HPFPropertyHandler.START, "", true);
            HPFCodegen.generateOption(cgReq, idHandler, HPFPropertyHandler.END, "", true);
            HPFCodegen.generateOption(cgReq, idHandler, HPFPropertyHandler.SETMISSING, "MISSING");
            HPFCodegen.generateOption(cgReq, idHandler, HPFPropertyHandler.ZEROMISS, "NONE");
            cgReq.addSourceCode(";\n");
        }
        HPFPropertyHandler forecastHandler = new HPFPropertyHandler((Root)classifierMap, HPFPropertyHandler.FORECAST_PROPERTY_SET_NAME);
        List forecastVarsList = forecastHandler.getPropertyColumns(HPFPropertyHandler.FORECAST_VARIABLE_PROPERTY_NAME);
        m_strIndent = HPFCodegen.buildIndent(9);
        List possibleForecastColumns = HPFUtil.getPossibleForecastColumns(classifierMap);
        if (forecastVarsList == null || forecastVarsList.isEmpty() && possibleForecastColumns != null) {
            forecastVarsList = possibleForecastColumns;
        } else {
            if (possibleForecastColumns != null) {
                forecastVarsList.retainAll(possibleForecastColumns);
            }
            if (forecastVarsList.isEmpty()) {
                forecastVarsList = possibleForecastColumns;
            }
        }
        if (forecastVarsList == null || forecastVarsList.isEmpty()) {
            throw new CodegenException(bundle.getString("HPFCodegen.NoForecastColumns.Error.msg.txt"));
        }
        cgReq.addSourceCode("forecast ");
        cgReq.addSourceCode(cgReq.makeColumnList(forecastVarsList, m_strIndent));
        cgReq.addSourceCode(" / \n");
        HPFCodegen.generateOption(cgReq, forecastHandler, HPFPropertyHandler.ALPHA, Double.toString(0.05));
        HPFCodegen.generateOption(cgReq, forecastHandler, HPFPropertyHandler.HOLDOUT, Integer.toString(0));
        String holdout = forecastHandler.getSpecificOptionValue(HPFPropertyHandler.HOLDOUT);
        if (holdout.length() > 0 && Integer.parseInt(holdout) != 0) {
            HPFCodegen.generateOption(cgReq, forecastHandler, HPFPropertyHandler.HOLDOUTPCT, Double.toString(100.0));
        }
        if ((model = forecastHandler.getSpecificOptionValue(HPFPropertyHandler.MODEL)).equals("BESTALL")) {
            HPFCodegen.generateOption(cgReq, forecastHandler, HPFPropertyHandler.INTERMITTENT, Double.toString(1.25));
        }
        HPFCodegen.generateOption(cgReq, forecastHandler, HPFPropertyHandler.MEDIAN);
        HPFCodegen.generateOption(cgReq, forecastHandler, HPFPropertyHandler.MODEL, "BEST");
        HPFCodegen.generateOption(cgReq, forecastHandler, HPFPropertyHandler.SELECT, "RMSE");
        HPFCodegen.generateOption(cgReq, forecastHandler, HPFPropertyHandler.REPLACEMISSING);
        if (!model.equals("IDM")) {
            HPFCodegen.generateOption(cgReq, forecastHandler, HPFPropertyHandler.TRANSFORM, "NONE");
        }
        HPFCodegen.generateOption(cgReq, forecastHandler, HPFPropertyHandler.USE, "PREDICT");
        cgReq.addSourceCode(";\n");
        cgReq.unIndent();
        cgReq.addSourceCode("run; \n\n");
        if (enablePrint) {
            cgReq.addSourceCode("ods html close;\n");
            if (hpfHandler.getSpecificOptionValue(HPFPropertyHandler.USEOUTPUTWINDOW).length() == 0) {
                cgReq.addSourceCode("ods listing;\n");
            }
            if (!lstPlot.isEmpty()) {
                cgReq.addSourceCode("ods graphics off;\n\n");
            }
        }
    }

    public static String buildIndent(int numSpaces) {
        StringBuffer strBuffer = new StringBuffer(numSpaces);
        for (int i = 0; i < numSpaces; ++i) {
            strBuffer.append(" ");
        }
        return strBuffer.toString();
    }

    public static void generateOutStatement(CodegenRequest cgReq, PhysicalTable wTable) throws MdException, RemoteException {
        if (wTable != null) {
            WorkTableCG wTableCG = (WorkTableCG)CodeGenUtil.getCodeGenClass((CMetadata)wTable);
            String tableRole = HPFUtil.getTableRole((DataTable)wTable).toLowerCase();
            if (tableRole != null && tableRole.length() > 0) {
                cgReq.addSourceCode(m_strIndent + tableRole + " = ").addSourceCode(wTableCG.getDataLocation(cgReq) + "\n");
            }
        }
    }

    public static void generateOption(CodegenRequest cgReq, HPFPropertyHandler handler, String optionName) throws MdException, RemoteException {
        HPFCodegen.generateOption(cgReq, handler, optionName, "", false);
    }

    public static void generateOption(CodegenRequest cgReq, HPFPropertyHandler handler, String optionName, String defaultValue) throws MdException, RemoteException {
        HPFCodegen.generateOption(cgReq, handler, optionName, defaultValue, false);
    }

    public static void generateOption(CodegenRequest cgReq, HPFPropertyHandler handler, String optionName, String defaultValue, boolean dateValue) throws MdException, RemoteException {
        String optionValue = handler.getSpecificOptionValue(optionName);
        String optionString = handler.getPropertyNameValue(optionName);
        if (optionValue.length() > 0 && !optionValue.equals(defaultValue)) {
            if (!dateValue) {
                cgReq.addSourceCode(m_strIndent + optionString + "\n");
            } else {
                cgReq.addSourceCode(m_strIndent + optionName + " = '" + optionValue + "'d\n");
            }
        }
    }
}

