/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.hadoop.util;

import com.sas.etl.models.IModel;
import com.sas.etl.models.impl.BaseModel;
import com.sas.etl.models.other.IHadoopServer;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.wadmin.transforms.hadoop.util.ActionFactory;
import com.sas.wadmin.visuals.common.ModelUIUtilities;
import com.sas.wadmin.visuals.common.ModelUndoManager;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.undo.UndoManager;

public class ClusterInformationMenuManager
implements MenuListener {
    private JMenu m_mnuHadoopClusterMonitoring;

    public ClusterInformationMenuManager(JMenu mnuWindow) {
        this.m_mnuHadoopClusterMonitoring = mnuWindow;
        this.m_mnuHadoopClusterMonitoring.addMenuListener(this);
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    @Override
    public void menuSelected(MenuEvent e) {
        JMenu menu = (JMenu)e.getSource();
        IHadoopServer[] serverList = this.getServers();
        for (int i = 0; i < serverList.length; ++i) {
            IHadoopServer server = serverList[i];
            StringBuffer serverName = new StringBuffer(server.getName());
            serverName.append("   ");
            JMenu serverMenu = new JMenu(serverName.toString());
            Action[] aActions = ActionFactory.getInstance().createHadoopServerActions(server);
            ActionFactory.addActionsToMenu(serverMenu, aActions);
            menu.add(serverMenu);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IHadoopServer[] getServers() {
        BaseModel model = new BaseModel(null);
        IHadoopServer[] svrHadoop = null;
        try {
            model.setEditable(true);
            model.setUndoManager((UndoManager)((Object)new ModelUndoManager()));
            svrHadoop = ModelUIUtilities.getHadoopServers((IModel)model);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (ServiceException se) {
            Workspace.handleServiceException((ServiceException)se);
        }
        finally {
            model.dispose();
        }
        return svrHadoop;
    }

    @Override
    public void menuDeselected(MenuEvent e) {
        JMenu menu = (JMenu)e.getSource();
        menu.removeAll();
    }
}

