/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.fork;

import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.ColumnCG;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.transforms.fork.ForkUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsColumnMetadataUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class ForkColumns {
    private List m_columns = new ArrayList();
    private static WAdminResource bundle = WAdminResource.getBundle(ForkColumns.class);
    public static final int HANDLE = 0;
    public static final int MACHINE = 1;
    public static final int STARTTIME = 2;
    public static final int ENDTIME = 3;
    public static final int STATUS = 4;
    public static final int JOBRC = 5;

    public ForkColumns() {
        this.m_columns.add(new cColumn("etls_handleName", 32, WsColumnMetadataUtil.getDataCharacterType(), 0));
        this.m_columns.add(new cColumn("etls_machineId", 32, WsColumnMetadataUtil.getDataCharacterType(), 1));
        this.m_columns.add(new cColumn("etls_startTime", 8, WsColumnMetadataUtil.getDataNumericType(), "nldatmap.", "", 2));
        this.m_columns.add(new cColumn("etls_endTime", 8, WsColumnMetadataUtil.getDataNumericType(), "nldatmap.", "", 3));
        this.m_columns.add(new cColumn("etls_status", 32, WsColumnMetadataUtil.getDataCharacterType(), 4));
        this.m_columns.add(new cColumn("etls_jobRC", 8, WsColumnMetadataUtil.getDataNumericType(), 5));
    }

    public int getNumberOfCreatedColumns() {
        return this.m_columns.size();
    }

    public StringBuffer getColumnXML() {
        StringBuffer colXML = new StringBuffer();
        for (int i = 0; i < this.m_columns.size(); ++i) {
            colXML.append(((cColumn)this.m_columns.get(i)).getXML());
        }
        return colXML;
    }

    public boolean isForkColumn(String columnName) {
        boolean forkColumn = false;
        for (int i = 0; i < this.m_columns.size(); ++i) {
            if (!columnName.equalsIgnoreCase(((cColumn)this.m_columns.get(i)).getName())) continue;
            forkColumn = true;
            break;
        }
        return forkColumn;
    }

    public String getIdColumnName(int id) {
        String colName = null;
        for (int i = 0; i < this.m_columns.size(); ++i) {
            cColumn col = (cColumn)this.m_columns.get(i);
            if (col.getId() != id) continue;
            colName = col.getName();
            break;
        }
        return colName;
    }

    public Column getMetadataColumn(List colList, String name) {
        try {
            Column retcol = null;
            if (colList != null) {
                for (int i = 0; i < colList.size(); ++i) {
                    Column col = (Column)colList.get(i);
                    if (!col.getSASColumnName().equalsIgnoreCase(name)) continue;
                    retcol = col;
                    break;
                }
            }
            return retcol;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    public boolean createMissingColumns(ClassifierMap cMap, DataTable table) throws MdException, RemoteException {
        boolean changeMade = false;
        if (table != null) {
            AssociationList sColumns = table.getColumns();
            for (int i = 0; i < this.m_columns.size(); ++i) {
                cColumn col = (cColumn)this.m_columns.get(i);
                if (this.getMetadataColumn((List)sColumns, col.getName()) != null) continue;
                ForkUtil.createTargetColumn(cMap, table, col.getName(), col.getType(), col.getId(), col.getDescription());
                changeMade = true;
            }
        }
        return changeMade;
    }

    public CodegenRequest genColumnCreateStatements(CodegenRequest cgReq, List metadataColumnList) throws MdException, RemoteException {
        for (int i = 0; i < this.m_columns.size(); ++i) {
            cColumn col = (cColumn)this.m_columns.get(i);
            Column metaColumn = this.getMetadataColumn(metadataColumnList, col.getName());
            if (metaColumn == null) continue;
            ColumnCG columnCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)metaColumn);
            cgReq.addSourceCode(columnCG.getAttrib(cgReq, true, true, true));
        }
        return cgReq;
    }

    private class cColumn {
        private String m_name;
        private int m_length;
        private String m_format;
        private String m_inFormat;
        private String m_type;
        private int m_id;
        private String m_desc;

        public cColumn(String name, int length, String type, int id) {
            this(name, length, type, "", "", id);
        }

        public cColumn(String name, int length, String type, String format, String informat, int id) {
            this.m_name = name;
            this.m_length = length;
            this.m_type = type;
            this.m_format = format;
            this.m_inFormat = informat;
            this.m_id = id;
            this.m_desc = bundle.getString("Fork.Column." + this.m_name + ".desc.txt");
        }

        public StringBuffer getXML() {
            return new StringBuffer("<Column Name=\"" + this.m_name + "\" Desc=\"" + this.m_desc + "\" ColumnName=\"" + this.m_name + "\" SASColumnName=\"" + this.m_name + "\" ColumnLength=\"" + Integer.toString(this.m_length) + "\" SASColumnLength=\"" + Integer.toString(this.m_length) + "\" SASColumnType=\"" + this.m_type + "\" SASFormat=\"" + this.m_format + "\" SASInformat=\"" + this.m_inFormat + "\" IsNullable=\"1\" />");
        }

        public String toString() {
            return this.m_name;
        }

        public String getName() {
            return this.m_name;
        }

        public int getLength() {
            return this.m_length;
        }

        public String getType() {
            return this.m_type;
        }

        public String getFormat() {
            return this.m_format;
        }

        public String getInFormat() {
            return this.m_inFormat;
        }

        public int getId() {
            return this.m_id;
        }

        public String getDescription() {
            return this.m_desc;
        }
    }
}

