/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.edmflow;

import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.edmflow.IEDMFlowColumn;
import com.sas.etl.models.job.transforms.edmflow.mapping.IEDMFlowMapping;
import com.sas.etl.models.job.transforms.edmflow.mapping.IEDMFlowMappingsContainer;
import com.sas.wadmin.transforms.edmflow.EDMFlowTargetColumnsTableModel;
import com.sas.wadmin.visuals.common.SourceColumnsTableModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WsMapping;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsTableMappingsPanel;
import java.util.List;

public class EDMFlowTableMappingsPanel
extends WsTableMappingsPanel {
    private EDMFlowTargetColumnsTableModel m_mdlTargetColumns;
    private SourceColumnsTableModel m_mdlSourceColumns;
    private IEDMFlowMappingsContainer m_container;

    public EDMFlowTableMappingsPanel(WsTable tblSource, WsTable tblTarget, IEDMFlowMappingsContainer container) {
        super(tblSource, tblTarget);
        this.m_container = container;
    }

    public void setSourceTable(WsTable tblSource) {
        super.setSourceTable(tblSource);
        this.m_mdlSourceColumns = (SourceColumnsTableModel)((Object)tblSource.getModel());
    }

    public void setTargetTable(WsTable tblTarget) {
        super.setTargetTable(tblTarget);
        this.m_mdlTargetColumns = (EDMFlowTargetColumnsTableModel)((Object)tblTarget.getModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCreateMappings(List lPairings) {
        this.m_bDragging = false;
        if (lPairings.isEmpty()) {
            return;
        }
        if (this.m_bDragFromSourceToTarget) {
            int iTarget = ((WsMapping)lPairings.get(0)).getTarget();
            IEDMFlowMapping mapping = this.m_mdlTargetColumns.getMapping(iTarget);
            IEDMFlowColumn[] aTargets = new IEDMFlowColumn[]{this.m_mdlTargetColumns.getTargetColumn(iTarget)};
            IColumn[] aSources = this.createProposedSourceColumns(mapping, lPairings);
            if (!this.m_container.isEDMFlowMappingAllowed(aSources, aTargets)) {
                MessageUtil.displayMessage((String)this.m_container.getReasonMappingIsNotAllowed(aSources, aTargets), (int)0);
            } else if (mapping == null) {
                this.m_container.addMapping(aSources, aTargets);
            } else {
                this.m_container.getModel().startCompoundUndoable();
                try {
                    for (int iPairing = 0; iPairing < lPairings.size(); ++iPairing) {
                        WsMapping pairing = (WsMapping)lPairings.get(iPairing);
                        mapping.addSource(this.m_mdlSourceColumns.getSourceColumn(pairing.getSource()));
                    }
                }
                finally {
                    this.m_container.getModel().endCompoundUndoable();
                }
            }
        } else {
            IColumn[] aSources;
            WsMapping pairing;
            int iPairing;
            IEDMFlowColumn[] aTargets = new IEDMFlowColumn[1];
            for (iPairing = 0; iPairing < lPairings.size(); ++iPairing) {
                pairing = (WsMapping)lPairings.get(iPairing);
                int iTargetColumn = pairing.getTarget();
                aTargets[0] = this.m_mdlTargetColumns.getTargetColumn(iTargetColumn);
                aSources = this.createProposedSourceColumns(this.m_mdlTargetColumns.getMapping(iTargetColumn), pairing);
                if (this.m_container.isEDMFlowMappingAllowed(aSources, aTargets)) continue;
                MessageUtil.displayMessage((String)this.m_container.getReasonMappingIsNotAllowed(aSources, aTargets), (int)0);
                return;
            }
            this.m_container.getModel().startCompoundUndoable();
            try {
                aSources = new IColumn[1];
                for (iPairing = 0; iPairing < lPairings.size(); ++iPairing) {
                    pairing = (WsMapping)lPairings.get(iPairing);
                    int iTarget = pairing.getTarget();
                    aTargets[0] = this.m_mdlTargetColumns.getTargetColumn(iTarget);
                    IEDMFlowMapping mapping = this.m_mdlTargetColumns.getMapping(iTarget);
                    if (mapping == null) {
                        aSources[0] = this.m_mdlSourceColumns.getSourceColumn(pairing.getSource());
                        this.m_container.addMapping(aSources, aTargets);
                        continue;
                    }
                    mapping.addSource(this.m_mdlSourceColumns.getSourceColumn(pairing.getSource()));
                }
            }
            finally {
                this.m_container.getModel().endCompoundUndoable();
            }
        }
    }

    private IColumn[] createProposedSourceColumns(IEDMFlowMapping mapping, List lPairings) {
        int iSource;
        IColumn[] aSources;
        if (mapping != null) {
            int nSources = mapping.getSourceCount();
            aSources = new IColumn[nSources + lPairings.size()];
            System.arraycopy(mapping.getSources(), 0, aSources, 0, nSources);
            iSource = nSources;
        } else {
            aSources = new IColumn[lPairings.size()];
            iSource = 0;
        }
        for (int iPairing = 0; iPairing < lPairings.size(); ++iPairing) {
            WsMapping pairing = (WsMapping)lPairings.get(iPairing);
            aSources[iSource++] = this.m_mdlSourceColumns.getSourceColumn(pairing.getSource());
        }
        return aSources;
    }

    private IColumn[] createProposedSourceColumns(IEDMFlowMapping mapping, WsMapping pairing) {
        IColumn source = this.m_mdlSourceColumns.getSourceColumn(pairing.getSource());
        if (mapping == null) {
            return new IColumn[]{source};
        }
        int nSources = mapping.getSourceCount();
        IColumn[] aSources = new IColumn[nSources + 1];
        System.arraycopy(mapping.getSources(), 0, aSources, 0, nSources);
        aSources[nSources] = source;
        return aSources;
    }
}

