/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.edmflow;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.edmflow.IEDMFlow;
import com.sas.etl.models.data.edmflow.IEDMFlowVersion;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.transforms.edmflow.EDMFlowTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.wadmin.app.AppPropertiesDialogFactory;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.objectselector.ObjectSelectorPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.Comparator;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

public class EDMFlowAttributesTab
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(EDMFlowAttributesTab.class);
    private EDMFlowTransformModel m_mdlTransform;
    private int m_selectedVersionIndex = -1;
    private IModelListener m_lsnrModel;
    private ItemListener m_lsnItem;
    private WsAbstractAction m_actSelectPackage;
    private JLabel m_lblName;
    private JLabel m_lblDescription;
    private JLabel m_lblVersion;
    private WATextField m_txtName;
    private JScrollPane m_scrDescription;
    private WATextArea m_txtDescription;
    private JButton m_btnPackage;
    private WAComboBox m_cmbVersion;
    private WsAbstractAction m_properties;

    public EDMFlowAttributesTab(EDMFlowTransformModel model) {
        this.setName(bundle.getString("EDMFlowAttributesTab.Name.txt"));
        this.m_mdlTransform = model;
        this.m_lsnrModel = new EDMFlowModelListener();
        this.m_mdlTransform.getModel().addModelListener(this.m_lsnrModel);
        this.initialize();
        this.layoutWidgets();
        this.setHelpProduct("wdb");
        this.setHelpTopic("edm_flow_edm");
    }

    public void initialize() {
        this.m_txtName = new WATextField();
        this.m_txtName.setToolTipText(bundle.getString("EDMFlowAttributesTab.TextField.Name.ToolTip.txt"));
        this.m_txtName.setEditable(false);
        this.m_lblName = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtName, (String)bundle.getString("EDMFlowAttributesTab.Label.Name.txt"));
        this.m_actSelectPackage = new SelectPackageAction();
        this.m_btnPackage = new JButton((Action)this.m_actSelectPackage);
        this.m_btnPackage.setPreferredSize(new Dimension(this.m_txtName.getPreferredSize().height, this.m_txtName.getPreferredSize().height));
        this.m_txtDescription = new WATextArea();
        this.m_txtDescription.setEditable(false);
        this.m_txtDescription.setMaxCharacters(200);
        this.m_txtDescription.setLineWrap(true);
        this.m_txtDescription.setWrapStyleWord(true);
        this.m_txtDescription.setRows(5);
        this.m_txtDescription.setColumns(30);
        this.m_scrDescription = new JScrollPane((Component)this.m_txtDescription, 20, 31);
        WsUIUtilities.adjustScrollPanePreferredSize((JScrollPane)this.m_scrDescription);
        this.m_lblDescription = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtDescription, (String)bundle.getString("EDMFlowAttributesTab.Label.Description.txt"));
        this.m_txtDescription.setToolTipText(bundle.getString("EDMFlowAttributesTab.TextField.Description.ToolTip.txt"));
        this.m_properties = new cPropertiesAction();
        this.m_cmbVersion = new WAComboBox(true, false);
        this.m_cmbVersion.setRenderer((ListCellRenderer)new VersionRenderer());
        this.m_cmbVersion.setSortComparator((Comparator)new UVComparator());
        this.m_lsnItem = new VersionSelectionListener();
        this.m_cmbVersion.addItemListener((ItemListener)new VersionSelectionListener());
        this.m_lblVersion = WsUIUtilities.createLabelForComponent((JComponent)this.m_cmbVersion, (String)bundle.getString("EDMFlowAttributesTab.Label.Version.txt"));
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.m_txtName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.add(this.m_btnPackage, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add(new JButton((Action)this.m_properties), new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_lblDescription, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 5), 0, 0));
        this.add(this.m_scrDescription, new GridBagConstraints(1, 1, 5, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(1, 2, 5, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        try {
            if (this.m_mdlTransform.getEDMFlow() != null) {
                this.m_txtName.setText(this.m_mdlTransform.getEDMFlow().getName());
                this.m_txtDescription.setText(this.m_mdlTransform.getEDMFlow().getDescription());
            }
            this.updateActions();
        }
        finally {
            this.setListeningForChanges(true);
        }
    }

    private int getSelectedVersionIndex() {
        return this.m_selectedVersionIndex;
    }

    private void setSelectedVersion(IEDMFlowVersion version) {
        this.m_cmbVersion.setSelectedItem((Object)version);
        this.m_selectedVersionIndex = this.m_cmbVersion.getSelectedIndex();
    }

    protected void updateActions() {
        boolean actionEnabled = this.isEditable() && !this.m_mdlTransform.isUsingUserWrittenCode();
        this.m_actSelectPackage.setEnabled(actionEnabled);
        this.m_cmbVersion.setEnabled(actionEnabled && this.m_mdlTransform.getEDMFlow() != null);
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_cmbVersion.removeItemListener(this.m_lsnItem);
        this.m_mdlTransform.getModel().removeModelListener(this.m_lsnrModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleModelChanged(ModelEvent ev) {
        String type = ev.getType();
        boolean bWasListeningForChanges = this.isListeningForChanges();
        this.setListeningForChanges(false);
        try {
            if ("EDMFlowTransformModel:EDMFlowChanged".equals(type)) {
                if (this.m_mdlTransform.getEDMFlow() != null) {
                    this.m_txtName.setText(this.m_mdlTransform.getEDMFlow().getName());
                    this.m_txtDescription.setText(this.m_mdlTransform.getEDMFlow().getDescription());
                }
                this.updateActions();
            }
        }
        finally {
            this.setListeningForChanges(bWasListeningForChanges);
        }
    }

    private void setFlowVersion(IEDMFlowVersion version) {
        if (version != null) {
            try {
                version.loadFromOMR();
            }
            catch (RemoteException e) {
                Workspace.getWorkspace();
                Workspace.handleRemoteException((RemoteException)e);
            }
            catch (ServiceException e) {
                Workspace.getWorkspace();
                Workspace.handleServiceException((ServiceException)e);
            }
        }
        this.m_mdlTransform.setEDMFlowVersion(version);
    }

    private class EDMFlowModelListener
    implements IModelListener {
        private EDMFlowModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            if (!EDMFlowAttributesTab.this.isListeningForChanges()) {
                return;
            }
            String type = ev.getType();
            if (type == "ModelController:UnknownChanges") {
                try {
                    EDMFlowAttributesTab.this.moveDataToView();
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                return;
            }
            IObject object = ev.getModelObject();
            if (object != EDMFlowAttributesTab.this.m_mdlTransform) {
                return;
            }
            EDMFlowAttributesTab.this.handleModelChanged(ev);
        }
    }

    private class SelectPackageAction
    extends WsAbstractAction {
        public SelectPackageAction() {
            super(bundle, "EDMFlowAttributesTab.SelectPackageAction", 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            String sTitle = bundle.getString("EDMFlowAttributesTab.PackageSelector.title.txt");
            ObjectSelectorPanel pnl = new ObjectSelectorPanel(Workspace.getWorkspace().getUserContext(), -1);
            SimpleObject simpleOld = pnl.getSelectedObject();
            pnl.setSelectionOptional(true);
            pnl.setSelectableTypes(new String[]{"DecisionLogic"});
            pnl.setVisibleTypes(new String[]{"DecisionLogic"});
            pnl.setInventoryTypes(new String[]{"DecisionLogic"});
            pnl.setAdditionalHierarchyModel(null);
            WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sTitle, true, (WAPanel)pnl);
            dlg.setResizable(true);
            dlg.setHelpProduct("wdb");
            dlg.setHelpTopic("edm_flow_select");
            dlg.show();
            if (dlg.getReturnValue() == 1) {
                SimpleObject simpleObject = pnl.getSelectedObject();
                if (simpleObject != null && simpleObject.equals((Object)simpleOld)) {
                    return;
                }
                EDMFlowAttributesTab.this.m_mdlTransform.getModel().startCompoundUndoable();
                if (EDMFlowAttributesTab.this.m_mdlTransform != null) {
                    EDMFlowAttributesTab.this.m_mdlTransform.clearMappingListAfterNewFlowSet((List)EDMFlowAttributesTab.this.m_mdlTransform.getPriorMappings());
                }
                OMRAdapter load = null;
                try {
                    if (simpleObject != null && EDMFlowAttributesTab.this.m_mdlTransform != null) {
                        load = new OMRAdapter(EDMFlowAttributesTab.this.m_mdlTransform.getModel(), Workspace.getMdFactory(), "load EDM Flow");
                        SimpleObject[] so = new SimpleObject[]{simpleObject};
                        IEDMFlow flow = (IEDMFlow)load.acquireObject(ObjectConverter.getInstance().convertToJOMAObject(load.getOMRStore(), so[0]));
                        EDMFlowAttributesTab.this.m_mdlTransform.setEDMFlow(flow);
                        EDMFlowAttributesTab.this.setFlowVersion(flow.getDefaultVersion());
                    } else {
                        EDMFlowAttributesTab.this.m_mdlTransform.setEDMFlow(null);
                    }
                }
                catch (MdException me) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                finally {
                    if (load != null) {
                        load.dispose();
                    }
                    EDMFlowAttributesTab.this.m_mdlTransform.getModel().endCompoundUndoable();
                }
            }
        }
    }

    private class cPropertiesAction
    extends WsAbstractAction {
        public cPropertiesAction() {
            super(bundle, "EDMFlowAttributeTab.cPropertiesAction", 0);
        }

        public void actionPerformed(ActionEvent e) {
            IEDMFlow flow = EDMFlowAttributesTab.this.m_mdlTransform.getEDMFlow();
            if (flow != null) {
                AppPropertiesDialogFactory.getInstance().showPropertiesDialog((Window)Workspace.getWorkspace(), (SimpleObject)flow);
            }
        }
    }

    private class VersionRenderer
    extends DefaultListCellRenderer {
        private VersionRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null && value instanceof IEDMFlowVersion) {
                IEDMFlowVersion version = (IEDMFlowVersion)value;
                this.setText(version.toString());
            }
            return this;
        }
    }

    private class UVComparator
    implements Comparator<IEDMFlowVersion> {
        private UVComparator() {
        }

        @Override
        public int compare(IEDMFlowVersion o1, IEDMFlowVersion o2) {
            return o1.compareTo((Object)o2);
        }
    }

    private class VersionSelectionListener
    implements ItemListener {
        private VersionSelectionListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent ev) {
            int iSelect;
            if (ev.getStateChange() != 1 || (iSelect = EDMFlowAttributesTab.this.m_cmbVersion.getSelectedIndex()) != EDMFlowAttributesTab.this.getSelectedVersionIndex()) {
                // empty if block
            }
        }
    }
}

