/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.datavalidation;

import com.sas.etl.models.job.transforms.dataValidation.DataValidationRecord;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationTransformModel;
import com.sas.workspace.WsAbstractTableModel;
import java.util.ArrayList;
import java.util.List;

public abstract class DataValidationTableModel
extends WsAbstractTableModel {
    protected String m_validationType;
    protected int[] m_rowMappings;
    protected DataValidationTransformModel m_DVTransformModel;
    public int m_iVisibleColumns = 11;
    public int m_iHiddenColumns = 1;

    public DataValidationTableModel(DataValidationTransformModel DVTransformModel) {
        this.m_DVTransformModel = DVTransformModel;
        this.createColumnDefinitions();
    }

    public abstract void createColumnDefinitions();

    public int getColumnCount() {
        return 0;
    }

    public int getHiddenColumnCount() {
        return 0;
    }

    public void setValueAt(Object value, int iRow, int iColumn) {
        super.setValueAt(value, iRow, iColumn);
    }

    public void moveDataToModel() {
        this.clear();
        this.fireTableModelPopulated();
        this.m_nRowInstances = this.m_lData.size() + 1;
    }

    public void moveDataToStore() {
        throw new UnsupportedOperationException("moveDataToStore not implemented.  changes are immediately made to the model");
    }

    public void populateStore() {
        throw new UnsupportedOperationException("populateStore not implemented.  Model does not use a store");
    }

    protected List createRowValues() {
        ArrayList lValues = new ArrayList(this.m_iVisibleColumns + this.m_iHiddenColumns);
        return lValues;
    }

    protected List createRowValues(DataValidationRecord oDVR) {
        ArrayList<Object> lValues = new ArrayList<Object>(this.getColumnCount() + this.getHiddenColumnCount());
        for (int i = 0; i < this.getColumnCount() + this.getHiddenColumnCount(); ++i) {
            lValues.add(null);
        }
        this.addRowValues(oDVR, lValues);
        return lValues;
    }

    protected void addVisibleValues(DataValidationRecord oDVR, List lValues) {
    }

    public List addRowValues(DataValidationRecord oDVR, List lRowValues) {
        return null;
    }

    public void dispose() {
    }

    public void addDVR(DataValidationRecord oDVR) {
        int iRow = this.m_DVTransformModel.indexOfDataValidationRecord(oDVR);
        this.insertRow(iRow - 1, this.createRowValues(oDVR));
    }

    public void removeDVR(DataValidationRecord oDVR) {
        if (this.getRowIndex(oDVR) >= 0) {
            this.deleteRow(this.getRowIndex(oDVR));
        }
    }

    public DataValidationRecord getDVRForRow(int iRow) {
        return (DataValidationRecord)this.getValueAt(iRow, this.getColumnCount() + this.getHiddenColumnCount() - 1);
    }

    public int getRowIndex(String sDVR_FQID) {
        for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
            if (!this.getDVRForRow(iRow).getID().equals(sDVR_FQID)) continue;
            return iRow;
        }
        return -1;
    }

    public int getRowIndex(DataValidationRecord oDVR) {
        for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
            if (this.getDVRForRow(iRow) != oDVR) continue;
            return iRow;
        }
        return -1;
    }

    public List newRow() {
        ArrayList<Object> rowValues = new ArrayList<Object>();
        for (int i = 0; i < this.getColumnCount() + this.getHiddenColumnCount(); ++i) {
            rowValues.add(null);
        }
        return rowValues;
    }

    public List getTableRows() {
        ArrayList<List> rows = new ArrayList<List>(this.getRowCount());
        for (int i = 0; i < this.getRowCount(); ++i) {
            List rowValues = this.getRowValues(i);
            rows.add(rowValues);
        }
        return rows;
    }

    public int getOrderedRow(int selectedRow) {
        int orderedRow = selectedRow;
        if (this.m_rowMappings != null) {
            orderedRow = this.m_rowMappings[selectedRow];
        }
        return orderedRow;
    }

    public List getRowValues(int selectedRow) {
        return super.getRowValues(this.getOrderedRow(selectedRow));
    }

    public String getValidationType() {
        return this.m_validationType;
    }

    public void setValidationType(String validationType) {
        this.m_validationType = validationType;
    }

    public void setRowMappings(int[] rowMappings) {
        this.m_rowMappings = rowMappings;
    }

    public int[] getRowMappings() {
        return this.m_rowMappings;
    }

    public void moveDVR(DataValidationRecord oDVR, int iTo) {
        this.m_DVTransformModel.moveDataValidationRecord(oDVR, iTo, this.getValidationType());
    }
}

