/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.datavalidation;

import com.sas.etl.models.job.transforms.dataValidation.DataValidationTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.transforms.datavalidation.DataValidationCustomTableModel;
import com.sas.wadmin.transforms.datavalidation.DataValidationDuplicatesTableModel;
import com.sas.wadmin.transforms.datavalidation.DataValidationInvalidTableModel;
import com.sas.wadmin.transforms.datavalidation.DataValidationMissingTableModel;
import com.sas.wadmin.transforms.datavalidation.DataValidationTableModel;
import com.sas.wadmin.transforms.datavalidation.DataValidationTableViewer;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.rmi.RemoteException;

public class DataValidationPropertyTab
extends WAPropertyTab {
    protected DataValidationTableViewer m_dvTableViewer;
    protected DataValidationTransformModel m_validateTM;
    protected String m_validationType;
    private static WAdminResource bundle = WAdminResource.getBundle(DataValidationPropertyTab.class);

    public DataValidationPropertyTab(DataValidationTransformModel validateTM, String validationType) {
        this.m_validationType = validationType;
        this.m_validateTM = validateTM;
        this.initialize();
        String helpID = "";
        if (this.m_validationType.equalsIgnoreCase("Missing")) {
            helpID = "missing_values_tab";
            this.setName(bundle.getString("DataValidation.MissingTab.title.txt"));
        } else if (this.m_validationType.equalsIgnoreCase("Duplicate")) {
            helpID = "dup_values_tab";
            this.setName(bundle.getString("DataValidation.DuplicateTab.title.txt"));
        } else if (this.m_validationType.equalsIgnoreCase("Invalid")) {
            helpID = "invalid_values_tab";
            this.setName(bundle.getString("DataValidation.InvalidTab.title.txt"));
        } else if (this.m_validationType.equalsIgnoreCase("Custom")) {
            helpID = "custom_validation_tab";
            this.setName(bundle.getString("DataValidation.CustomTab.title.txt"));
        }
        this.setHelpTopic(helpID);
    }

    protected void initialize() {
        this.m_dvTableViewer = new DataValidationTableViewer(this.m_validateTM, this.m_validationType);
        this.listenForDataChangesTo((WAPanel)this.m_dvTableViewer);
        DataValidationTableModel tableModel = null;
        if (this.m_validationType.equalsIgnoreCase("Missing")) {
            tableModel = new DataValidationMissingTableModel(this.m_validateTM);
        } else if (this.m_validationType.equalsIgnoreCase("Duplicate")) {
            tableModel = new DataValidationDuplicatesTableModel(this.m_validateTM);
        } else if (this.m_validationType.equalsIgnoreCase("Invalid")) {
            tableModel = new DataValidationInvalidTableModel(this.m_validateTM);
        } else if (this.m_validationType.equalsIgnoreCase("Custom")) {
            tableModel = new DataValidationCustomTableModel(this.m_validateTM);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.m_dvTableViewer), "Center");
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public boolean validateData() {
        return this.m_dvTableViewer.validateData();
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        System.out.println("doDataExchange");
        if (bSaveToModel) {
            this.m_dvTableViewer.moveDataToStore();
        } else {
            this.m_dvTableViewer.moveDataToView();
        }
        this.setDataChanged(false);
        return true;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_dvTableViewer.setEditable(bEditable);
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        this.m_dvTableViewer.updateWorkspaceUIComponents(bActive);
    }
}

