/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.datavalidation;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationRecord;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationTransformModel;
import com.sas.wadmin.transforms.datavalidation.DataValidationTableModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.util.List;

public class DataValidationMissingTableModel
extends DataValidationTableModel {
    private static WAdminResource bundle = WAdminResource.getBundle(DataValidationMissingTableModel.class);
    static final int NUM_VISIBLE_COLUMNS = 3;
    static final int NUM_HIDDEN_COLUMNS = 3;
    static final int MISSING_COLUMN_NAME_INDEX = 0;
    static final int MISSING_ACTION_INDEX = 1;
    static final int MISSING_EXPRESSION_INDEX = 2;
    static final int MISSING_CHANGE_INDEX = 3;
    static final int MISSING_COLUMN_INDEX = 4;
    static final int MISSING_DVR_INDEX = 5;
    static final int MISSING_NUM_VALUES = 6;
    public IModelListener m_lsnrModel = new ModelListener();

    public DataValidationMissingTableModel(DataValidationTransformModel DVTransformModel) {
        super(DVTransformModel);
        this.m_DVTransformModel.getModel().addModelListener(this.m_lsnrModel);
    }

    @Override
    public void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("DataValidationTableModel.Column.label.txt"), 150);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("DataValidationTableModel.Missing.Action.label.txt"), 200);
        this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("DataValidationTableModel.Expression.label.txt"), 200);
        this.m_aColumns[3] = new WsObjectTableColumn();
        this.m_aColumns[4] = new WsObjectTableColumn();
        this.m_aColumns[5] = new WsObjectTableColumn();
        this.m_aColumns[0].setEditable(false);
        this.m_aColumns[1].setEditable(false);
        this.m_aColumns[2].setEditable(false);
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getHiddenColumnCount() {
        return 3;
    }

    @Override
    public String getValidationType() {
        return "Missing";
    }

    @Override
    public void moveDataToModel() {
        this.clear();
        List lDVRs = this.m_DVTransformModel.getModelList(this.getValidationType());
        for (int recNum = 0; recNum < lDVRs.size(); ++recNum) {
            DataValidationRecord oDVR = (DataValidationRecord)lDVRs.get(recNum);
            this.m_lData.add(this.createRowValues(oDVR));
        }
        this.fireTableModelPopulated();
        this.m_nRowInstances = this.m_lData.size() + 1;
    }

    @Override
    public List addRowValues(DataValidationRecord oDVR, List lRowValues) {
        return DataValidationMissingTableModel.getRowValuesFromValidationRecord(oDVR, lRowValues);
    }

    public static List getRowValuesFromValidationRecord(DataValidationRecord oDVR, List lRowValues) {
        lRowValues.set(4, oDVR.getColumn_FM1());
        lRowValues.set(0, oDVR.getColumn_FM1_Name());
        lRowValues.set(1, oDVR.getAction());
        lRowValues.set(2, oDVR.getExpression());
        lRowValues.set(3, oDVR.getColumn_FM1());
        lRowValues.set(5, oDVR);
        return lRowValues;
    }

    @Override
    public void dispose() {
        this.m_DVTransformModel.getModel().removeModelListener(this.m_lsnrModel);
    }

    protected class ModelListener
    implements IModelListener {
        protected ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            IObject obj = ev.getModelObject();
            if (sType == "ModelController:UnknownChanges") {
                DataValidationMissingTableModel.this.moveDataToModel();
            } else if (obj == DataValidationMissingTableModel.this.m_DVTransformModel) {
                if (sType == "DVR:MissingTypeDataValidationRecordAdded") {
                    DataValidationMissingTableModel.this.addDVR((DataValidationRecord)ev.getData());
                } else if (sType == "DVR:MissingTypeDataValidationRecordMoved") {
                    DataValidationMissingTableModel.this.removeDVR((DataValidationRecord)ev.getData());
                    DataValidationMissingTableModel.this.addDVR((DataValidationRecord)ev.getData());
                } else if (sType == "DVR:MissingTypeDataValidationRecordRemoved") {
                    DataValidationMissingTableModel.this.removeDVR((DataValidationRecord)ev.getData());
                }
            }
        }
    }
}

