/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.datavalidation;

import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationRecord;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.transforms.datavalidation.DataValidationBaseObjectRenderer;
import com.sas.wadmin.transforms.datavalidation.DataValidationEditPanel;
import com.sas.wadmin.transforms.datavalidation.DataValidationMissingTableModel;
import com.sas.wadmin.visuals.common.WsExpressionTextField_ITable;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;

public class DataValidationMissingEditPanel
extends DataValidationEditPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(DataValidationMissingEditPanel.class);
    protected JLabel m_lblColumn;
    protected WAComboBox m_cmbColumn;
    protected JLabel m_lblAction;
    protected WAComboBox m_cmbAction;
    protected JLabel m_lblExpression;
    protected WsExpressionTextField_ITable m_expExpression;
    protected cActionComboBoxListener m_actionListener = new cActionComboBoxListener();
    protected int m_changeAction = -1;
    protected List m_rowValues;
    protected DataValidationTransformModel m_DVTransformModel;
    protected List m_actionList;
    protected List m_columnList;
    static final String HELP_ID = "missing_values_win";

    public DataValidationMissingEditPanel(DataValidationTransformModel dataValidationTransformModel, List rowValues, boolean bEditable) {
        super(bEditable);
        this.m_DVTransformModel = dataValidationTransformModel;
        this.m_rowValues = rowValues;
        this.initialize();
        this.setHelpTopic(HELP_ID);
    }

    protected void initialize() {
        super.initialize();
        this.m_cmbColumn = new WAComboBox();
        this.m_cmbColumn.setToolTipText(bundle.getString("DataValidationEditPanel.Column.tooltip.txt"));
        this.m_cmbColumn.setRenderer((ListCellRenderer)new DataValidationBaseObjectRenderer());
        this.m_lblColumn = new JLabel(bundle.getString("DataValidationEditPanel.Column.label.txt"));
        this.m_lblColumn.setLabelFor((Component)this.m_cmbColumn);
        this.m_lblColumn.setDisplayedMnemonic(bundle.getString("DataValidationEditPanel.Column.mnem").charAt(0));
        this.m_cmbAction = new WAComboBox();
        this.m_cmbAction.setToolTipText(bundle.getString("DataValidationEditPanel.Missing.Action.tooltip.txt"));
        this.m_lblAction = new JLabel(bundle.getString("DataValidationEditPanel.Missing.Action.label.txt"));
        this.m_lblAction.setLabelFor((Component)this.m_cmbAction);
        this.m_lblAction.setDisplayedMnemonic(bundle.getString("DataValidationEditPanel.Missing.Action.mnem").charAt(0));
        this.m_cmbAction.addActionListener((ActionListener)this.m_actionListener);
        this.m_expExpression = new WsExpressionTextField_ITable((ITable)this.m_DVTransformModel.getTargetTable(), "");
        this.m_expExpression.setToolTipText(bundle.getString("DataValidationEditPanel.Expression.tooltip.txt"));
        this.m_lblExpression = new JLabel(bundle.getString("DataValidationEditPanel.Expression.label.txt"));
        this.m_lblExpression.setLabelFor((Component)((Object)this.m_expExpression));
        this.m_lblExpression.setDisplayedMnemonic(bundle.getString("DataValidationEditPanel.Expression.mnem").charAt(0));
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblColumn, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.m_cmbColumn, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_lblAction, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 5), 0, 0));
        this.add((Component)this.m_cmbAction, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add(this.m_lblExpression, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 5), 0, 0));
        this.add((Component)((Object)this.m_expExpression), new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_columnList = this.m_DVTransformModel.makeColumnList((ITable)this.m_DVTransformModel.getTargetTable());
        for (int i = 0; i < this.m_columnList.size(); ++i) {
            this.m_cmbColumn.addItem(this.m_columnList.get(i));
        }
        IColumn oColumnToEdit = (IColumn)this.m_rowValues.get(4);
        for (int i = 0; i < this.m_columnList.size(); ++i) {
            IColumn column2;
            if (oColumnToEdit == null || !(column2 = (IColumn)this.m_columnList.get(i)).getID().equals(oColumnToEdit.getID())) continue;
            oColumnToEdit = column2;
        }
        if (oColumnToEdit == null && this.m_columnList.size() > 0) {
            this.m_cmbColumn.setSelectedIndex(0);
        } else if (oColumnToEdit != null) {
            this.m_cmbColumn.setSelectedItem((Object)oColumnToEdit);
        }
        List m_metaActionList = DataValidationRecord.loadMetaActionList((String)"Missing");
        this.m_actionList = DataValidationRecord.makeActionList((List)m_metaActionList, (String)"Missing");
        this.m_changeAction = DataValidationRecord.getChangeAction((List)m_metaActionList);
        this.m_cmbAction.addItems(this.m_actionList);
        String action = (String)this.m_rowValues.get(1);
        if (action == null) {
            this.m_cmbAction.setSelectedIndex(0);
        } else {
            this.m_cmbAction.setSelectedItem((Object)action);
        }
        String expression = (String)this.m_rowValues.get(2);
        this.m_expExpression.setText(expression);
        this.enableExpressionComponent();
        this.setListeningForChanges(true);
    }

    @Override
    public boolean validateData() {
        if (this.m_cmbColumn.getSelectedIndex() < 0) {
            MessageUtil.displayMessage((String)bundle.getString("DataValidationEditPanel.MissingColumn.Error.txt"), (String)bundle.getString("DataValidationEditPanel.MissingColumn.Title.txt"), (int)0);
            this.m_cmbColumn.requestFocus();
            return false;
        }
        if (this.m_cmbAction.getSelectedIndex() < 0) {
            MessageUtil.displayMessage((String)bundle.getString("DataValidationEditPanel.MissingAction.Error.txt"), (String)bundle.getString("DataValidationEditPanel.MissingAction.Title.txt"), (int)0);
            this.m_cmbAction.requestFocus();
            return false;
        }
        return true;
    }

    @Override
    public List getRow() {
        return this.getRow(null, null, null);
    }

    @Override
    public List getRow(String oDVRFQID, String oCustomConditionRecordFQID, DataValidationRecord oParentDVR) {
        DataValidationRecord oDVR = null;
        if (oDVRFQID == null) {
            String sEventFQID = this.m_DVTransformModel.createNewDataValidationRecord();
            oDVR = new DataValidationRecord(sEventFQID, this.m_DVTransformModel, "Missing");
        } else {
            oDVR = new DataValidationRecord(oDVRFQID, this.m_DVTransformModel, "Missing");
        }
        IColumn oIColumn = (IColumn)this.m_cmbColumn.getSelectedItem();
        String columnName = "";
        if (oIColumn != null) {
            columnName = oIColumn.getName();
        }
        oDVR.setPropertyTrue_PS1_DefVal(this.m_cmbAction.getSelectedItem().toString());
        oDVR.setColumn_FM1(oIColumn, this.m_DVTransformModel);
        oDVR.setExpression(this.m_expExpression.getText());
        oDVR.setAction(this.m_cmbAction.getSelectedItem().toString());
        ArrayList<Object> lRowValues = new ArrayList<Object>(6);
        for (int i = 0; i < 6; ++i) {
            lRowValues.add(null);
        }
        oDVR.setChanged(true);
        return DataValidationMissingTableModel.getRowValuesFromValidationRecord(oDVR, lRowValues);
    }

    public void enableExpressionComponent() {
        if (this.m_cmbAction.getSelectedIndex() == this.m_changeAction) {
            this.m_expExpression.setEditable(true);
        } else {
            this.m_expExpression.setText("");
            this.m_expExpression.setEditable(false);
        }
    }

    public void saveSettingsAndCleanUp() {
        this.m_cmbAction.removeActionListener((ActionListener)this.m_actionListener);
        super.saveSettingsAndCleanUp();
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.m_DVTransformModel = null;
        this.m_cmbAction = null;
        this.m_lblColumn = null;
        this.m_cmbColumn = null;
        this.m_lblAction = null;
        this.m_rowValues = null;
        this.m_actionList = null;
        this.m_columnList = null;
    }

    class cActionComboBoxListener
    implements ActionListener {
        cActionComboBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataValidationMissingEditPanel.this.enableExpressionComponent();
        }
    }
}

