/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.datavalidation;

import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationRecord;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationTransformModel;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.WorkTable;
import com.sas.wadmin.transforms.datavalidation.DataValidationBaseObjectRenderer;
import com.sas.wadmin.transforms.datavalidation.DataValidationEditPanel;
import com.sas.wadmin.transforms.datavalidation.DataValidationInvalidTableModel;
import com.sas.wadmin.visuals.SelectedColumnPanel;
import com.sas.wadmin.visuals.common.WsExpressionTextField_ITable;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;

public class DataValidationInvalidEditPanel
extends DataValidationEditPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(DataValidationInvalidEditPanel.class);
    protected JLabel m_lblColumn;
    protected WAComboBox m_cmbColumn;
    protected SelectedColumnPanel m_selLookup;
    protected JCheckBox m_chkBlanks;
    protected JLabel m_lblAction;
    protected WAComboBox m_cmbAction;
    protected JLabel m_lblExpression;
    protected WsExpressionTextField_ITable m_expExpression;
    protected DataValidationTransformModel m_DVTransformModel;
    protected cActionComboBoxListener m_actionListener = new cActionComboBoxListener();
    protected int m_changeAction = -1;
    protected List m_rowValues;
    protected List m_actionList;
    protected List m_columnList;
    protected MdObjectStore m_store;
    static final String HELP_ID = "invalid_values_win";

    public DataValidationInvalidEditPanel(DataValidationTransformModel dataValidationTransformModel, List rowValues, boolean bEditable) {
        super(bEditable);
        this.m_DVTransformModel = dataValidationTransformModel;
        this.m_rowValues = rowValues;
        this.initialize();
        this.setHelpTopic(HELP_ID);
    }

    protected void initialize() {
        super.initialize();
        this.m_cmbColumn = new WAComboBox();
        this.m_cmbColumn.setToolTipText(bundle.getString("DataValidationEditPanel.Column.tooltip.txt"));
        this.m_cmbColumn.setRenderer((ListCellRenderer)new DataValidationBaseObjectRenderer());
        this.m_lblColumn = new JLabel(bundle.getString("DataValidationEditPanel.Column.label.txt"));
        this.m_lblColumn.setLabelFor((Component)this.m_cmbColumn);
        this.m_lblColumn.setDisplayedMnemonic(bundle.getString("DataValidationEditPanel.Column.mnem").charAt(0));
        this.m_selLookup = new SelectedColumnPanel();
        this.m_selLookup.setTableLabel(bundle.getString("DataValidationEditPanel.LookupTable.label.txt"), bundle.getString("DataValidationEditPanel.LookupTable.mnem").charAt(0));
        this.m_selLookup.setColumnLabel(bundle.getString("DataValidationEditPanel.LookupColumn.label.txt"), bundle.getString("DataValidationEditPanel.LookupColumn.mnem").charAt(0));
        this.m_selLookup.setColumnSelectorDialogTitle(bundle.getString("DataValidationEditPanel.LookupDialog.title.txt"));
        this.m_selLookup.setSelectButtonToolTip(bundle.getString("DataValidationEditPanel.LookupButton.tooltip.txt"));
        this.m_selLookup.setColumnSelectorDialogHelpTopic("select_column_lookup_win");
        this.m_chkBlanks = new JCheckBox(bundle.getString("DataValidationEditPanel.Blanks.label.txt"));
        this.m_chkBlanks.setToolTipText(bundle.getString("DataValidationEditPanel.Blanks.tooltip.txt"));
        this.m_chkBlanks.setMnemonic(bundle.getString("DataValidationEditPanel.Blanks.mnem").charAt(0));
        this.m_cmbAction = new WAComboBox();
        this.m_cmbAction.setToolTipText(bundle.getString("DataValidationEditPanel.Invalid.Action.tooltip.txt"));
        this.m_lblAction = new JLabel(bundle.getString("DataValidationEditPanel.Invalid.Action.label.txt"));
        this.m_lblAction.setLabelFor((Component)this.m_cmbAction);
        this.m_lblAction.setDisplayedMnemonic(bundle.getString("DataValidationEditPanel.Invalid.Action.mnem").charAt(0));
        this.m_cmbAction.addActionListener((ActionListener)this.m_actionListener);
        this.m_expExpression = new WsExpressionTextField_ITable((ITable)this.m_DVTransformModel.getTargetTable(), "");
        this.m_expExpression.setToolTipText(bundle.getString("DataValidationEditPanel.Expression.tooltip.txt"));
        this.m_lblExpression = new JLabel(bundle.getString("DataValidationEditPanel.Expression.label.txt"));
        this.m_lblExpression.setLabelFor((Component)((Object)this.m_expExpression));
        this.m_lblExpression.setDisplayedMnemonic(bundle.getString("DataValidationEditPanel.Expression.mnem").charAt(0));
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblColumn, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.m_cmbColumn, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_selLookup, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 18, 2, new Insets(10, 0, 0, 5), 0, 0));
        this.add(this.m_chkBlanks, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 5), 0, 0));
        this.add(this.m_lblAction, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 5), 0, 0));
        this.add((Component)this.m_cmbAction, new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add(this.m_lblExpression, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 5), 0, 0));
        this.add((Component)((Object)this.m_expExpression), new GridBagConstraints(2, 5, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_store = Workspace.getMdFactory().createObjectStore(null, "DataValidationInvalidEditPanel");
        this.m_columnList = this.m_DVTransformModel.makeColumnList((ITable)this.m_DVTransformModel.getTargetTable());
        if (this.m_columnList == null || this.m_columnList.size() <= 0) {
            return;
        }
        for (int i = 0; i < this.m_columnList.size(); ++i) {
            this.m_cmbColumn.addItem(this.m_columnList.get(i));
        }
        IColumn oColumnToEdit = (IColumn)this.m_rowValues.get(7);
        for (int i = 0; i < this.m_columnList.size(); ++i) {
            IColumn column2;
            if (oColumnToEdit == null || !(column2 = (IColumn)this.m_columnList.get(i)).getID().equals(oColumnToEdit.getID())) continue;
            oColumnToEdit = column2;
        }
        if (oColumnToEdit == null && this.m_columnList.size() > 0) {
            this.m_cmbColumn.setSelectedIndex(0);
        } else if (oColumnToEdit != null) {
            this.m_cmbColumn.setSelectedItem((Object)oColumnToEdit);
        }
        IColumn lookupColumn = (IColumn)this.m_rowValues.get(9);
        String sFQID = null;
        Column oColumn = null;
        if (lookupColumn != null) {
            sFQID = lookupColumn.getID();
            oColumn = (Column)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((MdStore)this.m_store, "Column", sFQID, null, null, null, 8);
        }
        this.m_selLookup.setColumn(oColumn);
        this.m_selLookup.setStore(this.m_store);
        DataValidationRecord record = (DataValidationRecord)this.m_rowValues.get(10);
        String blanksValue = "No";
        if (record != null) {
            blanksValue = record.getProperty_FM1_DefVal();
        }
        this.m_chkBlanks.setSelected("Yes".equalsIgnoreCase(blanksValue));
        List m_metaActionList = DataValidationRecord.loadMetaActionList((String)"Missing");
        this.m_actionList = DataValidationRecord.makeActionList((List)m_metaActionList, (String)"Missing");
        this.m_changeAction = DataValidationRecord.getChangeAction((List)m_metaActionList);
        this.m_cmbAction.addItems(this.m_actionList);
        String action = (String)this.m_rowValues.get(4);
        if (action == null) {
            this.m_cmbAction.setSelectedIndex(0);
        } else {
            this.m_cmbAction.setSelectedItem((Object)action);
        }
        String expression = (String)this.m_rowValues.get(5);
        this.m_expExpression.setText(expression);
        this.enableExpressionComponent();
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() {
    }

    @Override
    public boolean validateData() {
        if (this.m_cmbColumn.getSelectedIndex() < 0) {
            MessageUtil.displayMessage((String)bundle.getString("DataValidationEditPanel.MissingColumn.Error.txt"), (String)bundle.getString("DataValidationEditPanel.MissingColumn.Title.txt"), (int)0);
            this.m_cmbColumn.requestFocus();
            return false;
        }
        if (this.m_selLookup.getColumn() == null) {
            MessageUtil.displayMessage((String)bundle.getString("DataValidationEditPanel.MissingLookupColumnTable.Error.txt"), (String)bundle.getString("DataValidationEditPanel.MissingLookupColumnTable.Title.txt"), (int)0);
            this.m_selLookup.requestFocus();
            return false;
        }
        if (this.m_cmbAction.getSelectedIndex() < 0) {
            MessageUtil.displayMessage((String)bundle.getString("DataValidationMissingEditPanel.MissingAction.Error.txt"), (String)bundle.getString("DataValidationMissingEditPanel.MissingAction.Title.txt"), (int)0);
            this.m_cmbAction.requestFocus();
            return false;
        }
        return true;
    }

    @Override
    public List getRow() {
        return this.getRow(null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getRow(String oDVRFQID, String oCustomConditionRecordFQID, DataValidationRecord oParentDVR) {
        this.m_DVTransformModel.getModel().setUndoSupported(false);
        DataValidationRecord oDVR = null;
        if (oDVRFQID == null) {
            String sEventFQID = this.m_DVTransformModel.createNewDataValidationRecord();
            oDVR = new DataValidationRecord(sEventFQID, this.m_DVTransformModel, "Invalid");
        } else {
            oDVR = new DataValidationRecord(oDVRFQID, this.m_DVTransformModel, "Invalid");
        }
        IColumn oIColumn = (IColumn)this.m_cmbColumn.getSelectedItem();
        oDVR.setPropertyTrue_PS1_DefVal(this.m_cmbAction.getSelectedItem().toString());
        oDVR.setColumn_FM1(oIColumn, this.m_DVTransformModel);
        if (this.m_selLookup.getColumn() != null) {
            try {
                WorkTable mdoTable;
                IColumn oIColumn_Lookup = null;
                ITable oITable = null;
                OMRAdapter omr = new OMRAdapter(this.m_DVTransformModel.getModel(), Workspace.getMdFactory(), "DataValidationInvalidEditPanel");
                if (this.m_DVTransformModel.getModel().getObject(this.m_selLookup.getColumn().getTable().getId()) != null) {
                    oITable = (ITable)this.m_DVTransformModel.getModel().getObject(this.m_selLookup.getColumn().getTable().getId());
                } else if (this.m_selLookup.getColumn().getTable() instanceof WorkTable) {
                    mdoTable = (WorkTable)omr.acquireOMRObject(this.m_selLookup.getColumn().getTable().getId(), "WorkTable");
                    oITable = (ITable)omr.acquireObjectUsingTemplate((Root)mdoTable);
                } else if (this.m_selLookup.getColumn().getTable() instanceof PhysicalTable) {
                    mdoTable = (PhysicalTable)omr.acquireOMRObject(this.m_selLookup.getColumn().getTable().getId(), "PhysicalTable");
                    oITable = (ITable)omr.acquireObjectUsingTemplate((Root)mdoTable);
                } else if (this.m_selLookup.getColumn().getTable() instanceof ExternalTable) {
                    mdoTable = (ExternalTable)omr.acquireOMRObject(this.m_selLookup.getColumn().getTable().getId(), "ExternalTable");
                    oITable = (ITable)omr.acquireObjectUsingTemplate((Root)mdoTable);
                } else {
                    mdoTable = (DataTable)omr.acquireOMRObject(this.m_selLookup.getColumn().getTable().getId(), "DataTable");
                    oITable = (ITable)omr.acquireObjectUsingTemplate((Root)mdoTable);
                }
                try {
                    if (this.m_DVTransformModel.getModel().getObject(this.m_selLookup.getColumn().getId()) != null) {
                        oIColumn_Lookup = (IColumn)this.m_DVTransformModel.getModel().getObject(this.m_selLookup.getColumn().getId());
                    } else {
                        Column mdoColumn = (Column)omr.acquireOMRObject(this.m_selLookup.getColumn().getId(), "Column");
                        oIColumn_Lookup = (IColumn)omr.acquireObjectUsingTemplate((Root)mdoColumn);
                    }
                    oIColumn_Lookup.setTable(oITable);
                }
                finally {
                    omr.dispose();
                }
                oDVR.setLookupColumn_FM2(oIColumn_Lookup, this.m_DVTransformModel);
            }
            catch (RemoteException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
            catch (MdException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
        }
        oDVR.createProperty_FM1_ID();
        oDVR.setProperty_FM1_Name("Blanks");
        oDVR.setProperty_FM1_DefVal(this.m_chkBlanks.isSelected() ? "Yes" : "No");
        oDVR.setExpression(this.m_expExpression.getText());
        oDVR.setAction(this.m_cmbAction.getSelectedItem().toString());
        ArrayList<Object> lRowValues = new ArrayList<Object>(11);
        for (int i = 0; i < 11; ++i) {
            lRowValues.add(null);
        }
        oDVR.setChanged(true);
        this.m_DVTransformModel.getModel().setUndoSupported(true);
        return DataValidationInvalidTableModel.getRowValuesFromValidationRecord(oDVR, lRowValues);
    }

    public void enableExpressionComponent() {
        if (this.m_cmbAction.getSelectedIndex() == this.m_changeAction) {
            this.m_expExpression.setEditable(true);
        } else {
            this.m_expExpression.setText("");
            this.m_expExpression.setEditable(false);
        }
    }

    public void saveSettingsAndCleanUp() {
        this.m_cmbAction.removeActionListener((ActionListener)this.m_actionListener);
        super.saveSettingsAndCleanUp();
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.m_DVTransformModel = null;
        this.m_cmbAction = null;
        this.m_lblColumn = null;
        this.m_cmbColumn = null;
        this.m_lblAction = null;
        this.m_rowValues = null;
        this.m_actionList = null;
        this.m_columnList = null;
        if (this.m_store != null) {
            try {
                this.m_store.dispose();
            }
            catch (RemoteException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
        }
    }

    class cActionComboBoxListener
    implements ActionListener {
        cActionComboBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataValidationInvalidEditPanel.this.enableExpressionComponent();
        }
    }
}

