/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.datavalidation;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationRecord;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationTransformModel;
import com.sas.wadmin.transforms.datavalidation.DataValidationTableColumn;
import com.sas.wadmin.transforms.datavalidation.DataValidationTableModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsMetadataTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.util.List;

public class DataValidationDuplicatesTableModel
extends DataValidationTableModel {
    private static WAdminResource bundle = WAdminResource.getBundle(DataValidationDuplicatesTableModel.class);
    protected String[] m_tableList;
    static final int NUM_VISIBLE_COLUMNS = 3;
    static final int NUM_HIDDEN_COLUMNS = 2;
    static final int DUPLICATE_COLUMN_INDEX = 0;
    static final int DUPLICATE_TABLE_INDEX = 1;
    static final int DUPLICATE_ACTION_INDEX = 2;
    static final int DUPLICATE_COLUMN_LIST_INDEX = 3;
    static final int DUPLICATE_DVR_INDEX = 4;
    static final int DUPLICATE_NUM_VALUES = 5;
    public IModelListener m_lsnrModel = new ModelListener();

    public DataValidationDuplicatesTableModel(DataValidationTransformModel DVTransformModel) {
        super(DVTransformModel);
        this.m_DVTransformModel.getModel().addModelListener(this.m_lsnrModel);
    }

    @Override
    public void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new DataValidationTableColumn(0, bundle.getString("DataValidationTableModel.Duplicate.Column.label.txt"), 250);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("DataValidationTableModel.Table.label.txt"), 200);
        this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("DataValidationTableModel.Duplicate.Action.label.txt"), 200);
        this.m_aColumns[3] = new WsMetadataTableColumn();
        this.m_aColumns[4] = new WsMetadataTableColumn();
        this.m_aColumns[0].setEditable(false);
        this.m_aColumns[1].setEditable(false);
        this.m_aColumns[2].setEditable(false);
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getHiddenColumnCount() {
        return 2;
    }

    @Override
    public String getValidationType() {
        return "Duplicate";
    }

    @Override
    public void moveDataToModel() {
        this.clear();
        List lDVRs = this.m_DVTransformModel.getModelList(this.getValidationType());
        for (int recNum = 0; recNum < lDVRs.size(); ++recNum) {
            DataValidationRecord oDVR = (DataValidationRecord)lDVRs.get(recNum);
            this.m_lData.add(this.createRowValues(oDVR));
        }
        this.fireTableModelPopulated();
        this.m_nRowInstances = this.m_lData.size() + 1;
    }

    @Override
    public List addRowValues(DataValidationRecord oDVR, List lRowValues) {
        return DataValidationDuplicatesTableModel.getRowValuesFromValidationRecord(oDVR, lRowValues);
    }

    public static List getRowValuesFromValidationRecord(DataValidationRecord oDVR, List lRowValues) {
        lRowValues.set(0, oDVR.getColumnList_FM1());
        lRowValues.set(1, oDVR.getPropertyTablesToCheck_DisplayValue());
        lRowValues.set(2, oDVR.getAction());
        lRowValues.set(3, oDVR.getColumnList_FM1());
        lRowValues.set(4, oDVR);
        return lRowValues;
    }

    @Override
    public void dispose() {
        this.m_DVTransformModel.getModel().removeModelListener(this.m_lsnrModel);
    }

    protected class ModelListener
    implements IModelListener {
        protected ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            IObject obj = ev.getModelObject();
            if (sType == "ModelController:UnknownChanges") {
                DataValidationDuplicatesTableModel.this.moveDataToModel();
            } else if (obj == DataValidationDuplicatesTableModel.this.m_DVTransformModel) {
                if (sType == "DVR:DuplicateTypeDataValidationRecordAdded") {
                    DataValidationDuplicatesTableModel.this.addDVR((DataValidationRecord)ev.getData());
                } else if (sType == "DVR:DuplicateTypeDataValidationRecordMoved") {
                    DataValidationDuplicatesTableModel.this.removeDVR((DataValidationRecord)ev.getData());
                    DataValidationDuplicatesTableModel.this.addDVR((DataValidationRecord)ev.getData());
                } else if (sType == "DVR:DuplicateTypeDataValidationRecordRemoved") {
                    DataValidationDuplicatesTableModel.this.removeDVR((DataValidationRecord)ev.getData());
                }
            }
        }
    }
}

