/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.datavalidation;

import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.BaseObject;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationRecord;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationTransformModel;
import com.sas.metadata.remote.MdException;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.swing.visuals.util.Util;
import com.sas.wadmin.transforms.datavalidation.DataValidationDuplicatesTableModel;
import com.sas.wadmin.transforms.datavalidation.DataValidationEditPanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class DataValidationDuplicatesEditPanel
extends DataValidationEditPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(DataValidationDuplicatesEditPanel.class);
    protected JLabel m_lblColumns;
    protected WAPanel m_pnlColumns;
    protected DualListSelector m_dulColumns;
    protected DefaultListModel m_list1Model;
    protected DefaultListModel m_list2Model;
    protected JList m_cmpColumns;
    protected JLabel m_lblTable;
    protected WAComboBox m_cmbTablesToCheck;
    protected JLabel m_lblAction;
    protected WAComboBox m_cmbAction;
    protected List m_rowValues;
    protected DataValidationTransformModel m_DVTransformModel;
    protected List m_actionList;
    static final String HELP_ID = "dup_values_win";

    public DataValidationDuplicatesEditPanel(DataValidationTransformModel dataValidationTransformModel, List rowValues, boolean bEditable) {
        super(bEditable);
        this.m_DVTransformModel = dataValidationTransformModel;
        this.m_rowValues = rowValues;
        this.initialize();
        this.setHelpTopic(HELP_ID);
    }

    protected void initialize() {
        super.initialize();
        this.m_dulColumns = new DualListSelector();
        this.m_dulColumns.setSourceCellRenderer((ListCellRenderer)new cListCellRenderer());
        this.m_dulColumns.setTargetCellRenderer((ListCellRenderer)new cListCellRenderer());
        this.m_dulColumns.setTargetControlsVisible(false);
        this.m_dulColumns.setAlternatingSingleButtonStyle(false);
        this.m_dulColumns.setAlternatingMultipleButtonStyle(false);
        JLabel labelComponent = (JLabel)this.m_dulColumns.getSourceLabelComponent();
        String sSourceLabelWithMnemonic = bundle.getString("DataValidationEditPanel.AvailableColumns.label.txt");
        this.m_dulColumns.setSourceLabel(Util.getLabelWithoutMnemonic((String)sSourceLabelWithMnemonic));
        int iMnemonic = Util.getDisplayedMnemonic((String)sSourceLabelWithMnemonic);
        labelComponent.setDisplayedMnemonic(iMnemonic);
        labelComponent.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)sSourceLabelWithMnemonic));
        labelComponent = (JLabel)this.m_dulColumns.getTargetLabelComponent();
        String sTargetLabelWithMnemonic = bundle.getString("DataValidationEditPanel.SelectedColumns.label.txt");
        this.m_dulColumns.setTargetLabel(Util.getLabelWithoutMnemonic((String)sTargetLabelWithMnemonic));
        iMnemonic = Util.getDisplayedMnemonic((String)sTargetLabelWithMnemonic);
        labelComponent.setDisplayedMnemonic(iMnemonic);
        labelComponent.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)sTargetLabelWithMnemonic));
        this.m_dulColumns.setToolTipText(bundle.getString("DataValidationEditPanel.Duplicate.Columns.tooltip.txt"));
        this.m_cmpColumns = (JList)this.m_dulColumns.getSourceComponent();
        this.m_cmbTablesToCheck = new WAComboBox();
        this.m_cmbTablesToCheck.setToolTipText(bundle.getString("DataValidationEditPanel.Table.tooltip.txt"));
        this.m_lblTable = new JLabel(bundle.getString("DataValidationEditPanel.Table.label.txt"));
        this.m_lblTable.setLabelFor((Component)this.m_cmbTablesToCheck);
        this.m_lblTable.setDisplayedMnemonic(bundle.getString("DataValidationEditPanel.Table.mnem").charAt(0));
        this.m_cmbAction = new WAComboBox();
        this.m_cmbAction.setToolTipText(bundle.getString("DataValidationEditPanel.Duplicate.Action.tooltip.txt"));
        this.m_lblAction = new JLabel(bundle.getString("DataValidationEditPanel.Duplicate.Action.label.txt"));
        this.m_lblAction.setLabelFor((Component)this.m_cmbAction);
        this.m_lblAction.setDisplayedMnemonic(bundle.getString("DataValidationEditPanel.Duplicate.Action.mnem").charAt(0));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_dulColumns, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_lblTable, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 5), 0, 0));
        this.add((Component)this.m_cmbTablesToCheck, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add(this.m_lblAction, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 5), 0, 0));
        this.add((Component)this.m_cmbAction, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        Dimension dim = this.getPreferredSize();
        dim.setSize(dim.getWidth() + 150.0, dim.getHeight());
        this.setPreferredSize(dim);
        this.setDataChanged(false);
    }

    public void moveDataToView() throws MdException {
        this.setListeningForChanges(false);
        this.m_list1Model = new DefaultListModel();
        this.m_list2Model = new DefaultListModel();
        List availableColumnList = this.m_DVTransformModel.makeColumnList((ITable)this.m_DVTransformModel.getTargetTable());
        List selectedColumnList = (List)this.m_rowValues.get(3);
        for (int i = 0; i < availableColumnList.size(); ++i) {
            IColumn col = (IColumn)availableColumnList.get(i);
            if (selectedColumnList != null && this.isColumnInList(col, selectedColumnList)) {
                this.m_list2Model.addElement(col);
                continue;
            }
            this.m_list1Model.addElement(col);
        }
        this.m_dulColumns.setModel((ListModel)this.m_list1Model);
        this.m_dulColumns.setTargetModel((ListModel)this.m_list2Model);
        this.m_cmbTablesToCheck.addItems(DataValidationRecord.getTablesToCheckDisplayList());
        String tablesToCheck = (String)this.m_rowValues.get(1);
        if (tablesToCheck == null) {
            this.m_cmbTablesToCheck.setSelectedItem((Object)DataValidationRecord.getTablesToCheckDisplayDefault());
        } else {
            this.m_cmbTablesToCheck.setSelectedItem((Object)tablesToCheck);
        }
        List m_metaActionList = DataValidationRecord.loadMetaActionList((String)"Duplicate");
        this.m_actionList = DataValidationRecord.makeActionList((List)m_metaActionList, (String)"Duplicate");
        this.m_cmbAction.addItems(this.m_actionList);
        String action = (String)this.m_rowValues.get(2);
        if (action == null) {
            this.m_cmbAction.setSelectedIndex(0);
        } else {
            this.m_cmbAction.setSelectedItem((Object)action);
        }
        this.setListeningForChanges(true);
    }

    public boolean isColumnInList(IColumn oIColumn, List lIColumns) {
        for (int i = 0; i < lIColumns.size(); ++i) {
            if (lIColumns.get(i) == null) continue;
            String sID = ((IColumn)lIColumns.get(i)).getID();
            if (!oIColumn.getID().equals(sID)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean validateData() {
        if (this.m_list2Model.size() <= 0) {
            MessageUtil.displayMessage((String)bundle.getString("DataValidationEditPanel.Duplicate.MissingColumn.Error.txt"), (String)bundle.getString("DataValidationEditPanel.Duplicate.MissingColumn.Title.txt"), (int)0);
            this.m_dulColumns.requestFocus();
            return false;
        }
        if (this.m_cmbTablesToCheck.getSelectedIndex() < 0) {
            MessageUtil.displayMessage((String)bundle.getString("DataValidationEditPanel.MissingTable.Error.txt"), (String)bundle.getString("DataValidationEditPanel.MissingTable.Title.txt"), (int)0);
            this.m_cmbTablesToCheck.requestFocus();
            return false;
        }
        if (this.m_cmbAction.getSelectedIndex() < 0) {
            MessageUtil.displayMessage((String)bundle.getString("DataValidationEditPanel.MissingAction.Error.txt"), (String)bundle.getString("DataValidationEditPanel.MissingAction.Title.txt"), (int)0);
            this.m_cmbAction.requestFocus();
            return false;
        }
        return true;
    }

    @Override
    public List getRow() {
        return this.getRow(null, null, null);
    }

    @Override
    public List getRow(String oDVRFQID, String oCustomConditionRecordFQID, DataValidationRecord oParentDVR) {
        DataValidationRecord oDVR = null;
        if (oDVRFQID == null) {
            String sEventFQID = this.m_DVTransformModel.createNewDataValidationRecord();
            oDVR = new DataValidationRecord(sEventFQID, this.m_DVTransformModel, "Duplicate");
        } else {
            oDVR = new DataValidationRecord(oDVRFQID, this.m_DVTransformModel, "Duplicate");
        }
        ArrayList columnList = new ArrayList();
        for (int i = 0; i < this.m_list2Model.size(); ++i) {
            columnList.add(i, this.m_list2Model.get(i));
        }
        String colNames = DataValidationTransformModel.getColumnNames(columnList);
        oDVR.setFeatureMap1_Name(colNames);
        oDVR.setColumnList_FM1(columnList);
        oDVR.createPropertyTablesToCheck_ID();
        oDVR.setPropertyTablesToCheck_Name("Table");
        oDVR.setPropertyTablesToCheck_Role("Table");
        oDVR.setPropertyTablesToCheck_DisplayValue(this.m_cmbTablesToCheck.getSelectedItem().toString());
        oDVR.setAction(this.m_cmbAction.getSelectedItem().toString());
        oDVR.setChanged(true);
        ArrayList<Object> lRowValues = new ArrayList<Object>(5);
        for (int i = 0; i < 5; ++i) {
            lRowValues.add(null);
        }
        return DataValidationDuplicatesTableModel.getRowValuesFromValidationRecord(oDVR, lRowValues);
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.m_DVTransformModel = null;
        this.m_cmbAction = null;
        this.m_lblAction = null;
        this.m_rowValues.clear();
        this.m_rowValues = null;
        this.m_actionList.clear();
        this.m_actionList = null;
        this.m_lblColumns = null;
        this.m_pnlColumns = null;
        this.m_dulColumns = null;
        this.m_list1Model.clear();
        this.m_list1Model = null;
        this.m_list2Model.clear();
        this.m_list2Model = null;
        this.m_cmpColumns = null;
        this.m_lblTable = null;
        this.m_cmbTablesToCheck = null;
    }

    public class cListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int iRow, boolean bSelected, boolean bHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, iRow, bSelected, bHasFocus);
            if (value instanceof BaseObject) {
                BaseObject baseObject = (BaseObject)value;
                this.setText(baseObject.getName());
            }
            return this;
        }
    }
}

