/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.datavalidation;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationCustomConditionRecord;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationRecord;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationTransformModel;
import com.sas.wadmin.transforms.datavalidation.DataValidationCustomAssignEditPanel;
import com.sas.wadmin.transforms.datavalidation.DataValidationTableColumn;
import com.sas.wadmin.transforms.datavalidation.DataValidationTableModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsMetadataTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.util.ArrayList;
import java.util.List;

public class DataValidationCustomConditionFalseTableModel
extends DataValidationTableModel {
    private static WAdminResource bundle = WAdminResource.getBundle(DataValidationCustomConditionFalseTableModel.class);
    protected List m_rows = null;
    static final int NUM_VISIBLE_COLUMNS = 3;
    static final int NUM_HIDDEN_COLUMNS = 9;
    static final int TOTAL_COLUMNS = 12;
    static final int CUSTOM_COLUMN_NAME_INDEX = 0;
    static final int CUSTOM_ASSIGN_STRING_INDEX = 1;
    static final int CUSTOM_TYPE_INDEX = 2;
    static final int CUSTOM_META_TYPE_INDEX = 3;
    static final int CUSTOM_EXPRESSION_INDEX = 4;
    static final int CUSTOM_TRANS_TABLE_INDEX = 5;
    static final int CUSTOM_TRANS_FROM_INDEX = 6;
    static final int CUSTOM_TRANS_TO_INDEX = 7;
    static final int CUSTOM_TRANS_SET_VALUE_TO_FLAG_INDEX = 8;
    static final int CUSTOM_TRANS_SET_VALUE_TO_INDEX = 9;
    static final int CUSTOM_TRANS_EXCEPTION_INDEX = 10;
    static final int CUSTOM_CONDITION_RECORD_INDEX = 11;
    public IModelListener m_lsnrModel;
    public String m_sConditionType;
    protected DataValidationRecord m_DataValidationRecord;

    public DataValidationCustomConditionFalseTableModel(DataValidationTransformModel DVTransformModel, String sTrueFalse, List rows, DataValidationRecord dataValidationRecord) {
        super(DVTransformModel);
        this.m_sConditionType = sTrueFalse;
        this.m_DataValidationRecord = dataValidationRecord;
        this.m_lsnrModel = new ModelListener();
        this.m_DVTransformModel.getModel().addModelListener(this.m_lsnrModel);
        if (rows == null) {
            this.m_rows = new ArrayList(0);
        } else {
            this.m_rows = rows;
            for (int i = 0; i < this.m_rows.size(); ++i) {
                if (this.m_rows.get(i) instanceof DataValidationCustomConditionRecord) {
                    DataValidationCustomConditionRecord customConditionRecord = (DataValidationCustomConditionRecord)this.m_rows.get(i);
                    this.addCondition(customConditionRecord);
                    continue;
                }
                List lRow = (List)this.m_rows.get(i);
                DataValidationCustomConditionRecord customConditionRecord = (DataValidationCustomConditionRecord)lRow.get(this.getColumnCount() + this.getHiddenColumnCount() - 1);
                this.addCondition(customConditionRecord);
            }
        }
    }

    @Override
    public void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new DataValidationTableColumn(0, bundle.getString("DataValidationTableModel.Custom.Column.label.txt"), 150);
        this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("DataValidationTableModel.Type.label.txt"), 200);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("DataValidationTableModel.Assign.label.txt"), 200);
        this.m_aColumns[3] = new WsMetadataTableColumn();
        this.m_aColumns[4] = new WsMetadataTableColumn();
        this.m_aColumns[5] = new WsMetadataTableColumn();
        this.m_aColumns[6] = new WsMetadataTableColumn();
        this.m_aColumns[7] = new WsMetadataTableColumn();
        this.m_aColumns[9] = new WsMetadataTableColumn();
        this.m_aColumns[8] = new WsMetadataTableColumn();
        this.m_aColumns[10] = new WsMetadataTableColumn();
        this.m_aColumns[11] = new WsMetadataTableColumn();
    }

    public List getMetadataRows() {
        return this.m_rows;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getHiddenColumnCount() {
        return 9;
    }

    @Override
    public List newRow() {
        ArrayList<Object> rowValues = new ArrayList<Object>();
        for (int i = 0; i < this.getColumnCount() + this.getHiddenColumnCount(); ++i) {
            rowValues.add(null);
        }
        return rowValues;
    }

    protected List createRowValues(DataValidationCustomConditionRecord oCondition) {
        ArrayList<Object> lValues = new ArrayList<Object>(this.getColumnCount() + this.getHiddenColumnCount());
        for (int i = 0; i < this.getColumnCount() + this.getHiddenColumnCount(); ++i) {
            lValues.add(null);
        }
        this.addRowValues(oCondition, lValues);
        return lValues;
    }

    @Override
    public void dispose() {
        this.m_DVTransformModel.getModel().removeModelListener(this.m_lsnrModel);
    }

    @Override
    public void moveDataToModel() {
        this.clear();
        ModelList lConditionRecords = this.m_DataValidationRecord.getCustomFalseTypeRecords();
        if (lConditionRecords == null) {
            return;
        }
        for (int recNum = 0; recNum < lConditionRecords.size(); ++recNum) {
            DataValidationCustomConditionRecord oFalseTypeRecord = (DataValidationCustomConditionRecord)lConditionRecords.get(recNum);
            this.m_lData.add(this.createRowValues(oFalseTypeRecord));
        }
        this.fireTableModelPopulated();
        this.m_nRowInstances = this.m_lData.size() + 1;
    }

    public List addRowValues(DataValidationCustomConditionRecord oCondition, List lRowValues) {
        return DataValidationCustomAssignEditPanel.getRowValuesFromValidationRecord(oCondition, lRowValues);
    }

    public void addCondition(DataValidationCustomConditionRecord oCondition) {
        if (!oCondition.getConditionType().equals(this.m_sConditionType)) {
            return;
        }
        DataValidationRecord parentRecord = oCondition.getParentRecord();
        int iRow = parentRecord.indexOfDataValidationCustomConditionRecord(oCondition);
        if (parentRecord != this.m_DataValidationRecord) {
            return;
        }
        this.insertRow(iRow - 1, this.createRowValues(oCondition));
    }

    public void removeCondition(DataValidationCustomConditionRecord oCondition) {
        if (!oCondition.getConditionType().equals(this.m_sConditionType)) {
            return;
        }
        if (oCondition.getParentRecord() != this.m_DataValidationRecord) {
            return;
        }
        if (this.getRowIndex(oCondition) >= 0) {
            this.deleteRow(this.getRowIndex(oCondition));
        }
    }

    public DataValidationCustomConditionRecord getConditionForRow(int iRow) {
        return (DataValidationCustomConditionRecord)this.getValueAt(iRow, this.getColumnCount() + this.getHiddenColumnCount() - 1);
    }

    public int getRowIndex(DataValidationCustomConditionRecord oCondition) {
        for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
            if (this.getConditionForRow(iRow) != oCondition) continue;
            return iRow;
        }
        return -1;
    }

    public DataValidationCustomConditionRecord getConditionRecordForRow(int iRow) {
        return (DataValidationCustomConditionRecord)this.getValueAt(iRow, this.getColumnCount() + this.getHiddenColumnCount() - 1);
    }

    public boolean isConditionTypeTrue() {
        return this.m_sConditionType.compareToIgnoreCase("TRUE") == 0;
    }

    protected class ModelListener
    implements IModelListener {
        protected ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            IObject obj = ev.getModelObject();
            if (sType == "ModelController:UnknownChanges") {
                DataValidationCustomConditionFalseTableModel.this.moveDataToModel();
            } else if (obj == DataValidationCustomConditionFalseTableModel.this.m_DVTransformModel || obj == DataValidationCustomConditionFalseTableModel.this.m_DataValidationRecord) {
                if (sType == "DVR:CustomConditionFalseAdded") {
                    DataValidationCustomConditionFalseTableModel.this.addCondition((DataValidationCustomConditionRecord)ev.getData());
                } else if (sType == "DVR:CustomConditionFalseMoved") {
                    DataValidationCustomConditionFalseTableModel.this.removeCondition((DataValidationCustomConditionRecord)ev.getData());
                    DataValidationCustomConditionFalseTableModel.this.addCondition((DataValidationCustomConditionRecord)ev.getData());
                } else if (sType == "DVR:CustomConditionFalseRemoved") {
                    DataValidationCustomConditionFalseTableModel.this.removeCondition((DataValidationCustomConditionRecord)ev.getData());
                }
            }
        }
    }
}

