/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.control;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.model.TransformationSourceColumnsTableModel;
import com.sas.wadmin.model.TransformationTargetColumnsTableModel;
import com.sas.workspace.WsColumnMetadataUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class LoopSourceColumnsTableModel
extends TransformationSourceColumnsTableModel {
    @Override
    public void moveDataToModel() throws MdException, RemoteException {
        this.clear();
        if (!this.m_bTableProvided) {
            this.m_lDataTables.clear();
            AssociationList alCMs = this.m_oTS.getTransformations();
            int nCMs = alCMs.size();
            for (int iCM = 0; iCM < nCMs; ++iCM) {
                ClassifierMap oCM = (ClassifierMap)alCMs.get(iCM);
                AssociationList alSources = oCM.getClassifierSources();
                int nSources = alSources.size();
                for (int iSource = 0; iSource < nSources; ++iSource) {
                    Root oSource = (Root)alSources.get(iSource);
                    if (!(oSource instanceof DataTable) || this.m_lDataTables.contains(oSource)) continue;
                    this.m_lDataTables.add(oSource);
                }
            }
        }
        this.m_lDataColumns.clear();
        if (!this.m_lDataTables.isEmpty()) {
            ArrayList<Object> alRow = new ArrayList<Object>(this.getColumnCount() + this.getHiddenColumnCount());
            alRow.add("_n_");
            alRow.add("Row Number");
            alRow.add("");
            alRow.add("");
            alRow.add(WsColumnMetadataUtil.getColumnViewTypeString((String)WsColumnMetadataUtil.getDataNumericType()));
            alRow.add(new Integer(8));
            alRow.add("");
            alRow.add("");
            alRow.add(null);
            this.m_lData.add(alRow);
            this.m_lDataColumns.add(null);
            DataTable oSource = (DataTable)this.m_lDataTables.get(0);
            AssociationList alColumns = oSource.getColumns();
            int nColumns = alColumns.size();
            for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
                Column oColumn = (Column)alColumns.get(iColumn);
                String sName = TransformationTargetColumnsTableModel.getDataTableDisplayName(oSource);
                alRow = new ArrayList(this.getColumnCount() + this.getHiddenColumnCount());
                alRow.add(oColumn.getSASColumnName());
                alRow.add(oColumn.getDesc());
                alRow.add(sName);
                alRow.add(oSource.getDesc());
                alRow.add(WsColumnMetadataUtil.getColumnViewTypeString((Column)oColumn));
                alRow.add(new Integer(oColumn.getSASColumnLength()));
                alRow.add(oColumn.getSASInformat());
                alRow.add(oColumn.getSASFormat());
                alRow.add(oColumn);
                this.m_lDataColumns.add(oColumn);
                this.m_lData.add(alRow);
            }
        }
        this.fireTableModelPopulated();
        this.m_nRowInstances = this.m_lData.size();
    }
}

