/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.conditional;

import com.sas.etl.models.job.transforms.conditional.impl.ConditionalStartTransformModel;
import com.sas.expressions.visuals.DefaultFunctionTree;
import com.sas.expressions.visuals.ExpressionBuilderPanel;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WorkspaceTree;
import com.sas.workspace.visuals.expression.ExpressionPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class ConditionTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(ConditionTab.class);
    protected ExpressionBuilderPanel m_builder;
    protected ConditionalStartTransformModel m_transform;
    protected String m_sExpression;

    public ConditionTab(ConditionalStartTransformModel transform) {
        this.setName(bundle.getString("ConditionTab.title.txt"));
        this.m_transform = transform;
        this.initialize();
        this.layoutWidgets();
        this.setHelpProduct("wdb");
        this.setHelpTopic("cond_flow_condition");
    }

    public void populateStore() {
    }

    public void moveDataToView() {
        this.setListeningForChanges(false);
        String txt = this.m_transform != null ? this.m_transform.getCondition() : "";
        this.m_builder.setExpressionText(txt);
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() {
        if (this.isEditable()) {
            this.m_transform.setCondition(this.m_builder.getExpressionText());
        }
    }

    public boolean validateData() {
        ExpressionBuilderPanel.LineInfo lineInfo = this.m_builder.computeMaxLineLength();
        return lineInfo.getLine().length() <= 255 || 1 != SASCodeGeneration.displayLineLengthMessage((String)lineInfo.getLine(), (int)lineInfo.getLineNumber());
    }

    protected void initialize() {
        this.m_builder = this.createExpressionPanel();
        this.m_builder.setValidationButtonVisible(false);
        this.m_builder.setMaximumLineLength(255);
        this.listenForDataChangesTo((JTextComponent)this.m_builder.getExpressionTextPane());
        this.setHelpTopic("about");
        this.setHelpProduct("expbuild");
    }

    protected ExpressionBuilderPanel createExpressionPanel() {
        return new ExpressionPanel(1);
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_builder, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_builder.setReadOnly(false);
    }

    public void saveSettingsAndCleanUp() {
        this.m_builder.dispose();
        super.saveSettingsAndCleanUp();
    }

    public void setExpression(String sExpression) {
        this.m_builder.setExpressionText(sExpression);
    }

    public String getExpression() {
        return this.m_builder.getExpressionText();
    }

    protected class FunctionTree
    extends DefaultFunctionTree {
        protected FunctionTree() {
        }

        public TreeCellRenderer getJTreeCellRenderer(JTree tree) {
            return new FunctionGroupRenderer();
        }

        protected class FunctionGroupRenderer
        extends DefaultTreeCellRenderer {
            protected FunctionGroupRenderer() {
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object node, boolean bSelected, boolean bExpanded, boolean bLeaf, int iRow, boolean bHasFocus) {
                JLabel lbl = (JLabel)super.getTreeCellRendererComponent(tree, node, bSelected, bExpanded, bLeaf, iRow, bHasFocus);
                lbl.setIcon(bSelected ? WorkspaceTree.getOpenedFolderIcon() : WorkspaceTree.getClosedFolderIcon());
                return lbl;
            }
        }
    }
}

