/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.casloader;

import com.sas.swing.visuals.util.Util;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListItemPanel<T extends Comparable>
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(ListItemPanel.class);
    private DefaultListModel m_listModel;
    private JList m_list;
    private Object[] m_tableList;
    private JButton m_jbSelectNone;
    private TitledBorder titledBorder1;

    public ListItemPanel() {
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    public void moveDataToView() {
        Object[] objs = this.m_list.getSelectedValues();
        this.m_tableList = new Object[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            this.m_tableList[i] = objs[i];
        }
    }

    private void _layoutWidgets() {
        JPanel tableList = new JPanel(new BorderLayout());
        this.m_listModel = new DefaultListModel();
        this.m_list = new JList(this.m_listModel);
        tableList.add((Component)new JScrollPane(this.m_list), "Center");
        tableList.setPreferredSize(new Dimension(200, 200));
        this.m_list.setToolTipText(bundle.getString("ListItemPanel.TableList.Tooltip.txt"));
        this.add(tableList, new GridBagConstraints(0, 0, 2, 5, 1.0, 1.0, 17, 1, new Insets(10, 10, 10, 5), 0, 0));
        this.m_jbSelectNone = new JButton(Util.getLabelWithoutMnemonic((String)bundle.getString("ListItemPanel.SelectNone.txt")));
        this.m_jbSelectNone.setMnemonic(Util.getDisplayedMnemonicIndex((String)bundle.getString("ListItemPanel.SelectNone.txt")));
        this.m_jbSelectNone.setToolTipText(bundle.getString("ListItemPanel.SelectNone.ToolTip.txt"));
        this.m_jbSelectNone.setEnabled(false);
        this.m_jbSelectNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ListItemPanel.this.m_list.clearSelection();
            }
        });
        this.add(this.m_jbSelectNone, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.m_list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ListItemPanel.this.m_list.getSelectedIndex() == -1) {
                    ListItemPanel.this.m_jbSelectNone.setEnabled(false);
                } else {
                    ListItemPanel.this.m_jbSelectNone.setEnabled(true);
                }
            }
        });
        this.titledBorder1 = new TitledBorder(bundle.getString("ListItemPanel.Groupbox.txt"));
        this.setBorder(this.titledBorder1);
    }

    public void setTitle(String value) {
        this.titledBorder1.setTitle(value);
    }

    public void setListModel(DefaultListModel model) {
        this.m_listModel = model;
    }

    public void addItems(List<T> items) {
        if (items == null) {
            return;
        }
        Collections.sort(items);
        this.m_listModel.clear();
        for (T item : items) {
            this.m_listModel.addElement(item);
        }
    }

    public Object[] getSelectedList() {
        return this.m_list.getSelectedValues();
    }

    public void setSelectedItem(String item) {
        this.m_list.setSelectedValue(item, true);
    }

    public void setSelectedObject(Object item) {
        this.m_list.setSelectedValue(item, true);
    }

    public void setSelectionMode(int selectionMode) {
        this.m_list.setSelectionMode(selectionMode);
    }
}

