/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.casloader;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.cas.loader.CASLoaderTransformModel;
import com.sas.etl.models.other.IProperty;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.TitledBorder;

public class CASServerInfoPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(CASServerInfoPanel.class);
    private CASLoaderTransformModel transform;
    private TitledBorder m_titledBorder;
    private ModelListener m_lsnrModel;
    private JLabel lblCasServerName;
    private WATextField txtCasServerName;
    private JLabel lblCasServerHostName;
    private WATextField txtCasServerHostName;
    private JLabel lblCasPort;
    private WATextField txtCasPort;
    private JLabel lblCasLibrary;
    private WATextField txtCasLibrary;

    public CASServerInfoPanel(CASLoaderTransformModel txf) {
        this.transform = txf;
        this.m_lsnrModel = new ModelListener();
        this.transform.getModel().addModelListener((IModelListener)this.m_lsnrModel);
        this.initialize();
        this.layoutWidgets();
        this.updateServer();
    }

    public void initialize() {
        this.m_titledBorder = WsUIUtilities.createTitledBorder((String)bundle.getString("CASServerInfoPanel.Title.txt"));
        this.txtCasServerName = new WATextField();
        this.txtCasServerName.setEditable(false);
        this.lblCasServerName = WsUIUtilities.createLabelForComponent((JComponent)this.txtCasServerName, (String)bundle.getString("CASServerInfoPanel.ServerName.txt"));
        this.lblCasServerName.setToolTipText(bundle.getString("CASServerInfoPanel.ServerName.ToolTip.txt"));
        this.txtCasServerHostName = new WATextField();
        this.txtCasServerHostName.setEditable(false);
        this.lblCasServerHostName = WsUIUtilities.createLabelForComponent((JComponent)this.txtCasServerHostName, (String)bundle.getString("CASServerInfoPanel.ServerHostName.txt"));
        this.lblCasServerHostName.setToolTipText(bundle.getString("CASServerInfoPanel.ServerHostName.ToolTip.txt"));
        this.txtCasPort = new WATextField();
        this.txtCasPort.setEditable(false);
        this.lblCasPort = WsUIUtilities.createLabelForComponent((JComponent)this.txtCasPort, (String)bundle.getString("CASServerInfoPanel.ServerPort.txt"));
        this.lblCasPort.setToolTipText(bundle.getString("CASServerInfoPanel.ServerPort.ToolTip.txt"));
        this.txtCasLibrary = new WATextField();
        this.txtCasLibrary.setEditable(false);
        this.lblCasLibrary = WsUIUtilities.createLabelForComponent((JComponent)this.txtCasLibrary, (String)bundle.getString("CASServerInfoPanel.ServerLibrary.txt"));
        this.lblCasLibrary.setToolTipText(bundle.getString("CASServerInfoPanel.ServerLibrary.ToolTip.txt"));
    }

    public void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.setBorder(this.m_titledBorder);
        this.add(this.lblCasServerName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.txtCasServerName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.add(this.lblCasServerHostName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.txtCasServerHostName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.add(this.lblCasPort, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.txtCasPort, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.add(this.lblCasLibrary, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.txtCasLibrary, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
    }

    public void moveDataToView() throws RemoteException, MdException {
        super.moveDataToView();
        this.updateServer();
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.transform.getModel().removeModelListener((IModelListener)this.m_lsnrModel);
    }

    private void updateServer() {
        IServer server;
        IPhysicalTable table = this.transform.getTargetTable();
        if (table != null && null != (server = table.getDatabaseServer())) {
            this.txtCasServerName.setText(server.getName());
            this.txtCasServerHostName.setText(server.getHost());
            this.txtCasPort.setText(Integer.toString(server.getPort()));
            IProperty prop = table.getLibrary().findOption("CASLIB");
            if (null != prop) {
                this.txtCasLibrary.setText(prop.getDefaultValue());
            }
            return;
        }
        this.txtCasServerName.setText("");
        this.txtCasServerHostName.setText("");
        this.txtCasPort.setText("");
        this.txtCasLibrary.setText("");
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            if ("DataTransform.DataTargetAdded".equals(sType)) {
                CASServerInfoPanel.this.updateServer();
            } else if ("DataTransform.DataTargetRemoved".equals(sType)) {
                CASServerInfoPanel.this.updateServer();
            }
        }
    }
}

