/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.casloader;

import com.ibm.icu.text.MessageFormat;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.data.IGeneratedTable;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.impl.BaseGeneratedTable;
import com.sas.etl.models.data.impl.BaseGeneratedTableColumn;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.cas.loader.CASLoaderTransformModel;
import com.sas.etl.models.job.transforms.common.ITransformPort;
import com.sas.etl.models.job.transforms.common.impl.BaseTransformPort;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.MdException;
import com.sas.rio.MVAResultSet;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.transforms.casloader.CASInfoObject;
import com.sas.wadmin.transforms.casloader.WABrowseResultsTextField;
import com.sas.wadmin.transforms.loader.NameValueComboBoxModel;
import com.sas.wadmin.visuals.common.ChooseColumnsPanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;

public class CASDataPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(CASDataPanel.class);
    private CASLoaderTransformModel transform;
    private TitledBorder m_titledBorder;
    private ModelListener m_lsnrModel;
    private JLabel lblCasLibrary;
    private WABrowseResultsTextField casLibraryField;
    private JLabel lblCasSource;
    private WABrowseResultsTextField casSourceField;
    private FocusListener focusListener;
    private ViewOutputTableAction m_actViewOutputTable;
    private JButton m_btnOutputColumns;
    private JLabel m_lblSourceType;
    private WAComboBox m_cmbSourceType;
    private NameValueComboBoxModel m_sourceTypeListModel;
    private WsAbstractAction m_actSourceType;
    private cDocumentListener docListener;

    public CASDataPanel(CASLoaderTransformModel txf) {
        this.transform = txf;
        this.m_lsnrModel = new ModelListener();
        this.transform.getModel().addModelListener((IModelListener)this.m_lsnrModel);
        this.focusListener = new cFocusListener();
        this.m_actViewOutputTable = new ViewOutputTableAction();
        this.docListener = new cDocumentListener();
        this.initialize();
        this.layoutWidgets();
        this.updateServer(this.transform.getTargetTable());
    }

    public void setServer(IServer server) {
        this.casLibraryField.setServer(server);
        this.casSourceField.setServer(server);
    }

    public void initialize() {
        this.m_titledBorder = WsUIUtilities.createTitledBorder((String)MessageFormat.format((String)bundle.getString("SourcePropertyTab.SourceType.CASDATA.desc.txt"), (Object[])new Object[]{"CASDATA"}));
        this.casLibraryField = new WABrowseResultsTextField(null, "CAS.LIBRARY");
        this.casLibraryField.getTextField().addFocusListener(this.focusListener);
        this.casLibraryField.getTextField().getDocument().addDocumentListener(this.docListener);
        this.listenForDataChangesTo((JTextComponent)this.casLibraryField.getTextField());
        this.lblCasLibrary = WsUIUtilities.createLabelForComponent((JComponent)((Object)this.casLibraryField), (String)bundle.getString("CASDataPanel.CasLibrary.txt"));
        this.lblCasLibrary.setToolTipText(bundle.getString("CASDataPanel.CasLibrary.ToolTip.txt"));
        this.casSourceField = new WABrowseResultsTextField(null, "CAS.SOURCE");
        this.casSourceField.getTextField().addFocusListener(this.focusListener);
        this.casSourceField.getTextField().getDocument().addDocumentListener(this.docListener);
        this.listenForDataChangesTo((JTextComponent)this.casSourceField.getTextField());
        this.lblCasSource = WsUIUtilities.createLabelForComponent((JComponent)((Object)this.casSourceField), (String)bundle.getString("CASDataPanel.CasSource.txt"));
        this.lblCasSource.setToolTipText(bundle.getString("CASDataPanel.CasSource.ToolTip.txt"));
        this.m_sourceTypeListModel = new NameValueComboBoxModel(bundle, "FileDataPanel.FileType", true);
        String[] fileTypes = this.transform.getFileTypes();
        if (fileTypes != null) {
            for (String type : fileTypes) {
                this.m_sourceTypeListModel.addItem(type);
            }
        } else {
            this.m_sourceTypeListModel.addItem("AUTO");
        }
        this.m_cmbSourceType = new WAComboBox();
        this.m_cmbSourceType.setModel((ComboBoxModel)this.m_sourceTypeListModel);
        this.m_lblSourceType = WsUIUtilities.createLabelForComponent((JComponent)this.m_cmbSourceType, (String)bundle.getString("FileDataPanel.FileType.txt"));
        this.m_lblSourceType.setToolTipText(bundle.getString("FileDataPanel.FileType.ToolTip.txt"));
        this.listenForDataChangesTo((JComboBox)this.m_cmbSourceType);
        this.m_actSourceType = new cSourceTypeAction();
        this.m_cmbSourceType.addActionListener((ActionListener)this.m_actSourceType);
        this.m_btnOutputColumns = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actViewOutputTable);
    }

    public void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.setBorder(this.m_titledBorder);
        this.add(this.lblCasLibrary, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)((Object)this.casLibraryField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.add(this.lblCasSource, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)((Object)this.casSourceField), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.add(this.m_lblSourceType, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.m_cmbSourceType, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.add(this.m_btnOutputColumns, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void updateActions() {
        boolean actionEnabled = this.isEditable() && !this.transform.isUsingUserWrittenCode();
    }

    public void moveDataToView() throws RemoteException, MdException {
        super.moveDataToView();
        boolean isListening = this.docListener.isListening;
        this.docListener.setListening(false);
        try {
            this.updateLibrary(true, this.transform.getInCasLib(), this.transform.getInCasLibType());
            this.casSourceField.setText(this.transform.getCasSource());
            this.m_sourceTypeListModel.setSelectedValue(this.transform.getExternalFileType());
        }
        finally {
            this.docListener.setListening(isListening);
        }
        this.m_actViewOutputTable.setEnabled(this.transform.getTargetTable() != null);
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.transform.getModel().removeModelListener((IModelListener)this.m_lsnrModel);
    }

    private void updateLibrary(boolean setfield, String value, String type) {
        String lib;
        String string = lib = value != null ? value : "";
        if (setfield) {
            CASInfoObject infoObject = new CASInfoObject(value, type);
            this.casLibraryField.setData(infoObject);
            this.casLibraryField.setText(value);
            this.casSourceField.setText("");
        }
        this.casSourceField.setCasLib(lib);
    }

    private void updateServer(IPhysicalTable table) {
        this.casLibraryField.setServer(table != null ? table.getDatabaseServer() : null);
        this.casSourceField.setServer(table != null ? table.getDatabaseServer() : null);
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.casLibraryField.setEditable(editable);
        this.casSourceField.setEditable(editable);
        this.m_cmbSourceType.setEnabled(editable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean launchChooseColumnsDialog(String caslib, String filename) {
        BaseTransformPort port = new BaseTransformPort(this.transform.getModel().createIDForNewObject(this.transform.getID()), this.transform.getModel());
        port.setCanIncludeSourceColumns(false);
        port.setObject((Object)this.transform.getTargetTable());
        this.setCursor(Cursor.getPredefinedCursor(3));
        WsAppServer wsAppServer = WsAppServer.createDefaultAppServer();
        BaseGeneratedTable table = new BaseGeneratedTable(this.transform.getModel().createIDForNewObject(this.transform.getID()));
        port.setGeneratedTable((IGeneratedTable)table);
        List columns = table.getColumns();
        try {
            IServer server = this.casSourceField.getServer();
            StringBuffer code = new StringBuffer();
            code.append("options cashost=\"").append(server.getHost()).append("\" casport=").append(server.getPort()).append("; \n\n").append("cas loadsession;  /* start a session */\n").append("proc cas;\n").append(" session loadsession;\n");
            code.append(" action columninfo result=r / table={caslib=\"").append(caslib).append("\" name=\"").append(filename).append("\"};\n");
            code.append(" saveresult r dataout=work.casinfo;\n").append("run;\n").append("quit;\n");
            wsAppServer.submitSASCode(code.toString());
            MVAResultSet mytablelist = null;
            mytablelist = wsAppServer.submitSQLStatement("Select * from work.casinfo");
            try {
                mytablelist.next();
            }
            catch (SQLException e1) {
                this.setCursor(Cursor.getDefaultCursor());
                MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
            }
            boolean hasMore = true;
            while (hasMore) {
                try {
                    String name = mytablelist.getString("Column");
                    if (StringUtils.isNotEmpty((String)name)) {
                        int length;
                        BaseGeneratedTableColumn column = new BaseGeneratedTableColumn((IGeneratedTable)table, this.transform.getModel().createIDForNewObject(this.transform.getID()));
                        column.setName(name.trim());
                        if (mytablelist.getMetaData().getColumnCount() > 13) {
                            String format = mytablelist.getString("Format");
                            int formatlength = mytablelist.getInt("FormattedLength");
                            if (StringUtils.isNotEmpty((String)format)) {
                                format = format.trim();
                            }
                            column.setFormat(format + formatlength + ".");
                        }
                        if ((length = mytablelist.getInt("RawLength")) == 0) {
                            length = 32;
                        }
                        column.setSASLength(length);
                        String type = mytablelist.getString("Type");
                        int sastype = 0;
                        if ("double".equalsIgnoreCase(type.trim())) {
                            sastype = 1;
                        }
                        column.setSASType(sastype);
                        columns.add(column);
                    }
                    hasMore = mytablelist.next();
                }
                catch (SQLException e) {
                    hasMore = false;
                    Workspace.getDefaultLogger().debug((Object)"SQLException", (Throwable)e);
                }
            }
        }
        catch (WsAppServerFailException exc) {
            this.setCursor(Cursor.getDefaultCursor());
            MessageUtil.displayMessage((String)exc.getLocalizedMessage(), (int)0);
            boolean code = false;
            return code;
        }
        catch (WsAppServerCodeException exc) {
            this.setCursor(Cursor.getDefaultCursor());
            if (wsAppServer != null) {
                try {
                    StringBuffer log = wsAppServer.getLogBuffer();
                    if (null != log) {
                        WATextArea txtDetails = new WATextArea(log.toString());
                        txtDetails.setBehavior(2);
                        txtDetails.setRows(25);
                        JScrollPane scroll = new JScrollPane((Component)txtDetails);
                        scroll.setVerticalScrollBarPolicy(22);
                        scroll.setHorizontalScrollBarPolicy(32);
                        MessageUtil.displayDetailsMessage((String)exc.getLocalizedMessage(), (String)bundle.getString("Common.Error.txt"), (int)0, (int)-1, (JComponent)scroll);
                    }
                }
                catch (WsAppServerFailException log) {
                    // empty catch block
                }
            }
            boolean log = false;
            return log;
        }
        finally {
            wsAppServer.dispose();
        }
        ChooseColumnsPanel pnlChooseColumns = new ChooseColumnsPanel((ITransformPort<IPhysicalTable>)port, null);
        pnlChooseColumns.setEditable(this.isEditable());
        pnlChooseColumns.setHelpProduct("wdb");
        pnlChooseColumns.setHelpTopic("select_output_columns");
        WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("DirectiveTargetPanel.ChooseColumns.Title.txt"), true, (WAPanel)pnlChooseColumns);
        dlg.setEditable(this.isEditable());
        dlg.setResizable(true);
        dlg.setPreferredSize(new Dimension(750, 600));
        dlg.show();
        this.setCursor(Cursor.getDefaultCursor());
        return false;
    }

    private class ModelListener
    implements IModelListener {
        private boolean isListening = true;

        private ModelListener() {
        }

        public void setListening(boolean value) {
            this.isListening = value;
        }

        public void modelChanged(ModelEvent ev) {
            if (!this.isListening) {
                return;
            }
            String sType = ev.getType();
            if ("CASLoaderTransformModel:CASLibraryChanged".equals(sType)) {
                CASDataPanel.this.updateLibrary(true, ev.getData() != null ? ev.getData().toString() : "", CASDataPanel.this.transform.getInCasLibType());
            } else if ("CASLoaderTransformModel:CASSourceChanged".equals(sType)) {
                CASDataPanel.this.casSourceField.setText(ev.getData() != null ? ev.getData().toString() : "");
            } else if ("DataTransform.DataTargetAdded".equals(sType)) {
                CASDataPanel.this.m_actViewOutputTable.setEnabled(true);
            } else if ("DataTransform.DataTargetRemoved".equals(sType)) {
                CASDataPanel.this.m_actViewOutputTable.setEnabled(false);
            }
        }
    }

    private class ViewOutputTableAction
    extends WsAbstractAction {
        public ViewOutputTableAction() {
            super(bundle, "FileDataPanel.ViewOutputTableAction", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForPublicType("Column"));
        }

        public void actionPerformed(ActionEvent e) {
            CASDataPanel.this.launchChooseColumnsDialog(CASDataPanel.this.casLibraryField.getText(), CASDataPanel.this.casSourceField.getText());
        }
    }

    private class cFocusListener
    implements FocusListener {
        private cFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent arg0) {
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            if (arg0.getComponent() == CASDataPanel.this.casLibraryField.getTextField()) {
                if (CASDataPanel.this.casLibraryField.getData() instanceof CASInfoObject) {
                    CASInfoObject library = (CASInfoObject)CASDataPanel.this.casLibraryField.getData();
                    CASDataPanel.this.transform.setInCasLib(library.getName());
                    CASDataPanel.this.transform.setInCasLibType(library.getType());
                }
                CASDataPanel.this.transform.setInCasLib(CASDataPanel.this.casLibraryField.getText());
            } else if (arg0.getComponent() == CASDataPanel.this.casSourceField.getTextField()) {
                CASDataPanel.this.transform.setCasSource(CASDataPanel.this.casSourceField.getText());
            }
        }
    }

    private class cDocumentListener
    implements DocumentListener {
        private boolean isListening = true;

        private cDocumentListener() {
        }

        public void setListening(boolean value) {
            this.isListening = value;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateValue(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateValue(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateValue(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateValue(DocumentEvent e) {
            if (!this.isListening) {
                return;
            }
            if (CASDataPanel.this.casLibraryField.getTextField().getDocument() == e.getDocument()) {
                CASDataPanel.this.updateLibrary(false, CASDataPanel.this.casLibraryField.getText(), null);
                boolean isListening = CASDataPanel.this.m_lsnrModel.isListening;
                CASDataPanel.this.m_lsnrModel.setListening(false);
                try {
                    if (CASDataPanel.this.casLibraryField.getData() instanceof CASInfoObject) {
                        CASInfoObject library = (CASInfoObject)CASDataPanel.this.casLibraryField.getData();
                        CASDataPanel.this.transform.setInCasLib(library.getName());
                        CASDataPanel.this.transform.setInCasLibType(library.getType());
                    }
                    CASDataPanel.this.transform.setInCasLib(CASDataPanel.this.casLibraryField.getText());
                }
                finally {
                    CASDataPanel.this.m_lsnrModel.setListening(isListening);
                }
            }
            if (CASDataPanel.this.casSourceField.getTextField().getDocument() == e.getDocument()) {
                boolean isListening = CASDataPanel.this.m_lsnrModel.isListening;
                CASDataPanel.this.m_lsnrModel.setListening(false);
                try {
                    CASDataPanel.this.transform.setCasSource(CASDataPanel.this.casSourceField.getText());
                }
                finally {
                    CASDataPanel.this.m_lsnrModel.setListening(isListening);
                }
            }
        }
    }

    protected class cSourceTypeAction
    extends WsAbstractAction {
        protected cSourceTypeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!CASDataPanel.this.isListeningForChanges()) {
                return;
            }
            CASDataPanel.this.transform.setExternalFileType(CASDataPanel.this.m_sourceTypeListModel.getSelectedValue());
        }
    }
}

