/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.businessrules;

import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.job.transforms.businessrules.BusinessRuleTransformModel;
import com.sas.etl.models.job.transforms.common.ITransformPort;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.transforms.businessrules.TargetPortTableModel;
import com.sas.wadmin.visuals.common.ChooseColumnsPanel;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class BusinessRuleTargetPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(BusinessRuleTargetPanel.class);
    private BusinessRuleTransformModel m_transform;
    private TargetPortTableModel m_mdlOutputs;
    private JToolBar m_tools;
    private JScrollPane m_scrOutputs;
    private WsTable m_tblOutputs;
    private AddTableAction m_actAddTable;
    private ChooseColumnsAction m_actChooseColumns;

    public BusinessRuleTargetPanel(BusinessRuleTransformModel transform) {
        this.m_transform = transform;
        this.initialize();
    }

    protected void initialize() {
        this.createActions();
        this.createModel();
        this.createToolBar();
        this.createTable();
        this.layoutComponents();
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.add(this.m_tools, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_scrOutputs, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void createActions() {
        this.m_actAddTable = new AddTableAction();
        this.m_actChooseColumns = new ChooseColumnsAction();
    }

    private void createModel() {
        this.m_mdlOutputs = new TargetPortTableModel(this.m_transform);
        this.m_mdlOutputs.moveDataToModel();
    }

    private void createTable() {
        this.m_tblOutputs = new WsTable((WsAbstractTableModel)this.m_mdlOutputs);
        this.m_scrOutputs = new JScrollPane((Component)this.m_tblOutputs);
        this.m_tblOutputs.setRowHeaderVisible(false);
        this.m_tblOutputs.setSortingEnabled(false);
        this.m_tblOutputs.setAutoResizeMode(3);
        this.m_tblOutputs.setDefaultAction((Action)((Object)this.m_actChooseColumns));
        this.m_tblOutputs.setRowSelectionAllowed(true);
        this.m_tblOutputs.setSelectionMode(0);
        this.m_tblOutputs.setCellSelectionEnabled(false);
        TablePopupMenuListener lsnrPopup = new TablePopupMenuListener();
        this.m_tblOutputs.setTablePopupMenuRequestListener((WsPopupMenuRequestListener)lsnrPopup);
        this.m_tblOutputs.setRowHeaderPopupMenuRequestListener((WsPopupMenuRequestListener)lsnrPopup);
        TableSelectionListener listnr = new TableSelectionListener();
        this.m_tblOutputs.addMouseListener((MouseListener)listnr);
        this.m_scrOutputs.addMouseListener(listnr);
    }

    private void createToolBar() {
        this.m_tools = WsUIUtilities.createToolBar();
        this.m_tools.add(WsUIUtilities.createFlatTextIconButton((WsAbstractAction)this.m_actAddTable));
        this.m_tools.addSeparator();
        this.m_tools.add(WsUIUtilities.createFlatTextIconButton((WsAbstractAction)this.m_actChooseColumns));
    }

    private boolean launchChooseColumnsDialog(ITransformPort<IPhysicalTable> port, IPhysicalTable sourceTable) {
        ChooseColumnsPanel pnlChooseColumns = new ChooseColumnsPanel(port, sourceTable);
        pnlChooseColumns.setEditable(this.isEditable());
        WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.formatString("BusinessRuleTargetPanel.ChooseColumns.Title.fmt", (Object)((IPhysicalTable)port.getObject()).getName()), true, (WAPanel)pnlChooseColumns);
        dlg.setEditable(this.m_bEditable);
        dlg.setResizable(true);
        dlg.setPreferredSize(new Dimension(750, 600));
        dlg.show();
        if (dlg.getReturnValue() == 1) {
            if (pnlChooseColumns.hasSelectedColumnListChanged()) {
                this.setDataChanged(true);
            }
            return true;
        }
        return false;
    }

    private ITransformPort<IPhysicalTable> getSelectedPort() {
        return this.m_mdlOutputs.getPortForRow(this.m_tblOutputs.getSelectedRow());
    }

    public void setEditable(boolean isEditable) {
        super.setEditable(isEditable);
        ITransformPort<IPhysicalTable> port = this.getSelectedPort();
        this.m_actAddTable.setEnabled(isEditable && port != null && port.getObject() == null);
        this.m_actChooseColumns.setEnabled(port != null && port.getObject() != null);
    }

    public void moveDataToView() {
    }

    private class ChooseColumnsAction
    extends WsAbstractAction {
        public ChooseColumnsAction() {
            super(bundle, "BusinessRuleTargetPanel.ChooseColumnsAction", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForPublicType("Column"));
        }

        public void actionPerformed(ActionEvent e) {
            ITransformPort port = BusinessRuleTargetPanel.this.getSelectedPort();
            if (port == null) {
                return;
            }
            BusinessRuleTargetPanel.this.launchChooseColumnsDialog((ITransformPort<IPhysicalTable>)port, BusinessRuleTargetPanel.this.m_transform.getSourceTable());
            BusinessRuleTargetPanel.this.setEditable(BusinessRuleTargetPanel.this.isEditable());
        }
    }

    private class AddTableAction
    extends WsAbstractAction {
        public AddTableAction() {
            super(bundle, "BusinessRuleTargetPanel.AddTableAction", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("File:New:Table"));
        }

        public void actionPerformed(ActionEvent e) {
            BusinessRuleTargetPanel.this.m_transform.createPortGeneratedTable(BusinessRuleTargetPanel.this.getSelectedPort());
            BusinessRuleTargetPanel.this.setEditable(BusinessRuleTargetPanel.this.isEditable());
        }
    }

    private class TablePopupMenuListener
    implements WsPopupMenuRequestListener {
        private TablePopupMenuListener() {
        }

        public void popupMenuRequested(MouseEvent ev) {
            JPopupMenu mnuPopup = new JPopupMenu();
            mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)BusinessRuleTargetPanel.this.m_actAddTable));
            mnuPopup.addSeparator();
            mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)BusinessRuleTargetPanel.this.m_actChooseColumns));
            mnuPopup.show((Component)ev.getSource(), ev.getX(), ev.getY());
        }
    }

    private class TableSelectionListener
    extends MouseAdapter {
        private TableSelectionListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            BusinessRuleTargetPanel.this.setEditable(BusinessRuleTargetPanel.this.isEditable());
        }
    }

    private class TableSelectedListener
    implements ActionListener {
        private TableSelectedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BusinessRuleTargetPanel.this.setEditable(BusinessRuleTargetPanel.this.isEditable());
        }
    }
}

