/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.businessrules;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IExternalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.data.businessrule.IBusinessRuleFlowColumn;
import com.sas.etl.models.data.businessrule.IBusinessRuleFlowTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.IMappingsContainer;
import com.sas.etl.models.job.impl.DesignTimeJobModel;
import com.sas.etl.models.job.transforms.businessrules.mapping.IBusinessRuleMapping;
import com.sas.etl.models.job.transforms.businessrules.mapping.IBusinessRuleMappingsContainer;
import com.sas.etl.models.job.transforms.sql.IJoin;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.etl.models.job.transforms.sql.ISelectResultsContainer;
import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.transforms.businessrules.BusinessRuleMappingsModel;
import com.sas.wadmin.transforms.businessrules.BusinessRuleTableMappingsPanel;
import com.sas.wadmin.transforms.businessrules.BusinessRuleTargetColumnsTableModel;
import com.sas.wadmin.visuals.common.MappingsTab;
import com.sas.wadmin.visuals.common.SourceColumnsTableModel;
import com.sas.wadmin.visuals.common.TableUIUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsDefaultTableRowModel;
import com.sas.workspace.WsDropMenuAction;
import com.sas.workspace.WsMapping;
import com.sas.workspace.WsObjectListModel;
import com.sas.workspace.WsObjectSelectionEvent;
import com.sas.workspace.WsObjectSelectionListener;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsTableRowModelEvent;
import com.sas.workspace.WsTableRowModelListener;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.WsUndoManager;
import com.sas.workspace.models.SimpleObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class BusinessRuleMappingsTab
extends WAPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(MappingsTab.class);
    private static final int MIN_TABLE_WIDTH = 50;
    private static final int MIN_TABLE_HEIGHT = 100;
    private static final int PREF_TABLE_WIDTH = 150;
    private static final int PREF_TABLE_HEIGHT = 200;
    private static final int MIN_MAPPINGS_WIDTH = 20;
    private static final int MIN_MAPPINGS_HEIGHT = 100;
    private static final int PREF_MAPPINGS_WIDTH = 50;
    private static final int PREF_MAPPINGS_HEIGHT = 200;
    private static final int MIN_WIDTH = 120;
    private static final int MEDIUM_WIDTH = 320;
    private static final int PREF_WIDTH = 350;
    private IBusinessRuleMappingsContainer m_container;
    private DesignTimeJobModel m_mdlJob;
    private SourceColumnsTableModel m_mdlSourceColumns;
    private BusinessRuleTargetColumnsTableModel m_mdlTargetColumns;
    private BusinessRuleMappingsModel m_mdlMappings;
    private ITable[] m_aSourceTables;
    private boolean[] m_aSourceTableEditables;
    private IBusinessRuleFlowTable[] m_aTargetTables;
    private boolean[] m_aTargetTableEditables;
    private MappingsTab.Configuration m_configuration;
    private JCheckBox m_ckbAllFields;
    private JCheckBox m_ckbDistinctRows;
    private JPanel m_pnlSetOperatorSpecifics;
    private JToolBar m_barTools;
    private JSplitPane m_spltInner;
    private JSplitPane m_spltOuter;
    private WsTable m_tblSourceColumns;
    private JScrollPane m_scrSourceColumns;
    private JLabel m_lblSourceTables;
    private WAComboBox m_cmbSourceTables;
    private JLabel m_lblSourceTable;
    private JButton m_btnExpandSourcePanel;
    private JButton m_btnCollapseSourcePanel;
    private JToolBar m_pnlSourceLabel;
    private JPanel m_pnlSource;
    private JPopupMenu m_mnuSourceTablePopup;
    private JPopupMenu m_mnuSourceViewportPopup;
    private WsTable m_tblTargetColumns;
    private JScrollPane m_scrTargetColumns;
    private JLabel m_lblTargetTables;
    private WAComboBox m_cmbTargetTables;
    private JLabel m_lblTargetTable;
    private JButton m_btnExpandTargetPanel;
    private JButton m_btnCollapseTargetPanel;
    private JToolBar m_pnlTargetLabel;
    private JPanel m_pnlTarget;
    private JPopupMenu m_mnuTargetTablePopup;
    private JPopupMenu m_mnuTargetViewportPopup;
    private BusinessRuleTableMappingsPanel m_pnlMappings;
    private JPanel m_pnlCenterLabel;
    private JPanel m_pnlCenter;
    private JPopupMenu m_mnuMappingsPopup;
    private WsAbstractAction m_actMapAll;
    private WsAbstractAction m_actMapSelected;
    private WsAbstractToggleAction m_actIncludeTransformationInMapping;
    private WsDropMenuAction m_actFixWarningDropMenu;
    private WsAbstractAction m_actUndo;
    private WsAbstractAction m_actRedo;
    private WsDropMenuAction m_actDelete;
    private WsAbstractAction m_actDeleteMappings;
    private WsAbstractAction m_actExpandSourcePanel;
    private WsAbstractAction m_actCollapseSourcePanel;
    private WsAbstractAction m_actExpandTargetPanel;
    private WsAbstractAction m_actCollapseTargetPanel;
    private WsAbstractAction m_actSelectAllSourceColumns;
    private WsAbstractAction m_actSelectAllMappings;
    private WsAbstractAction m_actSelectAllTargetColumns;
    private WsAbstractToggleAction m_actAllFields;
    private WsAbstractToggleAction m_actDistinctRows;
    private ChangeListener m_lsnrUndo;
    private ModelListener m_lsnrModel;
    private Border m_brdrPanel;
    private ITable m_tblSelectedSource;
    private boolean m_bSelectedSourceTableEditable;
    private IBusinessRuleFlowTable m_tblSelectedTarget;
    private boolean m_bSelectedTargetTableEditable;
    private boolean m_bSourcePanelExpanded;
    private boolean m_bTargetPanelExpanded;
    private boolean m_bSplitLocationSet;
    private int m_cxInnerOriginal;
    private int m_cxOuterOriginal;
    private int m_cxDividerSize;
    private JRootPane m_rootPane;

    public BusinessRuleMappingsTab(IBusinessRuleMappingsContainer container) {
        this(container, new MappingsTab.Configuration());
    }

    public BusinessRuleMappingsTab(IBusinessRuleMappingsContainer container, MappingsTab.Configuration configuration) {
        this.m_container = container;
        this.m_mdlJob = (DesignTimeJobModel)container.getModel();
        this.m_configuration = configuration;
        this.initialize();
        this.setHelpProduct("wdb");
        this.setHelpTopic("bus_rules_map");
    }

    protected void initialize() {
        this.createActions();
        this.createSetOperatorSpecifics();
        this.createToolBar();
        this.createPanelBorder();
        this.createSourceColumnsTableModel();
        this.createSourceColumnsTable();
        this.createSourceColumnsTablePopupMenu();
        this.createSourceColumnsViewportPopupMenu();
        this.createSourcePanelLabel();
        this.createSourcePanel();
        this.createTargetColumnsTableModel();
        this.createTargetColumnsTable();
        this.createTargetColumnsTablePopupMenu();
        this.createTargetColumnsViewportPopupMenu();
        this.createTargetPanelLabel();
        this.createTargetPanel();
        this.createMappingsModel();
        this.createMappingsPanel();
        this.createMappingsPopupMenu();
        this.createCenterPanelLabel();
        this.createCenterPanel();
        this.m_spltInner = this.createSplitPane(this.m_pnlSource, this.m_pnlCenter);
        this.m_spltInner.setName("inner");
        this.m_spltOuter = this.createSplitPane(this.m_spltInner, this.m_pnlTarget);
        this.m_spltOuter.setName("outer");
        this.layoutComponents();
        this.m_aSourceTables = this.m_container.getSourceTables();
        this.m_aTargetTables = this.m_container.getSourceBusinessRuleTables();
        this.m_lsnrModel = new ModelListener();
        this.m_container.getModel().addModelListener((IModelListener)this.m_lsnrModel);
    }

    private void createActions() {
        this.m_actMapAll = new MapAllAction();
        this.m_actMapSelected = new MapSelectedColumnsAction();
        this.m_actIncludeTransformationInMapping = new IncludeTransformationInMappingAction();
        this.m_actFixWarningDropMenu = new FixWarningDropMenuAction();
        this.m_actUndo = new UndoAction();
        this.m_actRedo = new RedoAction();
        this.m_actAllFields = new AllFieldsToggleAction();
        this.m_actDistinctRows = new DistinctRowsToggleAction();
        this.m_actExpandSourcePanel = new ExpandSourcePanelAction();
        this.m_actCollapseSourcePanel = new CollapseSourcePanelAction();
        this.m_actExpandTargetPanel = new ExpandTargetPanelAction();
        this.m_actCollapseTargetPanel = new CollapseTargetPanelAction();
        this.m_actDelete = new DeleteAction();
        this.m_actDeleteMappings = new DeleteMappingsAction();
        this.m_actDelete.setDropMenu(this.createDeleteDropMenu());
        this.m_actSelectAllSourceColumns = new SelectAllSourceColumnsAction();
        this.m_actSelectAllMappings = new SelectAllMappingsAction();
        this.m_actSelectAllTargetColumns = new SelectAllTargetColumnsAction();
        ActionMap mapActions = this.getActionMap();
        mapActions.put("delete", (Action)this.m_actDeleteMappings);
        mapActions.put("selectAll", (Action)this.m_actSelectAllMappings);
        InputMap mapInput = this.getInputMap(1);
        mapInput.put(KeyStroke.getKeyStroke(127, 0), "delete");
        mapInput.put(KeyStroke.getKeyStroke(65, 2), "selectAll");
    }

    private JPopupMenu createDeleteDropMenu() {
        JPopupMenu mnuDrop = new JPopupMenu();
        if (this.m_configuration.isSourceTablesEditable()) {
            mnuDrop.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actDeleteMappings));
        }
        return mnuDrop;
    }

    private void createSetOperatorSpecifics() {
        if (this.m_configuration.isSetOperatorSpecificsEnabled()) {
            this.m_ckbAllFields = WsUIUtilities.createCheckBox((WsAbstractToggleAction)this.m_actAllFields);
            this.m_ckbDistinctRows = WsUIUtilities.createCheckBox((WsAbstractToggleAction)this.m_actDistinctRows);
            this.listenForDataChangesTo(this.m_ckbAllFields);
            this.listenForDataChangesTo(this.m_ckbDistinctRows);
            this.m_pnlSetOperatorSpecifics = new JPanel(new GridBagLayout());
            this.m_pnlSetOperatorSpecifics.add((Component)this.m_ckbAllFields, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.m_pnlSetOperatorSpecifics.add((Component)this.m_ckbDistinctRows, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.m_pnlSetOperatorSpecifics.add((Component)new JPanel(), new GridBagConstraints(2, 0, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.m_pnlSetOperatorSpecifics.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, SystemColor.controlShadow));
        }
    }

    private void createToolBar() {
        this.m_barTools = this.createToolBarInstant();
    }

    protected JToolBar createToolBarInstant() {
        JToolBar toolbar = WsUIUtilities.createToolBar();
        toolbar.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actMapAll));
        toolbar.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actMapSelected));
        toolbar.addSeparator();
        toolbar.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actUndo));
        toolbar.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actRedo));
        toolbar.add(WsUIUtilities.createDropMenuButton((WsDropMenuAction)this.m_actDelete));
        return toolbar;
    }

    private void createSourceColumnsTableModel() {
        this.m_mdlSourceColumns = new SourceColumnsTableModel((IMappingsContainer)this.m_container);
        if (!this.m_configuration.isSourceTablesEditable()) {
            for (int iColumn = 0; iColumn < this.m_mdlSourceColumns.getColumnCount(); ++iColumn) {
                this.m_mdlSourceColumns.getColumn(iColumn).setEditable(false);
            }
        }
    }

    private void createSourceColumnsTable() {
        this.m_tblSourceColumns = new WsTable((WsAbstractTableModel)this.m_mdlSourceColumns);
        this.m_tblSourceColumns.setName("source");
        this.m_tblSourceColumns.setKeepSortedEnabled(true);
        this.m_tblSourceColumns.setMultipleSelectionDragEnabled(this.m_configuration.isDragMultipleSourceColumnsEnabled());
        int[] aHiddenColumns = this.m_configuration.getHiddenColumnsInSourceColumnsTable();
        for (int iColumn = 0; iColumn < aHiddenColumns.length; ++iColumn) {
            this.m_tblSourceColumns.removeColumn(aHiddenColumns[iColumn]);
        }
        String rootKey = this.m_configuration.getSettingsKeyPrefix() + "." + this.m_configuration.getWhereUsedSettingsKeyPrefix() + ".";
        this.m_tblSourceColumns.restoreSettings(rootKey + this.m_configuration.getSourceTableSettingsKeyPrefix());
        SourceColumnsTablePopupListener lsnr = new SourceColumnsTablePopupListener();
        this.m_tblSourceColumns.setTablePopupMenuRequestListener((WsPopupMenuRequestListener)lsnr);
        this.m_tblSourceColumns.setRowHeaderPopupMenuRequestListener((WsPopupMenuRequestListener)lsnr);
        this.m_tblSourceColumns.setViewportPopupMenuRequestListener((WsPopupMenuRequestListener)new SourceColumnsViewportPopupListener());
        this.m_tblSourceColumns.getSelectionModel().addListSelectionListener(new SourceColumnsSelectionListener());
        ((WsDefaultTableRowModel)this.m_tblSourceColumns.getRowModel()).addRowModelListener((WsTableRowModelListener)new SourceRowModelListener());
        this.m_scrSourceColumns = new JScrollPane((Component)this.m_tblSourceColumns);
        this.m_scrSourceColumns.setMinimumSize(new Dimension(50, 100));
        this.m_scrSourceColumns.setPreferredSize(new Dimension(150, 200));
        this.m_scrSourceColumns.setBorder(BorderFactory.createEmptyBorder());
    }

    private void createSourceColumnsTablePopupMenu() {
        this.m_mnuSourceTablePopup = this.createSourceTablePopupMenu();
    }

    protected JPopupMenu createSourceTablePopupMenu() {
        JPopupMenu sourceTablePopupMenu = new JPopupMenu();
        sourceTablePopupMenu.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actMapAll));
        sourceTablePopupMenu.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actMapSelected));
        sourceTablePopupMenu.addSeparator();
        sourceTablePopupMenu.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actSelectAllSourceColumns));
        return sourceTablePopupMenu;
    }

    private void createSourceColumnsViewportPopupMenu() {
        this.m_mnuSourceViewportPopup = new JPopupMenu();
        this.m_mnuSourceViewportPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actSelectAllSourceColumns));
    }

    private void createSourcePanelLabel() {
        this.m_pnlSourceLabel = WsUIUtilities.createToolBar();
        this.m_pnlSourceLabel.setLayout(new GridBagLayout());
        this.m_btnExpandSourcePanel = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actExpandSourcePanel);
        this.m_btnCollapseSourcePanel = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actCollapseSourcePanel);
        this.m_btnCollapseSourcePanel.setVisible(false);
        if (this.m_configuration.isMultipleSourceTablesEnabled()) {
            this.m_cmbSourceTables = new WAComboBox();
            this.m_cmbSourceTables.addItemListener((ItemListener)new SourceTableSelectionListener());
            this.m_lblSourceTables = WsUIUtilities.createLabelForComponent((JComponent)this.m_cmbSourceTables, (String)this.m_configuration.getSourceTableLabel());
            this.m_pnlSourceLabel.add((Component)this.m_lblSourceTables, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 3, 0, 3), 0, 0));
            this.m_pnlSourceLabel.add((Component)this.m_cmbSourceTables, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
            this.m_pnlSourceLabel.add((Component)this.m_btnExpandSourcePanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.m_pnlSourceLabel.add((Component)this.m_btnCollapseSourcePanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this.m_lblSourceTable = new JLabel();
            this.m_lblSourceTables = WsUIUtilities.createLabelForComponent((JComponent)this.m_tblSourceColumns, (String)this.m_configuration.getSourceTableLabel());
            this.m_pnlSourceLabel.add((Component)this.m_lblSourceTables, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
            this.m_pnlSourceLabel.add((Component)this.m_lblSourceTable, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(3, 0, 3, 3), 0, 0));
            this.m_pnlSourceLabel.add((Component)this.m_btnExpandSourcePanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.m_pnlSourceLabel.add((Component)this.m_btnCollapseSourcePanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    private void refreshSQLSetOperatorsSpecifics() {
        IQuery query = null;
        if (this.m_container instanceof ISelectResultsContainer && this.m_configuration.isSetOperatorSpecificsEnabled()) {
            query = ((ISelectResultsContainer)this.m_container).getParentQuery();
            this.m_ckbDistinctRows.setSelected(query.useDistinct());
            this.m_ckbAllFields.setSelected(query.useImplicit());
        }
    }

    private void refreshSourcePanelLabel() {
        if (this.m_configuration.isMultipleSourceTablesEnabled()) {
            ITable tblSelected = this.getSelectedSourceTable();
            this.m_cmbSourceTables.removeAllItems();
            this.m_cmbSourceTables.addItem((Object)bundle.getString("MappingsTab.ComboBoxItem.AllTables.txt"));
            this.m_cmbSourceTables.addItem(WAComboBox.SEPARATOR);
            for (int iTable = 0; iTable < this.m_aSourceTables.length; ++iTable) {
                this.m_cmbSourceTables.addItem((Object)TableUIUtilities.getViewName(this.m_aSourceTables[iTable]));
                if (this.m_aSourceTables[iTable] != tblSelected) continue;
                this.m_cmbSourceTables.setSelectedIndex(iTable + 2);
            }
            if (this.m_aSourceTables.length == 1) {
                this.m_cmbSourceTables.setSelectedIndex(2);
            }
        } else {
            this.m_lblSourceTable.setText(this.m_aSourceTables.length > 0 ? TableUIUtilities.getViewName(this.m_aSourceTables[0]) : "");
            this.setSelectedSourceTable(this.m_aSourceTables.length > 0 ? this.m_aSourceTables[0] : null);
        }
    }

    private void createSourcePanel() {
        this.m_pnlSource = new JPanel(new BorderLayout());
        this.m_pnlSource.setBorder(this.m_brdrPanel);
        this.m_pnlSource.add((Component)this.m_pnlSourceLabel, "North");
        this.m_pnlSource.add((Component)this.m_scrSourceColumns, "Center");
    }

    private void setSourceColumnsTableEditable(boolean bEditable) {
        if (!this.m_configuration.isSourceTablesEditable()) {
            return;
        }
        for (int iColumn = 0; iColumn < this.m_mdlSourceColumns.getColumnCount(); ++iColumn) {
            this.m_mdlSourceColumns.getColumn(iColumn).setEditable(bEditable);
        }
    }

    private void createTargetColumnsTableModel() {
        this.m_mdlTargetColumns = new BusinessRuleTargetColumnsTableModel(this.m_container);
        this.m_mdlTargetColumns.setMappingsFilter(this.m_configuration.getMappingsFilter());
        if (!this.m_configuration.isTargetTablesEditable()) {
            for (int iColumn = 0; iColumn < this.m_mdlTargetColumns.getColumnCount(); ++iColumn) {
                if (iColumn == 0 || iColumn == 1) continue;
                this.m_mdlTargetColumns.getColumn(iColumn).setEditable(false);
            }
        }
    }

    private void createTargetColumnsTable() {
        this.m_tblTargetColumns = new WsTable((WsAbstractTableModel)this.m_mdlTargetColumns);
        this.m_tblTargetColumns.setName("target");
        this.m_tblTargetColumns.setKeepSortedEnabled(true);
        this.m_tblTargetColumns.setColumnHeaderToolTipsEnabled(true);
        this.m_tblTargetColumns.setMultipleSelectionDragEnabled(this.m_configuration.isDragMultipleTargetColumnsEnabled());
        this.m_tblTargetColumns.getColumnModel().getColumn(0).setResizable(false);
        this.m_tblTargetColumns.getColumnModel().getColumn(1).setResizable(false);
        String rootKey = this.m_configuration.getSettingsKeyPrefix() + "." + this.m_configuration.getWhereUsedSettingsKeyPrefix() + ".";
        this.m_tblTargetColumns.restoreSettings(rootKey + this.m_configuration.getTargetTableSettingsKeyPrefix());
        TargetColumnsTablePopupListener lsnr = new TargetColumnsTablePopupListener();
        this.m_tblTargetColumns.setTablePopupMenuRequestListener((WsPopupMenuRequestListener)lsnr);
        this.m_tblTargetColumns.setRowHeaderPopupMenuRequestListener((WsPopupMenuRequestListener)lsnr);
        this.m_tblTargetColumns.setViewportPopupMenuRequestListener((WsPopupMenuRequestListener)new TargetColumnsViewportPopupListener());
        this.m_tblTargetColumns.getSelectionModel().addListSelectionListener(new TargetColumnsSelectionListener());
        ((WsDefaultTableRowModel)this.m_tblTargetColumns.getRowModel()).addRowModelListener((WsTableRowModelListener)new TargetRowModelListener());
        this.m_scrTargetColumns = new JScrollPane((Component)this.m_tblTargetColumns);
        this.m_scrTargetColumns.setBorder(BorderFactory.createEmptyBorder());
        this.m_scrTargetColumns.setMinimumSize(new Dimension(50, 100));
        this.m_scrTargetColumns.setPreferredSize(new Dimension(150, 200));
    }

    private void createTargetColumnsTablePopupMenu() {
        this.m_mnuTargetTablePopup = this.createTargetTablePopupMenu();
    }

    protected JPopupMenu createTargetTablePopupMenu() {
        JPopupMenu targetTablePopupMenu = new JPopupMenu();
        targetTablePopupMenu.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actMapAll));
        targetTablePopupMenu.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actMapSelected));
        targetTablePopupMenu.addSeparator();
        targetTablePopupMenu.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actSelectAllTargetColumns));
        return targetTablePopupMenu;
    }

    private void createTargetColumnsViewportPopupMenu() {
        this.m_mnuTargetViewportPopup = new JPopupMenu();
        this.m_mnuTargetViewportPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actSelectAllTargetColumns));
        if (this.m_configuration.isTargetTablesEditable()) {
            this.m_mnuTargetViewportPopup.addSeparator();
        }
    }

    private void createTargetPanelLabel() {
        this.m_pnlTargetLabel = WsUIUtilities.createToolBar();
        this.m_pnlTargetLabel.setLayout(new GridBagLayout());
        this.m_btnExpandTargetPanel = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actExpandTargetPanel);
        this.m_btnCollapseTargetPanel = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actCollapseTargetPanel);
        this.m_btnCollapseTargetPanel.setVisible(false);
        if (this.m_configuration.isMultipleTargetTablesEnabled()) {
            this.m_cmbTargetTables = new WAComboBox();
            this.m_cmbTargetTables.addItemListener((ItemListener)new TargetTableSelectionListener());
            this.m_lblTargetTables = WsUIUtilities.createLabelForComponent((JComponent)this.m_cmbTargetTables, (String)this.m_configuration.getTargetTableLabel());
            this.m_pnlTargetLabel.add((Component)this.m_lblTargetTables, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 3, 0, 3), 0, 0));
            this.m_pnlTargetLabel.add((Component)this.m_cmbTargetTables, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
            this.m_pnlTargetLabel.add((Component)this.m_btnExpandTargetPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.m_pnlTargetLabel.add((Component)this.m_btnCollapseTargetPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this.m_lblTargetTable = new JLabel();
            this.m_lblTargetTables = WsUIUtilities.createLabelForComponent((JComponent)this.m_tblTargetColumns, (String)this.m_configuration.getTargetTableLabel());
            this.m_pnlTargetLabel.add((Component)this.m_lblTargetTables, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
            this.m_pnlTargetLabel.add((Component)this.m_lblTargetTable, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(3, 0, 3, 3), 0, 0));
            this.m_pnlTargetLabel.add((Component)this.m_btnExpandTargetPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.m_pnlTargetLabel.add((Component)this.m_btnCollapseTargetPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    private void refreshTargetPanelLabel() {
    }

    private void createTargetPanel() {
        this.m_pnlTarget = new JPanel(new BorderLayout());
        this.m_pnlTarget.setBorder(this.m_brdrPanel);
        this.m_pnlTarget.add((Component)this.m_pnlTargetLabel, "North");
        this.m_pnlTarget.add((Component)this.m_scrTargetColumns, "Center");
    }

    private void setTargetColumnsTableEditable(boolean bEditable) {
        if (!this.m_configuration.isTargetTablesEditable()) {
            return;
        }
        for (int iColumn = 0; iColumn < this.m_mdlTargetColumns.getColumnCount(); ++iColumn) {
            if (iColumn == 0 || iColumn == 1) continue;
            this.m_mdlTargetColumns.getColumn(iColumn).setEditable(bEditable);
        }
    }

    private void createMappingsModel() {
        this.m_mdlMappings = new BusinessRuleMappingsModel(this.m_container, this.m_mdlSourceColumns, this.m_mdlTargetColumns);
        this.m_mdlMappings.setMappingsFilter(this.m_configuration.getMappingsFilter());
    }

    private void createMappingsPanel() {
        this.m_pnlMappings = new BusinessRuleTableMappingsPanel(this.m_tblSourceColumns, this.m_tblTargetColumns, this.m_container);
        this.m_pnlMappings.setMappingsModel((WsObjectListModel)this.m_mdlMappings);
        this.m_pnlMappings.setPreferredSize(new Dimension(50, 200));
        this.m_pnlMappings.setMinimumSize(new Dimension(20, 100));
        this.m_pnlMappings.setBorder(this.m_brdrPanel);
        this.m_pnlMappings.setAutoSelectEnabled(true);
        this.m_pnlMappings.getSelectionModel().addObjectSelectionListener((WsObjectSelectionListener)new MappingsSelectionListener());
        this.m_pnlMappings.setPopupMenuRequestListener(new MappingsPopupListener());
    }

    private void createMappingsPopupMenu() {
        this.m_mnuMappingsPopup = new JPopupMenu();
        this.m_mnuMappingsPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actMapAll));
        this.m_mnuMappingsPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actSelectAllMappings));
        this.m_mnuMappingsPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actDeleteMappings));
    }

    private void createCenterPanelLabel() {
        this.m_pnlCenterLabel = new JPanel(new GridBagLayout());
        this.m_pnlCenterLabel.setBorder(this.m_brdrPanel);
        this.m_pnlCenterLabel.setCursor(Cursor.getPredefinedCursor(10));
        CenterPanelLabelMouseListener listener = new CenterPanelLabelMouseListener();
        this.m_pnlCenterLabel.addMouseListener(listener);
        this.m_pnlCenterLabel.addMouseMotionListener(listener);
        JLabel lbl = new JLabel("|||");
        lbl.setForeground(this.m_pnlCenterLabel.getBackground().darker());
        this.m_pnlCenterLabel.add((Component)lbl, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void createCenterPanel() {
        this.m_pnlCenter = new JPanel(new BorderLayout());
        this.m_pnlCenter.add((Component)this.m_pnlCenterLabel, "North");
        this.m_pnlCenter.add((Component)((Object)this.m_pnlMappings), "Center");
    }

    private void createPanelBorder() {
        this.m_brdrPanel = BorderFactory.createBevelBorder(1, SystemColor.controlHighlight, SystemColor.controlShadow);
    }

    private JSplitPane createSplitPane(JComponent cmpLeft, JComponent cmpRight) {
        JSplitPane splt = new JSplitPane(1, cmpLeft, cmpRight);
        splt.setContinuousLayout(true);
        splt.setResizeWeight(0.0);
        splt.setBorder(null);
        splt.setDividerSize(splt.getDividerSize() / 2);
        ((BasicSplitPaneUI)splt.getUI()).getDivider().setBorder(null);
        return splt;
    }

    private void layoutComponents() {
        int height = Math.max(this.m_pnlSourceLabel.getPreferredSize().height, this.m_pnlTargetLabel.getPreferredSize().height);
        this.m_pnlSourceLabel.setMinimumSize(new Dimension(50, height));
        this.m_pnlSourceLabel.setPreferredSize(new Dimension(150, height));
        this.m_pnlCenterLabel.setMinimumSize(new Dimension(20, height));
        this.m_pnlCenterLabel.setPreferredSize(new Dimension(50, height));
        this.m_pnlTargetLabel.setMinimumSize(new Dimension(50, height));
        this.m_pnlTargetLabel.setPreferredSize(new Dimension(150, height));
        if (this.m_pnlSetOperatorSpecifics != null) {
            this.setLayout(new GridBagLayout());
            this.add(this.m_pnlSetOperatorSpecifics, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.m_barTools, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.m_spltOuter, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add(new JPanel(), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this.setLayout(new BorderLayout());
            this.add(this.m_barTools, "North");
            this.add(this.m_spltOuter, "Center");
        }
    }

    public void doLayout() {
        if (!this.m_bSplitLocationSet) {
            int cxMappings;
            int cxTable;
            int cxDeficit;
            Insets insTab = this.getInsets();
            Insets insSource = this.m_pnlSource.getInsets();
            Insets insCenter = this.m_pnlCenter.getInsets();
            Insets insTarget = this.m_pnlTarget.getInsets();
            int cxAvailable = this.getWidth() - insTab.left - insSource.left - insSource.right - this.m_spltInner.getDividerSize() - insCenter.left - insCenter.right - this.m_spltOuter.getDividerSize() - insTarget.left - insTarget.right - insTab.right;
            if (cxAvailable < 120) {
                cxDeficit = (120 - cxAvailable) / 3;
                cxTable = 50 - cxDeficit;
                cxMappings = 20 - cxDeficit;
            } else if (cxAvailable < 320) {
                cxDeficit = (320 - cxAvailable) / 2;
                cxTable = 150 - cxDeficit;
                cxMappings = 20;
            } else if (cxAvailable < 350) {
                cxDeficit = 350 - cxAvailable;
                cxTable = 150;
                cxMappings = 50 - cxDeficit;
            } else {
                int cxExtra = (cxAvailable - 350) / 2;
                cxTable = 150 + cxExtra;
                cxMappings = 50;
            }
            int xInner = cxTable + insSource.left + insSource.right;
            int xOuter = xInner + this.m_spltInner.getDividerSize() + cxMappings + insCenter.left + insCenter.right;
            WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
            String rootKey = this.m_configuration.getSettingsKeyPrefix() + "." + this.m_configuration.getWhereUsedSettingsKeyPrefix();
            this.m_spltOuter.setDividerLocation(appDefaults.getPropertyInt(rootKey + ".OuterLocation.x", xOuter));
            this.m_spltInner.setDividerLocation(appDefaults.getPropertyInt(rootKey + ".InnerLocation.x", xInner));
            this.m_bSplitLocationSet = true;
        }
        super.doLayout();
    }

    private void setSelectedSourceTable(ITable tbl) {
        if (tbl == null) {
            this.m_bSelectedSourceTableEditable = this.allTrue(this.m_aSourceTableEditables);
            this.setSourceColumnsTableEditable(this.m_bSelectedSourceTableEditable);
        }
        if (this.m_tblSelectedSource == tbl) {
            return;
        }
        this.m_tblSourceColumns.cancelCellEditing();
        this.m_tblSelectedSource = tbl;
        this.m_mdlSourceColumns.setSelectedTable(tbl);
        if (tbl != null) {
            int iSourceTable = this.indexOfSourceTable(tbl);
            this.m_bSelectedSourceTableEditable = this.m_aSourceTableEditables[iSourceTable];
            this.setSourceColumnsTableEditable(this.m_bSelectedSourceTableEditable);
        }
        this.m_mdlMappings.moveDataToModel();
    }

    private ITable getSelectedSourceTable() {
        return this.m_tblSelectedSource;
    }

    private void setSelectedTargetTable(IBusinessRuleFlowTable tbl) {
        if (tbl == null) {
            this.m_bSelectedTargetTableEditable = this.allTrue(this.m_aTargetTableEditables);
            this.setTargetColumnsTableEditable(this.m_bSelectedTargetTableEditable);
        }
        if (this.m_tblSelectedTarget == tbl) {
            return;
        }
        this.m_tblTargetColumns.cancelCellEditing();
        this.m_tblSelectedTarget = tbl;
        this.m_mdlTargetColumns.setSelectedTable(tbl);
        if (tbl != null) {
            int iTargetTable = this.indexOfTargetTable(tbl);
            this.m_bSelectedTargetTableEditable = this.m_aTargetTableEditables[iTargetTable];
            this.setTargetColumnsTableEditable(this.m_bSelectedTargetTableEditable);
        }
        this.m_mdlMappings.moveDataToModel();
    }

    private IBusinessRuleFlowTable getSelectedTargetTable() {
        return this.m_tblSelectedTarget;
    }

    private void setSourcePanelExpanded(boolean bExpanded) {
        if (this.m_bSourcePanelExpanded == bExpanded) {
            return;
        }
        this.m_bSourcePanelExpanded = bExpanded;
        this.m_btnExpandSourcePanel.setVisible(!bExpanded);
        this.m_btnExpandTargetPanel.setVisible(!bExpanded);
        this.m_btnCollapseSourcePanel.setVisible(bExpanded);
        if (bExpanded) {
            this.m_cxInnerOriginal = this.m_spltInner.getDividerLocation();
            this.m_cxOuterOriginal = this.m_spltOuter.getDividerLocation();
            this.m_spltOuter.setDividerLocation(1.0);
            this.m_spltOuter.validate();
            this.m_spltInner.setDividerLocation(1.0);
            this.m_cxDividerSize = this.m_spltInner.getDividerSize();
            this.m_spltInner.setDividerSize(0);
            this.m_spltOuter.setDividerSize(0);
        } else {
            this.m_spltOuter.setDividerLocation(this.m_cxOuterOriginal);
            this.m_spltInner.setDividerLocation(this.m_cxInnerOriginal);
            this.m_spltOuter.setDividerSize(this.m_cxDividerSize);
            this.m_spltInner.setDividerSize(this.m_cxDividerSize);
        }
    }

    private boolean isSourcePanelExpanded() {
        return this.m_bSourcePanelExpanded;
    }

    private void setTargetPanelExpanded(boolean bExpanded) {
        if (this.m_bTargetPanelExpanded == bExpanded) {
            return;
        }
        this.m_bTargetPanelExpanded = bExpanded;
        this.m_btnExpandTargetPanel.setVisible(!bExpanded);
        this.m_btnCollapseTargetPanel.setVisible(bExpanded);
        if (bExpanded) {
            this.m_cxInnerOriginal = this.m_spltInner.getDividerLocation();
            this.m_cxOuterOriginal = this.m_spltOuter.getDividerLocation();
            this.m_spltOuter.setDividerLocation(0.0);
            this.m_spltInner.setDividerLocation(0.0);
            this.m_cxDividerSize = this.m_spltInner.getDividerSize();
            this.m_spltInner.setDividerSize(0);
            this.m_spltOuter.setDividerSize(0);
        } else {
            this.m_spltOuter.setDividerLocation(this.m_cxOuterOriginal);
            this.m_spltInner.setDividerLocation(this.m_cxInnerOriginal);
            this.m_spltOuter.setDividerSize(this.m_cxDividerSize);
            this.m_spltInner.setDividerSize(this.m_cxDividerSize);
        }
    }

    private boolean isTargetPanelExpanded() {
        return this.m_bTargetPanelExpanded;
    }

    private void initializeUndo() {
        if (this.m_lsnrUndo != null) {
            return;
        }
        WsUndoManager mgrUndo = (WsUndoManager)this.m_container.getModel().getUndoManager();
        this.m_lsnrUndo = new UndoManagerListener();
        mgrUndo.addChangeListener(this.m_lsnrUndo);
        this.m_actUndo.setEnabled(mgrUndo.canUndo());
        this.m_actRedo.setEnabled(mgrUndo.canRedo());
    }

    public void moveDataToView() {
        this.m_mdlSourceColumns.moveDataToModel();
        if (this.m_container.getSourceBusinessRuleTableCount() > 0) {
            this.m_mdlTargetColumns.setSelectedTable(this.m_container.getSourceBusinessRuleTables()[0]);
        }
        this.m_mdlMappings.moveDataToModel();
        this.m_aSourceTableEditables = this.getTableEditables(this.m_aSourceTables);
        this.m_aTargetTableEditables = new boolean[this.m_aTargetTables.length];
        for (int i = 0; i < this.m_aTargetTables.length; ++i) {
            this.m_aTargetTableEditables[i] = false;
        }
        this.refreshSourcePanelLabel();
        this.refreshTargetPanelLabel();
        this.refreshSQLSetOperatorsSpecifics();
        this.updateActions();
        this.initializeUndo();
    }

    private boolean[] getTableEditables(ITable[] aTables) {
        boolean[] aEditables = new boolean[aTables.length];
        for (int iTable = 0; iTable < aTables.length; ++iTable) {
            aEditables[iTable] = aTables[iTable] instanceof IWorkTable ? this.m_mdlJob.isEditable() : (aTables[iTable] instanceof IExternalTable && ((IExternalTable)aTables[iTable]).isFixedWidth() ? false : Workspace.isObjectEditable((SimpleObject)aTables[iTable]));
        }
        return aEditables;
    }

    public boolean validateData() {
        if (!this.stopCellEditing()) {
            return false;
        }
        return this.validateSourceColumns();
    }

    private boolean validateSourceColumns() {
        int iViewInformatColumn = this.m_tblSourceColumns.convertColumnIndexToView(6);
        int iViewFormatColumn = this.m_tblSourceColumns.convertColumnIndexToView(7);
        for (int iRow = 0; iRow < this.m_tblSourceColumns.getRowCount(); ++iRow) {
            int iModelRow = this.m_tblSourceColumns.convertRowIndexToModel(iRow);
            String sType = this.m_mdlSourceColumns.getSourceColumn(iModelRow).getType() == 0 ? WsColumnMetadataUtil.getDataCharacterType() : WsColumnMetadataUtil.getDataNumericType();
            String sInformat = (String)this.m_mdlSourceColumns.getValueAt(iModelRow, 6);
            if (!sInformat.equals(WsColumnMetadataUtil.NONE) && !WsColumnMetadataUtil.isInformatNameValid((String)sInformat, (String)sType)) {
                String sMessage = bundle.getString("MappingsTab.Error.InvalidInformat.txt");
                MessageUtil.displayMessage((String)sMessage, (int)0);
                if (iViewFormatColumn != -1) {
                    this.m_tblSourceColumns.selectCell(iRow, iViewInformatColumn);
                    this.m_tblSourceColumns.editCellAt(iRow, iViewInformatColumn);
                }
                return false;
            }
            String sFormat = (String)this.m_mdlSourceColumns.getValueAt(iModelRow, 7);
            if (sFormat.equals(WsColumnMetadataUtil.NONE) || WsColumnMetadataUtil.isFormatNameValid((String)sFormat, (String)sType)) continue;
            String sMessage = bundle.getString("MappingsTab.Error.InvalidFormat.txt");
            MessageUtil.displayMessage((String)sMessage, (int)0);
            if (iViewFormatColumn != -1) {
                this.m_tblSourceColumns.selectCell(iRow, iViewFormatColumn);
                this.m_tblSourceColumns.editCellAt(iRow, iViewFormatColumn);
            }
            return false;
        }
        return true;
    }

    public void saveSettingsAndCleanUp() {
        String rootKey = this.m_configuration.getSettingsKeyPrefix() + "." + this.m_configuration.getWhereUsedSettingsKeyPrefix() + ".";
        this.m_tblSourceColumns.saveSettings(rootKey + this.m_configuration.getSourceTableSettingsKeyPrefix());
        this.m_tblTargetColumns.saveSettings(rootKey + this.m_configuration.getTargetTableSettingsKeyPrefix());
        boolean bUseSavedValues = this.isSourcePanelExpanded() || this.isTargetPanelExpanded();
        int xOuter = bUseSavedValues ? this.m_cxOuterOriginal : this.m_spltOuter.getDividerLocation();
        int xInner = bUseSavedValues ? this.m_cxInnerOriginal : this.m_spltInner.getDividerLocation();
        WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        appDefaults.setPropertyInt(rootKey + "OuterLocation.x", xOuter);
        appDefaults.setPropertyInt(rootKey + "InnerLocation.x", xInner);
        this.m_mdlSourceColumns.dispose();
        this.m_mdlTargetColumns.dispose();
        this.m_mdlMappings.dispose();
        IModel mdl = this.m_container.getModel();
        ((WsUndoManager)mdl.getUndoManager()).removeChangeListener(this.m_lsnrUndo);
        mdl.removeModelListener((IModelListener)this.m_lsnrModel);
    }

    private void updateActions() {
        boolean bEditable = this.isEditable();
        boolean bSourceNotSorted = !this.m_tblSourceColumns.isSorted();
        boolean bTargetNotSorted = !this.m_tblTargetColumns.isSorted();
        boolean bOneSourceTable = this.getSelectedSourceTable() != null;
        boolean bOneTargetTable = this.getSelectedTargetTable() != null;
        boolean bAtLeastOneSourceTable = this.m_aSourceTables.length > 0;
        boolean bAtLeastOneTargetTable = this.m_aTargetTables.length > 0;
        boolean bSourceTablesEditable = bAtLeastOneSourceTable && this.m_bSelectedSourceTableEditable;
        boolean bTargetTablesEditable = bAtLeastOneTargetTable && this.m_bSelectedTargetTableEditable;
        int[] aSourceRows = this.m_tblSourceColumns.getSelectedRowsFromSelectedCells();
        int[] aTargetRows = this.m_tblTargetColumns.getSelectedRowsFromSelectedCells();
        List lMappings = this.m_pnlMappings.getSelectedMappings();
        boolean bAtLeastOneSourceColumn = aSourceRows.length > 0;
        boolean bAtLeastOneMapping = lMappings.size() > 0;
        boolean bOneTargetColumn = aTargetRows.length == 1;
        boolean bAnyIncludedInPropagation = false;
        boolean bAnyIncludedInMapping = false;
        for (int iTargetRow = 0; iTargetRow < aTargetRows.length; ++iTargetRow) {
            int iModelRow = this.m_tblTargetColumns.convertRowIndexToModel(aTargetRows[iTargetRow]);
            IBusinessRuleFlowColumn column = this.m_mdlTargetColumns.getTargetColumn(iModelRow);
            if (!this.m_container.getListOfColumnsExcludedFromPropagation().contains(column)) {
                bAnyIncludedInPropagation = true;
            }
            if (!this.m_container.getListOfColumnsExcludedFromMapping().contains(column)) {
                bAnyIncludedInMapping = true;
            }
            if (bAnyIncludedInMapping && bAnyIncludedInPropagation) break;
        }
        this.m_actMapAll.setEnabled(bEditable && bAtLeastOneSourceTable && bAtLeastOneTargetTable);
        this.m_actMapSelected.setEnabled(bEditable && bAtLeastOneSourceColumn && bOneTargetColumn);
        this.m_actIncludeTransformationInMapping.setEnabled(bEditable);
        this.m_actIncludeTransformationInMapping.setSelected(this.m_container.isIncludedInMapping());
        this.m_actFixWarningDropMenu.setEnabled(bEditable);
        this.m_actDeleteMappings.setEnabled(bEditable && bAtLeastOneMapping);
        this.m_actSelectAllMappings.setEnabled(this.m_pnlMappings.getMappingsCount() > 0);
        this.m_actSelectAllSourceColumns.setEnabled(this.m_tblSourceColumns.getRowCount() > 0);
        this.m_actSelectAllTargetColumns.setEnabled(this.m_tblTargetColumns.getRowCount() > 0);
        this.m_tblSourceColumns.setRowsReorderable(bEditable && this.m_configuration.isSourceTablesEditable() && bOneSourceTable && bSourceTablesEditable && bSourceNotSorted);
        this.m_tblTargetColumns.setRowsReorderable(bEditable && this.m_configuration.isTargetTablesEditable() && bOneTargetTable && bTargetTablesEditable && bTargetNotSorted);
        this.m_actAllFields.setEnabled(bEditable);
        this.m_actDistinctRows.setEnabled(bEditable);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_pnlMappings.setDraggingFromSourceTableEnabled(bEditable);
        this.m_pnlMappings.setDraggingFromTargetTableEnabled(bEditable);
        this.m_tblSourceColumns.setEditable(bEditable);
        this.m_tblTargetColumns.setEditable(bEditable);
        this.updateActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPairingsBetweenSelectedColumns() {
        int iTargetRow = this.m_tblTargetColumns.convertRowIndexToModel(this.m_tblTargetColumns.getSelectedRowsFromSelectedCells()[0]);
        int[] aSourceRows = this.m_tblSourceColumns.getSelectedRowsFromSelectedCells();
        this.m_container.getModel().startCompoundUndoable();
        try {
            ArrayList<WsMapping> lPairings = new ArrayList<WsMapping>(aSourceRows.length);
            for (int iSourceRow = 0; iSourceRow < aSourceRows.length; ++iSourceRow) {
                lPairings.add(new WsMapping(this.m_tblSourceColumns.convertRowIndexToModel(aSourceRows[iSourceRow]), iTargetRow));
            }
            this.m_pnlMappings.onCreateMappings(lPairings);
        }
        finally {
            this.m_container.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mapColumns() {
        this.m_container.getModel().startCompoundUndoable();
        this.setWaitCursor(true);
        try {
            ITable[] aSourceTables = this.getSelectedSourceTables();
            IBusinessRuleFlowTable[] aTargetTables = this.getSelectedTargetTables();
            for (int iSourceTable = 0; iSourceTable < aSourceTables.length; ++iSourceTable) {
                for (int iTargetTable = 0; iTargetTable < aTargetTables.length; ++iTargetTable) {
                    this.m_container.mapAllBusinessRuleColumnsByName(aSourceTables[iSourceTable], aTargetTables[iTargetTable]);
                }
            }
        }
        finally {
            this.m_container.getModel().endCompoundUndoable();
            this.setWaitCursor(false);
        }
    }

    private void selectAllMappings() {
        this.m_pnlMappings.setAutoSelectEnabled(false);
        try {
            this.m_pnlMappings.selectAllMappings();
        }
        finally {
            this.m_pnlMappings.setAutoSelectEnabled(true);
            this.m_pnlMappings.autoSelectFromMappings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveSourceColumn(int iFrom, int iTo) {
        if (!this.stopCellEditing()) {
            return;
        }
        ITable table = this.getSelectedSourceTable();
        table.getModel().startCompoundUndoable();
        try {
            this.m_tblSourceColumns.clearSelection();
            IColumn column = this.m_mdlSourceColumns.getSourceColumn(iFrom);
            table.getModel().undoableEditHappened((UndoableEdit)new SelectSourceColumnsUndoable(column, true, false));
            table.moveColumn(column, iTo);
            this.m_tblSourceColumns.selectRow(iTo);
            table.getModel().undoableEditHappened((UndoableEdit)new SelectSourceColumnsUndoable(column, false, true));
        }
        finally {
            table.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSelectedPairings() {
        if (!this.stopCellEditing()) {
            return;
        }
        this.setWaitCursor(true);
        this.m_container.getModel().startCompoundUndoable();
        try {
            List lMappings = this.m_pnlMappings.getSelectedMappings();
            this.m_pnlMappings.deselectAllMappings();
            WsMapping[] aMappings = lMappings.toArray(new WsMapping[lMappings.size()]);
            this.m_container.getModel().undoableEditHappened((UndoableEdit)new SelectPairingsUndoable(aMappings, true, false));
            for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
                WsMapping pairing = aMappings[iMapping];
                IColumn colSource = this.m_mdlSourceColumns.getSourceColumn(pairing.getSource());
                IBusinessRuleMapping mapping = this.m_mdlTargetColumns.getMapping(pairing.getTarget());
                mapping.removeSource(colSource);
            }
        }
        finally {
            this.setWaitCursor(false);
            this.m_container.getModel().endCompoundUndoable();
        }
    }

    private void undo() {
        this.setWaitCursor(true);
        try {
            this.m_container.getModel().getUndoManager().undo();
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    private void redo() {
        this.setWaitCursor(true);
        try {
            this.m_container.getModel().getUndoManager().redo();
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    private boolean stopCellEditing() {
        return this.m_tblSourceColumns.stopCellEditing() && this.m_tblTargetColumns.stopCellEditing();
    }

    private boolean isSourceTable(ITable tbl) {
        return this.indexOfSourceTable(tbl) != -1;
    }

    private boolean isTargetTable(IBusinessRuleFlowTable tbl) {
        return this.indexOfTargetTable(tbl) != -1;
    }

    private int indexOfSourceTable(ITable tbl) {
        for (int iTable = 0; iTable < this.m_aSourceTables.length; ++iTable) {
            if (this.m_aSourceTables[iTable] != tbl) continue;
            return iTable;
        }
        return -1;
    }

    private int indexOfTargetTable(IBusinessRuleFlowTable tbl) {
        for (int iTable = 0; iTable < this.m_aTargetTables.length; ++iTable) {
            if (this.m_aTargetTables[iTable] != tbl) continue;
            return iTable;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectSourceColumns(IColumn[] aColumns) {
        this.m_pnlMappings.setAutoSelectEnabled(false);
        try {
            this.m_tblSourceColumns.clearSelection();
            for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                int iRow = this.m_mdlSourceColumns.getRowIndex(aColumns[iColumn]);
                if (iRow == -1) continue;
                this.m_tblSourceColumns.addRowToSelection(this.m_tblSourceColumns.convertRowIndexToView(iRow));
            }
        }
        finally {
            this.m_pnlMappings.setAutoSelectEnabled(true);
            this.m_pnlMappings.autoSelectFromTable(true);
        }
    }

    private void selectPairings(WsMapping[] aPairings) {
        this.setWaitCursor(true);
        this.m_pnlMappings.setAutoSelectEnabled(false);
        try {
            this.m_pnlMappings.deselectAllMappings();
            for (int iPairing = 0; iPairing < aPairings.length; ++iPairing) {
                this.m_pnlMappings.selectMapping(aPairings[iPairing]);
            }
        }
        finally {
            this.m_pnlMappings.setAutoSelectEnabled(true);
            this.m_pnlMappings.autoSelectFromMappings();
            this.setWaitCursor(false);
        }
    }

    private ITable[] getSelectedSourceTables() {
        ITable[] iTableArray;
        ITable tbl = this.getSelectedSourceTable();
        if (tbl != null) {
            ITable[] iTableArray2 = new ITable[1];
            iTableArray = iTableArray2;
            iTableArray2[0] = tbl;
        } else {
            iTableArray = this.m_aSourceTables;
        }
        return iTableArray;
    }

    private IBusinessRuleFlowTable[] getSelectedTargetTables() {
        IBusinessRuleFlowTable[] iBusinessRuleFlowTableArray;
        IBusinessRuleFlowTable tbl = this.getSelectedTargetTable();
        if (tbl != null) {
            IBusinessRuleFlowTable[] iBusinessRuleFlowTableArray2 = new IBusinessRuleFlowTable[1];
            iBusinessRuleFlowTableArray = iBusinessRuleFlowTableArray2;
            iBusinessRuleFlowTableArray2[0] = tbl;
        } else {
            iBusinessRuleFlowTableArray = this.m_aTargetTables;
        }
        return iBusinessRuleFlowTableArray;
    }

    private boolean allTrue(boolean[] aValues) {
        for (int iValue = 0; iValue < aValues.length; ++iValue) {
            if (aValues[iValue]) continue;
            return false;
        }
        return true;
    }

    private void setWaitCursor(boolean bWait) {
        if (this.m_rootPane == null) {
            this.m_rootPane = SwingUtilities.getRootPane((Component)((Object)this));
        }
        Cursor cursor = bWait ? Cursor.getPredefinedCursor(3) : Cursor.getDefaultCursor();
        this.m_rootPane.setCursor(cursor);
    }

    protected WsAbstractAction getMapAll() {
        return this.m_actMapAll;
    }

    protected WsAbstractAction getMapSelected() {
        return this.m_actMapSelected;
    }

    protected WsAbstractAction getSelectAllSourceColumns() {
        return this.m_actSelectAllSourceColumns;
    }

    protected WsAbstractAction getSelectAllTargetColumns() {
        return this.m_actSelectAllTargetColumns;
    }

    static /* synthetic */ ITable[] access$1602(BusinessRuleMappingsTab x0, ITable[] x1) {
        x0.m_aSourceTables = x1;
        return x1;
    }

    static /* synthetic */ boolean[] access$3302(BusinessRuleMappingsTab x0, boolean[] x1) {
        x0.m_aSourceTableEditables = x1;
        return x1;
    }

    static /* synthetic */ IBusinessRuleFlowTable[] access$2002(BusinessRuleMappingsTab x0, IBusinessRuleFlowTable[] x1) {
        x0.m_aTargetTables = x1;
        return x1;
    }

    static /* synthetic */ boolean[] access$3602(BusinessRuleMappingsTab x0, boolean[] x1) {
        x0.m_aTargetTableEditables = x1;
        return x1;
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            BusinessRuleMappingsTab.this.m_tblSourceColumns.cancelCellEditing();
            BusinessRuleMappingsTab.this.m_tblTargetColumns.cancelCellEditing();
            String sType = ev.getType();
            IObject obj = ev.getModelObject();
            if (sType == "ModelController:UnknownChanges") {
                BusinessRuleMappingsTab.this.moveDataToView();
            } else if (obj == BusinessRuleMappingsTab.this.m_container) {
                if (sType == "DataTransform.DataSourceAdded" || sType == "DataTransform.DataSourceRemoved") {
                    BusinessRuleMappingsTab.access$1602(BusinessRuleMappingsTab.this, BusinessRuleMappingsTab.this.m_container.getSourceTables());
                    BusinessRuleMappingsTab.access$3302(BusinessRuleMappingsTab.this, BusinessRuleMappingsTab.this.getTableEditables(BusinessRuleMappingsTab.this.m_aSourceTables));
                    BusinessRuleMappingsTab.this.refreshSourcePanelLabel();
                    BusinessRuleMappingsTab.this.updateActions();
                } else if (sType == "DataTransform.DataTargetAdded" || sType == "DataTransform.DataTargetRemoved" || sType == "BusinessRuleTransformModel:BusinessRuleVersionChanged") {
                    BusinessRuleMappingsTab.access$2002(BusinessRuleMappingsTab.this, BusinessRuleMappingsTab.this.m_container.getSourceBusinessRuleTables());
                    BusinessRuleMappingsTab.access$3602(BusinessRuleMappingsTab.this, new boolean[BusinessRuleMappingsTab.this.m_aTargetTables.length]);
                    for (int i = 0; i < BusinessRuleMappingsTab.this.m_aTargetTables.length; ++i) {
                        ((BusinessRuleMappingsTab)BusinessRuleMappingsTab.this).m_aTargetTableEditables[i] = false;
                    }
                    BusinessRuleMappingsTab.this.refreshTargetPanelLabel();
                    BusinessRuleMappingsTab.this.updateActions();
                } else if (sType == "MappingsContainer:IncludeInPropagationChanged" || sType == "MappingsContainer:IncludeInMappingsChanged") {
                    BusinessRuleMappingsTab.this.updateActions();
                } else if (sType == "MappingsContainer:BusinessRuleMappingAdded" || sType == "MappingsContainer:BusinessRuleMappingChanged" || sType == "MappingsContainer:BusinessRuleMappingRemoved") {
                    BusinessRuleMappingsTab.this.m_actSelectAllMappings.setEnabled(BusinessRuleMappingsTab.this.m_container.getBusinessRuleMappings().length != 0);
                    BusinessRuleMappingsTab.this.updateActions();
                } else if (sType == "MappingsContainer:MappingChanged") {
                    BusinessRuleMappingsTab.this.updateActions();
                } else if (sType == "MiningResultTransformModel:MiningResultChanged") {
                    BusinessRuleMappingsTab.this.moveDataToView();
                }
            } else if (BusinessRuleMappingsTab.this.m_container instanceof ISelectResultsContainer && ((ISelectResultsContainer)BusinessRuleMappingsTab.this.m_container).getParentQuery() == obj) {
                if (sType == "SelectResults:UseDistinctChanged" && BusinessRuleMappingsTab.this.m_configuration.isSetOperatorSpecificsEnabled()) {
                    BusinessRuleMappingsTab.this.m_ckbDistinctRows.setSelected(((IQuery)obj).useDistinct());
                }
                if (sType == "SelectResults:UseImplicitChanged" && BusinessRuleMappingsTab.this.m_configuration.isSetOperatorSpecificsEnabled()) {
                    BusinessRuleMappingsTab.this.m_ckbAllFields.setSelected(((IQuery)obj).useImplicit());
                }
                if (sType == "SQLObject:QueryTableAdded" || sType == "SQLObject:QueryTableRemoved" || sType == "BaseQuery:SubqueryAdded" || sType == "BaseQuery:SubqueryRemoved" || sType == "SQLFrom:SourceOfFromChanged") {
                    BusinessRuleMappingsTab.access$1602(BusinessRuleMappingsTab.this, BusinessRuleMappingsTab.this.m_container.getSourceTables());
                    BusinessRuleMappingsTab.access$3302(BusinessRuleMappingsTab.this, BusinessRuleMappingsTab.this.getTableEditables(BusinessRuleMappingsTab.this.m_aSourceTables));
                    BusinessRuleMappingsTab.this.refreshSourcePanelLabel();
                    BusinessRuleMappingsTab.this.updateActions();
                }
            } else if (BusinessRuleMappingsTab.this.m_container instanceof ISelectResultsContainer && obj instanceof IJoin) {
                if (sType == "Join:LeftSideChanged" || sType == "Join:RightSideChanged") {
                    BusinessRuleMappingsTab.access$1602(BusinessRuleMappingsTab.this, BusinessRuleMappingsTab.this.m_container.getSourceTables());
                    BusinessRuleMappingsTab.access$3302(BusinessRuleMappingsTab.this, BusinessRuleMappingsTab.this.getTableEditables(BusinessRuleMappingsTab.this.m_aSourceTables));
                    BusinessRuleMappingsTab.this.refreshSourcePanelLabel();
                    BusinessRuleMappingsTab.this.updateActions();
                }
            } else if (BusinessRuleMappingsTab.this.m_container instanceof ISelectResultsContainer && ((ISelectResultsContainer)BusinessRuleMappingsTab.this.m_container).getParentQuery().getTransformModel() == obj) {
                if (sType == "DataTransform.DataTargetAdded" || sType == "DataTransform.DataTargetRemoved") {
                    BusinessRuleMappingsTab.access$2002(BusinessRuleMappingsTab.this, BusinessRuleMappingsTab.this.m_container.getSourceBusinessRuleTables());
                    BusinessRuleMappingsTab.access$3602(BusinessRuleMappingsTab.this, new boolean[BusinessRuleMappingsTab.this.m_aTargetTables.length]);
                    for (int i = 0; i < BusinessRuleMappingsTab.this.m_aTargetTables.length; ++i) {
                        ((BusinessRuleMappingsTab)BusinessRuleMappingsTab.this).m_aTargetTableEditables[i] = false;
                    }
                    BusinessRuleMappingsTab.this.refreshTargetPanelLabel();
                    BusinessRuleMappingsTab.this.updateActions();
                } else if (sType == "DataTransform.DataSourceAdded" || sType == "DataTransform.DataSourceRemoved") {
                    BusinessRuleMappingsTab.access$1602(BusinessRuleMappingsTab.this, BusinessRuleMappingsTab.this.m_container.getSourceTables());
                    BusinessRuleMappingsTab.access$3302(BusinessRuleMappingsTab.this, BusinessRuleMappingsTab.this.getTableEditables(BusinessRuleMappingsTab.this.m_aSourceTables));
                    BusinessRuleMappingsTab.this.refreshSourcePanelLabel();
                    BusinessRuleMappingsTab.this.updateActions();
                }
            } else if (obj instanceof ITable) {
                if (sType == "Object:NameChanged") {
                    if (BusinessRuleMappingsTab.this.isSourceTable((ITable)obj)) {
                        BusinessRuleMappingsTab.this.refreshSourcePanelLabel();
                    }
                } else if ((sType == "Table:ColumnAdded" || sType == "Table:ColumnRemoved") && BusinessRuleMappingsTab.this.isSourceTable((ITable)obj)) {
                    BusinessRuleMappingsTab.this.m_actSelectAllSourceColumns.setEnabled(BusinessRuleMappingsTab.this.m_tblSourceColumns.getRowCount() > 0);
                }
            } else if (obj instanceof IBusinessRuleFlowTable) {
                if (sType == "Object:NameChanged") {
                    if (BusinessRuleMappingsTab.this.isTargetTable((IBusinessRuleFlowTable)obj)) {
                        BusinessRuleMappingsTab.this.refreshTargetPanelLabel();
                    }
                } else if ((sType == "Table:ColumnAdded" || sType == "Table:ColumnRemoved") && BusinessRuleMappingsTab.this.isTargetTable((IBusinessRuleFlowTable)obj)) {
                    BusinessRuleMappingsTab.this.m_actSelectAllTargetColumns.setEnabled(BusinessRuleMappingsTab.this.m_tblTargetColumns.getRowCount() > 0);
                }
            }
        }
    }

    private class MapAllAction
    extends WsAbstractAction {
        public MapAllAction() {
            super(bundle, "MappingsTab.Action.MapAll", 1);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Actions:MapColumns"));
        }

        public void actionPerformed(ActionEvent ev) {
            BusinessRuleMappingsTab.this.mapColumns();
        }
    }

    private class MapSelectedColumnsAction
    extends WsAbstractAction {
        public MapSelectedColumnsAction() {
            super(bundle, "MappingsTab.Action.MapSelectedColumns", 1);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("MapSelectedColumns"));
        }

        public void actionPerformed(ActionEvent ev) {
            BusinessRuleMappingsTab.this.createPairingsBetweenSelectedColumns();
        }
    }

    private class IncludeTransformationInMappingAction
    extends WsAbstractToggleAction {
        public IncludeTransformationInMappingAction() {
            super(bundle, "MappingsTab.Action.IncludeTransformationInMapping", 256);
        }

        public void actionPerformed(ActionEvent ev) {
            BusinessRuleMappingsTab.this.m_container.setIncludedInMapping(this.isSelected());
        }
    }

    private class FixWarningDropMenuAction
    extends WsDropMenuAction {
        public FixWarningDropMenuAction() {
            super(bundle, "MappingsTab.Action.FixWarningDropMenu", 18);
        }
    }

    private class UndoAction
    extends WsAbstractAction {
        public UndoAction() {
            super(bundle, "MappingsTab.Action.Undo", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Undo"));
        }

        public void actionPerformed(ActionEvent ev) {
            BusinessRuleMappingsTab.this.undo();
        }
    }

    private class RedoAction
    extends WsAbstractAction {
        public RedoAction() {
            super(bundle, "MappingsTab.Action.Redo", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Redo"));
        }

        public void actionPerformed(ActionEvent ev) {
            BusinessRuleMappingsTab.this.redo();
        }
    }

    private class AllFieldsToggleAction
    extends WsAbstractToggleAction {
        public AllFieldsToggleAction() {
            super(bundle, "MappingsTab.Action.AllFields", 0);
        }

        public void actionPerformed(ActionEvent e) {
            IQuery query = null;
            if (BusinessRuleMappingsTab.this.m_container instanceof ISelectResultsContainer) {
                query = ((ISelectResultsContainer)BusinessRuleMappingsTab.this.m_container).getParentQuery();
                query.setUseImplicit(BusinessRuleMappingsTab.this.m_ckbAllFields.isSelected());
            }
        }
    }

    private class DistinctRowsToggleAction
    extends WsAbstractToggleAction {
        public DistinctRowsToggleAction() {
            super(bundle, "MappingsTab.Action.DistinctRows", 0);
        }

        public void actionPerformed(ActionEvent e) {
            IQuery query = null;
            if (BusinessRuleMappingsTab.this.m_container instanceof ISelectResultsContainer) {
                query = ((ISelectResultsContainer)BusinessRuleMappingsTab.this.m_container).getParentQuery();
                query.setUseDistinct(BusinessRuleMappingsTab.this.m_ckbDistinctRows.isSelected());
            }
        }
    }

    private class ExpandSourcePanelAction
    extends WsAbstractAction {
        public ExpandSourcePanelAction() {
            super(bundle, "MappingsTab.Action.ExpandSourcePanel", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("ExpandLeftPanel"));
        }

        public void actionPerformed(ActionEvent ev) {
            BusinessRuleMappingsTab.this.setSourcePanelExpanded(true);
        }
    }

    private class CollapseSourcePanelAction
    extends WsAbstractAction {
        public CollapseSourcePanelAction() {
            super(bundle, "MappingsTab.Action.CollapseSourcePanel", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("ShowBothPanels"));
        }

        public void actionPerformed(ActionEvent e) {
            BusinessRuleMappingsTab.this.setSourcePanelExpanded(false);
        }
    }

    private class ExpandTargetPanelAction
    extends WsAbstractAction {
        public ExpandTargetPanelAction() {
            super(bundle, "MappingsTab.Action.ExpandTargetPanel", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("ExpandRightPanel"));
        }

        public void actionPerformed(ActionEvent ev) {
            BusinessRuleMappingsTab.this.setTargetPanelExpanded(true);
        }
    }

    private class CollapseTargetPanelAction
    extends WsAbstractAction {
        public CollapseTargetPanelAction() {
            super(bundle, "MappingsTab.Action.CollapseTargetPanel", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("ShowBothPanels"));
        }

        public void actionPerformed(ActionEvent e) {
            BusinessRuleMappingsTab.this.setTargetPanelExpanded(false);
        }
    }

    private class DeleteAction
    extends WsDropMenuAction {
        public DeleteAction() {
            super(bundle, "MappingsTab.Action.Delete", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("DeleteDropMenu"));
        }
    }

    private class DeleteMappingsAction
    extends WsAbstractAction {
        public DeleteMappingsAction() {
            super(bundle, "MappingsTab.Action.DeleteMappings", 257);
        }

        public void actionPerformed(ActionEvent e) {
            BusinessRuleMappingsTab.this.deleteSelectedPairings();
        }
    }

    private class SelectAllSourceColumnsAction
    extends WsAbstractAction {
        public SelectAllSourceColumnsAction() {
            super(bundle, "MappingsTab.Action.SelectAll", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            BusinessRuleMappingsTab.this.m_tblSourceColumns.selectAll();
        }
    }

    private class SelectAllMappingsAction
    extends WsAbstractAction {
        public SelectAllMappingsAction() {
            super(bundle, "MappingsTab.Action.SelectAll", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            BusinessRuleMappingsTab.this.selectAllMappings();
        }
    }

    private class SelectAllTargetColumnsAction
    extends WsAbstractAction {
        public SelectAllTargetColumnsAction() {
            super(bundle, "MappingsTab.Action.SelectAll", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            BusinessRuleMappingsTab.this.m_tblTargetColumns.selectAll();
        }
    }

    private class SourceColumnsTablePopupListener
    implements WsPopupMenuRequestListener {
        private SourceColumnsTablePopupListener() {
        }

        public void popupMenuRequested(MouseEvent ev) {
            BusinessRuleMappingsTab.this.m_mnuSourceTablePopup.show((Component)BusinessRuleMappingsTab.this.m_tblSourceColumns, ev.getX(), ev.getY());
        }
    }

    private class SourceColumnsViewportPopupListener
    implements WsPopupMenuRequestListener {
        private SourceColumnsViewportPopupListener() {
        }

        public void popupMenuRequested(MouseEvent ev) {
            BusinessRuleMappingsTab.this.m_mnuSourceViewportPopup.show((Component)BusinessRuleMappingsTab.this.m_tblSourceColumns, ev.getX(), ev.getY());
        }
    }

    private class SourceColumnsSelectionListener
    implements ListSelectionListener {
        private SourceColumnsSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent ev) {
            BusinessRuleMappingsTab.this.updateActions();
        }
    }

    private class SourceRowModelListener
    implements WsTableRowModelListener {
        private SourceRowModelListener() {
        }

        public void rowDragged(TableRowModelEvent ev) {
            WsDefaultTableRowModel mdlRows = (WsDefaultTableRowModel)BusinessRuleMappingsTab.this.m_tblSourceColumns.getRowModel();
            mdlRows.clearRowMoves();
            BusinessRuleMappingsTab.this.moveSourceColumn(ev.getFromIndex(), ev.getToIndex());
        }

        public void rowsRemapped(ChangeEvent ev) {
            BusinessRuleMappingsTab.this.updateActions();
        }

        public void rowsHidden(WsTableRowModelEvent ev) {
        }

        public void rowsShown(WsTableRowModelEvent ev) {
        }
    }

    private class SourceTableSelectionListener
    implements ItemListener {
        private SourceTableSelectionListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent ev) {
            int iSelect = BusinessRuleMappingsTab.this.m_cmbSourceTables.getSelectedIndex();
            if (iSelect >= 2) {
                BusinessRuleMappingsTab.this.setSelectedSourceTable(BusinessRuleMappingsTab.this.m_aSourceTables[iSelect - 2]);
            } else {
                BusinessRuleMappingsTab.this.setSelectedSourceTable(null);
            }
            BusinessRuleMappingsTab.this.updateActions();
        }
    }

    private class TargetColumnsTablePopupListener
    implements WsPopupMenuRequestListener {
        private TargetColumnsTablePopupListener() {
        }

        public void popupMenuRequested(MouseEvent ev) {
            BusinessRuleMappingsTab.this.m_mnuTargetTablePopup.show((Component)BusinessRuleMappingsTab.this.m_tblTargetColumns, ev.getX(), ev.getY());
        }
    }

    private class TargetColumnsViewportPopupListener
    implements WsPopupMenuRequestListener {
        private TargetColumnsViewportPopupListener() {
        }

        public void popupMenuRequested(MouseEvent ev) {
            BusinessRuleMappingsTab.this.m_mnuTargetViewportPopup.show((Component)BusinessRuleMappingsTab.this.m_tblTargetColumns, ev.getX(), ev.getY());
        }
    }

    private class TargetColumnsSelectionListener
    implements ListSelectionListener {
        private TargetColumnsSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent ev) {
            BusinessRuleMappingsTab.this.updateActions();
        }
    }

    private class TargetRowModelListener
    implements WsTableRowModelListener {
        private TargetRowModelListener() {
        }

        public void rowDragged(TableRowModelEvent ev) {
        }

        public void rowsRemapped(ChangeEvent ev) {
            BusinessRuleMappingsTab.this.updateActions();
        }

        public void rowsHidden(WsTableRowModelEvent ev) {
        }

        public void rowsShown(WsTableRowModelEvent ev) {
        }
    }

    private class TargetTableSelectionListener
    implements ItemListener {
        private TargetTableSelectionListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent ev) {
            int iSelect = BusinessRuleMappingsTab.this.m_cmbTargetTables.getSelectedIndex();
            if (iSelect >= 2) {
                BusinessRuleMappingsTab.this.setSelectedTargetTable(BusinessRuleMappingsTab.this.m_aTargetTables[iSelect - 2]);
            } else {
                BusinessRuleMappingsTab.this.setSelectedTargetTable(null);
            }
            BusinessRuleMappingsTab.this.updateActions();
        }
    }

    private class MappingsSelectionListener
    implements WsObjectSelectionListener {
        private MappingsSelectionListener() {
        }

        public void objectChangedSelection(WsObjectSelectionEvent ev) {
            BusinessRuleMappingsTab.this.updateActions();
        }
    }

    private class MappingsPopupListener
    implements WsPopupMenuRequestListener {
        private MappingsPopupListener() {
        }

        public void popupMenuRequested(MouseEvent ev) {
            BusinessRuleMappingsTab.this.m_mnuMappingsPopup.show((Component)((Object)BusinessRuleMappingsTab.this.m_pnlMappings), ev.getX(), ev.getY());
        }
    }

    private class CenterPanelLabelMouseListener
    implements MouseListener,
    MouseMotionListener {
        private int _x = -1;
        private boolean _dragging;

        private CenterPanelLabelMouseListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this._dragging) {
                Point pt = e.getPoint();
                SwingUtilities.convertPointToScreen(pt, e.getComponent());
                int x = pt.x;
                int delta = x - this._x;
                int outer = BusinessRuleMappingsTab.this.m_spltOuter.getDividerLocation() + delta;
                int inner = BusinessRuleMappingsTab.this.m_spltInner.getDividerLocation() + delta;
                if (delta < 0 ? inner < BusinessRuleMappingsTab.this.m_spltInner.getMinimumDividerLocation() : outer > BusinessRuleMappingsTab.this.m_spltOuter.getMaximumDividerLocation()) {
                    return;
                }
                BusinessRuleMappingsTab.this.m_spltOuter.setDividerLocation(outer);
                BusinessRuleMappingsTab.this.m_spltOuter.validate();
                BusinessRuleMappingsTab.this.m_spltInner.setDividerLocation(inner);
                BusinessRuleMappingsTab.this.m_spltInner.validate();
                this._x = x;
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this._dragging = true;
            Point pt = e.getPoint();
            SwingUtilities.convertPointToScreen(pt, e.getComponent());
            this._x = pt.x;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this._dragging = false;
            this._x = -1;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private class UndoManagerListener
    implements ChangeListener {
        private UndoManagerListener() {
        }

        @Override
        public void stateChanged(ChangeEvent ev) {
            UndoManager mgrUndo = BusinessRuleMappingsTab.this.m_container.getModel().getUndoManager();
            BusinessRuleMappingsTab.this.m_actUndo.setEnabled(mgrUndo.canUndo());
            BusinessRuleMappingsTab.this.m_actRedo.setEnabled(mgrUndo.canRedo());
        }
    }

    private class SelectSourceColumnsUndoable
    extends AbstractUndoableEdit {
        private IColumn[] m_aColumns;
        private boolean m_bOnUndo;
        private boolean m_bOnRedo;

        public SelectSourceColumnsUndoable(IColumn column, boolean bOnUndo, boolean bOnRedo) {
            this(new IColumn[]{column}, bOnUndo, bOnRedo);
        }

        public SelectSourceColumnsUndoable(IColumn[] aColumns, boolean bOnUndo, boolean bOnRedo) {
            this.m_aColumns = aColumns;
            this.m_bOnUndo = bOnUndo;
            this.m_bOnRedo = bOnRedo;
        }

        @Override
        public void undo() {
            super.undo();
            if (this.m_bOnUndo) {
                BusinessRuleMappingsTab.this.selectSourceColumns(this.m_aColumns);
            }
        }

        @Override
        public void redo() {
            super.redo();
            if (this.m_bOnRedo) {
                BusinessRuleMappingsTab.this.selectSourceColumns(this.m_aColumns);
            }
        }

        @Override
        public void die() {
            super.die();
            Arrays.fill(this.m_aColumns, null);
            this.m_aColumns = null;
        }
    }

    private class SelectPairingsUndoable
    extends AbstractUndoableEdit {
        private WsMapping[] m_aPairings;
        private boolean m_bOnUndo;
        private boolean m_bOnRedo;

        public SelectPairingsUndoable(WsMapping[] aPairings, boolean bOnUndo, boolean bOnRedo) {
            this.m_aPairings = aPairings;
            this.m_bOnUndo = bOnUndo;
            this.m_bOnRedo = bOnRedo;
        }

        @Override
        public void undo() {
            super.undo();
            if (this.m_bOnUndo) {
                BusinessRuleMappingsTab.this.selectPairings(this.m_aPairings);
            }
        }

        @Override
        public void redo() {
            super.redo();
            if (this.m_bOnRedo) {
                BusinessRuleMappingsTab.this.selectPairings(this.m_aPairings);
            }
        }

        @Override
        public void die() {
            super.die();
            Arrays.fill(this.m_aPairings, null);
            this.m_aPairings = null;
        }
    }
}

