/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.transforms.businessrules;

import com.sas.etl.models.job.transforms.businessrules.BusinessRuleTransformModel;
import com.sas.etl.models.job.transforms.businessrules.mapping.IBusinessRuleMappingsContainer;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.transforms.businessrules.BusinessRuleMappingsTab;
import com.sas.wadmin.transforms.businessrules.BusinessRuleTargetPanel;
import com.sas.wadmin.visuals.common.MappingsTab;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class BusinessRuleInputOutputTab
extends WAPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(BusinessRuleInputOutputTab.class);
    private static final String SPLIT_DETAILS_PANE_DIV_LOC = "BusinessRuleSplitPanelLocation";
    private BusinessRuleTransformModel _transform;
    private BusinessRuleMappingsTab _brMappings;
    private BusinessRuleTargetPanel _targetPanel;
    private JSplitPane m_splitPane;
    private boolean m_layoutComplete;

    public BusinessRuleInputOutputTab(BusinessRuleTransformModel model, MappingsTab.Configuration configuration) {
        this.setName(bundle.getString("BusinessRuleInputOutputTab.Name.txt"));
        this._transform = model;
        this._brMappings = new BusinessRuleMappingsTab((IBusinessRuleMappingsContainer)this._transform, configuration);
        this._targetPanel = new BusinessRuleTargetPanel(this._transform);
        this.initialize();
    }

    protected void initialize() {
        super.initialize();
        JPanel top = new JPanel();
        top.setLayout(new GridBagLayout());
        JLabel lbltop = WsUIUtilities.createLabelForComponent((JComponent)((Object)this._brMappings), (String)bundle.getString("BusinessRuleInputOutputTab.Inputs.txt"));
        top.add((Component)lbltop, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        top.add((Component)((Object)this._brMappings), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        JPanel bottom = new JPanel();
        bottom.setLayout(new GridBagLayout());
        JLabel lblbottom = WsUIUtilities.createLabelForComponent((JComponent)((Object)this._brMappings), (String)bundle.getString("BusinessRuleInputOutputTab.Outputs.txt"));
        bottom.add((Component)lblbottom, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        bottom.add((Component)((Object)this._targetPanel), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.m_splitPane = new JSplitPane(0, true);
        this.m_splitPane.setTopComponent(top);
        this.m_splitPane.setBottomComponent(bottom);
        this.add(this.m_splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void doLayout() {
        if (!this.m_layoutComplete) {
            WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
            this.m_splitPane.setDividerLocation(appDefaults.getPropertyInt(SPLIT_DETAILS_PANE_DIV_LOC, 300));
            this.m_splitPane.setResizeWeight(0.5);
            this.m_layoutComplete = true;
        }
        super.doLayout();
    }

    public void moveDataToStore() throws RemoteException, MdException {
        super.moveDataToStore();
        this._brMappings.moveDataToStore();
        this._targetPanel.moveDataToStore();
    }

    public void moveDataToView() {
        this._brMappings.moveDataToView();
        this._targetPanel.moveDataToView();
    }

    public void setEditable(boolean isEditable) {
        super.setEditable(isEditable);
        this._brMappings.setEditable(isEditable);
        this._targetPanel.setEditable(isEditable);
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyInt(SPLIT_DETAILS_PANE_DIV_LOC, this.m_splitPane.getDividerLocation());
        this._brMappings.saveSettingsAndCleanUp();
        this._targetPanel.saveSettingsAndCleanUp();
    }

    public boolean validateData() {
        return super.validateData() && this._brMappings.validateData() && this._targetPanel.validateData();
    }
}

