/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.search;

import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.services.ServiceException;
import com.sas.services.information.publicobject.DetailsProcessorInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.visuals.Resources;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDateTableColumn;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleObjectImpl;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class SearchResultsTableModel
extends WsAbstractTableModel {
    private static WAdminResource bundle = new WAdminResource(SearchResultsTableModel.class);
    private static final int NAME_COLUMN = 0;
    private static final int TYPE_COLUMN = 1;
    private static final int PATH_COLUMN = 2;
    private static final int DESCRIPTION_COLUMN = 3;
    private static final int DATE_MODIFIED_COLUMN = 4;
    private static final int DATE_CREATED_COLUMN = 5;
    private static final int VISIBLE_COLUMN_COUNT = 6;
    private static final int ICON_COLUMN = 6;
    private static final int OBJECT_COLUMN = 7;
    private static final int HIDDEN_COLUMN_COUNT = 2;
    private PopulatePathsThread m_thread;

    public SearchResultsTableModel() {
        WsStringTableColumn nameColumn = new WsStringTableColumn(0, bundle.getString("SearchResultsTableModel.Column.Name.txt"), 125);
        nameColumn.setIconColumn(6);
        this.m_aColumns = new WsAbstractTableColumn[8];
        this.m_aColumns[0] = nameColumn;
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("SearchResultsTableModel.Column.Type.txt"), 70);
        this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("SearchResultsTableModel.Column.Path.txt"), 150);
        this.m_aColumns[3] = new WsStringTableColumn(3, bundle.getString("SearchResultsTableModel.Column.Description.txt"), 150);
        this.m_aColumns[4] = new WsDateTableColumn(4, bundle.getString("SearchResultsTableModel.Column.DateModified.txt"), 150);
        this.m_aColumns[5] = new WsDateTableColumn(5, bundle.getString("SearchResultsTableModel.Column.DateCreated.txt"), 150);
        this.m_aColumns[6] = new WsObjectTableColumn();
        this.m_aColumns[7] = new WsObjectTableColumn();
        this.m_aColumns[1].setEditable(false);
        this.m_aColumns[2].setEditable(false);
        this.m_aColumns[4].setEditable(false);
        this.m_aColumns[5].setEditable(false);
    }

    public void setObjects(List<PublicObjectInterface> objects) throws ServiceException, RemoteException, MdException, LogicalTypeException {
        if (this.m_thread != null) {
            this.m_thread.cancel();
            this.m_thread = null;
        }
        this.clear();
        ArrayList<SimpleObject> simples = new ArrayList<SimpleObject>();
        for (PublicObjectInterface object : objects) {
            List<Object> lRowValues = this.createRowValues(object);
            if (lRowValues != null) {
                this.m_lData.add(lRowValues);
            }
            simples.add((SimpleObject)lRowValues.get(7));
        }
        this.fireTableModelPopulated();
        this.m_thread = new PopulatePathsThread(simples);
        this.m_thread.start();
    }

    private List<Object> createRowValues(PublicObjectInterface object) throws ServiceException, RemoteException, MdException, LogicalTypeException {
        DetailsProcessorInterface details = (DetailsProcessorInterface)object.getProcessorInterface("com.sas.services.information.publicobject.DetailsProcessorInterface");
        if (details == null) {
            return null;
        }
        ArrayList<Object> lRowValues = new ArrayList<Object>(7);
        String sMetadataType = "";
        String sPublicType = "";
        String sDisplayType = bundle.getString("SearchResultsTableModel.Unknown.txt");
        Icon iconType = Resources.getImageIcon((String)"GenericSASObject.gif", (int)16);
        TypeDescriptorInterface type = details.getType();
        if (type != null) {
            sMetadataType = type.getMetadataType();
            sPublicType = type.getTypeName();
            sDisplayType = type.getType();
            iconType = type.getIcon(16);
        }
        lRowValues.add(details.getName());
        lRowValues.add(sDisplayType);
        lRowValues.add("");
        lRowValues.add(details.getDescription());
        lRowValues.add(details.getModifyDate());
        lRowValues.add(details.getCreateDate());
        lRowValues.add(iconType);
        lRowValues.add(new SimpleObjectImpl(object.getName(), object.getIdentifier(), sMetadataType, sPublicType));
        return lRowValues;
    }

    public SimpleObject getSimpleObject(int iRow) {
        List row = (List)this.m_lData.get(iRow);
        return (SimpleObject)row.get(7);
    }

    private String getPath(PrimaryType object) throws RemoteException, MdException, ServiceException {
        String sPath = Workspace.getMdFactory().getOMIUtil().getObjectPath((MdObjectStore)object.getObjectStore(), object, false);
        int iLast = sPath.lastIndexOf(47);
        return iLast != -1 ? sPath.substring(0, iLast) : "";
    }

    public int getColumnCount() {
        return 6;
    }

    public int getHiddenColumnCount() {
        return 2;
    }

    public void moveDataToModel() throws MdException, RemoteException {
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public void populateStore() throws MdException, RemoteException {
    }

    private class PopulatePathsThread
    extends Thread {
        private List<SimpleObject> m_objects;
        private boolean m_bCancelled;

        public PopulatePathsThread(List<SimpleObject> objects) {
            this.m_objects = objects;
        }

        public void cancel() {
            this.m_bCancelled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.m_bCancelled) {
                return;
            }
            MdFactory factory = Workspace.getMdFactory();
            try {
                MdObjectStore store = factory.createObjectStore(null, "ObjectsTableModel");
                try {
                    for (int iObject = 0; iObject < this.m_objects.size(); ++iObject) {
                        SimpleObject object = this.m_objects.get(iObject);
                        PrimaryType mdo = (PrimaryType)Workspace.getMdFactory().createComplexMetadataObject(store, object.getName(), object.getMetadataType(), object.getID());
                        mdo.setPublicType(object.getPublicType());
                        String sPath = SearchResultsTableModel.this.getPath(mdo);
                        if (this.m_bCancelled) {
                        } else {
                            SwingUtilities.invokeLater(new UpdatePathRunnable(object, iObject, sPath));
                            if (!this.m_bCancelled) continue;
                        }
                        break;
                    }
                }
                finally {
                    store.dispose();
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            catch (ServiceException ex) {
                Workspace.handleServiceException((ServiceException)ex);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
        }
    }

    private class UpdatePathRunnable
    implements Runnable {
        private SimpleObject m_object;
        private int m_iRow;
        private String m_sPath;

        public UpdatePathRunnable(SimpleObject object, int iRow, String sPath) {
            this.m_object = object;
            this.m_iRow = iRow;
            this.m_sPath = sPath;
        }

        @Override
        public void run() {
            if (this.m_iRow < SearchResultsTableModel.this.getRowCount() && SearchResultsTableModel.this.getSimpleObject(this.m_iRow) == this.m_object) {
                SearchResultsTableModel.this.setValueAt(this.m_sPath, this.m_iRow, 2);
            }
        }
    }
}

