/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.sascodeimporter;

import com.sas.visuals.Resources;
import com.sas.wadmin.sascodeimporter.SASCodeItem;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.visuals.WsLogPropertyTab;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SASCodeImporterLogPanel
extends WAPanel {
    private static final WAdminResource bundle = WAdminResource.getBundle(SASCodeImporterLogPanel.class);
    private static final int PANEL_WIDTH = 600;
    private static final int PANEL_HEIGHT = 400;
    private static final int FILELIST_WIDTH = 200;
    private static final Icon _errorTabIcon = Resources.getImageIcon((String)"Error", (int)12);
    private JLabel m_lblDescription;
    private JList m_lstFiles;
    private JScrollPane m_scrFileList;
    private ListSelectionListener m_lsrFileSelection;
    private SASCodeItem[] m_items;
    private JSplitPane m_splPane;
    private JTabbedPane m_logTabs;
    private WsLogPropertyTab m_convertLogTab;
    private WATextArea m_parseLogTab;

    public SASCodeImporterLogPanel(List<SASCodeItem> items) {
        this.m_items = items.toArray(new SASCodeItem[items.size()]);
        this.setHelpProduct("wdb");
        this.setHelpTopic("import_sas_code_convers_log");
        this.initialize();
        this.layoutWidgets();
    }

    protected void initialize() {
        WorkspaceFile defaultsFile = Workspace.getWorkspace().getAppDefaultsFile();
        int width = defaultsFile.getPropertyInt("SASCodeImporterTab.LogPanelWidth", 600);
        int height = defaultsFile.getPropertyInt("SASCodeImporterTab.LogPanelHeight", 400);
        this.setPreferredSize(new Dimension(width, height));
        this.m_lblDescription = new JLabel(bundle.getString("SASCodeImporterTab.ConversionLogsLabel.txt"));
        this.m_lsrFileSelection = new ImportLogSelectionListener();
        this.m_lstFiles = new JList<SASCodeItem>(this.m_items);
        this.m_lstFiles.setCellRenderer(new FileListCellRenderer());
        this.m_lstFiles.setSelectionMode(0);
        this.m_lstFiles.addListSelectionListener(this.m_lsrFileSelection);
        this.m_scrFileList = new JScrollPane(this.m_lstFiles);
        this.m_logTabs = new JTabbedPane();
        this.m_convertLogTab = new WsLogPropertyTab(1);
        this.m_parseLogTab = new WATextArea();
        this.m_parseLogTab.setTabSize(5);
        this.m_parseLogTab.setEditable(false);
        Font font = this.m_parseLogTab.getFont();
        this.m_parseLogTab.setFont(new Font("monospaced", font.getStyle(), font.getSize()));
        this.m_splPane = new JSplitPane();
        this.m_splPane.setOrientation(1);
        this.m_splPane.setLeftComponent(this.m_scrFileList);
        this.m_splPane.setRightComponent(this.m_logTabs);
        int splitLocation = defaultsFile.getPropertyInt("SASCodeImporterTab.ImportPanelSplit", 200);
        this.m_splPane.setDividerLocation(splitLocation);
        this.m_lstFiles.setSelectedIndex(0);
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblDescription, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.m_splPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void saveSettingsAndCleanUp() {
        WorkspaceFile defaultsFile = Workspace.getWorkspace().getAppDefaultsFile();
        defaultsFile.setPropertyInt("SASCodeImporterTab.ImportPanelSplit", this.m_splPane.getDividerLocation());
        defaultsFile.setPropertyInt("SASCodeImporterTab.LogPanelWidth", this.getWidth());
        defaultsFile.setPropertyInt("SASCodeImporterTab.LogPanelHeight", this.getHeight());
        this.m_lstFiles.getSelectionModel().removeListSelectionListener(this.m_lsrFileSelection);
        this.m_lsrFileSelection = null;
    }

    private Icon getResultIcon(SASCodeItem.Result result) {
        if (result == SASCodeItem.Result.SUCCESS) {
            return Resources.getImageIcon((String)"Complete", (int)14);
        }
        return Resources.getImageIcon((String)"Error", (int)14);
    }

    private class ImportLogSelectionListener
    implements ListSelectionListener {
        private ImportLogSelectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(ListSelectionEvent e) {
            Window parent = SwingUtilities.getWindowAncestor((Component)((Object)SASCodeImporterLogPanel.this));
            if (parent != null) {
                parent.setCursor(Cursor.getPredefinedCursor(3));
            }
            try {
                SASCodeImporterLogPanel.this.m_logTabs.removeAll();
                SASCodeItem selectedItem = (SASCodeItem)SASCodeImporterLogPanel.this.m_lstFiles.getSelectedValue();
                if (selectedItem != null) {
                    if (selectedItem._convertLog != null) {
                        SASCodeImporterLogPanel.this.m_convertLogTab.setText(selectedItem._convertLog);
                        SASCodeImporterLogPanel.this.m_convertLogTab.scrollToTop();
                        Icon tabIcon = selectedItem._convertResult == SASCodeItem.Result.ERROR ? _errorTabIcon : null;
                        SASCodeImporterLogPanel.this.m_logTabs.addTab(bundle.getString("SASCodeImporterLogPanel.Convert.txt"), tabIcon, (Component)SASCodeImporterLogPanel.this.m_convertLogTab);
                    }
                    if (selectedItem._convertResult != SASCodeItem.Result.ERROR) {
                        SASCodeImporterLogPanel.this.m_parseLogTab.setText(selectedItem._parseLog);
                        SASCodeImporterLogPanel.this.m_parseLogTab.setCaretPosition(0);
                        String tabLabel = selectedItem._action == SASCodeItem.Action.IMPORT ? bundle.getString("SASCodeImporterLogPanel.Import.txt") : bundle.getString("SASCodeImporterLogPanel.Analyze.txt");
                        Icon tabIcon = selectedItem._parseResult == SASCodeItem.Result.ERROR ? _errorTabIcon : null;
                        SASCodeImporterLogPanel.this.m_logTabs.addTab(tabLabel, tabIcon, new JScrollPane((Component)SASCodeImporterLogPanel.this.m_parseLogTab));
                    }
                }
            }
            finally {
                if (parent != null) {
                    parent.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    private class FileListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public FileListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            SASCodeItem item = (SASCodeItem)value;
            SASCodeItem.Result result = item._convertResult == SASCodeItem.Result.SUCCESS && item._parseResult == SASCodeItem.Result.SUCCESS ? SASCodeItem.Result.SUCCESS : SASCodeItem.Result.ERROR;
            this.setIcon(SASCodeImporterLogPanel.this.getResultIcon(result));
            this.setText(item.toString());
            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            return this;
        }
    }
}

