/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.run;

import com.sas.etl.models.job.ICodeSegment;
import com.sas.wadmin.run.RunModel;
import com.sas.wadmin.run.RunResults;
import com.sas.workspace.WsAppServerFailException;
import java.util.EventObject;

public class RunEvent
extends EventObject {
    public static final String RUN_STARTED = "RunStarted";
    public static final String SEGMENT_STARTED = "SegmentStarted";
    public static final String SEGMENT_PARSING = "SegmentParsing";
    public static final String SEGMENT_COMPLETED = "SegmentCompleted";
    public static final String RUN_COMPLETED = "RunCompleted";
    public static final String RUN_STOPPED = "RunStopped";
    public static final String RUN_ABORTED = "RunAborted";
    private String m_sType;
    private ICodeSegment m_codeSegment;
    private RunResults m_results;
    private WsAppServerFailException m_exception;
    private long m_time;

    public RunEvent(RunModel mdl, String sType) {
        this(mdl, sType, null);
    }

    public RunEvent(RunModel mdl, String sType, ICodeSegment code) {
        this(mdl, sType, code, null);
    }

    public RunEvent(RunModel mdl, String sType, ICodeSegment code, RunResults results) {
        this(mdl, sType, code, results, null);
    }

    public RunEvent(RunModel mdl, String sType, ICodeSegment code, RunResults results, WsAppServerFailException ex) {
        super(mdl);
        this.m_time = results != null ? results.getStopTime() : System.currentTimeMillis();
        this.m_sType = sType;
        this.m_codeSegment = code;
        this.m_results = results;
        this.m_exception = ex;
    }

    public String getType() {
        return this.m_sType;
    }

    public ICodeSegment getCodeSegment() {
        return this.m_codeSegment;
    }

    public RunResults getResults() {
        return this.m_results;
    }

    public WsAppServerFailException getException() {
        return this.m_exception;
    }

    public long getTime() {
        return this.m_time;
    }
}

