/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.reports.jobdoc.parser;

import com.sas.wadmin.reports.jobdoc.PluginLogger;
import com.sas.wadmin.reports.jobdoc.md.GlobalProperties;
import com.sas.wadmin.reports.jobdoc.parser.Constants;
import com.sas.wadmin.reports.jobdoc.parser.HTMLInterpreter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Locale;

public class HTMLGenerator {
    private static final WAdminResource bundle = WAdminResource.getBundle(HTMLGenerator.class);

    public static InputStream createInputStream(String srcdir, String file) throws FileNotFoundException {
        FileInputStream is = null;
        Workspace.getDefaultLogger().debug((Object)"in create input stream");
        if (srcdir == null || srcdir.length() == 0) {
            String defaultLoc = System.getProperty("user.dir") + System.getProperty("file.separator") + "html" + System.getProperty("file.separator") + "JobDocReport" + System.getProperty("file.separator");
            Workspace.getDefaultLogger().debug((Object)("createInputStream loc: " + defaultLoc));
            File f = new File(defaultLoc + file);
            if (f.exists() && f.isFile()) {
                is = new FileInputStream(defaultLoc + file);
                Workspace.getDefaultLogger().debug((Object)("createInputStream loc1: " + defaultLoc + ":" + file));
            }
            Workspace.getDefaultLogger().debug((Object)"createInputStream loc1: ");
        } else {
            File f = new File(srcdir + file);
            if (f.exists() && f.isFile()) {
                is = new FileInputStream(srcdir + file);
            }
            Workspace.getDefaultLogger().debug((Object)("srcDir not null " + srcdir + ":" + file));
        }
        return is;
    }

    public static BufferedReader createReader(String src, String file) throws FileNotFoundException, UnsupportedEncodingException {
        BufferedReader br = null;
        Workspace.getDefaultLogger().debug((Object)"in create reader");
        if (src == null || src.length() == 0) {
            String defaultLoc = System.getProperty("user.dir") + System.getProperty("file.separator") + "html" + System.getProperty("file.separator") + "JobDocReport" + System.getProperty("file.separator");
            Workspace.getDefaultLogger().debug((Object)("createReader loc: " + defaultLoc));
            String localizedFileName = HTMLGenerator.getLocalizedFileName(defaultLoc, file);
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(defaultLoc + localizedFileName), "UTF-8"));
        } else {
            String localizedFileName = HTMLGenerator.getLocalizedFileName(src, file);
            Workspace.getDefaultLogger().debug((Object)("srce + file:" + src + ":" + file));
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(src + localizedFileName), "UTF-8"));
        }
        return br;
    }

    public void init() {
        String dir = GlobalProperties.instance().getOutputdirectory();
        String tmpl = GlobalProperties.instance().getTemplatedirectory();
        Workspace.getDefaultLogger().debug((Object)"in init");
        Workspace.getDefaultLogger().debug((Object)("output dir:" + dir));
        Workspace.getDefaultLogger().debug((Object)("tmpl: " + tmpl));
        if (tmpl != null && tmpl.length() > 0) {
            if (!tmpl.endsWith("/") && !tmpl.endsWith("\\")) {
                tmpl = tmpl + "/";
            }
            Workspace.getDefaultLogger().debug((Object)("***** HTMLGenerator.init(): using custom template: " + tmpl));
            GlobalProperties.instance().setTemplatedirectory(tmpl);
        }
        if (dir == null || dir.length() == 0) {
            Workspace.getDefaultLogger().debug((Object)"##### HTMLGenerator.init(): error, no output dir");
            return;
        }
        if (!dir.endsWith("/") && !dir.endsWith("\\")) {
            dir = dir + "/";
        }
        GlobalProperties.instance().setOutputdirectory(dir);
        Workspace.getDefaultLogger().debug((Object)("***** HTMLGenerator.init(): using output directory: " + dir));
        try {
            File f = new File(dir);
            if (!f.exists()) {
                f.mkdir();
            }
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().debug((Object)"##### HTMLGenerator.init(): error creating directory");
            Workspace.getDefaultLogger().debug((Object)("##### " + PluginLogger.getStackTrace(e)));
            MessageUtil.displayMessage((String)e.getMessage(), (String)bundle.getString("HTMLGenerator.Dir.Error.txt"), (int)0);
        }
    }

    public void run() {
        try {
            File test;
            Workspace.getDefaultLogger().debug((Object)"in run");
            String dir = GlobalProperties.instance().getOutputdirectory();
            String tmpl = GlobalProperties.instance().getTemplatedirectory();
            Workspace.getDefaultLogger().debug((Object)("run: output directory: " + dir));
            Workspace.getDefaultLogger().debug((Object)("run: template directory: " + tmpl));
            ArrayList<String> files = new ArrayList<String>();
            boolean bExists = true;
            if (tmpl != null && tmpl.length() > 0 && (bExists = (test = new File(tmpl)).exists())) {
                String[] listOfFiles = test.list();
                if (listOfFiles.length == 0) {
                    bExists = false;
                }
                Workspace.getDefaultLogger().debug((Object)"run: list of files was zero");
            }
            if (!bExists) {
                tmpl = null;
            }
            if (tmpl == null || tmpl.length() == 0 || !bExists) {
                BufferedReader br = HTMLGenerator.createReader(tmpl, "files.template");
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (line.length() == 0) continue;
                    files.add(line);
                }
                br.close();
            } else {
                File f = new File(tmpl);
                String[] fs = f.list();
                for (int i = 0; i < fs.length; ++i) {
                    files.add(fs[i]);
                }
            }
            for (int i = 0; i < files.size(); ++i) {
                String f = (String)files.get(i);
                boolean isStatic = true;
                for (int j = 0; j < Constants.DEFAULT_DYNFILES.length; ++j) {
                    if (!f.toUpperCase().endsWith(Constants.DEFAULT_DYNFILES[j])) continue;
                    isStatic = false;
                }
                if (isStatic) {
                    this.doCopyStaticFile(dir, tmpl, f);
                    continue;
                }
                this.doCopyAndParseFile(dir, tmpl, f);
            }
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().debug((Object)("##### HTMLGenerator.run(): " + e.getMessage()));
        }
    }

    private void doCopyAndParseFile(String tgtdir, String srcdir, String file) {
        Workspace.getDefaultLogger().debug((Object)("***** HTMLGenerator.doCopyAndParseFile(): copying file: srcdir tgtdir file" + srcdir + ":" + tgtdir + ":" + file));
        try {
            HTMLInterpreter hi = new HTMLInterpreter();
            PrintStream ps = new PrintStream(new FileOutputStream(tgtdir + file));
            hi.run(ps, srcdir, file);
            ps.close();
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().debug((Object)("##### HTMLGenerator.doCopyAndParseFile(): I/O error: " + srcdir + file));
            Workspace.getDefaultLogger().debug((Object)("##### " + e.getMessage()));
        }
    }

    private void doCopyStaticFile(String tgtdir, String srcdir, String file) {
        Workspace.getDefaultLogger().debug((Object)("***** HTMLGenerator.doCopyStaticFile(): using output directory: " + tgtdir + file));
        try {
            InputStream is = HTMLGenerator.createInputStream(srcdir, file);
            if (is == null) {
                return;
            }
            FileOutputStream fos = new FileOutputStream(tgtdir + file);
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = is.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
            is.close();
            fos.close();
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().debug((Object)("##### HTMLGenerator.doCopyStaticFile(): I/O error: " + srcdir + file));
            Workspace.getDefaultLogger().debug((Object)("##### " + e.getMessage()));
        }
    }

    private static String getLocalizedFileName(String path, String filename) {
        if (filename.endsWith(".html")) {
            String ln = Locale.getDefault().getLanguage();
            String cu = Locale.getDefault().getCountry();
            String sTemp = filename.substring(0, filename.lastIndexOf(".html")) + "_" + ln + "_" + cu + ".html";
            File temp = new File(path + sTemp);
            if (temp.exists()) {
                filename = sTemp;
            } else {
                sTemp = filename.substring(0, filename.lastIndexOf(".html")) + "_" + ln + ".html";
                temp = new File(path + sTemp);
                if (temp.exists()) {
                    filename = sTemp;
                }
            }
        }
        return filename;
    }
}

