/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.reports.jobdoc.md;

import com.sas.metadata.AssociationList;
import com.sas.metadata.CMetadata;
import com.sas.metadata.ClassifierMap;
import com.sas.metadata.DataTable;
import com.sas.metadata.DatabaseSchema;
import com.sas.metadata.ExternalTable;
import com.sas.metadata.File;
import com.sas.metadata.Job;
import com.sas.metadata.MdException;
import com.sas.metadata.PhysicalTable;
import com.sas.metadata.TransformationActivity;
import com.sas.metadata.TransformationStep;
import com.sas.wadmin.reports.jobdoc.PluginLogger;
import com.sas.wadmin.reports.jobdoc.md.BaseMetadata;
import com.sas.wadmin.reports.jobdoc.md.ColumnMetadata;
import com.sas.wadmin.reports.jobdoc.md.ETLObjects;
import com.sas.wadmin.reports.jobdoc.md.JobMetadata;
import com.sas.wadmin.reports.jobdoc.md.LibraryMetadata;
import java.util.ArrayList;

public class TableMetadata
extends BaseMetadata {
    private ArrayList informationMaps = null;
    private ArrayList cubes = null;
    private ArrayList indexes = null;
    private String sastablename = null;
    private String membertype = null;
    private String tablepackage = null;
    private String owningFile = null;
    private String[] columns = null;
    private String[] jobSources = null;
    private String[] jobTargets = null;
    private String[] informationMapsIds = null;
    private String[] indexIds = null;
    private String[] cubesIds = null;

    public TableMetadata(CMetadata cm) {
        super(cm.getRepositoryID(), cm.getName(), cm.getFQID(), cm.getDesc(), cm.getMetadataCreated(), cm.getMetadataUpdated());
        try {
            AssociationList list;
            if (cm instanceof PhysicalTable) {
                PhysicalTable pt = (PhysicalTable)cm;
                this.sastablename = pt.getSASTableName();
                this.membertype = pt.getMemberType();
                TableMetadata.collectIds(pt.getIndexes(), this, "_setIndexIds");
                TableMetadata.collectIds(pt.getReachThruCubes(), this, "_setCubeIds");
            } else if (cm instanceof ExternalTable && (list = ((ExternalTable)cm).getOwningFiles()) != null && list.size() > 0 && list.get(0) instanceof File) {
                File f = (File)list.get(0);
                this.owningFile = f.getFileName();
            }
            DataTable dt = (DataTable)cm;
            TableMetadata.collectIds(dt.getColumns(), this, "setColumns");
            AssociationList list2 = dt.getTablePackages();
            if (list2 != null && list2.size() > 0) {
                if (list2.get(0) instanceof DatabaseSchema) {
                    TableMetadata.collectIds(((DatabaseSchema)list2.get(0)).getUsedByPackages(), this, "setTablePackage");
                } else {
                    TableMetadata.collectIds(dt.getTablePackages(), this, "setTablePackage");
                }
            }
            this.setJobSources(this.extractJobs(dt.getSourceClassifierMaps()));
            this.setJobTargets(this.extractJobs(dt.getTargetClassifierMaps()));
            TableMetadata.collectIds(dt.getSourceTransformations(), this, "_setInformationMapIds");
            TableMetadata.collectIds(dt.getResponsibleParties(), this, "_setResponsiblePartyIds");
            TableMetadata.collectIds(dt.getNotes(), this, "_setNoteIds");
            TableMetadata.collectIds(dt.getTrees(), this, "_setTreeId");
        }
        catch (MdException e) {
            PluginLogger.log("##### TableMetadata.<init>: error: " + PluginLogger.getStackTrace(e));
        }
    }

    public ArrayList getJobsources() {
        if (this.jobSources == null || this.jobSources.length == 0) {
            return null;
        }
        ArrayList<JobMetadata> jobs = new ArrayList<JobMetadata>();
        for (int i = 0; i < this.jobSources.length; ++i) {
            JobMetadata jm = (JobMetadata)ETLObjects.instance().locate(JobMetadata.class, this.jobSources[i]);
            jobs.add(jm);
        }
        return jobs;
    }

    public ArrayList getJobtargets() {
        if (this.jobTargets == null || this.jobTargets.length == 0) {
            return null;
        }
        ArrayList<JobMetadata> jobs = new ArrayList<JobMetadata>();
        for (int i = 0; i < this.jobTargets.length; ++i) {
            JobMetadata jm = (JobMetadata)ETLObjects.instance().locate(JobMetadata.class, this.jobTargets[i]);
            jobs.add(jm);
        }
        return jobs;
    }

    public ArrayList getIndexes() {
        return this.indexes;
    }

    public void setIndexes(ArrayList indexes) {
        this.indexes = indexes;
    }

    private void setJobSources(String[] ids) {
        this.jobSources = ids;
    }

    private void setJobTargets(String[] ids) {
        this.jobTargets = ids;
    }

    public boolean isInUse() {
        return this.jobSources != null || this.jobTargets != null || this.cubesIds != null || this.informationMapsIds != null;
    }

    public String getMembertype() {
        return this.membertype;
    }

    public String getOwningfile() {
        return this.owningFile;
    }

    public String getSastablename() {
        return this.sastablename;
    }

    public void setColumns(String[] ids) {
        this.columns = ids;
    }

    public ArrayList getColumns() {
        if (this.columns == null || this.columns.length == 0) {
            return null;
        }
        ArrayList<ColumnMetadata> cols = new ArrayList<ColumnMetadata>();
        for (int i = 0; i < this.columns.length; ++i) {
            ColumnMetadata cm = (ColumnMetadata)ETLObjects.instance().locate(ColumnMetadata.class, this.columns[i]);
            cols.add(cm);
        }
        return cols;
    }

    public void setCubes(ArrayList cubes) {
        this.cubes = cubes;
    }

    public ArrayList getCubes() {
        return this.cubes;
    }

    public void setInformationMaps(ArrayList maps) {
        this.informationMaps = maps;
    }

    public ArrayList getInformationmaps() {
        return this.informationMaps;
    }

    public String[] _getInformationMapIds() {
        return this.informationMapsIds;
    }

    public void _setInformationMapIds(String[] informationMaps) {
        this.informationMapsIds = informationMaps;
    }

    public String[] _getIndexIds() {
        return this.indexIds;
    }

    public void _setIndexIds(String[] indexes) {
        this.indexIds = indexes;
    }

    public String[] _getCubeIds() {
        return this.cubesIds;
    }

    public void _setCubeIds(String[] cubes) {
        this.cubesIds = cubes;
    }

    public LibraryMetadata getTablepackage() {
        return (LibraryMetadata)ETLObjects.instance().locate(LibraryMetadata.class, this.tablepackage);
    }

    public void setTablePackage(String[] ids) {
        if (ids != null && ids.length > 0) {
            this.tablepackage = ids[0];
        }
    }

    private String[] extractJobs(AssociationList list) throws MdException {
        try {
            ArrayList<String> jobids = new ArrayList<String>();
            for (ClassifierMap cm : list) {
                TransformationActivity ta;
                AssociationList jobs;
                TransformationStep ts;
                AssociationList activities;
                AssociationList steps = cm.getSteps();
                if (steps == null || steps.size() <= 0 || (activities = (ts = (TransformationStep)steps.get(0)).getActivities()) == null || activities.size() <= 0 || (jobs = (ta = (TransformationActivity)activities.get(0)).getJobs()) == null || jobs.size() <= 0) continue;
                Job job = (Job)jobs.get(0);
                boolean alreadyInList = false;
                for (int i = 0; i < jobids.size(); ++i) {
                    String ji = (String)jobids.get(i);
                    if (!ji.equals(job.getFQID())) continue;
                    alreadyInList = true;
                    break;
                }
                if (alreadyInList) continue;
                jobids.add(job.getFQID());
            }
            if (jobids == null || jobids.size() == 0) {
                return null;
            }
            String[] jobs = new String[jobids.size()];
            for (int i = 0; i < jobids.size(); ++i) {
                jobs[i] = (String)jobids.get(i);
            }
            return jobs;
        }
        catch (Exception e) {
            PluginLogger.log("##### TableMetadata.extractJobs(): error: " + PluginLogger.getStackTrace(e));
            return null;
        }
    }
}

