/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.reports.jobdoc.md;

import com.sas.metadata.AssociationList;
import com.sas.metadata.CMetadata;
import com.sas.wadmin.reports.jobdoc.JobDoc;
import com.sas.wadmin.reports.jobdoc.PluginLogger;
import com.sas.wadmin.reports.jobdoc.md.ColumnMetadata;
import com.sas.wadmin.reports.jobdoc.md.CubeMetadata;
import com.sas.wadmin.reports.jobdoc.md.ETLObjects;
import com.sas.wadmin.reports.jobdoc.md.InformationMapMetadata;
import com.sas.wadmin.reports.jobdoc.md.JobMetadata;
import com.sas.wadmin.reports.jobdoc.md.LibraryMetadata;
import com.sas.wadmin.reports.jobdoc.md.NoteMetadata;
import com.sas.wadmin.reports.jobdoc.md.RepositoryMetadata;
import com.sas.wadmin.reports.jobdoc.md.ResponsiblePartyMetadata;
import com.sas.wadmin.reports.jobdoc.md.TableMetadata;
import com.sas.workspace.WAdminResource;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public class BaseMetadata {
    private static WAdminResource bundle = new WAdminResource(JobDoc.class);
    private DateFormat METADATASERVERDATETIMEFORMAT = new SimpleDateFormat("ddMMMyyyy:HH:mm:ss", new Locale("EN"));
    protected ArrayList notes = null;
    protected ArrayList responsibleparties = null;
    protected String repos = null;
    protected String name = null;
    protected String id = null;
    protected String desc = null;
    protected String metadatacreated = null;
    protected String metadataupdated = null;
    protected String tree = null;
    protected String _treeid = null;
    protected String[] noteids = null;
    private String[] responsiblePartyids = null;
    protected String type = null;

    public BaseMetadata(String repos, String name, String id, String desc, String mdcreated, String mdupdated) {
        this.repos = (repos.indexOf(".") == -1 ? "A0000001." : "") + repos;
        this.name = name;
        this.id = id;
        this.desc = desc;
        this.metadatacreated = mdcreated;
        this.metadataupdated = mdupdated;
        this.formatMetadatacreated();
        this.formatMetadataupdated();
        if (this instanceof TableMetadata) {
            this.type = bundle.getString("JobDoc.types.table.txt");
        } else if (this instanceof LibraryMetadata) {
            this.type = bundle.getString("JobDoc.types.library.txt");
        } else if (this instanceof ColumnMetadata) {
            this.type = bundle.getString("JobDoc.types.column.txt");
        } else if (this instanceof JobMetadata) {
            this.type = bundle.getString("JobDoc.types.job.txt");
        } else if (this instanceof RepositoryMetadata) {
            this.type = bundle.getString("JobDoc.types.repository.txt");
        } else if (this instanceof CubeMetadata) {
            this.type = bundle.getString("JobDoc.types.cube.txt");
        } else if (this instanceof InformationMapMetadata) {
            this.type = bundle.getString("JobDoc.types.informationmap.txt");
        } else if (this instanceof NoteMetadata) {
            this.type = bundle.getString("JobDoc.types.note.txt");
        } else if (this instanceof ResponsiblePartyMetadata) {
            this.type = bundle.getString("JobDoc.types.responsibleparty.txt");
        }
    }

    public int compareByNameIgnoreCase(BaseMetadata bm) {
        return this.getName().compareToIgnoreCase(bm.getName());
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getId() {
        return this.id;
    }

    public String getTree() {
        return this.tree;
    }

    public void setTree(String tree) {
        this.tree = tree;
    }

    public String _getTreeId() {
        return this._treeid;
    }

    public void _setTreeId(String[] ids) {
        if (ids != null && ids.length > 0) {
            this._treeid = ids[0];
        }
    }

    public String _getReposId() {
        return this.repos;
    }

    public RepositoryMetadata getRepository() {
        return (RepositoryMetadata)ETLObjects.instance().locate(RepositoryMetadata.class, this.repos);
    }

    public String getMetadatacreated() {
        return this.metadatacreated;
    }

    public String getMetadataupdated() {
        return this.metadataupdated;
    }

    public void _setNoteIds(String[] notes) {
        this.noteids = notes;
    }

    public String[] _getNoteIds() {
        return this.noteids;
    }

    public String[] _getResponsiblePartyIds() {
        return this.responsiblePartyids;
    }

    public void _setResponsiblePartyIds(String[] responsibleParties) {
        this.responsiblePartyids = responsibleParties;
    }

    public void setNotes(ArrayList notes) {
        this.notes = notes;
    }

    public ArrayList getNotes() {
        return this.notes;
    }

    public ArrayList getResponsibleparties() {
        return this.responsibleparties;
    }

    public void setResponsibleParties(ArrayList responsibleparties) {
        this.responsibleparties = responsibleparties;
    }

    protected static void collectIds(AssociationList list, Object store, String store_meth) {
        try {
            Class<?> clazz = store.getClass();
            Method[] methods = clazz.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(store_meth)) continue;
                if (list != null && list.size() > 0) {
                    String[] ids = new String[list.size()];
                    int j = 0;
                    for (CMetadata cm : list) {
                        ids[j++] = cm.getFQID();
                    }
                    methods[i].invoke(store, new Object[]{ids});
                }
                return;
            }
            PluginLogger.log("***** BaseMetadata.collectIds(): method " + store_meth + " not found");
        }
        catch (Exception e) {
            PluginLogger.log("##### BaseMetadata.collectIds(): error: " + PluginLogger.getStackTrace(e));
        }
    }

    protected void formatMetadatacreated() {
        if (this.metadatacreated != null) {
            try {
                Date d = this.METADATASERVERDATETIMEFORMAT.parse(this.metadatacreated);
                this.metadatacreated = DateFormat.getDateTimeInstance(1, 1).format(d);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    protected void formatMetadataupdated() {
        if (this.metadataupdated != null) {
            try {
                Date d = this.METADATASERVERDATETIMEFORMAT.parse(this.metadataupdated);
                this.metadataupdated = DateFormat.getDateTimeInstance(1, 1).format(d);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }
}

