/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.reports.jobdoc.iomi;

import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.AssociationList;
import com.sas.metadata.CMetadata;
import com.sas.metadata.Column;
import com.sas.metadata.Cube;
import com.sas.metadata.DataTable;
import com.sas.metadata.Directory;
import com.sas.metadata.File;
import com.sas.metadata.Index;
import com.sas.metadata.Job;
import com.sas.metadata.MdException;
import com.sas.metadata.MdStore;
import com.sas.metadata.MetadataUtil;
import com.sas.metadata.ResponsibleParty;
import com.sas.metadata.SASLibrary;
import com.sas.metadata.TextStore;
import com.sas.metadata.Transformation;
import com.sas.metadata.Tree;
import com.sas.wadmin.reports.jobdoc.JobDoc;
import com.sas.wadmin.reports.jobdoc.PluginLogger;
import com.sas.wadmin.reports.jobdoc.iomi.IOMIConnectionProvider;
import com.sas.wadmin.reports.jobdoc.iomi.MetadataSort;
import com.sas.wadmin.reports.jobdoc.md.BaseMetadata;
import com.sas.wadmin.reports.jobdoc.md.ColumnMetadata;
import com.sas.wadmin.reports.jobdoc.md.CubeMetadata;
import com.sas.wadmin.reports.jobdoc.md.ETLObjects;
import com.sas.wadmin.reports.jobdoc.md.GlobalProperties;
import com.sas.wadmin.reports.jobdoc.md.IndexMetadata;
import com.sas.wadmin.reports.jobdoc.md.InformationMapMetadata;
import com.sas.wadmin.reports.jobdoc.md.JobMetadata;
import com.sas.wadmin.reports.jobdoc.md.LibraryMetadata;
import com.sas.wadmin.reports.jobdoc.md.NoteMetadata;
import com.sas.wadmin.reports.jobdoc.md.RepositoryMetadata;
import com.sas.wadmin.reports.jobdoc.md.ResponsiblePartyMetadata;
import com.sas.wadmin.reports.jobdoc.md.TableMetadata;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IOMIAccess {
    private static WAdminResource bundle = new WAdminResource(JobDoc.class);
    private IOMIConnectionProvider iomiConn = null;
    private IOMI iomi = null;

    public IOMIAccess(IOMIConnectionProvider icp) {
        this.iomiConn = icp;
    }

    public void close() {
        if (this.iomiConn != null) {
            this.iomiConn.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init() {
        long now = new Date().getTime();
        try {
            this.iomiConn.connect();
            this.iomi = this.iomiConn.getConnection();
            ETLObjects.instance().init();
            for (CMetadata r : this.iomiConn.getRepositories()) {
                PluginLogger.log("***** IOMIAccess.init(): scanning repository " + r.getName() + " (" + r.getFQID() + ")");
                RepositoryMetadata rm = new RepositoryMetadata(r);
                rm.setRepositoryType(this.getRepositoryInformation(r.getName(), "RepositoryType"));
                rm.setPath(this.getRepositoryInformation(r.getName(), "Path"));
                rm.setMetadataCreated(this.getRepositoryInformation(r.getName(), "MetadataCreated"));
                rm.setMetadataUpdated(this.getRepositoryInformation(r.getName(), "MetadataUpdated"));
                ETLObjects.instance().addRepository(rm);
                this.doExtractMetadata(r, bundle.getString("JobDoc.xmlselect.physicaltable.txt.notrans"), "DataTable");
                this.doExtractMetadata(r, bundle.getString("JobDoc.xmlselect.externaltable.txt.notrans"), "DataTable");
                this.doExtractMetadata(r, bundle.getString("JobDoc.xmlselect.job.txt.notrans"), "Job");
                this.doExtractMetadata(r, bundle.getString("JobDoc.xmlselect.library.txt.notrans"), "SASLibrary");
                this.doExtractMetadata(r, bundle.getString("JobDoc.xmlselect.column.txt.notrans"), "Column");
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            PluginLogger.log("##### IOMIAccess.init(): error: " + PluginLogger.getStackTrace(e));
        }
        finally {
            long now2 = new Date().getTime() - now;
            PluginLogger.log("***** IOMIAccess.init(): method execution took " + (double)now2 / 1000.0 + " secs");
        }
        return false;
    }

    public void createCrossReferences() {
        int j;
        TableMetadata tm;
        int j2;
        long now = new Date().getTime();
        PluginLogger.log("***** IOMIAccess.createCrossReferences(): generating trees for libraries, tables, jobs");
        HashMap treeRegistry = new HashMap();
        this.doRetrieveMetadataTree(treeRegistry, ETLObjects.instance().getLibraries());
        this.doRetrieveMetadataTree(treeRegistry, ETLObjects.instance().getTables());
        this.doRetrieveMetadataTree(treeRegistry, ETLObjects.instance().getJobs());
        this.runGC();
        ArrayList tables = ETLObjects.instance().getTables();
        ArrayList<ColumnMetadata> usedColumns = new ArrayList<ColumnMetadata>();
        for (j2 = 0; j2 < tables.size(); ++j2) {
            tm = (TableMetadata)tables.get(j2);
            ArrayList tableColumns = tm.getColumns();
            for (int k = 0; tableColumns != null && k < tableColumns.size(); ++k) {
                ColumnMetadata cm = (ColumnMetadata)tableColumns.get(k);
                if (cm == null) continue;
                cm.setTable(tm.getId());
                usedColumns.add(cm);
            }
        }
        PluginLogger.log("***** IOMIAccess.createCrossReferences(): removed " + (ETLObjects.instance().getColumns().size() - usedColumns.size()) + " unused columns, total column count is now " + usedColumns.size());
        ETLObjects.instance().setColumns(usedColumns);
        this.runGC();
        PluginLogger.log("***** IOMIAccess.createCrossReferences(): retrieving indexes");
        for (j2 = 0; j2 < tables.size(); ++j2) {
            tm = (TableMetadata)tables.get(j2);
            ArrayList<IndexMetadata> idx = new ArrayList<IndexMetadata>();
            String[] idxids = tm._getIndexIds();
            for (int i = 0; idxids != null && i < idxids.length; ++i) {
                IndexMetadata im = this.doRetrieveIndexes(idxids[i]);
                if (im == null) continue;
                idx.add(im);
            }
            if (idx.size() <= 0) continue;
            tm.setIndexes(idx);
        }
        ArrayList<LibraryMetadata> usedLibraries = new ArrayList<LibraryMetadata>();
        for (int j3 = 0; j3 < tables.size(); ++j3) {
            TableMetadata tm2 = (TableMetadata)tables.get(j3);
            LibraryMetadata lm = tm2.getTablepackage();
            if (lm == null) continue;
            lm.setTable(tm2.getId());
            if (usedLibraries.contains(lm)) continue;
            usedLibraries.add(lm);
        }
        PluginLogger.log("***** IOMIAccess.createCrossReferences(): removed " + (ETLObjects.instance().getLibraries().size() - usedLibraries.size()) + " unused libraries, total library count is now " + usedLibraries.size());
        ETLObjects.instance().setLibraries(usedLibraries);
        ArrayList<JobMetadata> usedJobs = new ArrayList<JobMetadata>();
        for (j = 0; j < tables.size(); ++j) {
            TableMetadata tm3 = (TableMetadata)tables.get(j);
            ArrayList jobSources = tm3.getJobsources();
            for (int i = 0; jobSources != null && i < jobSources.size(); ++i) {
                JobMetadata jm = (JobMetadata)jobSources.get(i);
                jm.setSourceTable(tm3.getId());
                if (usedJobs.contains(jm)) continue;
                usedJobs.add(jm);
            }
            ArrayList jobTargets = tm3.getJobtargets();
            for (int i = 0; jobTargets != null && i < jobTargets.size(); ++i) {
                JobMetadata jm = (JobMetadata)jobTargets.get(i);
                jm.setTargetTable(tm3.getId());
                if (usedJobs.contains(jm)) continue;
                usedJobs.add(jm);
            }
        }
        PluginLogger.log("***** IOMIAccess.createCrossReferences(): removed " + (ETLObjects.instance().getJobs().size() - usedJobs.size()) + " unused jobs, total job count is now " + usedJobs.size());
        ETLObjects.instance().setJobs(usedJobs);
        this.runGC();
        PluginLogger.log("***** IOMIAccess.createCrossReferences(): retrieving information maps and cubes");
        treeRegistry = new HashMap();
        for (j = 0; j < tables.size(); ++j) {
            String[] cubeids;
            TableMetadata tm4 = (TableMetadata)tables.get(j);
            String[] mapids = tm4._getInformationMapIds();
            if (mapids != null && mapids.length > 0) {
                ArrayList<InformationMapMetadata> maps = new ArrayList<InformationMapMetadata>();
                for (int i = 0; i < mapids.length; ++i) {
                    InformationMapMetadata imm = this.doRetrieveInformationMaps(mapids[i]);
                    if (imm == null) continue;
                    maps.add(imm);
                }
                if (maps != null && maps.size() > 0) {
                    this.doRetrieveMetadataTree(treeRegistry, maps);
                    tm4.setInformationMaps(maps);
                }
            }
            if ((cubeids = tm4._getCubeIds()) == null || cubeids.length <= 0) continue;
            ArrayList<CubeMetadata> cubes = new ArrayList<CubeMetadata>();
            for (int i = 0; i < cubeids.length; ++i) {
                CubeMetadata cmm = this.doRetrieveCubes(cubeids[i]);
                if (cmm == null) continue;
                cubes.add(cmm);
            }
            tm4.setCubes(cubes);
        }
        this.runGC();
        PluginLogger.log("***** IOMIAccess.createCrossReferences(): retrieving notes");
        this.doRetrieveNotes(ETLObjects.instance().getTables());
        this.doRetrieveNotes(ETLObjects.instance().getLibraries());
        this.doRetrieveNotes(ETLObjects.instance().getJobs());
        PluginLogger.log("***** IOMIAccess.createCrossReferences(): retrieving responsible parties");
        this.doRetrieveParties(ETLObjects.instance().getTables());
        this.doRetrieveParties(ETLObjects.instance().getLibraries());
        this.doRetrieveParties(ETLObjects.instance().getJobs());
        ETLObjects.instance().setTables(MetadataSort.instance().sortByName(ETLObjects.instance().getTables()));
        ETLObjects.instance().setJobs(MetadataSort.instance().sortByName(ETLObjects.instance().getJobs()));
        ETLObjects.instance().setLibraries(MetadataSort.instance().sortByName(ETLObjects.instance().getLibraries()));
        ETLObjects.instance().setColumns(MetadataSort.instance().sortByName(ETLObjects.instance().getColumns()));
        this.runGC();
        long now2 = new Date().getTime() - now;
        PluginLogger.log("***** IOMIAccess.createCrossReferences(): method execution took " + (double)now2 / 1000.0 + " secs");
    }

    public String getRepositoryInformation(String repos, String attr) {
        String s2;
        block3: {
            StringHolder stringholder = new StringHolder();
            String s1 = "<XMLSELECT search=\"@Name='" + repos + "'\"/>";
            int c = 392;
            s2 = "UNKNOWN";
            try {
                this.iomi.GetMetadataObjects("A0000001.A0000001", "RepositoryBase", stringholder, "REPOS", c, s1);
                String s3 = stringholder.value.toString();
                Document document = MetadataUtil.parseXML((String)s3);
                if (document == null) break block3;
                Node node = document.getFirstChild();
                NodeList nodelist = node.getChildNodes();
                for (int i = 0; i < nodelist.getLength(); ++i) {
                    Node node1 = nodelist.item(i);
                    NamedNodeMap namednodemap = node1.getAttributes();
                    if (namednodemap.getNamedItem(attr) == null) continue;
                    s2 = namednodemap.getNamedItem(attr).getNodeValue();
                    break;
                }
            }
            catch (Exception e) {
                PluginLogger.log("##### IOMIAccess.getRepositoryInformation(): error: " + PluginLogger.getStackTrace(e));
            }
        }
        return s2;
    }

    private IndexMetadata doRetrieveIndexes(String id) {
        for (CMetadata r : this.iomiConn.getRepositories()) {
            try {
                String xmlstr = bundle.messageString("JobDoc.xmlselect.index.txt.notrans", (Object)("'" + id + "'"));
                List idx = MetadataUtil.getMetadataObjectsSubset((IOMI)this.iomi, (MdStore)this.iomiConn.getObjectStore(), (String)r.getFQID(), (String)"Index", (int)388, (String)xmlstr, (boolean)false);
                if (idx == null || idx.size() == 0) {
                    return null;
                }
                Index i = (Index)idx.get(0);
                IndexMetadata im = new IndexMetadata((CMetadata)i);
                AssociationList cols = i.getColumns();
                if (cols != null) {
                    String[] colids = new String[cols.size()];
                    for (int j = 0; j < cols.size(); ++j) {
                        colids[j] = ((Column)cols.get(j)).getFQID();
                    }
                    im.setColumns(colids);
                }
                return im;
            }
            catch (Exception e) {
                PluginLogger.log("##### IOMIAccess.doRetrieveIndexes(): error: " + PluginLogger.getStackTrace(e));
            }
        }
        return null;
    }

    private void doRetrieveParties(ArrayList list) {
        for (int i = 0; i < list.size(); ++i) {
            BaseMetadata bm = (BaseMetadata)list.get(i);
            ArrayList<ResponsiblePartyMetadata> parties = new ArrayList<ResponsiblePartyMetadata>();
            for (int j = 0; bm._getResponsiblePartyIds() != null && j < bm._getResponsiblePartyIds().length; ++j) {
                for (CMetadata r : this.iomiConn.getRepositories()) {
                    try {
                        String xmlstr = bundle.messageString("JobDoc.xmlselect.responsibleparty.txt.notrans", (Object)("'" + bm._getResponsiblePartyIds()[j] + "'"));
                        List list2 = MetadataUtil.getMetadataObjectsSubset((IOMI)this.iomi, (MdStore)this.iomiConn.getObjectStore(), (String)r.getFQID(), (String)"ResponsibleParty", (int)388, (String)xmlstr, (boolean)false);
                        if (list2 == null || list2.size() == 0) continue;
                        for (int k = 0; k < list2.size(); ++k) {
                            ResponsibleParty rp = (ResponsibleParty)list2.get(k);
                            ResponsiblePartyMetadata rpm = new ResponsiblePartyMetadata((CMetadata)rp);
                            rpm.setRole(rp.getRole());
                            parties.add(rpm);
                        }
                    }
                    catch (Exception e) {
                        PluginLogger.log("##### IOMIAccess.doRetrieveNotes(): error: " + PluginLogger.getStackTrace(e));
                    }
                }
                if (parties.size() <= 0) continue;
                bm.setResponsibleParties(parties);
            }
        }
    }

    private void doRetrieveNotes(ArrayList list) {
        for (int i = 0; i < list.size(); ++i) {
            BaseMetadata bm = (BaseMetadata)list.get(i);
            ArrayList<NoteMetadata> notes = new ArrayList<NoteMetadata>();
            for (int j = 0; bm._getNoteIds() != null && j < bm._getNoteIds().length; ++j) {
                for (CMetadata r : this.iomiConn.getRepositories()) {
                    try {
                        TextStore ts;
                        String xmlstr = bundle.messageString("JobDoc.xmlselect.note.txt.notrans", (Object)("'" + bm._getNoteIds()[j] + "'"));
                        List list2 = MetadataUtil.getMetadataObjectsSubset((IOMI)this.iomi, (MdStore)this.iomiConn.getObjectStore(), (String)r.getFQID(), (String)"TextStore", (int)388, (String)xmlstr, (boolean)false);
                        if (list2 == null || list2.size() == 0 || (ts = (TextStore)list2.get(0)).getStoredText() == null || ts.getStoredText().length() <= 0) continue;
                        NoteMetadata nm = new NoteMetadata((CMetadata)ts);
                        nm.setStoredtext(ts.getStoredText());
                        notes.add(nm);
                    }
                    catch (Exception e) {
                        PluginLogger.log("##### IOMIAccess.doRetrieveNotes(): error: " + PluginLogger.getStackTrace(e));
                    }
                }
                if (notes.size() <= 0) continue;
                bm.setNotes(notes);
            }
        }
    }

    private CubeMetadata doRetrieveCubes(String id) {
        for (CMetadata r : this.iomiConn.getRepositories()) {
            try {
                String xmlstr = bundle.messageString("JobDoc.xmlselect.cube.txt.notrans", (Object)("'" + id + "'"));
                List cubes = MetadataUtil.getMetadataObjectsSubset((IOMI)this.iomi, (MdStore)this.iomiConn.getObjectStore(), (String)r.getFQID(), (String)"Cube", (int)388, (String)xmlstr, (boolean)false);
                if (cubes == null || cubes.size() == 0) {
                    return null;
                }
                Cube c = (Cube)cubes.get(0);
                CubeMetadata cmm = new CubeMetadata((CMetadata)c);
                AssociationList list = c.getAssociatedFiles();
                if (list == null || list.size() == 0) {
                    return cmm;
                }
                File f = (File)list.get(0);
                if ((list = f.getDirectories()) == null || list.size() == 0) {
                    return cmm;
                }
                Directory d = (Directory)list.get(0);
                cmm.setPath(d.getDirectoryName());
                return cmm;
            }
            catch (Exception e) {
                PluginLogger.log("##### IOMIAccess.doRetrieveCubes(): error: " + PluginLogger.getStackTrace(e));
            }
        }
        return null;
    }

    private InformationMapMetadata doRetrieveInformationMaps(String id) {
        for (CMetadata r : this.iomiConn.getRepositories()) {
            try {
                String xmlstr = bundle.messageString("JobDoc.xmlselect.informationmap.txt.notrans", (Object)("'" + id + "'"));
                List maps = MetadataUtil.getMetadataObjectsSubset((IOMI)this.iomi, (MdStore)this.iomiConn.getObjectStore(), (String)r.getFQID(), (String)"Transformation", (int)388, (String)xmlstr, (boolean)false);
                if (maps == null || maps.size() == 0) {
                    return null;
                }
                Transformation t = (Transformation)maps.get(0);
                return new InformationMapMetadata((CMetadata)t);
            }
            catch (Exception e) {
                PluginLogger.log("##### IOMIAccess.doRetrieveInformationMaps(): error: " + PluginLogger.getStackTrace(e));
            }
        }
        return null;
    }

    private void doRetrieveMetadataTree(HashMap treeRegistry, ArrayList list) {
        for (int i = 0; list != null && i < list.size(); ++i) {
            BaseMetadata bm = (BaseMetadata)list.get(i);
            if (bm._getTreeId() == null || bm._getTreeId().length() == 0) continue;
            if (!treeRegistry.containsKey(bm._getTreeId())) {
                for (CMetadata r : this.iomiConn.getRepositories()) {
                    try {
                        String xmlstr = bundle.messageString("JobDoc.xmlselect.tree.txt.notrans", (Object)("'" + bm._getTreeId() + "'"));
                        List trees = MetadataUtil.getMetadataObjectsSubset((IOMI)this.iomi, (MdStore)this.iomiConn.getObjectStore(), (String)r.getFQID(), (String)"Tree", (int)388, (String)xmlstr, (boolean)false);
                        if (trees == null || trees.size() == 0) continue;
                        String treepath = this.doAppendTreePath("", (Tree)trees.get(0));
                        treeRegistry.put(bm._getTreeId(), treepath);
                    }
                    catch (Exception e) {
                        PluginLogger.log("##### IOMIAccess.retrieveMetadataTree(): error: " + PluginLogger.getStackTrace(e));
                    }
                }
            }
            if (treeRegistry.containsKey(bm._getTreeId())) {
                bm.setTree((String)treeRegistry.get(bm._getTreeId()));
                continue;
            }
            PluginLogger.log("##### IOMIAccess.retrieveMetadataTree(): no luck searching for: " + bm._getTreeId());
        }
    }

    private void doExtractMetadata(CMetadata repos, String xmlstr, String mdType) {
        try {
            List list = MetadataUtil.getMetadataObjectsSubset((IOMI)this.iomi, (MdStore)this.iomiConn.getObjectStore(), (String)repos.getFQID(), (String)mdType, (int)388, (String)xmlstr, (boolean)false);
            for (CMetadata cm : list) {
                if (cm instanceof Job) {
                    JobMetadata jm = new JobMetadata(cm);
                    ETLObjects.instance().addJob(jm);
                    continue;
                }
                if (cm instanceof DataTable) {
                    TableMetadata tm = new TableMetadata(cm);
                    if (!tm.isInUse() && !GlobalProperties.instance().isIncludeall()) continue;
                    ETLObjects.instance().addTable(tm);
                    continue;
                }
                if (cm instanceof SASLibrary) {
                    LibraryMetadata lm = new LibraryMetadata(cm);
                    ETLObjects.instance().addLibrary(lm);
                    continue;
                }
                if (!(cm instanceof Column)) continue;
                ColumnMetadata com = new ColumnMetadata(cm);
                ETLObjects.instance().addColumn(com);
            }
            PluginLogger.log("***** IOMIAccess.extractMetadata(): retrieved " + list.size() + " definitions of type " + mdType);
            this.runGC();
        }
        catch (MdException e) {
            PluginLogger.log("##### IOMIAccess.doExtractMetadata(): error: " + PluginLogger.getStackTrace(e));
        }
    }

    private String doAppendTreePath(String treepath, Tree tree) throws Exception {
        if (tree.getParentTree() != null) {
            Workspace.getDefaultLogger().debug((Object)("tree: " + tree.getName()));
            treepath = treepath + this.doAppendTreePath(treepath, tree.getParentTree());
        }
        treepath = treepath + "/" + tree.getName();
        Workspace.getDefaultLogger().debug((Object)("treepath : " + treepath));
        return treepath;
    }

    private void runGC() {
        long mem0 = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L;
        System.gc();
        long mem1 = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L;
        PluginLogger.log("***** IOMIAccess.runGC(): memory usage before: " + mem0 / 1024L + "M, now: " + mem1 / 1024L + "M, difference: " + (mem1 - mem0) + "KB");
    }
}

