/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.reports;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.reports.ReportingController;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsServerRequest;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.LinkedHashMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ODSOptionsPanel
extends WAPanel {
    private static final WAdminResource bundle = WAdminResource.getBundle(ODSOptionsPanel.class);
    private static final String StyleNameKey = "Reporting.ODSOptionsPanel.Style";
    private WAComboBox m_cbODSFormat;
    private WATextField m_txtStylePath;
    private WATextField m_txtAddOptions;
    private JButton m_btnBrowse;
    private WsAbstractAction m_actBrowse;
    private ReportingController m_controller;
    private static String[][] m_ODSList = new String[][]{{bundle.getString("ODSOptionsPanel.HTML.txt"), "html"}, {bundle.getString("ODSOptionsPanel.RTF.txt"), "rtf"}, {bundle.getString("ODSOptionsPanel.PDF.txt"), "pdf"}};

    public ODSOptionsPanel(ReportingController controller) {
        this.m_controller = controller;
        this.setHelpTopic("report_options");
        this.initialize();
    }

    protected void initialize() {
        this.m_cbODSFormat = new WAComboBox();
        this.m_cbODSFormat.setEditable(false);
        this.m_cbODSFormat.setToolTipText(bundle.getString("ODSOptionsPanel.ODSFormat.tip"));
        JLabel lblODSFormat = WsUIUtilities.createLabelForComponent((JComponent)this.m_cbODSFormat, (String)bundle.getString("ODSOptionsPanel.ODSFormat.txt"));
        this.loadShowItems();
        this.m_cbODSFormat.addActionListener((ActionListener)new FormatListener());
        this.m_txtStylePath = new WATextField(30);
        this.m_txtStylePath.setEditable(true);
        this.m_txtStylePath.setToolTipText(bundle.getString("ODSOptionsPanel.ODSStyle.tip"));
        JLabel lblStylePath = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtStylePath, (String)bundle.getString("ODSOptionsPanel.ODSStyle.txt"));
        this.m_actBrowse = new BrowseAction();
        this.m_btnBrowse = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actBrowse);
        this.m_txtAddOptions = new WATextField();
        this.m_txtAddOptions.setEditable(true);
        this.m_txtAddOptions.setToolTipText(bundle.getString("ODSOptionsPanel.ODSOptions.tip"));
        JLabel lblAddOptions = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtAddOptions, (String)bundle.getString("ODSOptionsPanel.ODSOptions.txt"));
        this.setLayout(new GridBagLayout());
        this.add(lblODSFormat, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.m_cbODSFormat, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add(lblStylePath, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.m_txtStylePath, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add(this.m_btnBrowse, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add(lblAddOptions, new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.m_txtAddOptions, new GridBagConstraints(0, 3, 4, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        String lastStyleUsed = Workspace.getWorkspace().getAppDefaultsFile().getPropertyString(StyleNameKey);
        if (this.m_txtStylePath.getText().length() == 0) {
            this.m_txtStylePath.setText(lastStyleUsed);
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.setDataChanged(false);
    }

    public boolean validateData() {
        return true;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.updateActions();
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actBrowse.setActive(bActive);
    }

    public void saveSettingsAndCleanUp() {
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyString(StyleNameKey, this.m_txtStylePath.getText());
    }

    public String getODSFormat() {
        String sSelected = (String)this.m_cbODSFormat.getSelectedItem();
        sSelected = this.translateSpecialTypes(sSelected);
        return sSelected;
    }

    public void setODSFormat(String odsFormat) {
        for (int i = 0; i < m_ODSList.length; ++i) {
            if (!odsFormat.equals(m_ODSList[i][1])) continue;
            this.m_cbODSFormat.setSelectedIndex(i);
            return;
        }
        this.m_cbODSFormat.setSelectedIndex(0);
    }

    public String getODSStyle() {
        return this.m_txtStylePath.getText();
    }

    public void setODSStyle(String cssFileName) {
        this.m_txtStylePath.setText(cssFileName);
    }

    public String getODSOptions() {
        return this.m_txtAddOptions.getText();
    }

    public void setODSOptions(String options) {
        this.m_txtAddOptions.setText(options);
    }

    protected void updateActions() {
        this.m_actBrowse.setEnabled(this.isEditable());
    }

    private void loadShowItems() {
        this.m_cbODSFormat.addItem((Object)m_ODSList[0][0]);
        this.m_cbODSFormat.addItem((Object)m_ODSList[1][0]);
        this.m_cbODSFormat.addItem((Object)m_ODSList[2][0]);
    }

    private void displayRemoteFileSelector() {
        try {
            WsServerRequest svrRequest = this.m_controller.getServerRequest();
            svrRequest.setWsAppServer(null);
            WsAppServer appServer = svrRequest.getAppServer();
            if (appServer == null) {
                return;
            }
            String strOS = appServer.getOperatingSystem();
            if (strOS.equalsIgnoreCase("OS")) {
                MessageUtil.displayMessage((String)bundle.getString("ODSOptionsPanel.Error.UnableToBrowse.txt"), (int)0);
                return;
            }
            LinkedHashMap<String, String> mapFileTypes = new LinkedHashMap<String, String>();
            mapFileTypes.put(bundle.getString("ODSOptionsPanel.CSSFileTypes.txt"), "css");
            mapFileTypes.put(bundle.getString("ODSOptionsPanel.AllFileTypes.txt"), "*");
            String sCSSPath = this.m_txtStylePath.getText();
            sCSSPath = sCSSPath != null ? sCSSPath.trim() : "";
            String newCSSPath = appServer.promptForFilename(bundle.getString("ODSOptionsPanel.RemoteFileSelector.Title.txt"), sCSSPath, mapFileTypes);
            if (newCSSPath != null) {
                this.m_txtStylePath.setText(newCSSPath);
            }
            appServer.close();
        }
        catch (WsAppServerFailException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        catch (GenericError ge) {
            MessageUtil.displayMessage((String)ge.getLocalizedMessage(), (int)0);
        }
    }

    private String translateSpecialTypes(String type) {
        for (int i = 0; i < m_ODSList.length; ++i) {
            if (!type.equals(m_ODSList[i][0])) continue;
            return m_ODSList[i][1];
        }
        return type;
    }

    private class FormatListener
    implements ActionListener {
        private FormatListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String sFormat = (String)ODSOptionsPanel.this.m_cbODSFormat.getSelectedItem();
            if ((sFormat = ODSOptionsPanel.this.translateSpecialTypes(sFormat)).equals("html")) {
                ODSOptionsPanel.this.m_txtStylePath.setEnabled(true);
                ODSOptionsPanel.this.m_actBrowse.setEnabled(true);
            } else {
                ODSOptionsPanel.this.m_txtStylePath.setEnabled(false);
                ODSOptionsPanel.this.m_actBrowse.setEnabled(false);
            }
        }
    }

    private class BrowseAction
    extends WsAbstractAction {
        public BrowseAction() {
            super(bundle, "ODSOptionsPanel.Action.Browse", 0);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                ODSOptionsPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                ODSOptionsPanel.this.displayRemoteFileSelector();
            }
            finally {
                ODSOptionsPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }
}

