/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.prompts.visuals;

import com.sas.etl.models.prompts.impl.PromptUtils;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.remote.MdException;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.definitions.PromptDefinition;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.prompts.groups.PromptGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.information.metadata.prompt.PersistenceFactoryWithServices;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.valueprovider.StaticValueProvider;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.util.LocalizableString;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.fs.ServicesLogFactory;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsReadingContext;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.prefs.BackingStoreException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class PromptXMLDialog
extends WAPropertyDialog {
    private static final WAdminResource bundle = WAdminResource.getBundle(PromptXMLDialog.class);
    private static final String XML = "xml";
    private PromptGroupInterface m_promptGroup;
    private final String encoding = "UTF-8";
    private static final String FILE_KEY = "PromptXMLDialog.LastFileSaved";

    public PromptXMLDialog(boolean export) {
        super((Frame)Workspace.getWorkspace(), true);
        if (export) {
            this.setTitle(bundle.getString("PromptXMLDialog.Export.Title.txt"));
        } else {
            this.setTitle(bundle.getString("PromptXMLDialog.Import.Title.txt"));
        }
        this.setHelpProduct("wdb");
        this.setHelpTopic("");
        super.setEditable(true);
        PromptXMLTab panel = new PromptXMLTab(export);
        this.setMainPanel((WAPanel)panel);
    }

    public void setPromptGroup(PromptGroupInterface group) {
        this.m_promptGroup = group;
    }

    public PromptGroupInterface getPromptGroup() {
        return this.m_promptGroup;
    }

    public class PromptXMLTab
    extends WAPropertyTab {
        private WAdminResource bundle2 = WAdminResource.getBundle(PromptXMLTab.class);
        private JLabel m_lblFilename;
        private WATextField m_tfFilename;
        private JButton m_btnExportBrowse;
        private boolean m_export = true;

        public PromptXMLTab(boolean export) {
            this.m_export = export;
            this.initialize();
            this.layoutWidgets();
        }

        protected void initialize() {
            this.m_tfFilename = new WATextField();
            this.m_lblFilename = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_tfFilename, (WAdminResource)this.bundle2, (String)"PromptXMLDialog.Filename");
            this.m_lblFilename.setLabelFor((Component)this.m_tfFilename);
            this.m_btnExportBrowse = WsUIUtilities.createTextButton((WsAbstractAction)new cBrowseAction());
        }

        protected void layoutWidgets() {
            this.setLayout(new GridBagLayout());
            this.add(this.m_lblFilename, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.add((Component)this.m_tfFilename, new GridBagConstraints(1, 0, 4, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 350, 0));
            this.add(this.m_btnExportBrowse, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        }

        public void populateStore() throws MdException, RemoteException {
            if (this.isStorePopulated()) {
                return;
            }
            this.setStorePopulated(true);
        }

        public void moveDataToView() throws MdException, RemoteException {
            this.setListeningForChanges(false);
            this.m_tfFilename.setText(Workspace.getWorkspace().getAppDefaultsFile().getPropertyString(PromptXMLDialog.FILE_KEY, ""));
            this.setListeningForChanges(true);
        }

        private void fixBooleanPrompts(PromptGroup promptGroup) {
            List definitions = promptGroup.getPromptDefinitions(true);
            for (int i = 0; i < definitions.size(); ++i) {
                PromptDefinition def = (PromptDefinition)definitions.get(i);
                if (!def.getUserInfo().contains("Boolean Type")) continue;
                String defValue = (String)def.getDefaultValue();
                if (defValue != null) {
                    def.setDefaultValue((Object)defValue.toUpperCase());
                }
                def.removeUserInfo("Boolean Type");
            }
        }

        private void removeNonEnglish(Object prompt, Locale locale) {
            if (prompt instanceof PromptGroup) {
                PromptGroup pGroup = (PromptGroup)prompt;
                LocalizableString desc = pGroup.getPromptGroupDescriptions();
                desc.clearText(locale);
                pGroup.setPromptGroupDescriptions(desc);
                LocalizableString labels = pGroup.getPromptGroupLabels();
                labels.clearText(locale);
                pGroup.setPromptGroupLabels(labels);
                List subs = pGroup.getPromptDefinitionsAndSubgroups(null, true, true, true);
                for (int j = 0; j < subs.size(); ++j) {
                    this.removeNonEnglish(subs.get(j), locale);
                }
            } else if (prompt instanceof PromptDefinition) {
                StaticValueProvider svp;
                ValueProviderDefinitionInterface vpDef;
                ValueProviderInterface vp;
                PromptDefinition pDef = (PromptDefinition)prompt;
                LocalizableString desc = pDef.getPromptDescriptions();
                desc.clearText(locale);
                pDef.setPromptDescriptions(desc);
                LocalizableString labels = pDef.getPromptLabels();
                labels.clearText(locale);
                pDef.setPromptLabels(labels);
                if (pDef instanceof ValueProviderDefinitionInterface && (vp = (vpDef = (ValueProviderDefinitionInterface)pDef).getValueProvider()) instanceof StaticValueProvider && (svp = (StaticValueProvider)vp).getLocales().contains(locale)) {
                    svp.setValues(new ArrayList(), locale);
                }
            }
        }

        public void moveDataToStore() throws MdException, RemoteException {
            OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace());
            request.setDelayBeforeProgressCancelDialog(200);
            Workspace.getWorkspace().getAppDefaultsFile().setPropertyString(PromptXMLDialog.FILE_KEY, this.m_tfFilename.getText());
            if (this.m_export) {
                request.setTitle(bundle.getString("PromptXMLDialog.ExportProgress.Title.txt"));
                Runnable runExport = new Runnable(){

                    @Override
                    public void run() {
                        PromptGroup pGroup = (PromptGroup)PromptUtils.copyPromptGroup((UserContextInterface)Workspace.getWorkspace().getUserContext(), (PromptGroupInterface)PromptXMLDialog.this.m_promptGroup);
                        PromptXMLTab.this.fixBooleanPrompts(pGroup);
                        StringBuffer strXML = null;
                        try {
                            strXML = PromptUtils.getXMLForObject((PersistenceInterface)pGroup, null);
                        }
                        catch (ParserConfigurationException exc) {
                            MessageUtil.displayMessage((String)exc.getLocalizedMessage(), (int)0);
                        }
                        catch (BackingStoreException exc) {
                            MessageUtil.displayMessage((String)exc.getLocalizedMessage(), (int)0);
                        }
                        if (strXML == null || strXML.length() <= 0) {
                            return;
                        }
                        try {
                            FileOutputStream file = new FileOutputStream(PromptXMLTab.this.m_tfFilename.getText());
                            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)file, "UTF-8");
                            writer.write(strXML.toString(), 0, strXML.length());
                            writer.close();
                            file.close();
                        }
                        catch (IOException exc) {
                            MessageUtil.displayMessage((String)exc.getLocalizedMessage(), (int)0);
                        }
                    }
                };
                request.execute(runExport);
            } else {
                request.setTitle(bundle.getString("PromptXMLDialog.ImportProgress.Title.txt"));
                Runnable runImport = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            FileInputStream file = new FileInputStream(PromptXMLTab.this.m_tfFilename.getText());
                            PromptsReadingContext rc = PersistenceFactoryWithServices.newReadingContext((UserContextInterface)UtilPlatformServices.getUserContext());
                            ServicesLogFactory logFactory = new ServicesLogFactory(UtilPlatformServices.getSessionContext());
                            BufferedReader bis = new BufferedReader(new InputStreamReader((InputStream)file, "UTF-8"));
                            PromptXMLDialog.this.m_promptGroup = (PromptGroupInterface)PromptUtil.newObjectFromXML((Reader)bis, (LoggerFactoryInterface)logFactory, (PromptsReadingContext)rc);
                        }
                        catch (ParserConfigurationException exc) {
                            MessageUtil.displayMessage((String)exc.getLocalizedMessage(), (int)0);
                        }
                        catch (SAXException exc) {
                            MessageUtil.displayMessage((String)exc.getLocalizedMessage(), (int)0);
                        }
                        catch (IOException exc) {
                            MessageUtil.displayMessage((String)exc.getLocalizedMessage(), (int)0);
                        }
                    }
                };
                request.execute(runImport);
            }
        }

        public boolean validateData() {
            return this.isValidFileName(this.m_tfFilename.getText());
        }

        private String getExtension(File f) {
            return this.getExtension(f.getName());
        }

        private String getExtension(String filename) {
            String ext = null;
            int i = filename.lastIndexOf(46);
            if (i > 0 && i < filename.length() - 1) {
                ext = filename.substring(i + 1).toLowerCase();
            }
            return ext;
        }

        protected boolean isValidFileName(String sFileName) {
            File file = new File(sFileName);
            if (this.m_export) {
                if (file.exists()) {
                    String sMessage = this.bundle2.formatString("PromptXMLDialog.ExportFileExistsWarning.fmt.txt", (Object)sFileName);
                    int eAnswer = MessageUtil.displayMessage((String)sMessage, (int)2, (int)0);
                    if (eAnswer != 0) {
                        return false;
                    }
                } else {
                    try {
                        file.createNewFile();
                        file.delete();
                    }
                    catch (IOException e) {
                        String sMessage = this.bundle2.formatString("PromptXMLDialog.UnableToCreateFileError.fmt.txt", (Object)sFileName);
                        MessageUtil.displayMessage((String)sMessage, (int)0);
                        return false;
                    }
                }
            } else if (!file.exists()) {
                String sMessage = this.bundle2.formatString("PromptXMLDialog.UnableToCreateFileError.fmt.txt", (Object)sFileName);
                MessageUtil.displayMessage((String)sMessage, (int)0, (int)-1);
                return false;
            }
            return true;
        }

        protected class cBrowseAction
        extends WsAbstractAction {
            public cBrowseAction() {
                super(PromptXMLTab.this.bundle2, "PromptXMLDialog.Browse", false, false);
            }

            public void actionPerformed(ActionEvent e) {
                File exportDirectory = new File(PromptXMLTab.this.m_tfFilename.getText()).getParentFile();
                JFileChooser chooser = new JFileChooser(exportDirectory != null ? exportDirectory.getPath() : "");
                if (PromptXMLTab.this.m_export) {
                    chooser.setDialogType(1);
                    chooser.setDialogTitle(PromptXMLTab.this.bundle2.getString("PromptXMLDialog.Browse.Export.Title.txt"));
                } else {
                    chooser.setDialogType(0);
                    chooser.setDialogTitle(PromptXMLTab.this.bundle2.getString("PromptXMLDialog.Browse.Import.Title.txt"));
                }
                chooser.setFileSelectionMode(0);
                chooser.setFileFilter(new XMLFileFilter());
                int eReturn = chooser.showSaveDialog((Component)Workspace.getWorkspace());
                if (eReturn == 0) {
                    String filepath = chooser.getSelectedFile().getPath();
                    if (PromptXMLTab.this.getExtension(filepath) == null) {
                        filepath = filepath + "." + PromptXMLDialog.XML;
                    }
                    PromptXMLTab.this.m_tfFilename.setText(filepath);
                }
            }
        }

        private class XMLFileFilter
        extends FileFilter {
            private XMLFileFilter() {
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = PromptXMLTab.this.getExtension(f);
                return extension != null && extension.equalsIgnoreCase(PromptXMLDialog.XML);
            }

            @Override
            public String getDescription() {
                return PromptXMLTab.this.bundle2.getString("PromptXMLDialog.xmlfiles.txt");
            }
        }
    }
}

