/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.prompts.conversion;

import com.sas.entities.AttributeDescriptorInterface;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerContext;
import com.sas.rio.MVAResultSet;
import com.sas.wadmin.prompts.conversion.EntityObjectHandler;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;

public class EntityLookupHandler
extends EntityObjectHandler {
    private String[] m_strColumnPath;
    private int m_maxObservations;
    private List m_validValues = new ArrayList();
    private static WAdminResource bundle = WAdminResource.getBundle(EntityLookupHandler.class);
    private MdObjectStore m_store;
    private String m_defaultRepositoryId;

    public EntityLookupHandler(String defaultRepositoryId, MdFactory factory, AttributeDescriptorInterface attributeDescriptor, MdObjectStore store) throws MdException, RemoteException {
        super(factory, attributeDescriptor, null);
        this.m_defaultRepositoryId = defaultRepositoryId;
        this.m_store = store;
        this.setupHandler();
    }

    @Override
    protected void setupHandler() {
        String m_strLimit;
        super.setupHandler();
        Node node = MacroPluginUtilities.getNodeForTag(this.m_docConfig, "LookupColumn");
        this.m_strColumnPath = MacroPluginUtilities.getValueForNode(node).split("\\.");
        this.m_maxObservations = -1;
        node = MacroPluginUtilities.getNodeForTag(this.m_docConfig, "LimitObservations");
        if (node != null && (m_strLimit = MacroPluginUtilities.getValueForNode(node)) != null && m_strLimit.length() > 0) {
            this.m_maxObservations = Integer.parseInt(m_strLimit);
        }
        node = MacroPluginUtilities.getNodeForTag(this.m_docConfig, "SelectDistinct");
    }

    public int getMaximumObservations() {
        return this.m_maxObservations;
    }

    public String[] getColumnPath() {
        return this.m_strColumnPath;
    }

    public Column getColumnObject() throws MdException, RemoteException {
        return MacroPluginUtilities.findColumn(this.m_defaultRepositoryId, this.m_strColumnPath, this.m_store);
    }

    @Override
    public List getValidValues() {
        this.m_validValues.clear();
        WsAppServer appServer = WsAppServer.createDefaultAppServer();
        try {
            appServer.open();
        }
        catch (WsAppServerFailException exc) {
            MessageUtil.displayMessage((String)exc.getMessage(), (int)0);
            return this.m_validValues;
        }
        StringBuffer strSQL = new StringBuffer();
        String colPath = "";
        for (int i = 0; i < this.m_strColumnPath.length; ++i) {
            colPath = colPath + this.m_strColumnPath[i].trim() + '.';
        }
        colPath = colPath.substring(0, colPath.length() - 1);
        try {
            SASLibrary lib = MacroPluginUtilities.findLibrary(this.m_defaultRepositoryId, this.m_strColumnPath[0], this.m_store);
            StringBuffer strSetup = new StringBuffer();
            SASCodeGeneration codeGen = new SASCodeGeneration();
            strSetup.append(codeGen.getReturnCodeSetup());
            strSetup.append(LibraryUtil.accessPath((SASLibrary)lib, (ServerContext)appServer.getServerContext()));
            Column col = MacroPluginUtilities.findColumn(this.m_defaultRepositoryId, this.m_strColumnPath, this.m_store);
            if (col == null) {
                MessageUtil.displayMessage((String)bundle.formatString("MacroUserOptionsTable.LookupColumnNotFound.msg.txt", (Object)colPath), (int)0);
                return this.m_validValues;
            }
            PhysicalTable pTable = (PhysicalTable)col.getTable();
            String tableName = DBMSNamesUtil.getQuotedString((String)pTable.getSASTableName(), (DataTable)pTable, (boolean)false);
            String columnName = DBMSNamesUtil.getQuotedString((String)col.getSASColumnName(), (DataTable)pTable, (boolean)false);
            String libTableName = lib.getLibref() + '.' + tableName;
            try {
                appServer.submitSASCode(strSetup.toString());
            }
            catch (WsAppServerCodeException exc) {
                MessageUtil.displayMessage((String)exc.getMessage(), (int)0);
                return this.m_validValues;
            }
            catch (WsAppServerFailException exc) {
                MessageUtil.displayMessage((String)exc.getMessage(), (int)0);
                return this.m_validValues;
            }
            strSQL.append("select distinct ");
            strSQL.append(columnName);
            strSQL.append(" from ");
            strSQL.append(libTableName);
            strSQL.append("(keep=");
            strSQL.append(columnName);
            if (this.m_maxObservations > -1) {
                strSQL.append(" obs=" + String.valueOf(this.m_maxObservations) + " ");
            }
            strSQL.append(")");
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            return this.m_validValues;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        try {
            MVAResultSet resultSet = appServer.submitSQLStatement(strSQL.toString());
            while (resultSet.next()) {
                Object val = resultSet.getObject(1);
                if (val == null) continue;
                this.m_validValues.add(val.toString().trim());
            }
            resultSet.close();
            appServer.dispose();
            if (this.m_validValues.isEmpty()) {
                MessageUtil.displayMessage((String)bundle.formatString("MacroUserOptionsTable.NoLookupValuesNotFound.msg.txt", (Object)colPath), (int)2);
            }
        }
        catch (SQLException exc) {
            MessageUtil.displayMessage((String)bundle.formatString("MacroUserOptionsTable.LookupValuesNotFound.msg.txt", (Object)colPath), (int)0);
            return this.m_validValues;
        }
        catch (WsAppServerFailException exc) {
            MessageUtil.displayMessage((String)(bundle.formatString("MacroUserOptionsTable.LookupFailed.msg.txt", (Object)colPath) + "\n" + exc.getMessage()), (int)0);
            return this.m_validValues;
        }
        return this.m_validValues;
    }

    @Override
    public String getDefaultValue() {
        if (!this.m_validValues.isEmpty()) {
            return this.m_validValues.get(0).toString();
        }
        return "";
    }

    @Override
    public String validateInputValue(Object inputValue) {
        String strValid = null;
        if (!this.m_validValues.isEmpty() && !this.m_validValues.contains(inputValue)) {
            strValid = bundle.formatString("MacroUserOptionsTable.ValidValueNotFound.Error.txt", (Object)inputValue.toString());
        }
        return strValid;
    }
}

