/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.prompts.conversion;

import com.sas.entities.AttributeDescriptorInterface;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.wadmin.prompts.conversion.EntityObjectHandler;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.List;
import org.w3c.dom.NamedNodeMap;

public class EntityIntegerHandler
extends EntityObjectHandler {
    private static WAdminResource bundle = WAdminResource.getBundle(EntityIntegerHandler.class);
    private int m_minValue;
    private int m_maxValue;

    public EntityIntegerHandler(MdFactory factory, AttributeDescriptorInterface attributeDescriptor) throws MdException, RemoteException {
        super(factory, attributeDescriptor, "Integer");
    }

    @Override
    public void setupHandler() {
        super.setupHandler();
        if (this.m_docConfig != null) {
            NamedNodeMap rangeNodeMap = MacroPluginUtilities.getNodeForTag(this.m_docConfig, "IntegerRange").getAttributes();
            String strLength = rangeNodeMap.getNamedItem("min").getNodeValue();
            this.m_minValue = strLength != null && strLength.length() > 0 ? Integer.parseInt(strLength) : Integer.MIN_VALUE;
            strLength = rangeNodeMap.getNamedItem("max").getNodeValue();
            this.m_maxValue = strLength != null && strLength.length() > 0 ? Integer.parseInt(strLength) : Integer.MAX_VALUE;
        }
    }

    @Override
    public List getValidValues() {
        return null;
    }

    public int getMinimumValue() {
        return this.m_minValue;
    }

    public int getMaximumValue() {
        return this.m_maxValue;
    }

    @Override
    public String validateInputValue(Object inputValue) {
        String strValid = super.validateInputValue(inputValue);
        if (strValid == null && inputValue.toString().length() > 0) {
            try {
                int inValue = Integer.parseInt(inputValue.toString());
                if (inValue < this.m_minValue) {
                    strValid = bundle.formatString("MacroUserOptionsTable.OptionMinimum.msg.txt", (Object)"{0}", (Object)new Integer(this.m_minValue));
                }
                if (inValue > this.m_maxValue) {
                    strValid = bundle.formatString("MacroUserOptionsTable.OptionMaximum.msg.txt", (Object)"{0}", (Object)new Integer(this.m_maxValue));
                }
            }
            catch (NumberFormatException exc) {
                strValid = "NaN";
            }
        }
        return strValid;
    }
}

