/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.pfd;

import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Classifier;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.pfd.MappingUtil;
import com.sas.wadmin.pfd.PFDException;
import com.sas.wadmin.pfd.PFDPanel;
import com.sas.wadmin.pfd.WAPFDLink;
import com.sas.wadmin.pfd.WAPFDNodeInterface;
import com.sas.wadmin.pfd.WAPFDTableNode;
import com.sas.wadmin.pfd.WAPFDTableNodeModel;
import com.sas.wadmin.pfd.WAPFDTemplateNode;
import com.sas.wadmin.pfd.WAPFDTemplateNodeModel;
import com.sas.wadmin.pfd.WAPFDTransformLoaderNode;
import com.sas.wadmin.pfd.WAPFDTransformNode;
import com.sas.wadmin.pfd.WAPFDTransformNodeModel;
import com.sas.wadmin.pfd.WAPFDWorkTableNode;
import com.sas.wadmin.pfd.WAPFDWorkTableNodeModel;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.workspace.Workspace;
import java.awt.Point;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;

public class WAPFDTransformLoaderNodeModel
extends WAPFDTransformNodeModel {
    public WAPFDTransformLoaderNodeModel(PFDPanel parentPanel, CMetadata object) {
        super(parentPanel, object);
    }

    public WAPFDTransformLoaderNodeModel(PFDPanel parentPanel) {
        super(parentPanel, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void handleLocation(MdObjectStore newStore, PFDPrimitive primLogicalLocation, ArrayList affectedObjects) throws MdException, RemoteException, PFDException {
        TransformationStep thisStep = (TransformationStep)this.getMetadataObject(newStore);
        switch (this.getintLogicalLocation(primLogicalLocation)) {
            case 0: {
                this.updateTemplateVisual(thisStep);
                return;
            }
            case 4: {
                WAPFDTemplateNode templateNode = (WAPFDTemplateNode)primLogicalLocation;
                WAPFDTemplateNodeModel templateModel = (WAPFDTemplateNodeModel)templateNode.getWAPFDNodeModel();
                if (templateModel.getTemplateType(newStore) == 0) {
                    this.m_parentPanel.updateView();
                    throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
                }
                super.handleLocation(newStore, primLogicalLocation, affectedObjects);
                return;
            }
            case 1: {
                if (primLogicalLocation instanceof WAPFDTableNode || primLogicalLocation instanceof WAPFDTransformLoaderNode) {
                    this.m_parentPanel.updateView();
                    throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
                }
                WAPFDTransformNodeModel transformNodeModel = (WAPFDTransformNodeModel)((WAPFDTransformNode)primLogicalLocation).getWAPFDNodeModel();
                if (transformNodeModel.fNodeHasSpace(newStore, 0)) {
                    this.m_parentPanel.updateView();
                    throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
                }
                if (!transformNodeModel.fNodeHasSpace(newStore, 1)) {
                    this.m_parentPanel.updateView();
                    throw new PFDException("PFDEXCEPTION.NOSPACEONTRANSFORM.txt");
                }
                this.connectNodeMetadata(newStore, (WAPFDTransformNode)primLogicalLocation, this.getViewNode(), affectedObjects);
                new WAPFDLink(transformNodeModel.getViewNode(), this.getViewNode(), this.m_parentPanel);
                this.updateTemplateVisual(thisStep);
                DataTable targetTable = (DataTable)((ClassifierMap)thisStep.getTransformations().elementAt(0)).getClassifierTargets(false).elementAt(0);
                MappingUtil.doAutomaticMappings(targetTable);
                return;
            }
            case 2: {
                WAPFDLink existingLink = (WAPFDLink)primLogicalLocation;
                if (!existingLink.isValidMetadataDropLocation()) {
                    this.m_parentPanel.updateView();
                    throw new PFDException("PFDEXCEPTION.CANNOTDROPTRANSFORMONLINK.txt");
                }
                WAPFDNodeInterface fromNode = existingLink.getWAFromNode();
                WAPFDNodeInterface toNode = existingLink.getWAToNode();
                affectedObjects.add(fromNode.getWAPFDNodeModel().getMetadataObject(newStore));
                affectedObjects.add(toNode.getWAPFDNodeModel().getMetadataObject(newStore));
                if (!(toNode instanceof WAPFDTableNode)) return;
                TransformationStep nextDataStepAfterComputeStep = null;
                WAPFDTableNodeModel toNodeModel = (WAPFDTableNodeModel)toNode.getWAPFDNodeModel();
                ArrayList cmsToConnectTo = new ArrayList();
                TransformationStep fromStep = (TransformationStep)fromNode.getWAPFDNodeModel().getMetadataObject(newStore);
                nextDataStepAfterComputeStep = this.findNextDataStep(fromStep, false);
                if (nextDataStepAfterComputeStep != null && nextDataStepAfterComputeStep.getFQID().equalsIgnoreCase(fromStep.getFQID())) {
                    nextDataStepAfterComputeStep = null;
                }
                thisStep = (TransformationStep)this.getMetadataObject(newStore);
                toNodeModel.disconnectNodeMetadata(newStore, fromNode, toNode, cmsToConnectTo, true);
                existingLink.disconnectLink();
                ArrayList temp = new ArrayList();
                this.connectNodeMetadata(newStore, fromNode, this.getViewNode(), temp);
                ((WAPFDTransformNodeModel)fromNode.getWAPFDNodeModel()).addWorkTableNodes(fromStep);
                this.deleteTransformWorkTables(thisStep, affectedObjects);
                toNodeModel.connectNodeMetadata(newStore, thisStep, toNode, nextDataStepAfterComputeStep, null, null);
                List lNewWorkTableNodes = ((WAPFDTransformNodeModel)fromNode.getWAPFDNodeModel()).getWorkTableNodes();
                if (lNewWorkTableNodes.isEmpty()) {
                    new WAPFDLink(fromNode, this.getViewNode(), this.m_parentPanel);
                } else {
                    for (int j = 0; j < lNewWorkTableNodes.size(); ++j) {
                        WAPFDWorkTableNode workNode = (WAPFDWorkTableNode)lNewWorkTableNodes.get(j);
                        WAPFDWorkTableNodeModel workModel = (WAPFDWorkTableNodeModel)workNode.getWAPFDNodeModel();
                        String nodeHookedUp = workModel.getNodeHookedUp();
                        if (!nodeHookedUp.equalsIgnoreCase("N")) continue;
                        this.addLinksForWorkTableNode(fromNode, workNode, this.getViewNode(), this.m_parentPanel);
                        break;
                    }
                }
                new WAPFDLink(this.getViewNode(), toNode, this.m_parentPanel);
                this.updateTemplateVisual(thisStep);
                DataTable oTargetTable = null;
                DataTable oSourceTable = null;
                if (thisStep.getTransformations().size() <= 0) return;
                oTargetTable = (DataTable)((ClassifierMap)thisStep.getTransformations().elementAt(0)).getClassifierTargets(false).elementAt(0);
                if (((ClassifierMap)thisStep.getTransformations().elementAt(0)).getClassifierSources(false).size() > 0) {
                    oSourceTable = (DataTable)((ClassifierMap)thisStep.getTransformations().elementAt(0)).getClassifierSources(false).elementAt(0);
                }
                if (oSourceTable == null) return;
                if (oTargetTable == null) return;
                MappingUtil.doAutomaticMappings(oTargetTable);
                return;
            }
        }
        throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
    }

    public Classifier findOutputClassifierOnThisStepToMapTo(TransformationStep thisStep) throws MdException, RemoteException {
        Classifier targetClassifierToMapTo = (Classifier)((ClassifierMap)thisStep.getTransformations(false).elementAt(0)).getClassifierTargets(false).elementAt(0);
        return targetClassifierToMapTo;
    }

    @Override
    public void addNode(CMetadata step) throws PFDException, MdException, RemoteException {
        this.m_viewNode = new WAPFDTransformLoaderNode(new Point(0, 0), this.getIcon(step), step.getName(), this, this.m_parentPanel);
        this.m_viewNode.addNode();
    }

    @Override
    public void addNode(MdObjectStore newStore, TransformInterface transformBeingDropped) throws PFDException, MdException, RemoteException {
        ArrayList inputs = new ArrayList();
        ArrayList outputs = new ArrayList();
        TransformationStep temporaryTS = (TransformationStep)WAPFDTransformLoaderNodeModel.makeDropObject(this.m_activeJob, newStore, transformBeingDropped, inputs, outputs);
        if (temporaryTS == null) {
            throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_CANNOTCREATETRANFORM.txt");
        }
        this.m_objectID = temporaryTS.getFQID();
        TransformationActivity taoldstore = (TransformationActivity)((Job)this.m_activeJob).getJobActivities(false).elementAt(0);
        TransformationActivity ta = (TransformationActivity)Workspace.getMdFactory().createComplexMetadataObject(newStore, (CMetadata)taoldstore);
        temporaryTS.getActivities(false).add((Object)ta);
        this.m_viewNode = new WAPFDTransformLoaderNode(new Point(0, 0), (ImageIcon)transformBeingDropped.getIcon(), temporaryTS.getName(), this, this.m_parentPanel);
        this.m_viewNode.addNode();
    }

    public static WAPFDTransformNodeModel addLoaderToJob(PFDPanel parentPanel, CMetadata job, MdObjectStore newStore, TransformationActivity ta, DataTable table, TransformInterface transformBeingDropped) throws MdException, RemoteException {
        ArrayList inputs = new ArrayList();
        ArrayList outputs = new ArrayList();
        TransformationStep temporaryTS = (TransformationStep)WAPFDTransformLoaderNodeModel.makeDropObject(job, newStore, transformBeingDropped, inputs, outputs);
        temporaryTS.getActivities().add((Object)ta);
        ClassifierMap map = (ClassifierMap)temporaryTS.getTransformations().elementAt(0);
        map.getClassifierTargets(false).add((Object)table);
        WAPFDTransformLoaderNodeModel loaderModel = new WAPFDTransformLoaderNodeModel(parentPanel, (CMetadata)temporaryTS);
        loaderModel.addNode((CMetadata)temporaryTS);
        return loaderModel;
    }

    public void deleteFromTable(ArrayList affectedObjects) throws MdException, RemoteException, PFDException {
        this.updateTemplateVisual((TransformationStep)this.getMetadataObject());
    }
}

