/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.pfd;

import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.Join;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.StepPrecedence;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.pfd.PFDException;
import com.sas.wadmin.pfd.PFDPanel;
import com.sas.wadmin.pfd.WAPFDLink;
import com.sas.wadmin.pfd.WAPFDNode;
import com.sas.wadmin.pfd.WAPFDNodeInterface;
import com.sas.wadmin.pfd.WAPFDTemplateNode;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.visuals.TransformManager;
import com.sas.workspace.ProjectUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsOMAView;
import com.sas.workspace.WsViewFactory;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JInternalFrame;

public class WAPFDNodeModel {
    protected String m_objectID = null;
    protected CMetadata m_activeJob = null;
    protected PFDPanel m_parentPanel = null;
    protected WAPFDNodeInterface m_viewNode = null;
    public static final int CANVAS = 0;
    public static final int NODE = 1;
    public static final int LINK = 2;
    public static final int TABLE = 3;
    public static final int TEMPLATE = 4;

    public WAPFDNodeModel(PFDPanel parentPanel, CMetadata object) {
        this.m_activeJob = parentPanel.getActiveJob();
        this.m_parentPanel = parentPanel;
        if (object != null) {
            try {
                String sParentID;
                this.m_objectID = object.getFQID();
                this.m_parentPanel.addNodeModelToHashmap(object.getFQID(), this);
                if ((object.getCMetadataType().equalsIgnoreCase("PhysicalTable") || object.getCMetadataType().equalsIgnoreCase("ExternalTable") || object.getCMetadataType().equalsIgnoreCase("SASLibrary") || object.getCMetadataType().equalsIgnoreCase("Job") || object.getCMetadataType().equalsIgnoreCase("Transformation")) && (sParentID = ProjectUtil.getParentRepositoryID((Root)((Root)object))) != null) {
                    this.m_parentPanel.addNodeModelToHashmap(sParentID, this);
                }
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    public void addNodeModelToHashmap(CMetadata object) {
        try {
            String sParentID;
            this.m_parentPanel.addNodeModelToHashmap(object.getFQID(), this);
            if ((object.getCMetadataType().equalsIgnoreCase("PhysicalTable") || object.getCMetadataType().equalsIgnoreCase("ExternalTable") || object.getCMetadataType().equalsIgnoreCase("SASLibrary") || object.getCMetadataType().equalsIgnoreCase("Job")) && (sParentID = ProjectUtil.getParentRepositoryID((Root)((Root)object))) != null) {
                this.m_parentPanel.addNodeModelToHashmap(sParentID, this);
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void handleLocation(MdObjectStore newStore, PFDPrimitive primLogicalLocation, ArrayList affectedObjects) throws MdException, RemoteException, PFDException {
    }

    public int getintLogicalLocation(PFDPrimitive primLogicalLocation) {
        int iLogicalLocation = primLogicalLocation == null ? 0 : (primLogicalLocation instanceof WAPFDNode ? 1 : (primLogicalLocation instanceof WAPFDTemplateNode ? 4 : (primLogicalLocation instanceof WAPFDLink ? 2 : 0)));
        return iLogicalLocation;
    }

    protected void dispose() {
        this.m_activeJob = null;
        this.m_viewNode = null;
        this.m_objectID = null;
    }

    public CMetadata getMetadataObject() {
        try {
            return ((MdObjectStore)this.m_activeJob.getObjectStore()).getObject(this.m_objectID);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
            return null;
        }
    }

    public CMetadata getMetadataObject(CMetadata object) {
        try {
            return ((MdObjectStore)object.getObjectStore()).getObject(this.m_objectID);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
            return null;
        }
    }

    public CMetadata getMetadataObject(MdObjectStore store) {
        try {
            return store.getObject(this.m_objectID);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
            return null;
        }
    }

    public void updateObjectWithOMAView(CMetadata object, WsOMAView m_processView) {
        if (object != null) {
            try {
                ArrayList viewList = object.getViewList();
                viewList.add(m_processView);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    public void setViewNode(WAPFDNode node) {
        this.m_viewNode = node;
    }

    public WAPFDNodeInterface getViewNode() {
        return this.m_viewNode;
    }

    protected void removeNode() {
    }

    protected boolean isOutputTable(String tableID) throws MdException, RemoteException {
        boolean fIsOutput = false;
        AssociationList activities = ((Job)this.m_activeJob).getJobActivities(false);
        block0: for (int i = 0; i < activities.size(); ++i) {
            TransformationActivity activity = (TransformationActivity)activities.elementAt(i);
            AssociationList targetObjects = activity.getTransformationTargets(false);
            for (int j = 0; j < targetObjects.size(); ++j) {
                CMetadata object = (CMetadata)targetObjects.elementAt(j);
                if (object.getFQID().compareTo(tableID) != 0) continue;
                fIsOutput = true;
                continue block0;
            }
        }
        return fIsOutput;
    }

    public void properties() throws MdException, RemoteException {
        CMetadata iObj = this.getMetadataObject();
        MdObjectStore newStore = Workspace.getMdFactory().createObjectStore(this.m_activeJob.getObjectStore());
        newStore.setIsGotToServerForMetadata(false);
        CMetadata newObject = Workspace.getMdFactory().createComplexMetadataObject(newStore, null, iObj);
        if (iObj instanceof Join) {
            this.m_parentPanel.addChildFrame((JInternalFrame)WsViewFactory.showPropertyView((CMetadata)newObject, (String)"com.sas.query.wa.", (String)"JoinView").getFrame());
        } else {
            String classname = WAPFDNodeModel.getClassName((TransformationStep)this.getMetadataObject());
            TransformInterface transformInterface = TransformManager.getInstance().getTransform(classname);
            this.m_parentPanel.addChildFrame(transformInterface.displayProperties(newObject));
        }
    }

    public static String getClassName(TransformationStep step) throws MdException, RemoteException {
        String classname = null;
        AssociationList properties = step.getProperties();
        for (int i = 0; i < properties.size(); ++i) {
            Property prop = (Property)properties.get(i);
            if (!prop.getPropertyName().equals("Class")) continue;
            classname = prop.getDefaultValue();
            break;
        }
        return classname;
    }

    public TransformInterface getTransformFromStep(TransformationStep step) {
        if (step == null) {
            return null;
        }
        TransformInterface transform = null;
        String classname = null;
        try {
            AssociationList properties = step.getProperties();
            for (int i = 0; i < properties.size(); ++i) {
                Property prop = (Property)properties.get(i);
                if (!prop.getPropertyName().equals("Class")) continue;
                classname = prop.getDefaultValue();
                break;
            }
            transform = TransformManager.getInstance().getTransform(classname);
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        return transform;
    }

    public void delete(ArrayList affectedObjects) throws MdException, RemoteException, PFDException {
    }

    public void deleteFromOtherNode(ArrayList affecteObjects) throws MdException, RemoteException, PFDException {
    }

    public void disconnectFromNode(WAPFDNode fromNode, ArrayList affectedObjects) throws MdException, RemoteException, PFDException {
    }

    public void updateIDs(String idOld, String idNew) {
        if (this.m_objectID != null && this.m_objectID.compareTo(idOld) == 0) {
            this.m_objectID = idNew;
        }
    }

    public void removeFMs(DataTable fromTable) throws MdException, RemoteException, PFDException {
        WAPFDNodeModel.removeFMs(this.m_activeJob, fromTable);
    }

    public static void removeFMs(CMetadata mObject, DataTable fromTable) throws MdException, RemoteException, PFDException {
        WAPFDNodeModel.removeFMs(mObject, fromTable, null);
    }

    public static void removeFMs(CMetadata mObject, DataTable fromTable, List excludeColumns) throws MdException, RemoteException, PFDException {
        AssociationList list = fromTable.getColumns(false);
        if (list != null && list.size() > 0) {
            ArrayList<Object> deleteList = new ArrayList<Object>();
            for (int g = 0; g < list.size(); ++g) {
                FeatureMap fm;
                int h;
                Column tableColumn = (Column)list.get(g);
                if (excludeColumns != null && excludeColumns.contains(tableColumn)) continue;
                AssociationList fmList = tableColumn.getSourceFeatureMaps(false);
                block1: for (h = 0; h < fmList.size(); ++h) {
                    fm = (FeatureMap)fmList.get(h);
                    if (fm.getFeatureSources(false).size() > 1) {
                        for (int p = 0; p < fm.getFeatureSources(false).size(); ++p) {
                            Column col = (Column)fm.getFeatureSources(false).get(p);
                            if (!col.getFQID().equalsIgnoreCase(tableColumn.getFQID())) continue;
                            fm.getFeatureSources(false).remove(p);
                            continue block1;
                        }
                        continue;
                    }
                    deleteList.add(fm);
                    for (int m = 0; m < fm.getSubstitutionVariables().size(); ++m) {
                        deleteList.add(fm.getSubstitutionVariables().elementAt(m));
                    }
                    AssociationList alText = fm.getSourceCodes();
                    if (alText.size() > 0) {
                        deleteList.add(alText.get(0));
                    }
                    if ((alText = fm.getProperties()).size() <= 0) continue;
                    for (int gg = 0; gg < alText.size(); ++gg) {
                        deleteList.add(alText.get(gg));
                    }
                }
                block5: for (h = 0; h < tableColumn.getTargetFeatureMaps(false).size(); ++h) {
                    fm = (FeatureMap)tableColumn.getTargetFeatureMaps(false).get(h);
                    if (fm.getFeatureSources(false).size() > 1) {
                        for (int p = 0; p < fm.getFeatureSources(false).size(); ++p) {
                            Column col = (Column)fm.getFeatureSources(false).get(p);
                            if (col == null || !col.getFQID().equalsIgnoreCase(tableColumn.getFQID())) continue;
                            fm.getFeatureSources(false).remove(p);
                            continue block5;
                        }
                        continue;
                    }
                    deleteList.add(fm);
                    for (int m = 0; m < fm.getSubstitutionVariables().size(); ++m) {
                        deleteList.add(fm.getSubstitutionVariables().elementAt(m));
                    }
                    AssociationList alText = fm.getSourceCodes();
                    if (alText.size() > 0) {
                        deleteList.add(alText.get(0));
                    }
                    if ((alText = fm.getProperties()).size() <= 0) continue;
                    for (int gg = 0; gg < alText.size(); ++gg) {
                        deleteList.add(alText.get(gg));
                    }
                }
            }
            if (deleteList.size() > 0) {
                ((MdObjectStore)mObject.getObjectStore()).removeObjectsFromStore(deleteList);
            }
        }
    }

    public static void removeFMs(ClassifierMap map) throws MdException, RemoteException, PFDException {
        if (map != null) {
            ArrayList<Object> deleteList = new ArrayList<Object>();
            AssociationList features = map.getFeatureMaps(false);
            for (int g = 0; g < features.size(); ++g) {
                FeatureMap fm = (FeatureMap)features.get(g);
                deleteList.add(fm);
                for (int m = 0; m < fm.getSubstitutionVariables().size(); ++m) {
                    deleteList.add(fm.getSubstitutionVariables().elementAt(m));
                }
                AssociationList alText = fm.getSourceCodes();
                if (alText.size() > 0) {
                    deleteList.add(alText.get(0));
                }
                if ((alText = fm.getProperties()).size() <= 0) continue;
                for (int gg = 0; gg < alText.size(); ++gg) {
                    deleteList.add(alText.get(gg));
                }
            }
            if (deleteList.size() > 0) {
                ((MdObjectStore)map.getObjectStore()).removeObjectsFromStore(deleteList);
            }
        }
    }

    protected TransformationStep findLastDataStep(TransformationStep thisStep) throws MdException, RemoteException {
        if (thisStep.getSuccessorDependencies(false).size() == 0) {
            return null;
        }
        StepPrecedence previousSP = (StepPrecedence)thisStep.getSuccessorDependencies(false).elementAt(0);
        if (previousSP != null && !previousSP.getPredecessors(false).isEmpty()) {
            TransformationStep previousStep = (TransformationStep)previousSP.getPredecessors(false).elementAt(0);
            if (previousStep.getTransformations().size() > 0 && !(previousStep.getTransformations().elementAt(0) instanceof Job)) {
                return previousStep;
            }
            return this.findLastDataStep(previousStep);
        }
        return null;
    }

    protected TransformationStep findPreviousDataStep(TransformationStep thisStep) throws MdException, RemoteException {
        if (thisStep.getTransformations().size() > 0 && !(thisStep.getTransformations().elementAt(0) instanceof Job)) {
            return thisStep;
        }
        if (thisStep.getSuccessorDependencies(false).size() == 0) {
            return null;
        }
        StepPrecedence previousSP = (StepPrecedence)thisStep.getSuccessorDependencies(false).elementAt(0);
        TransformationStep previousStep = (TransformationStep)previousSP.getPredecessors(false).elementAt(0);
        return this.findPreviousDataStep(previousStep);
    }

    protected TransformationStep findPreviousStep(TransformationStep thisStep) throws MdException, RemoteException {
        TransformationStep previousStep = null;
        if (thisStep.getSuccessorDependencies(false).size() == 0) {
            return null;
        }
        StepPrecedence previousSP = (StepPrecedence)thisStep.getSuccessorDependencies(false).elementAt(0);
        if (previousSP.getPredecessors(false).size() > 0) {
            previousStep = (TransformationStep)previousSP.getPredecessors(false).elementAt(0);
        }
        return previousStep;
    }

    protected void removeSP(MdObjectStore childStore, StepPrecedence stepPrec) throws MdException, RemoteException {
        if (stepPrec == null) {
            return;
        }
        stepPrec.getSuccessors(false).removeAllElements(false);
        stepPrec.getPredecessors(false).removeAllElements(false);
        ArrayList<StepPrecedence> objects = new ArrayList<StepPrecedence>();
        objects.add(stepPrec);
        childStore.removeObjectsFromStore(objects);
    }

    public TransformationStep findNextDataStep(TransformationStep thisStep) throws MdException, RemoteException {
        if (thisStep.getTransformations(false).size() > 0) {
            return thisStep;
        }
        if (thisStep.getPredecessorDependencies(false).size() == 0) {
            return null;
        }
        StepPrecedence nextSP = (StepPrecedence)thisStep.getPredecessorDependencies(false).elementAt(0);
        TransformationStep nextStep = (TransformationStep)nextSP.getSuccessors(false).elementAt(0);
        return this.findNextDataStep(nextStep);
    }

    public TransformationStep findNextDataStep(TransformationStep thisStep, boolean fReturnThisStepIfDataStep) throws MdException, RemoteException {
        if (fReturnThisStepIfDataStep) {
            if (thisStep.getTransformations(false).size() > 0) {
                return thisStep;
            }
            if (thisStep.getPredecessorDependencies(false).size() == 0) {
                return null;
            }
        } else if (thisStep.getPredecessorDependencies(false).size() == 0) {
            if (thisStep.getTransformations(false).size() > 0) {
                return thisStep;
            }
            return null;
        }
        StepPrecedence nextSP = (StepPrecedence)thisStep.getPredecessorDependencies(false).elementAt(0);
        TransformationStep nextStep = (TransformationStep)nextSP.getSuccessors(false).elementAt(0);
        return this.findNextDataStep(nextStep);
    }

    protected TransformationStep findNextStep(TransformationStep thisStep) throws MdException, RemoteException {
        TransformationStep nextStep = null;
        if (thisStep.getPredecessorDependencies(false).size() == 0) {
            return null;
        }
        StepPrecedence nextSP = (StepPrecedence)thisStep.getPredecessorDependencies(false).elementAt(0);
        if (nextSP.getSuccessors(false).size() > 0) {
            nextStep = (TransformationStep)nextSP.getSuccessors(false).elementAt(0);
        }
        return nextStep;
    }
}

