/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.pfd;

import com.sas.graphics.components.pfd.PFDIconNode;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.wadmin.pfd.PFDException;
import com.sas.wadmin.pfd.PFDPanel;
import com.sas.wadmin.pfd.WAPFDLink;
import com.sas.wadmin.pfd.WAPFDNodeInterface;
import com.sas.wadmin.pfd.WAPFDNodeModel;
import com.sas.wadmin.pfd.WAPFDPrimitiveInterface;
import com.sas.wadmin.pfd.WAPFDTemplateNode;
import com.sas.workspace.DNDObject;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.InputEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ImageIcon;

public class WAPFDNode
extends PFDIconNode
implements DragSourceListener,
DragGestureListener,
WAPFDNodeInterface,
WAPFDPrimitiveInterface {
    protected PFDPanel m_parentPanel = null;
    protected WAPFDNodeModel m_nodeModel = null;
    protected CMetadata m_activeJob = null;
    protected DragSource m_dragSource = null;

    public WAPFDNode(Point canvasLocation, Dimension size, int iShape, ImageIcon image, String sCaption, WAPFDNodeModel Model, PFDPanel parentPanel) {
        super(canvasLocation, size, iShape, image, sCaption);
        this.m_parentPanel = parentPanel;
        this.m_nodeModel = Model;
        this.m_activeJob = parentPanel.getActiveJob();
        if (this.getLabel() != null) {
            this.getLabel().setMultiline(true);
            this.getLabel().setClipHeight(Integer.MAX_VALUE);
        }
        this.getPort("east").setSelectable(false);
        this.getPort("west").setSelectable(false);
        this.getPort("north").setSelectable(false);
        this.getPort("south").setSelectable(false);
        this.m_parentPanel.getModel().addPrimitive((PFDPrimitive)this);
        this.setSelectable(true);
    }

    @Override
    public PFDPort getPort(String portLoc) {
        return super.getPort(portLoc);
    }

    @Override
    public void deleteNode() {
        this.m_parentPanel.removeNode(this);
        this.m_parentPanel.getModel().removePrimitive((PFDPrimitive)this);
    }

    @Override
    public void addNode() {
    }

    public void connectNodeVisual(WAPFDNodeInterface fromNode, WAPFDNodeInterface thisNode) {
        new WAPFDLink(fromNode, thisNode, this.m_parentPanel);
    }

    @Override
    public WAPFDNodeModel getWAPFDNodeModel() {
        return this.m_nodeModel;
    }

    public boolean isValidDropLocation(int location) {
        return true;
    }

    public void dispose() {
        this.m_nodeModel.dispose();
        this.m_activeJob = null;
        this.m_dragSource = null;
        this.m_nodeModel = null;
        this.removeAllPrimitives();
    }

    public CMetadata getMetadataObject() {
        return this.m_nodeModel.getMetadataObject();
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        InputEvent ie = dge.getTriggerEvent();
        if (ie.isControlDown() || ie.isShiftDown() || ie.isAltDown()) {
            return;
        }
        DNDObject thisObject = new DNDObject();
        this.m_dragSource.startDrag(dge, DragSource.DefaultMoveDrop, (Transferable)thisObject, this);
    }

    @Override
    public void getPortsFromNode(Vector ins, Vector outs) {
        if (PFDPanel.getLayoutDirection() == 2) {
            outs = this.getPort("east").getFromLinks();
            ins = this.getPort("west").getToLinks();
        } else if (PFDPanel.getLayoutDirection() == 0) {
            ins = this.getPort("east").getFromLinks();
            outs = this.getPort("west").getToLinks();
        } else if (PFDPanel.getLayoutDirection() == 3) {
            ins = this.getPort("north").getFromLinks();
            outs = this.getPort("south").getToLinks();
        } else {
            outs = this.getPort("north").getFromLinks();
            ins = this.getPort("south").getToLinks();
        }
    }

    @Override
    public void showProperties() throws MdException, RemoteException {
        this.m_nodeModel.properties();
    }

    public void checkReconnectLocation(PFDPrimitive primitive) throws MdException, RemoteException, PFDException {
    }

    @Override
    public boolean fCanShowPopup() throws MdException, RemoteException, PFDException {
        return false;
    }

    @Override
    public boolean fCanViewStepCode() throws MdException, RemoteException, PFDException {
        return false;
    }

    @Override
    public boolean fCanViewData() throws MdException, RemoteException, PFDException {
        return false;
    }

    @Override
    public boolean fCanViewFile() throws MdException, RemoteException, PFDException {
        return false;
    }

    @Override
    public boolean fCanShowImpact() throws MdException, RemoteException, PFDException {
        return false;
    }

    @Override
    public boolean fCanShowReverseImpact() throws MdException, RemoteException, PFDException {
        return false;
    }

    @Override
    public boolean fCanDelete() throws MdException, RemoteException, PFDException {
        return false;
    }

    @Override
    public boolean fCanShowProperties() throws MdException, RemoteException, PFDException {
        return false;
    }

    @Override
    public boolean fCanMakeOutput() throws MdException, RemoteException, PFDException {
        return false;
    }

    @Override
    public boolean fCanViewJob() throws MdException, RemoteException, PFDException {
        return false;
    }

    @Override
    public boolean fCanAddInputTemplate() {
        return false;
    }

    @Override
    public boolean fCanAddOutputTemplate() {
        return false;
    }

    @Override
    public void delete(ArrayList affectedObjects) throws MdException, RemoteException, PFDException {
        this.m_parentPanel.setDataChanged(true);
        this.m_nodeModel.delete(affectedObjects);
    }

    public void handleLocation(MdObjectStore newStore, PFDPrimitive primLogicalLocation, ArrayList affectedObjects) throws MdException, RemoteException, PFDException {
        this.m_nodeModel.handleLocation(newStore, primLogicalLocation, affectedObjects);
    }

    @Override
    public Vector getInputLinks() {
        Vector inputs = null;
        inputs = PFDPanel.getLayoutDirection() == 2 ? this.getPort("east").getToLinks() : (PFDPanel.getLayoutDirection() == 0 ? this.getPort("west").getToLinks() : (PFDPanel.getLayoutDirection() == 3 ? this.getPort("south").getToLinks() : this.getPort("north").getToLinks()));
        return inputs;
    }

    @Override
    public Vector getOutputLinks() {
        Vector outputs = null;
        outputs = PFDPanel.getLayoutDirection() == 2 ? this.getPort("west").getFromLinks() : (PFDPanel.getLayoutDirection() == 0 ? this.getPort("east").getFromLinks() : (PFDPanel.getLayoutDirection() == 3 ? this.getPort("north").getFromLinks() : this.getPort("south").getFromLinks()));
        return outputs;
    }

    public void deleteFromOtherNode(ArrayList affectedObjects) throws MdException, RemoteException, PFDException {
        this.m_nodeModel.deleteFromOtherNode(affectedObjects);
    }

    @Override
    public void disconnectFromNode(WAPFDNodeInterface fromNode, ArrayList affectedObjects) throws MdException, RemoteException, PFDException {
        if (fromNode instanceof WAPFDNode) {
            this.m_nodeModel.disconnectFromNode((WAPFDNode)fromNode, affectedObjects);
        }
    }

    @Override
    public void viewData() {
    }

    @Override
    public void viewFile() {
    }

    @Override
    public void showImpactAnalysis(boolean bForward) {
    }

    @Override
    public void showReverseImpactAnslysis(boolean bForward) {
    }

    public int getShowingInputTemplates() {
        Vector inputs = this.getInputLinks();
        int templates = 0;
        for (int i = 0; i < inputs.size(); ++i) {
            WAPFDLink link = (WAPFDLink)inputs.elementAt(i);
            if (!(link.getFromNode() instanceof WAPFDTemplateNode)) continue;
            ++templates;
        }
        return templates;
    }

    public int getShowingOutputTemplates() {
        Vector outputs = this.getOutputLinks();
        int templates = 0;
        for (int i = 0; i < outputs.size(); ++i) {
            WAPFDLink link = (WAPFDLink)outputs.elementAt(i);
            if (!(link.getToNode() instanceof WAPFDTemplateNode)) continue;
            ++templates;
        }
        return templates;
    }
}

