/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.pfd;

import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.WorkTable;
import com.sas.wadmin.pfd.PFDException;
import com.sas.wadmin.pfd.PFDPanel;
import com.sas.wadmin.pfd.WAPFDExternalTableNode;
import com.sas.wadmin.pfd.WAPFDInformationNode;
import com.sas.wadmin.pfd.WAPFDNode;
import com.sas.wadmin.pfd.WAPFDNodeInterface;
import com.sas.wadmin.pfd.WAPFDNodeModel;
import com.sas.wadmin.pfd.WAPFDPrimitiveInterface;
import com.sas.wadmin.pfd.WAPFDTableNode;
import com.sas.wadmin.pfd.WAPFDTemplateNode;
import com.sas.wadmin.pfd.WAPFDTransformNode;
import com.sas.wadmin.pfd.WAPFDTransformNodeModel;
import com.sas.wadmin.pfd.WAPFDWorkTableNode;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.plugins.TransformNoDeleteLoaderInterface;
import com.sas.wadmin.plugins.TransformUpdateControlInterface;
import com.sas.wadmin.plugins.TransformWorkTableInterface;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.wadmin.visuals.TransformManager;
import java.awt.Color;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;

public class WAPFDLink
extends PFDLink
implements WAPFDPrimitiveInterface {
    protected String m_ID = "LINK" + ++count;
    protected static int count = 0;
    protected WAPFDNodeInterface m_fromNode = null;
    protected WAPFDNodeInterface m_toNode = null;
    protected PFDPanel m_parentPanel = null;

    @Override
    public void delete(ArrayList affectedObjects) throws MdException, RemoteException, PFDException {
        this.m_parentPanel.setDataChanged(true);
        CMetadata toMetaObject = this.m_toNode.getWAPFDNodeModel().getMetadataObject();
        if (toMetaObject instanceof TransformationStep) {
            MacroPluginUtilities.removeLinkToAssociationProperty((TransformationStep)toMetaObject, this.m_fromNode.getWAPFDNodeModel().getMetadataObject());
        }
        if (this.m_fromNode instanceof WAPFDWorkTableNode) {
            WAPFDNodeInterface workFromNode;
            WAPFDWorkTableNode workNode = (WAPFDWorkTableNode)this.m_fromNode;
            WAPFDLink workInputLink = null;
            Vector workInputLinks = this.m_fromNode.getInputLinks();
            if (workInputLinks != null && !workInputLinks.isEmpty() && (workFromNode = (workInputLink = (WAPFDLink)workInputLinks.elementAt(0)).getWAFromNode()) instanceof WAPFDNode) {
                this.m_fromNode = (WAPFDNode)workFromNode;
                WAPFDTransformNodeModel fromModel = (WAPFDTransformNodeModel)this.m_fromNode.getWAPFDNodeModel();
                fromModel.deleteWorkTableNodeAndLink((WorkTable)workNode.getMetadataObject(), affectedObjects);
            }
        }
        this.m_toNode.disconnectFromNode(this.m_fromNode, affectedObjects);
        this.disconnectLink();
    }

    @Override
    public void showProperties() {
    }

    public WAPFDLink(WAPFDNodeInterface fromNode, WAPFDNodeInterface toNode, PFDPanel parentPanel) {
        this.m_parentPanel = parentPanel;
        this.m_parentPanel.addLink(this);
        parentPanel.forceFlowDirectionChange();
        this.m_fromNode = fromNode;
        this.m_toNode = toNode;
        this.updateFromPort();
        this.updateToPort();
        this.setDraggable(false);
        this.setArrowShape(1);
        this.setArrowBase(8.0f);
        this.getPen().setColor(Color.black);
        this.setFromElbowLineWidth(5.0f);
        this.setSelectable(true);
        this.m_parentPanel.getModel().addPrimitive(0, (PFDPrimitive)this);
    }

    public boolean isValidMetadataDropLocation() throws MdException, RemoteException {
        int location;
        int i;
        ArrayList locations;
        TransformInterface transform;
        TransformationStep step;
        WAPFDTransformNodeModel Model;
        if (this.m_fromNode instanceof WAPFDTemplateNode) {
            return false;
        }
        if (this.m_toNode instanceof WAPFDTransformNode) {
            Model = (WAPFDTransformNodeModel)this.m_toNode.getWAPFDNodeModel();
            transform = Model.getTransformFromStep(step = (TransformationStep)Model.getMetadataObject());
            if (transform instanceof TransformUpdateControlInterface && ((TransformUpdateControlInterface)((Object)transform)).vetoInputLinkChanges()) {
                return false;
            }
            locations = transform.getValidDropTargets();
            for (i = 0; i < locations.size(); ++i) {
                location = (Integer)locations.get(i);
                if (location != TransformInterface.LINK_OUTPUT_ONLY) continue;
                return false;
            }
        }
        if (this.m_fromNode instanceof WAPFDTransformNode) {
            Model = (WAPFDTransformNodeModel)this.m_fromNode.getWAPFDNodeModel();
            transform = Model.getTransformFromStep(step = (TransformationStep)Model.getMetadataObject());
            if (transform instanceof TransformUpdateControlInterface && ((TransformUpdateControlInterface)((Object)transform)).vetoOutputLinkChanges()) {
                return false;
            }
            locations = transform.getValidDropTargets();
            for (i = 0; i < locations.size(); ++i) {
                location = (Integer)locations.get(i);
                if (location != TransformInterface.LINK_INPUT_ONLY) continue;
                return false;
            }
        }
        return true;
    }

    public WAPFDNode doDeleteInputLink(ArrayList affectedObjects) throws PFDException, MdException, RemoteException {
        WAPFDNode returningFromNode = null;
        if (this.m_fromNode instanceof WAPFDTemplateNode) {
            ((WAPFDTemplateNode)this.m_fromNode).delete(affectedObjects, true);
        } else {
            returningFromNode = (WAPFDNode)this.m_fromNode;
        }
        this.disconnectLink();
        return returningFromNode;
    }

    public WAPFDNode doDeleteOutputLink(ArrayList affectedObjects) throws PFDException, MdException, RemoteException {
        WAPFDNode returningToNode = null;
        if (this.m_toNode instanceof WAPFDTemplateNode) {
            ((WAPFDTemplateNode)this.m_toNode).delete(affectedObjects, true);
        } else {
            returningToNode = (WAPFDNode)this.m_toNode;
        }
        this.disconnectLink();
        return returningToNode;
    }

    public WAPFDNode doDeleteOutputTemplate(ArrayList affectedObjects) throws PFDException, MdException, RemoteException {
        WAPFDNode returningToNode = null;
        if (this.m_toNode instanceof WAPFDTemplateNode) {
            this.m_parentPanel.removeNode(this.m_toNode);
            this.m_parentPanel.getModel().removePrimitive((PFDPrimitive)((WAPFDTemplateNode)this.m_toNode));
        } else {
            returningToNode = (WAPFDNode)this.m_toNode;
        }
        this.disconnectLink();
        return returningToNode;
    }

    public void setFromNode(WAPFDNodeInterface newFrom) {
        this.m_fromNode = newFrom;
        this.updateFromPort();
    }

    public WAPFDNodeInterface getWAFromNode() {
        return this.m_fromNode;
    }

    public void setToNode(WAPFDNodeInterface newTo) {
        this.m_toNode = newTo;
        this.updateToPort();
    }

    public WAPFDNodeInterface getWAToNode() {
        return this.m_toNode;
    }

    public void disconnectLink() {
        this.m_parentPanel.getModel().removePrimitive((PFDPrimitive)this);
        this.m_parentPanel.removeLink(this);
        this.dispose();
    }

    protected void updateFromPort() {
        PFDPort FromPort = null;
        switch (PFDPanel.getLayoutDirection()) {
            case 2: {
                FromPort = this.m_fromNode.getPort("west");
                break;
            }
            case 3: {
                FromPort = this.m_fromNode.getPort("north");
                break;
            }
            case 1: {
                FromPort = this.m_fromNode.getPort("south");
                break;
            }
            default: {
                FromPort = this.m_fromNode.getPort("east");
            }
        }
        FromPort.setEndSegmentLength(10);
        this.setFromPort(FromPort);
    }

    protected void updateToPort() {
        PFDPort ToPort = null;
        switch (PFDPanel.getLayoutDirection()) {
            case 2: {
                ToPort = this.m_toNode.getPort("east");
                break;
            }
            case 3: {
                ToPort = this.m_toNode.getPort("south");
                break;
            }
            case 1: {
                ToPort = this.m_toNode.getPort("north");
                break;
            }
            default: {
                ToPort = this.m_toNode.getPort("west");
            }
        }
        ToPort.setEndSegmentLength(10);
        this.setToPort(ToPort);
    }

    protected void dispose() {
        this.setFromPort(null);
        this.setToPort(null);
        this.m_fromNode = null;
        this.m_toNode = null;
        this.m_parentPanel = null;
    }

    @Override
    public boolean fCanAddInputTemplate() {
        return false;
    }

    @Override
    public boolean fCanAddOutputTemplate() {
        return false;
    }

    @Override
    public boolean fCanShowPopup() throws MdException, RemoteException, PFDException {
        return true;
    }

    @Override
    public boolean fCanViewStepCode() throws MdException, RemoteException, PFDException {
        return false;
    }

    @Override
    public boolean fCanViewData() throws MdException, RemoteException, PFDException {
        return false;
    }

    @Override
    public boolean fCanViewFile() throws MdException, RemoteException, PFDException {
        return false;
    }

    @Override
    public boolean fCanShowImpact() throws MdException, RemoteException, PFDException {
        return false;
    }

    @Override
    public boolean fCanShowReverseImpact() throws MdException, RemoteException, PFDException {
        return false;
    }

    @Override
    public boolean fCanDelete() throws MdException, RemoteException, PFDException {
        TransformInterface transform;
        TransformationStep step;
        WAPFDTransformNodeModel Model;
        if (this.m_fromNode instanceof WAPFDTemplateNode || this.m_toNode instanceof WAPFDTemplateNode || this.m_toNode instanceof WAPFDWorkTableNode || this.m_toNode instanceof WAPFDExternalTableNode || this.m_toNode instanceof WAPFDInformationNode) {
            return false;
        }
        if (this.m_fromNode instanceof WAPFDTableNode) {
            // empty if block
        }
        if (this.m_toNode instanceof WAPFDTransformNode) {
            Model = (WAPFDTransformNodeModel)this.m_toNode.getWAPFDNodeModel();
            step = (TransformationStep)Model.getMetadataObject();
            if (step.getTransformations(false).size() == 0) {
                return false;
            }
            transform = Model.getTransformFromStep(step);
            if (transform instanceof TransformUpdateControlInterface && ((TransformUpdateControlInterface)((Object)transform)).vetoInputLinkChanges()) {
                return false;
            }
        }
        if (this.m_fromNode instanceof WAPFDTransformNode || this.m_fromNode instanceof WAPFDWorkTableNode) {
            DataTable workTable = null;
            WAPFDNode returningFromNode = (WAPFDNode)this.m_fromNode;
            if (returningFromNode instanceof WAPFDWorkTableNode) {
                workTable = (DataTable)returningFromNode.getMetadataObject();
                WAPFDLink workInputLink = null;
                Vector workInputLinks = returningFromNode.getInputLinks();
                if (workInputLinks != null && !workInputLinks.isEmpty()) {
                    workInputLink = (WAPFDLink)workInputLinks.elementAt(0);
                    WAPFDNodeInterface workFromNode = workInputLink.getWAFromNode();
                    returningFromNode = workFromNode instanceof WAPFDNode ? (WAPFDNode)workFromNode : null;
                }
            }
            WAPFDTransformNodeModel oModel = (WAPFDTransformNodeModel)returningFromNode.getWAPFDNodeModel();
            TransformationStep step2 = (TransformationStep)oModel.getMetadataObject();
            String classname = WAPFDNodeModel.getClassName(step2);
            TransformInterface transformInterface = TransformManager.getInstance().getTransform(classname);
            if (transformInterface instanceof TransformNoDeleteLoaderInterface) {
                return false;
            }
            if (transformInterface instanceof TransformWorkTableInterface) {
                TransformWorkTableInterface workInterface = (TransformWorkTableInterface)((Object)transformInterface);
                if (workTable != null && !workInterface.recreateWorkTable(workTable, step2)) {
                    return false;
                }
            }
        }
        return !(this.m_fromNode instanceof WAPFDTransformNode) || !((transform = (Model = (WAPFDTransformNodeModel)this.m_fromNode.getWAPFDNodeModel()).getTransformFromStep(step = (TransformationStep)Model.getMetadataObject())) instanceof TransformUpdateControlInterface) || !((TransformUpdateControlInterface)((Object)transform)).vetoOutputLinkChanges();
    }

    @Override
    public boolean fCanShowProperties() throws MdException, RemoteException, PFDException {
        return false;
    }

    @Override
    public boolean fCanMakeOutput() throws MdException, RemoteException, PFDException {
        return false;
    }

    @Override
    public boolean fCanViewJob() throws MdException, RemoteException, PFDException {
        return false;
    }

    @Override
    public void viewData() {
    }

    @Override
    public void viewFile() {
    }

    @Override
    public void showImpactAnalysis(boolean bForward) {
    }

    @Override
    public void showReverseImpactAnslysis(boolean bForward) {
    }
}

