/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.pfd;

import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Classifier;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.StepPrecedence;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.pfd.MappingUtil;
import com.sas.wadmin.pfd.PFDException;
import com.sas.wadmin.pfd.PFDMetadataParsing;
import com.sas.wadmin.pfd.PFDPanel;
import com.sas.wadmin.pfd.WAPFDJobNode;
import com.sas.wadmin.pfd.WAPFDLink;
import com.sas.wadmin.pfd.WAPFDNode;
import com.sas.wadmin.pfd.WAPFDNodeInterface;
import com.sas.wadmin.pfd.WAPFDTableNode;
import com.sas.wadmin.pfd.WAPFDTemplateNode;
import com.sas.wadmin.pfd.WAPFDTemplateNodeModel;
import com.sas.wadmin.pfd.WAPFDTransformLoaderNode;
import com.sas.wadmin.pfd.WAPFDTransformNodeModel;
import com.sas.wadmin.plugins.TransformControlInterface;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.wadmin.visuals.SASJob;
import com.sas.workspace.ProjectUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Point;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WAPFDJobNodeModel
extends WAPFDTransformNodeModel {
    public WAPFDJobNodeModel(PFDPanel parentPanel, CMetadata object) {
        super(parentPanel, null);
        if (object != null) {
            try {
                this.m_objectID = object.getFQID();
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    public WAPFDJobNodeModel(PFDPanel parentPanel) {
        super(parentPanel, null);
    }

    public void addNode(MdObjectStore newStore, CMetadata jobBeingAdded) throws PFDException, MdException, RemoteException {
        CMetadata objectToAdd = jobBeingAdded;
        Job job = (Job)Workspace.getMdFactory().createComplexMetadataObject(newStore, null, objectToAdd.getName(), objectToAdd.getCMetadataType(), objectToAdd.getFQID(), null);
        ArrayList inputs = new ArrayList();
        ArrayList outputs = new ArrayList();
        SASJob pluginJob = new SASJob();
        TransformationActivity taoldstore = (TransformationActivity)((Job)this.m_activeJob).getJobActivities(false).elementAt(0);
        TransformationActivity ta = (TransformationActivity)Workspace.getMdFactory().createComplexMetadataObject(newStore, (CMetadata)taoldstore);
        TransformationStep temporaryTS = (TransformationStep)WAPFDJobNodeModel.makeDropObject((CMetadata)job, this.m_activeJob, newStore, pluginJob, inputs, outputs);
        temporaryTS.getActivities().add((Object)ta);
        temporaryTS.getTransformations().add((Object)job);
        this.m_objectID = temporaryTS.getFQID();
        this.m_parentPanel.addNodeModelToHashmap(this.m_objectID, this);
        job.getViewList().add(this.m_parentPanel.getInnerJobView());
        this.m_parentPanel.addNodeModelToHashmap(job.getFQID(), this);
        String sParentID = ProjectUtil.getParentRepositoryID((Root)job);
        if (sParentID != null) {
            this.m_parentPanel.addNodeModelToHashmap(sParentID, this);
        }
        this.makeViewNode(job);
        this.m_viewNode.addNode();
    }

    @Override
    public void addNode(CMetadata step) throws PFDException, MdException, RemoteException {
        Job job = (Job)((TransformationStep)step).getTransformations(false).get(0);
        this.m_viewNode = new WAPFDJobNode(new Point(0, 0), this.getIcon(step), job.getName(), this, this.m_parentPanel);
        this.m_parentPanel.addNodeModelToHashmap(step.getFQID(), this);
        job.getViewList().add(this.m_parentPanel.getInnerJobView());
        this.m_parentPanel.addNodeModelToHashmap(job.getFQID(), this);
        String sParentID = ProjectUtil.getParentRepositoryID((Root)job);
        if (sParentID != null) {
            this.m_parentPanel.addNodeModelToHashmap(sParentID, this);
        }
        this.m_viewNode.addNode();
    }

    @Override
    public void addNode(CMetadata object, String sName) throws PFDException, MdException, RemoteException {
        CMetadata step = object;
        Job job = (Job)((TransformationStep)step).getTransformations(false).get(0);
        this.m_viewNode = new WAPFDJobNode(new Point(0, 0), this.getIcon(step), job.getName(), this, this.m_parentPanel);
        this.m_parentPanel.addNodeModelToHashmap(step.getFQID(), this);
        job.getViewList().add(this.m_parentPanel.getInnerJobView());
        this.m_parentPanel.addNodeModelToHashmap(job.getFQID(), this);
        String sParentID = ProjectUtil.getParentRepositoryID((Root)job);
        if (sParentID != null) {
            this.m_parentPanel.addNodeModelToHashmap(sParentID, this);
        }
        this.m_viewNode.addNode();
    }

    protected void makeViewNode(Job job) {
        try {
            this.m_viewNode = new WAPFDJobNode(new Point(0, 0), WAdminResource.getTypeIcon((String)job.getCMetadataType(), (boolean)false), job.getName(), this, this.m_parentPanel);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    protected static CMetadata makeDropObject(CMetadata newJob, CMetadata activeJob, MdObjectStore newStore, TransformInterface content, ArrayList inputs, ArrayList outputs) throws MdException, RemoteException {
        TransformationStep cmStep = null;
        String reposFQID = activeJob.getFQID().substring(0, 8);
        String transformXMLString = content.getXML();
        Document doc = Workspace.getMdFactory().getOMIUtil().parseXML(transformXMLString);
        Node firstNode = doc.getFirstChild();
        cmStep = (TransformationStep)Workspace.getMdFactory().createComplexMetadataObject(newStore, null, content.getName(), "TransformationStep", reposFQID);
        cmStep = (TransformationStep)PFDMetadataParsing.populateNewObjects((CMetadata)cmStep, firstNode.getAttributes(), firstNode.getChildNodes(), reposFQID, inputs, outputs);
        cmStep.setName(newJob.getName());
        return cmStep;
    }

    @Override
    public void handleLocation(MdObjectStore newStore, PFDPrimitive primLogicalLocation, ArrayList affectedObjects) throws MdException, RemoteException, PFDException {
        TransformationStep thisStep = (TransformationStep)this.getMetadataObject(newStore);
        switch (this.getintLogicalLocation(primLogicalLocation)) {
            case 0: {
                this.updateTemplateVisual((TransformationStep)this.getMetadataObject(newStore));
                break;
            }
            case 4: {
                WAPFDTemplateNode templateNode = (WAPFDTemplateNode)primLogicalLocation;
                WAPFDTemplateNodeModel templateModel = (WAPFDTemplateNodeModel)templateNode.getWAPFDNodeModel();
                TransformationStep associatedStep = templateModel.getAssociatedStep(newStore);
                if (associatedStep.getFQID().equals(thisStep.getFQID())) {
                    this.m_parentPanel.updateView();
                    throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
                }
                int iType = templateModel.getTemplateType((MdObjectStore)this.m_activeJob.getObjectStore());
                if (iType == 0) {
                    int iNumFullOutputs = this.getNumFullExistingClassifiers(thisStep);
                    int iNumMaxOutputTemplates = this.getMaxTemplates(thisStep, "OUTPUT");
                    if (iNumMaxOutputTemplates != 0 && iNumFullOutputs >= iNumMaxOutputTemplates) {
                        this.m_parentPanel.updateView();
                        throw new PFDException("PFDEXCEPTION.NOSPACEONTRANSFORM.txt");
                    }
                } else {
                    int iNumMaxInputTemplates;
                    int iNumFullInputs = thisStep.getSuccessorDependencies(false).size();
                    if (iNumFullInputs > 0 && (iNumMaxInputTemplates = this.getMaxTemplates(thisStep, "INPUT")) != 0 && iNumFullInputs >= iNumMaxInputTemplates) {
                        this.m_parentPanel.updateView();
                        throw new PFDException("PFDEXCEPTION.NOSPACEONTRANSFORM.txt");
                    }
                }
                WAPFDTemplateNodeModel nodeModel = (WAPFDTemplateNodeModel)((WAPFDTemplateNode)primLogicalLocation).getWAPFDNodeModel();
                nodeModel.connectNodeMetadata(newStore, this.getViewNode(), null, affectedObjects);
                ((WAPFDTemplateNode)primLogicalLocation).replaceTemplateNode((WAPFDNode)this.getViewNode());
                this.updateTemplateVisual(thisStep);
                TransformationStep nextDataStep = this.findNextDataStep(thisStep);
                if (nextDataStep == null) {
                    nextDataStep = this.findPreviousDataStep(thisStep);
                }
                if (nextDataStep == null || ((ClassifierMap)nextDataStep.getTransformations(false).elementAt(0)).getClassifierTargets(false).size() <= 0) break;
                DataTable targetTable = (DataTable)((ClassifierMap)nextDataStep.getTransformations(false).elementAt(0)).getClassifierTargets(false).elementAt(0);
                if (!thisStep.getTransformRole().equals("Contents")) {
                    MappingUtil.doAutomaticMappings(targetTable);
                    break;
                }
                DataTable sourceTable = (DataTable)((ClassifierMap)nextDataStep.getTransformations(false).elementAt(0)).getClassifierSources(false).elementAt(0);
                if (!MappingUtil.isAutoMapEnabled(thisStep)) break;
                MappingUtil.quickMap((CMetadata)sourceTable, (CMetadata)targetTable);
                break;
            }
            case 2: {
                WAPFDLink existingLink = (WAPFDLink)primLogicalLocation;
                if (!existingLink.isValidMetadataDropLocation()) {
                    this.m_parentPanel.updateView();
                    throw new PFDException("PFDEXCEPTION.CANNOTDROPTRANSFORMONLINK.txt");
                }
                WAPFDNodeInterface fromNode = existingLink.getWAFromNode();
                WAPFDNodeInterface toNode = existingLink.getWAToNode();
                if (fromNode instanceof WAPFDTransformLoaderNode) {
                    this.m_parentPanel.updateView();
                    throw new PFDException("PFDEXCEPTION.CANNOTDROPTRANSFORMONLINK.txt");
                }
                if (fromNode instanceof WAPFDTableNode && this instanceof TransformControlInterface) {
                    throw new PFDException("PFDEXCEPTION.CANNOTDROPTRANSFORMONLINK.txt");
                }
                affectedObjects.add(fromNode.getWAPFDNodeModel().getMetadataObject(newStore));
                affectedObjects.add(toNode.getWAPFDNodeModel().getMetadataObject(newStore));
                WAPFDTransformNodeModel toNodeModel = (WAPFDTransformNodeModel)toNode.getWAPFDNodeModel();
                ArrayList cmsToConnectTo = new ArrayList();
                thisStep = (TransformationStep)this.getMetadataObject(newStore);
                AssociationProperty assocProp = MacroPluginUtilities.removeLinkToAssociationProperty((TransformationStep)toNodeModel.getMetadataObject(newStore), fromNode.getWAPFDNodeModel().getMetadataObject(newStore));
                if (((TransformationStep)this.getMetadataObject(newStore)).getTransformations().size() > 1) {
                    toNodeModel.disconnectNodeMetadata(newStore, fromNode, toNode, cmsToConnectTo, true);
                } else {
                    toNodeModel.disconnectNodeMetadata(newStore, fromNode, toNode, cmsToConnectTo, false);
                }
                MacroPluginUtilities.createLinkToAssociationProperty((TransformationStep)toNodeModel.getMetadataObject(newStore), assocProp, (CMetadata)((TransformationStep)this.getMetadataObject(newStore)));
                existingLink.disconnectLink();
                ArrayList temp = new ArrayList();
                this.connectNodeMetadata(newStore, fromNode, this.getViewNode(), temp);
                new WAPFDLink(fromNode, this.getViewNode(), this.m_parentPanel);
                toNodeModel.connectNodeMetadata(newStore, this.getViewNode(), toNode, cmsToConnectTo);
                new WAPFDLink(this.getViewNode(), toNode, this.m_parentPanel);
                this.updateTemplateVisual(thisStep);
                break;
            }
            case 1: {
                this.m_parentPanel.updateView();
                throw new PFDException("PFDEXCEPTION.CANNOTDROPTRANSFORMONNODE.txt");
            }
            default: {
                this.m_parentPanel.updateView();
                throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
            }
        }
    }

    @Override
    public TransformationStep findNextDataStep(TransformationStep thisStep) throws MdException, RemoteException {
        if (!thisStep.getTransformations().isEmpty() && !thisStep.getTransformRole().equalsIgnoreCase("com.sas.wadmin.visuals.SASJob")) {
            return thisStep;
        }
        if (thisStep.getPredecessorDependencies(false).size() == 0) {
            return null;
        }
        StepPrecedence nextSP = (StepPrecedence)thisStep.getPredecessorDependencies(false).elementAt(0);
        TransformationStep nextStep = (TransformationStep)nextSP.getSuccessors(false).elementAt(0);
        return this.findNextDataStep(nextStep);
    }

    @Override
    public Classifier findOutputClassifierOnThisStepToMapTo(MdObjectStore store, TransformationStep thisStep) throws MdException, RemoteException {
        TransformationStep nextStep = this.findPreviousDataStep(thisStep);
        if (nextStep == null) {
            return null;
        }
        WAPFDTransformNodeModel nodeModel = (WAPFDTransformNodeModel)this.m_parentPanel.getNodeModel(nextStep.getFQID());
        if (nodeModel == null) {
            return this.findEmptyExistingClassifier(nextStep);
        }
        return nodeModel.findOutputClassifierOnThisStepToMapTo(store, nextStep);
    }

    @Override
    public void connectNodeMetadata(MdObjectStore newStore, WAPFDNodeInterface fromNode, WAPFDNodeInterface toNode, ArrayList thisNodesCMsThatWereDisconnectedFrom) throws MdException, RemoteException, PFDException {
        CMetadata fromNodeObject = fromNode.getWAPFDNodeModel().getMetadataObject(newStore);
        CMetadata toNodeObject = toNode.getWAPFDNodeModel().getMetadataObject(newStore);
        ArrayList targetCMsToMapTo = null;
        TransformationStep thisStep = (TransformationStep)toNodeObject;
        ArrayList nextTSList = new ArrayList();
        targetCMsToMapTo = this.findInputCMsOnThisStepToMapTo(thisStep, nextTSList);
        TransformationStep nextStep = null;
        if (nextTSList.size() > 0) {
            nextStep = (TransformationStep)nextTSList.get(0);
        }
        if (!(fromNodeObject instanceof Classifier)) {
            this.hookupSP(newStore, (TransformationStep)fromNodeObject, (TransformationStep)toNodeObject);
            TransformationStep prevDataStep = (TransformationStep)fromNodeObject;
            Classifier fromNodeClassifier = ((WAPFDTransformNodeModel)fromNode.getWAPFDNodeModel()).findOutputClassifierOnThisStepToMapTo(newStore, prevDataStep);
            if (fromNodeClassifier == null && (prevDataStep = this.findPreviousDataStep(thisStep)) != null && (fromNodeClassifier = ((WAPFDTransformNodeModel)fromNode.getWAPFDNodeModel()).findOutputClassifierOnThisStepToMapTo(newStore, prevDataStep)) == null) {
                throw new PFDException("PFDEXCEPTION.NOSPACEONTRANSFORM.txt");
            }
            if (fromNodeClassifier != null && nextStep != null) {
                this.connectNodeMetadata(newStore, prevDataStep, nextStep, targetCMsToMapTo, fromNodeClassifier);
            }
        }
    }

    @Override
    protected int getNumFullExistingClassifiers(TransformationStep thisStep) throws MdException, RemoteException {
        return this.getNumFullOutputs(thisStep);
    }

    @Override
    protected ArrayList findInputCMsOnThisStepToMapTo(TransformationStep thisStep) throws MdException, RemoteException {
        return this.findInputCMsOnThisStepToMapTo(thisStep, null);
    }

    protected ArrayList findInputCMsOnThisStepToMapTo(TransformationStep thisStep, ArrayList nextTSList) throws MdException, RemoteException {
        ArrayList inputCMsToMapTo = new ArrayList();
        TransformationStep nextStep = this.findNextDataStep(thisStep);
        if (nextStep == null) {
            return inputCMsToMapTo;
        }
        inputCMsToMapTo = super.findInputCMsOnThisStepToMapTo(nextStep);
        if (nextTSList != null) {
            nextTSList.add(nextStep);
        }
        return inputCMsToMapTo;
    }

    @Override
    protected int getNumFullInputs(TransformationStep thisStep) throws MdException, RemoteException {
        return thisStep.getSuccessorDependencies(false).size();
    }

    protected int getNumFullOutputs(TransformationStep thisStep) throws MdException, RemoteException {
        return thisStep.getPredecessorDependencies(false).size();
    }

    @Override
    protected void cleanupThisNode(TransformationStep thisStep, ArrayList thisNodesCMsThatWereDisconnectedFrom) throws MdException, RemoteException, PFDException {
    }

    @Override
    public boolean fNodeHasSpace(MdObjectStore newStore, int iTypeToLookFor) throws MdException, RemoteException {
        TransformationStep step = (TransformationStep)this.getMetadataObject(newStore);
        if (iTypeToLookFor == 0) {
            if (this.getMaxTemplates(step, "INPUT") == 0) {
                return true;
            }
            return step.getSuccessorDependencies(false).size() < this.getMaxTemplates(step, "INPUT");
        }
        if (step.getPredecessorDependencies(false).size() < this.getMaxTemplates(step, "OUTPUT")) {
            return true;
        }
        return this.getMaxTemplates(step, "OUTPUT") == 0;
    }
}

