/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.pfd;

import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.pfd.PFDException;
import com.sas.wadmin.pfd.PFDPanel;
import com.sas.wadmin.pfd.WAPFDInformationNodeModel;
import com.sas.wadmin.pfd.WAPFDTableNode;
import com.sas.wadmin.pfd.WAPFDTemplateNode;
import com.sas.wadmin.pfd.WAPFDTransformNodeModel;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.transforms.queues.IBMWSQReader;
import com.sas.wadmin.transforms.queues.IBMWSQWriter;
import com.sas.wadmin.transforms.queues.QueueReader;
import com.sas.wadmin.transforms.queues.QueueWriter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.rmi.RemoteException;
import javax.swing.ImageIcon;

public class WAPFDInformationNode
extends WAPFDTableNode {
    public WAPFDInformationNode(Point loc, ImageIcon image, String sCaption, WAPFDInformationNodeModel Model, PFDPanel parentPanel) {
        super(loc, new Dimension(36, 36), 5, image, sCaption, Model, parentPanel);
        this.getDrawable().getPen().setLineWidth(3.0f);
        this.getDrawable().getPen().setColor(new Color(252, 181, 38));
        this.getDrawable().getBrush().setColor(new Color(254, 222, 158));
    }

    @Override
    public boolean fCanDelete() throws MdException, RemoteException, PFDException {
        return true;
    }

    @Override
    public boolean fCanMakeOutput() throws MdException, RemoteException, PFDException {
        return false;
    }

    @Override
    public boolean fCanShowImpact() throws MdException, RemoteException, PFDException {
        return true;
    }

    @Override
    public boolean fCanShowReverseImpact() throws MdException, RemoteException, PFDException {
        return true;
    }

    @Override
    public boolean fCanViewData() {
        return false;
    }

    public static void isValidLocation(MdObjectStore newStore, PFDPrimitive primLogicalLocation) throws MdException, RemoteException, PFDException {
        if (!WAPFDInformationNode.checkLocation(newStore, primLogicalLocation)) {
            throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
        }
    }

    private static boolean checkLocation(MdObjectStore newStore, PFDPrimitive primLogicalLocation) throws MdException, RemoteException, PFDException {
        if (primLogicalLocation instanceof WAPFDTemplateNode) {
            WAPFDTemplateNode templateNode = (WAPFDTemplateNode)primLogicalLocation;
            AssociationProperty assocProp = (AssociationProperty)templateNode.getWAPFDNodeModel().getMetadataObject();
            TransformationStep existingStep = (TransformationStep)((Prototype)assocProp.getOwningPrototypes(false).elementAt(0)).getUsedByPrototypes(false).elementAt(0);
            TransformInterface transformInterface = WAPFDTransformNodeModel.getInterfaceClass(existingStep);
            if ((transformInterface instanceof QueueWriter || transformInterface instanceof IBMWSQWriter) && templateNode.getInputLinks().size() > 0) {
                return true;
            }
            return (transformInterface instanceof QueueReader || transformInterface instanceof IBMWSQReader) && templateNode.getOutputLinks().size() > 0;
        }
        return false;
    }

    @Override
    public void checkReconnectLocation(PFDPrimitive primitive) throws MdException, RemoteException, PFDException {
        if (primitive instanceof WAPFDTemplateNode) {
            WAPFDTemplateNode templateNode = (WAPFDTemplateNode)primitive;
            AssociationProperty assocProp = (AssociationProperty)templateNode.getWAPFDNodeModel().getMetadataObject();
            TransformationStep existingStep = (TransformationStep)((Prototype)assocProp.getOwningPrototypes(false).elementAt(0)).getUsedByPrototypes(false).elementAt(0);
            TransformInterface transformInterface = WAPFDTransformNodeModel.getInterfaceClass(existingStep);
            if ((transformInterface instanceof QueueWriter || transformInterface instanceof IBMWSQWriter) && templateNode.getInputLinks().size() > 0) {
                return;
            }
            if ((transformInterface instanceof QueueReader || transformInterface instanceof IBMWSQReader) && templateNode.getOutputLinks().size() > 0) {
                return;
            }
        }
        throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
    }
}

