/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.pfd;

import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import com.sas.wadmin.pfd.PFDException;
import com.sas.wadmin.pfd.PFDPanel;
import com.sas.wadmin.pfd.WAPFDDocumentNodeModel;
import com.sas.wadmin.pfd.WAPFDExternalTableNode;
import com.sas.wadmin.pfd.WAPFDExternalTableNodeModel;
import com.sas.wadmin.pfd.WAPFDInformationNode;
import com.sas.wadmin.pfd.WAPFDInformationNodeModel;
import com.sas.wadmin.pfd.WAPFDJobNode;
import com.sas.wadmin.pfd.WAPFDJobNodeModel;
import com.sas.wadmin.pfd.WAPFDNode;
import com.sas.wadmin.pfd.WAPFDNodeModel;
import com.sas.wadmin.pfd.WAPFDSASLibraryNode;
import com.sas.wadmin.pfd.WAPFDSASLibraryNodeModel;
import com.sas.wadmin.pfd.WAPFDTableNode;
import com.sas.wadmin.pfd.WAPFDTableNodeModel;
import com.sas.wadmin.pfd.WAPFDTransformComputeNodeModel;
import com.sas.wadmin.pfd.WAPFDTransformLoaderNodeModel;
import com.sas.wadmin.pfd.WAPFDTransformNode;
import com.sas.wadmin.pfd.WAPFDTransformNodeModel;
import com.sas.wadmin.plugins.TransformControlInterface;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.plugins.TransformLoaderInterface;
import com.sas.wadmin.visuals.MacroPlugin;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.workspace.DNDObject;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.metadata.EFIDataModel;
import com.sas.workspace.metadata.GeneratedTransformationUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;

public class PFDDnDAdapter
implements DropTargetListener,
DragSourceListener,
DragGestureListener {
    protected PFDPanel m_parentPanel = null;
    protected DropTarget m_dropTarget = null;
    protected DragSource m_dragSource = null;
    protected MdObjectStore m_newStore = null;
    protected static EventListenerList listenerList = new EventListenerList();
    private static WAdminResource m_bundle = WAdminResource.getBundle(PFDDnDAdapter.class);

    public PFDDnDAdapter() {
    }

    public PFDDnDAdapter(PFDPanel panel) {
        this.m_parentPanel = panel;
        this.m_dragSource = new DragSource();
        this.m_dragSource.createDefaultDragGestureRecognizer((Component)((Object)this.m_parentPanel), 3, this);
        this.m_dropTarget = new DropTarget((Component)((Object)this.m_parentPanel), this);
        this.m_dropTarget.setActive(true);
        this.m_dropTarget.setDefaultActions(3);
    }

    public void dispose() {
        if (this.m_dropTarget != null) {
            this.m_dropTarget.setComponent(null);
            this.m_dropTarget.removeDropTargetListener(this);
            this.m_dropTarget = null;
        }
        this.m_parentPanel = null;
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(DropTargetDropEvent dtde) {
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        boolean fComplete = true;
        ArrayList affectedObjects = new ArrayList();
        Object objectBeingDropped = null;
        try {
            Workspace.getDefaultLogger().debug((Object)"drop");
            Transferable transfer = dtde.getTransferable();
            if (transfer == null) {
                Workspace.getDefaultLogger().debug((Object)"No transferable");
                dtde.dropComplete(false);
                Workspace.getWorkspace().setCursor(null);
                return;
            }
            if (!transfer.isDataFlavorSupported(DNDObject.dndObjectDataFlavor)) {
                Workspace.getDefaultLogger().debug((Object)"No transfer data obtained: wrong flavor");
                dtde.dropComplete(false);
                Workspace.getWorkspace().setCursor(null);
                return;
            }
            Vector contentVector = (Vector)transfer.getTransferData(DNDObject.dndObjectDataFlavor);
            if (contentVector.size() == 0) {
                Workspace.getDefaultLogger().debug((Object)"No object");
                dtde.dropComplete(false);
                Workspace.getWorkspace().setCursor(null);
                return;
            }
            try {
                objectBeingDropped = contentVector.get(0);
            }
            catch (Exception ex) {
                Workspace.getDefaultLogger().error((Object)("No transfer data obtained: " + ex.getMessage()));
                dtde.dropComplete(false);
                Workspace.getWorkspace().setCursor(null);
                return;
            }
            Point dropLocation = dtde.getLocation();
            PFDPrimitive objectAtDropLocation = this.m_parentPanel.pickPrimitive(dropLocation.x, dropLocation.y);
            fComplete = this.dropHelper(objectAtDropLocation, objectBeingDropped, affectedObjects);
            if (!fComplete) {
                dtde.dropComplete(false);
                Workspace.getWorkspace().setCursor(null);
                this.dropComplete(false, affectedObjects);
                return;
            }
            dtde.dropComplete(fComplete);
        }
        catch (MdException ex1) {
            dtde.dropComplete(false);
            MessageUtil.displayMetadataExceptionMessage((MdException)ex1, (String)"Reading");
            fComplete = false;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (PFDException ex2) {
            dtde.dropComplete(false);
            PFDPanel.displayPFDErrorMessage(ex2.getMessage());
            fComplete = false;
        }
        catch (Exception ex3) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)ex3);
            fComplete = false;
        }
        finally {
            if (fComplete && objectBeingDropped instanceof TransformInterface) {
                fComplete = ((TransformInterface)objectBeingDropped).onAfterDrop(this.m_newStore);
            }
            this.dropComplete(fComplete, affectedObjects);
        }
    }

    public void dropComplete(boolean fComplete, ArrayList affectedObjects) {
        this.dropComplete(fComplete, affectedObjects, false);
    }

    public void dropComplete(boolean fComplete, ArrayList affectedObjects, boolean fUsePassedInStore) {
        if (fComplete) {
            this.m_parentPanel.updateView();
            this.m_parentPanel.setDataChanged(true);
            if (affectedObjects.size() > 0) {
                this.m_parentPanel.fireOnAddEvent(new ChangeEvent(affectedObjects));
            }
        }
        try {
            if (this.m_newStore != null) {
                if (fComplete) {
                    this.m_newStore.flushUpdatesToParentStore();
                }
                if (!fUsePassedInStore) {
                    Workspace.getDefaultLogger().debug((Object)"disposing of pfd dnd store");
                    this.m_newStore.dispose();
                }
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        Workspace.getWorkspace().setCursor(null);
    }

    public boolean dropHelper(PFDPrimitive objectAtDropLocation, Object objectBeingDropped, ArrayList affectedObjects) throws PFDException, MdException, RemoteException {
        return this.dropHelper(objectAtDropLocation, objectBeingDropped, affectedObjects, null, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropHelper(PFDPrimitive objectAtDropLocation, Object objectBeingDropped, ArrayList affectedObjects, CMetadata worktabletouse, boolean fCalledFromAPI, MdStore storeToUse) throws PFDException, MdException, RemoteException {
        CMetadata object = null;
        Job mainStoreActiveJob = (Job)this.m_parentPanel.getActiveJob();
        if (objectBeingDropped instanceof CMetadata) {
            object = (CMetadata)objectBeingDropped;
            boolean fFail = false;
            if (!this.validateDropObject(object, fCalledFromAPI)) {
                fFail = true;
                Workspace.getWorkspace().setStatusText(m_bundle.getString("PFDDNDADAPTER.OBJECTNOTALLOWED.txt"));
            }
            if (!object.getCMetadataType().equalsIgnoreCase("Prototype") && this.m_parentPanel.isNodeModelAlreadyAdded(object)) {
                fFail = true;
                Workspace.getWorkspace().setStatusText(m_bundle.getString("PFDDNDADAPTER.OBJECTALREADYADDED.txt"));
            }
            if (fFail) {
                Workspace.getWorkspace().setCursor(null);
                return false;
            }
        }
        if (this.m_parentPanel.isCMReadOnlyJob()) {
            Workspace.getWorkspace().setStatusText(m_bundle.getString("PFDDNDADAPTER.CHANGEMANAGEDOBJECTONLY.txt"));
            Workspace.getWorkspace().setCursor(null);
            return false;
        }
        if (this.m_parentPanel.isJobPropertiesReadOnlyJob()) {
            Workspace.getWorkspace().setStatusText(m_bundle.getString("PFDDNDADAPTER.NONMODIFIABLE.txt"));
            Workspace.getWorkspace().setCursor(null);
            return false;
        }
        Workspace.getDefaultLogger().debug((Object)"creating pfd dnd store");
        this.m_newStore = storeToUse == null ? Workspace.getMdFactory().createObjectStore(mainStoreActiveJob.getObjectStore(), "PFDDnD Store: " + objectBeingDropped.getClass()) : (MdObjectStore)storeToUse;
        WAPFDNodeModel newNodeModel = null;
        if (objectBeingDropped instanceof CMetadata) {
            String strType = object.getCMetadataType();
            if (strType.compareTo("PhysicalTable") == 0) {
                if (!fCalledFromAPI) {
                    WAPFDTableNode.isValidLocation(this.m_newStore, objectAtDropLocation);
                }
                newNodeModel = new WAPFDTableNodeModel(this.m_parentPanel, (CMetadata)objectBeingDropped);
                newNodeModel.addNode(this.m_newStore, (CMetadata)objectBeingDropped);
                newNodeModel.handleLocation(this.m_newStore, objectAtDropLocation, affectedObjects, worktabletouse);
            } else if (strType.compareTo("ExternalTable") == 0) {
                MdObjectStore tempstore = Workspace.getMdFactory().createObjectStore(null, "External Table PFD Temporary Store");
                ExternalTable table = (ExternalTable)Workspace.getMdFactory().createComplexMetadataObject(tempstore, null, object);
                if (EFIDataModel.isLegacyEFIObject((ExternalTable)table)) {
                    tempstore.dispose();
                    throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_CANNOTDROPOLDSTYLEEFINODES.txt");
                }
                tempstore.dispose();
                WAPFDExternalTableNode.isValidLocation(this.m_newStore, objectAtDropLocation);
                newNodeModel = new WAPFDExternalTableNodeModel(this.m_parentPanel, (CMetadata)objectBeingDropped);
                ((WAPFDExternalTableNodeModel)newNodeModel).addNode(this.m_newStore, (CMetadata)objectBeingDropped);
                ((WAPFDExternalTableNodeModel)newNodeModel).handleLocation(this.m_newStore, objectAtDropLocation, affectedObjects);
            } else if (strType.compareTo("SASLibrary") == 0) {
                WAPFDSASLibraryNode.isValidLocation(this.m_newStore, objectAtDropLocation);
                newNodeModel = new WAPFDSASLibraryNodeModel(this.m_parentPanel, (CMetadata)objectBeingDropped);
                ((WAPFDSASLibraryNodeModel)newNodeModel).addNode(this.m_newStore, (CMetadata)objectBeingDropped);
                ((WAPFDSASLibraryNodeModel)newNodeModel).handleLocation(this.m_newStore, objectAtDropLocation, affectedObjects);
            } else if (strType.compareTo("Document") == 0) {
                newNodeModel = new WAPFDDocumentNodeModel(this.m_parentPanel, (CMetadata)objectBeingDropped);
                ((WAPFDDocumentNodeModel)newNodeModel).addNode(this.m_newStore, (CMetadata)objectBeingDropped, ((WAPFDNode)objectAtDropLocation).getWAPFDNodeModel());
            } else if (strType.compareTo("Job") == 0) {
                if (this.m_parentPanel.getActiveJob().getFQID().equalsIgnoreCase(object.getFQID())) {
                    throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_CANNOTDROPJOBONTOITSELF.txt");
                }
                WAPFDJobNode.isValidLocation(this.m_newStore, objectAtDropLocation);
                newNodeModel = new WAPFDJobNodeModel(this.m_parentPanel, (CMetadata)objectBeingDropped);
                ((WAPFDJobNodeModel)newNodeModel).addNode(this.m_newStore, (CMetadata)objectBeingDropped);
                ((WAPFDJobNodeModel)newNodeModel).handleLocation(this.m_newStore, objectAtDropLocation, affectedObjects);
            } else if (strType.compareTo("Transformation") == 0) {
                WAPFDInformationNode.isValidLocation(this.m_newStore, objectAtDropLocation);
                newNodeModel = new WAPFDInformationNodeModel(this.m_parentPanel, (CMetadata)objectBeingDropped);
                ((WAPFDInformationNodeModel)newNodeModel).addNode(this.m_newStore, (CMetadata)objectBeingDropped);
                ((WAPFDInformationNodeModel)newNodeModel).handleLocation(this.m_newStore, objectAtDropLocation, affectedObjects);
            } else if (strType.compareTo("Prototype") == 0) {
                MdObjectStore store = null;
                try {
                    boolean fSuccess;
                    store = Workspace.getMdFactory().createObjectStore();
                    Prototype prototype = (Prototype)Workspace.getMdFactory().createComplexMetadataObject(store, (CMetadata)objectBeingDropped);
                    Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)prototype, null, null, "", 8);
                    if (!MacroPluginUtilities.isGeneratedTransform((Root)prototype)) {
                        store.dispose();
                        store = null;
                        throw new PFDException("PFDEXCEPTION.INVALIDDROPLOCATION.txt");
                    }
                    AssociationList properties = prototype.getProperties();
                    String strGetXML = null;
                    for (int k = 0; k < properties.size(); ++k) {
                        Property property = (Property)properties.elementAt(k);
                        if (!property.getPropertyName().equalsIgnoreCase("GetXML")) continue;
                        TextStore storedText = (TextStore)property.getStoredConfiguration();
                        strGetXML = storedText.getStoredText();
                        if (strGetXML.length() != 0 && strGetXML.indexOf("PropertyName=\"Class\"") != -1) break;
                        if (store != null) {
                            store.dispose();
                            store = null;
                        }
                        boolean bl = false;
                        return bl;
                    }
                    MacroPlugin macro = new MacroPlugin((CMetadata)objectBeingDropped, strGetXML, GeneratedTransformationUtilities.getProcessTreePath((Root)prototype));
                    if (store != null) {
                        store.dispose();
                        store = null;
                    }
                    boolean bl = fSuccess = this.handleTransformInterfaceObjects(objectAtDropLocation, macro, affectedObjects, worktabletouse, fCalledFromAPI, storeToUse);
                    return bl;
                }
                finally {
                    if (store != null) {
                        store.dispose();
                        store = null;
                    }
                }
            }
        } else {
            return this.handleTransformInterfaceObjects(objectAtDropLocation, objectBeingDropped, affectedObjects, worktabletouse, fCalledFromAPI, storeToUse);
        }
        return true;
    }

    protected boolean handleTransformInterfaceObjects(PFDPrimitive objectAtDropLocation, Object objectBeingDropped, ArrayList affectedObjects, CMetadata worktabletouse, boolean fCalledFromAPI, MdStore storeToUse) throws PFDException, MdException, RemoteException {
        WAPFDTransformNodeModel newNodeModel = null;
        WAPFDTransformNode.isValidLocation(this.m_newStore, objectAtDropLocation, (TransformInterface)objectBeingDropped);
        boolean fContinue = true;
        fContinue = ((TransformInterface)objectBeingDropped).onBeforeDrop(this.m_newStore);
        if (!fContinue) {
            return false;
        }
        if (objectBeingDropped instanceof MacroPlugin && MacroPluginUtilities.isEditingGeneratedTransform()) {
            MessageUtil.displayMessage((String)m_bundle.getString("NoDropWhenEditing.txt"), (int)2);
            throw new PFDException("PFDEXCEPTION.PFDEXCEPTION_CANNOTDROPWHENEDITINGTRANSFORM.txt");
        }
        newNodeModel = objectBeingDropped instanceof TransformControlInterface ? new WAPFDTransformComputeNodeModel(this.m_parentPanel) : (objectBeingDropped instanceof TransformLoaderInterface ? new WAPFDTransformLoaderNodeModel(this.m_parentPanel) : new WAPFDTransformNodeModel(this.m_parentPanel));
        ((WAPFDTransformNodeModel)newNodeModel).addNode(this.m_newStore, (TransformInterface)objectBeingDropped);
        if (((WAPFDTransformNodeModel)newNodeModel).getMetadataObject(this.m_newStore) != null) {
            ((WAPFDTransformNodeModel)newNodeModel).addNodeModelToHashmap(((WAPFDTransformNodeModel)newNodeModel).getMetadataObject(this.m_newStore));
        }
        ((WAPFDTransformNodeModel)newNodeModel).handleLocation(this.m_newStore, objectAtDropLocation, affectedObjects);
        ((WAPFDTransformNodeModel)newNodeModel).addNodeModelToHashmap(((WAPFDTransformNodeModel)newNodeModel).getMetadataObject(this.m_newStore));
        return true;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
    }

    @Override
    public void dragExit(DropTargetEvent e) {
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
    }

    public void dropActionChanged(DropTargetEvent e) {
    }

    public boolean validateDropObject(CMetadata object, boolean fCalledFromAPI) {
        try {
            String strType = object.getCMetadataType();
            if (fCalledFromAPI && strType.compareTo("Document") == 0) {
                return true;
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return PFDDnDAdapter.validateDropObject(object);
    }

    public static boolean validateDropObject(CMetadata object) {
        try {
            String strType = object.getCMetadataType();
            if (strType.compareTo("PhysicalTable") == 0 || strType.compareTo("ExternalTable") == 0 || strType.compareTo("SASLibrary") == 0 || strType.compareTo("Job") == 0 || strType.compareTo("Prototype") == 0) {
                return true;
            }
            return strType.compareTo("Transformation") == 0;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
            return false;
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e) {
        if (e.getDropSuccess()) {
            // empty if block
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent e) {
        Workspace.getDefaultLogger().debug((Object)" dragEnter");
    }

    @Override
    public void dragExit(DragSourceEvent e) {
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
        Workspace.getDefaultLogger().debug((Object)"dragExit");
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent e) {
    }

    public boolean validateUnderChangeManagement(CMetadata object) {
        if (Workspace.getWorkspace().getChangeManagementState() == Workspace.CHANGEMANAGEMENT_OFF) {
            return true;
        }
        try {
            String projectReposID = Workspace.getWorkspace().getProjectRepository().getFQID();
            String lowerHalf = projectReposID.substring(9, 17);
            return object.getFQID().indexOf(lowerHalf) > -1;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
            return false;
        }
    }
}

