/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model.tree;

import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.transforms.GeneratedTransformModel;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.wadmin.model.tree.GeneratedTransformationTreeNode;
import com.sas.wadmin.model.tree.ITransformationTreeNode;
import com.sas.wadmin.plugins.TransformHiddenInterface;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.visuals.MacroPlugin;
import com.sas.wadmin.visuals.TransformManager;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDecoratableIcon;
import com.sas.workspace.metadata.GeneratedTransformationUtilities;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleBrowseObjectImpl;
import com.sas.workspace.models.tree.AbstractTreeModel;
import com.sas.workspace.models.tree.AbstractTreeNode;
import com.sas.workspace.models.tree.CategoryTreeNode;
import com.sas.workspace.models.tree.IDataTreeNode;
import com.sas.workspace.models.tree.ITransformationsTreeModel;
import com.sas.workspace.models.tree.ITreeModel;
import com.sas.workspace.models.tree.ITreeNode;
import java.awt.Cursor;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;

public class TransformationsTreeModel
extends AbstractTreeModel
implements ITransformationsTreeModel {
    private static final WAdminResource bundle = WAdminResource.getBundle(TransformationsTreeModel.class);
    private Map m_categoryNodesMap = new HashMap();
    private Map m_transformationNodesMap = new HashMap();

    public TransformationsTreeModel(UserContextInterface userContext) {
        super(userContext, null);
        cTransformationsRootNode transformationsRoot = new cTransformationsRootNode();
        transformationsRoot.setTreeModel((ITreeModel)this);
        this.setRoot((TreeNode)((Object)transformationsRoot));
    }

    public void addTransformation(TransformInterface transformation) {
        ITreeNode parentNode;
        if (transformation instanceof TransformHiddenInterface) {
            return;
        }
        ITransformationTreeNode newNode = (ITransformationTreeNode)this.createNode(transformation);
        if (newNode == null) {
            return;
        }
        String sCategory = newNode.getCategory();
        if (sCategory.equals("")) {
            sCategory = bundle.getString("TransformationsTreeModel.Ungrouped.txt");
        }
        if ((parentNode = (ITreeNode)this.m_categoryNodesMap.get(sCategory)) == null) {
            parentNode = this.addTransformationCategory(sCategory);
        }
        this.addChild((ITreeNode)newNode, parentNode);
        this.m_transformationNodesMap.put(transformation.getTransformClass(), newNode);
    }

    public void removeTransformation(TransformInterface transformation) {
        ITreeNode node = (ITreeNode)this.m_transformationNodesMap.get(transformation.getTransformClass());
        if (node == null) {
            return;
        }
        CategoryTreeNode parentNode = (CategoryTreeNode)node.getParent();
        this.removeChild(node);
        this.m_transformationNodesMap.remove(transformation.getTransformClass());
        if (parentNode.getChildCount() == 0) {
            this.removeTransformationCategory(parentNode);
        }
    }

    public boolean isValidParent(ITreeNode nodeParent, ITreeNode nodeChild) {
        if (nodeChild instanceof CategoryTreeNode) {
            return nodeParent.equals(this.getRoot());
        }
        if (nodeChild instanceof ITransformationTreeNode && nodeParent instanceof CategoryTreeNode) {
            String sCategory = ((ITransformationTreeNode)nodeChild).getCategory();
            return ((CategoryTreeNode)nodeParent).getUserObject().equals(sCategory);
        }
        return false;
    }

    public void addChildren(ITreeNode parentNode) {
    }

    public void addChild(IDataTreeNode nodeNew) {
        List lParentNodes = this.findParentNodes((SimpleBrowseObject)nodeNew.getData());
        if (lParentNodes.size() > 0) {
            this.addChild((ITreeNode)nodeNew, (ITreeNode)lParentNodes.get(0));
        }
    }

    public ITreeNode createNode(Object userObject) {
        if (userObject instanceof TransformInterface) {
            if (userObject instanceof MacroPlugin) {
                try {
                    CMetadata prototype = ((MacroPlugin)userObject).getPrototype();
                    Filter filter = new Filter("Id", 0, prototype.getFQID());
                    filter.setType(prototype.getCMetadataType());
                    filter.setOMRTemplate(m_browseFilter.getOMRTemplate());
                    filter.setOMRFlags(m_browseFilter.getOMRFlags() | 0x80 | 0x100 | 0x2000 | 0x4000);
                    List lBrowseObjects = Workspace.getWorkspace().getUserContext().getAuthServer().browseSearch((FilterInterface)filter);
                    if (lBrowseObjects.isEmpty()) {
                        return null;
                    }
                    BrowseMetadataInterface browseObj = (BrowseMetadataInterface)lBrowseObjects.get(0);
                    SimpleBrowseObjectImpl simpleObj = new SimpleBrowseObjectImpl(browseObj);
                    return new GeneratedTransformationTreeNode((SimpleBrowseObject)simpleObj, (TransformInterface)userObject);
                }
                catch (ServiceException ex) {
                    MessageUtil.displayServiceExceptionMessage((ServiceException)ex);
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                }
            }
            return new cTransformationTreeNode((TransformInterface)userObject);
        }
        return null;
    }

    public List findParentNodes(SimpleBrowseObject object) {
        ITransformationTreeNode node;
        String sCategory;
        CategoryTreeNode parentNode;
        ArrayList<CategoryTreeNode> lParentNodes = new ArrayList<CategoryTreeNode>(1);
        List lNodes = this.findNodes(object.getID());
        if (!lNodes.isEmpty() && (parentNode = (CategoryTreeNode)this.m_categoryNodesMap.get(sCategory = (node = (ITransformationTreeNode)lNodes.get(0)).getTransformation().getCategory())) != null) {
            lParentNodes.add(parentNode);
        }
        return lParentNodes;
    }

    public List findTransformationNodes(SimpleObject[] aSimpleObjects) {
        ArrayList<ITreeNode> lNodes = new ArrayList<ITreeNode>(aSimpleObjects.length);
        for (int i = 0; i < aSimpleObjects.length; ++i) {
            String sFQID;
            SimpleObject simpleObj = aSimpleObjects[i];
            if (simpleObj instanceof GeneratedTransformModel) {
                sFQID = ((GeneratedTransformModel)simpleObj).getTransformDefinition().getID();
                lNodes.addAll(this.findNodes(sFQID));
                continue;
            }
            if (simpleObj instanceof ITransform) {
                String sTransformClass = ((ITransform)simpleObj).getType();
                ITreeNode node = (ITreeNode)this.m_transformationNodesMap.get(sTransformClass);
                if (node == null) continue;
                lNodes.add(node);
                continue;
            }
            sFQID = simpleObj.getID();
            lNodes.addAll(this.findNodes(sFQID));
        }
        return lNodes;
    }

    public void refreshTransformations() {
        TransformManager.getInstance().loadGeneratedTransformations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCreatedObjects(Map objectsMap) {
        HashMap prototypesMap = new HashMap(objectsMap);
        Iterator iterEntry = prototypesMap.entrySet().iterator();
        while (iterEntry.hasNext()) {
            Map.Entry entry = iterEntry.next();
            if ("Prototype".equals(entry.getValue())) continue;
            iterEntry.remove();
        }
        if (prototypesMap.isEmpty()) {
            return;
        }
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "TransformationsTreeModel:addCreatedObjects");
            try {
                String sTemplate = "<Templates><Prototype Name=\"\" MetadataType=\"\" PublicType=\"\" /></Templates>";
                List lPrototypes = Workspace.getMdFactory().getOMIUtil().getMetadata((MdStore)store, prototypesMap, sTemplate, 4);
                TransformManager.getInstance().objectsCreated(lPrototypes);
            }
            finally {
                store.dispose();
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    protected void removeDeletedObjects(String[] aFQIDs) {
        for (int iFQID = 0; iFQID < aFQIDs.length; ++iFQID) {
            List lNodes = this.findNodes(aFQIDs[iFQID]);
            if (lNodes.isEmpty()) continue;
            TransformInterface transform = ((ITransformationTreeNode)lNodes.get(0)).getTransformation();
            TransformManager.getInstance().removeTransformation(transform);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateModifiedObjects(Map objectsMap) {
        HashMap prototypesMap = new HashMap(objectsMap);
        Iterator iterEntry = prototypesMap.entrySet().iterator();
        while (iterEntry.hasNext()) {
            Map.Entry entry = iterEntry.next();
            if ("Prototype".equals(entry.getValue())) continue;
            iterEntry.remove();
        }
        if (prototypesMap.isEmpty()) {
            return;
        }
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "TransformationsTreeModel:updateModifiedObjects");
            try {
                String sTemplate = "<Templates><Prototype Name=\"\" MetadataType=\"\" PublicType=\"\" /></Templates>";
                List lPrototypes = Workspace.getMdFactory().getOMIUtil().getMetadata((MdStore)store, prototypesMap, sTemplate, 4);
                TransformManager.getInstance().objectsModified(lPrototypes);
            }
            finally {
                store.dispose();
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private CategoryTreeNode addTransformationCategory(String sCategory) {
        cTransformationCategoryTreeNode categoryNode = new cTransformationCategoryTreeNode(sCategory);
        categoryNode.setCategoryObject(sCategory);
        categoryNode.setPopulated(true);
        this.addChild((ITreeNode)categoryNode, (ITreeNode)this.getRoot());
        this.m_categoryNodesMap.put(sCategory, categoryNode);
        return categoryNode;
    }

    private void removeTransformationCategory(CategoryTreeNode categoryNode) {
        this.removeChild((ITreeNode)categoryNode);
        this.m_categoryNodesMap.remove(categoryNode.getUserObject());
    }

    private String truncateCategory(String sCategory) {
        int iFirstDot = sCategory.indexOf(46);
        if (iFirstDot > -1) {
            sCategory = sCategory.substring(0, iFirstDot);
        }
        return sCategory;
    }

    private class cTransformationsRootNode
    extends AbstractTreeNode {
        public cTransformationsRootNode() {
            super((Object)"TransformationsRoot");
        }

        public Icon getIcon() {
            return null;
        }

        public boolean isFolder() {
            return true;
        }
    }

    private class cTransformationTreeNode
    extends AbstractTreeNode
    implements ITransformationTreeNode {
        private TransformInterface m_transformation;
        private Icon m_icon;

        public cTransformationTreeNode(TransformInterface transformation) {
            super((Object)transformation.getName(), false);
            this.setEditable(false);
            this.m_transformation = transformation;
            this.m_icon = transformation.getIcon();
            if (this.m_icon != null) {
                this.m_icon = new WsDecoratableIcon(this.m_icon);
            }
        }

        @Override
        public TransformInterface getTransformation() {
            return this.m_transformation;
        }

        @Override
        public String getCategory() {
            return TransformationsTreeModel.this.truncateCategory(this.m_transformation.getCategory());
        }

        public String getName() {
            return this.m_transformation.getName();
        }

        public Icon getIcon() {
            return this.m_icon;
        }

        public boolean isFolder() {
            return false;
        }

        public Object getData() {
            return this.m_transformation;
        }

        public String getID() {
            return this.m_transformation.getTransformClass();
        }

        public String getType() {
            return "JAVATransformation";
        }

        public boolean isValidName(String sNewName) {
            return false;
        }

        public boolean isRenameAllowed() {
            return false;
        }

        public void rename(String sNewName) {
            throw new UnsupportedOperationException("This node cannot be renamed.");
        }

        public boolean isDeleteAllowed() {
            return false;
        }

        public boolean delete() {
            throw new UnsupportedOperationException("This node cannot be deleted.");
        }

        public void update() {
        }
    }

    private class cTransformationCategoryTreeNode
    extends CategoryTreeNode {
        public cTransformationCategoryTreeNode(Object userObject) {
            super(userObject);
        }

        public boolean isValidDropTarget() {
            return true;
        }

        public boolean isValidDropTarget(Object[] aDraggedObjects) {
            for (int i = 0; i < aDraggedObjects.length; ++i) {
                if (!(aDraggedObjects[i] instanceof SimpleObject)) {
                    return false;
                }
                SimpleObject simpleObj = (SimpleObject)aDraggedObjects[i];
                if ("GeneratedTransform".equals(simpleObj.getPublicType())) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drop(Object[] aDroppedObjects) {
            try {
                Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
                MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "cTransformationCategoryTreeNode:drop");
                try {
                    for (int i = 0; i < aDroppedObjects.length; ++i) {
                        if (!(aDroppedObjects[i] instanceof SimpleObject)) continue;
                        SimpleObject simpleObj = (SimpleObject)aDroppedObjects[i];
                        Root mdObj = (Root)Workspace.getMdFactory().createComplexMetadataObject(store, simpleObj.getName(), simpleObj.getMetadataType(), simpleObj.getID());
                        GeneratedTransformationUtilities.setProcessTreePath((Root)mdObj, (String)this.getName());
                    }
                    store.updatedMetadataAll();
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                }
                finally {
                    store.dispose();
                    Workspace.getWorkspace().setCursor(null);
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }
}

