/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model.tree;

import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.wadmin.model.tree.DefaultLogicalObjectNode;
import com.sas.wadmin.visuals.ImpactAnalysisOMAView;
import com.sas.workspace.WAPropertyFrame;
import com.sas.workspace.WASplittablePropertyFrame;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceOMAView;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsOMAView;
import com.sas.workspace.WsViewFactory;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JPopupMenu;

public class MessageQueueNode
extends DefaultLogicalObjectNode {
    private static WAdminResource bundle = WAdminResource.getBundle(MessageQueueNode.class);
    private static WsAbstractAction s_actImpact = new ImpactAnalysisAction();
    private static WsAbstractAction s_actReverseImpact = new ReverseImpactAnalysisAction();
    private static MessageQueueNode s_nodeActive;

    public MessageQueueNode(LogicalObjectInterface lobData, Root mdoMesQueue) {
        super(lobData, mdoMesQueue);
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        s_nodeActive = bActive ? this : null;
        s_actImpact.setActive(bActive);
        s_actReverseImpact.setActive(bActive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void showImpactAnalysis(Root mdoPermanent, boolean bForward) {
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "MessageQueueNode:ImpactAnalysis");
            CMetadata detailsObject = Workspace.getMdFactory().createComplexMetadataObject(store, (CMetadata)mdoPermanent);
            ImpactAnalysisOMAView view = MessageQueueNode.findImpactAnalysisView((Transformation)detailsObject, bForward);
            if (view != null) {
                detailsObject.getObjectStore().dispose();
                WsViewFactory.showExistingView((WsOMAView)view);
                return;
            }
            view = new ImpactAnalysisOMAView((Transformation)detailsObject, bForward);
            WsViewFactory.attachViewToFrame((CMetadata)detailsObject, (WorkspaceOMAView)view, (WAPropertyFrame)new WASplittablePropertyFrame(detailsObject, ""));
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        finally {
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private static ImpactAnalysisOMAView findImpactAnalysisView(Transformation oTrans, boolean bForward) {
        try {
            ArrayList lViews = oTrans.getViewList();
            int nViews = lViews.size();
            for (int iView = 0; iView < nViews; ++iView) {
                ImpactAnalysisOMAView view;
                if (!lViews.get(iView).getClass().equals(ImpactAnalysisOMAView.class) || (view = (ImpactAnalysisOMAView)((Object)lViews.get(iView))).isForward() != bForward) continue;
                return view;
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return null;
    }

    public JPopupMenu getPopupMenu(WAdminResource bdl) {
        JPopupMenu menuPopup = super.getPopupMenu(bdl);
        menuPopup.addSeparator();
        menuPopup.add((Action)s_actImpact);
        menuPopup.add((Action)s_actReverseImpact);
        return menuPopup;
    }

    private static class ImpactAnalysisAction
    extends WsAbstractAction {
        public ImpactAnalysisAction() {
            super(bundle, "MessageQueueNode.Action.ImpactAnalysis", 2);
            this.setMenuSupportId("impactanalysis");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            if (s_nodeActive != null) {
                MessageQueueNode.showImpactAnalysis((Root)s_nodeActive.getMetadata(), true);
            }
        }
    }

    private static class ReverseImpactAnalysisAction
    extends WsAbstractAction {
        public ReverseImpactAnalysisAction() {
            super(bundle, "MessageQueueNode.Action.ReverseImpactAnalysis", 2);
            this.setMenuSupportId("reverseimpactanalysis");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            if (s_nodeActive != null) {
                MessageQueueNode.showImpactAnalysis((Root)s_nodeActive.getMetadata(), false);
            }
        }
    }
}

