/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model.tree;

import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalObject;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.MoveDisallowedCause;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.promotion.visuals.CopyPasteUtil;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.visuals.OperationUIAdapter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsLockManager;
import com.sas.workspace.WsMessageDisplayer;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleObjectImpl;
import com.sas.workspace.models.tree.DropTargetResult;
import com.sas.workspace.models.tree.IDataTreeNode2;
import com.sas.workspace.models.tree.SimpleBrowseObjectTreeNode;
import java.rmi.RemoteException;

public class LogicalBrowseObjectTreeNode
extends SimpleBrowseObjectTreeNode
implements IDataTreeNode2 {
    WAdminResource bundle = WAdminResource.getBundle(LogicalBrowseObjectTreeNode.class);

    public LogicalBrowseObjectTreeNode(SimpleBrowseObject browseObject) {
        super(browseObject);
    }

    protected LogicalObjectInterface getLogicalObject() {
        return this.getLogicalObject((SimpleObject)this.getSimpleBrowseObject());
    }

    protected LogicalObjectInterface getLogicalObject(SimpleObject simpleObj) {
        try {
            return ObjectConverter.getInstance().convertToLogicalObject(simpleObj);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return null;
    }

    public boolean isValidDropTarget() {
        return this.isFolder() && this.isEditable();
    }

    public boolean isValidDropTarget(Object[] aDraggedObjects) {
        return this.getIsValidDropTargetResult(aDraggedObjects).isValid();
    }

    public DropTargetResult getIsValidDropTargetResult(Object[] aDraggedObjects) {
        if (!this.isValidDropTarget()) {
            return DropTargetResult.INVALID;
        }
        LogicalObjectInterface target = this.getLogicalObject();
        if (!(target instanceof FolderInterface)) {
            return DropTargetResult.INVALID;
        }
        try {
            for (int i = 0; i < aDraggedObjects.length; ++i) {
                if (!(aDraggedObjects[i] instanceof SimpleObject)) {
                    return DropTargetResult.INVALID;
                }
                SimpleObject draggedObject = (SimpleObject)aDraggedObjects[i];
                LogicalObjectInterface logicalObject = this.getLogicalObject(draggedObject);
                if (logicalObject == null) {
                    return DropTargetResult.INVALID;
                }
                MoveDisallowedCause result = ((LogicalObject)logicalObject).checkMoveAllowed();
                if (result != null) {
                    return new DropTargetResult(false, result.toString());
                }
                result = ((LogicalObject)logicalObject).checkMoveAllowed((FolderInterface)target);
                if (result == null) continue;
                return new DropTargetResult(false, result.toString());
            }
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            return DropTargetResult.INVALID;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
            return DropTargetResult.INVALID;
        }
        return DropTargetResult.VALID;
    }

    public void drop(Object[] aDroppedObjects) {
        FolderInterface target = (FolderInterface)this.getLogicalObject();
        try {
            for (int i = 0; i < aDroppedObjects.length; ++i) {
                SimpleObject droppedObject;
                LogicalObjectInterface logicalObject;
                if (!(aDroppedObjects[i] instanceof SimpleObject) || (logicalObject = this.getLogicalObject(droppedObject = (SimpleObject)aDroppedObjects[i])) == null || target.getID().equals(logicalObject.getID())) continue;
                logicalObject.move(target);
            }
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public boolean isValidName(String sNewName) {
        try {
            LogicalObjectInterface logicalObject = this.getLogicalObject();
            if (logicalObject != null) {
                return logicalObject.isValidName(sNewName);
            }
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return false;
    }

    public boolean isRenameAllowed() {
        try {
            LogicalObjectInterface logicalObject = this.getLogicalObject();
            if (logicalObject != null) {
                return logicalObject.isRenameAllowed();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        return false;
    }

    public boolean isRenameAllowedMessage() {
        LogicalObjectInterface logicalObject = this.getLogicalObject();
        if (logicalObject == null) {
            return false;
        }
        if (logicalObject.getTypeInterface().getPublicType().equals("Job") && WsLockManager.getInstance().isLocked(logicalObject.getID())) {
            String sMessage = this.bundle.formatString("LogicalBrowseObjectTreeNode.Message.CannotRenameOpenJob.fmt.txt", (Object)logicalObject.getName());
            String sTitle = this.bundle.getString("LogicalBrowseObjectTreeNode.Message.CannotRenameOpenJob.Title.txt");
            MessageUtil.displayMessage((String)sMessage, (String)sTitle, (int)1);
            return false;
        }
        return true;
    }

    public void rename(String sNewName) {
        if (this.getName().equals(sNewName)) {
            return;
        }
        try {
            LogicalObjectInterface logicalObject = this.getLogicalObject();
            if (logicalObject != null) {
                OperationUIAdapter opUI = new OperationUIAdapter((WsMessageDisplayer)Workspace.getWorkspace().getStatusBar());
                logicalObject.rename(sNewName, (OperationUserInteractionInterface)opUI);
                WsMetadataUtil.updateModifiedByFor((SimpleObject)this.getSimpleBrowseObject());
            }
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public boolean isDeleteAllowed() {
        try {
            LogicalObjectInterface logicalObject = this.getLogicalObject();
            if (logicalObject != null) {
                return logicalObject.isDeleteAllowed();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        return false;
    }

    public boolean delete() {
        if (this.m_bDisposed) {
            return true;
        }
        try {
            OperationUIAdapter opUI;
            LogicalObjectInterface logicalObject = this.getLogicalObject();
            if (logicalObject != null && logicalObject.delete((OperationUserInteractionInterface)(opUI = new OperationUIAdapter((WsMessageDisplayer)Workspace.getWorkspace().getStatusBar())))) {
                CopyPasteUtil.removeItemFromCopyList((SimpleLogicalObjectInterface)logicalObject);
                String sChangeState = this.getSimpleBrowseObject().getChangeState();
                if (sChangeState != null && sChangeState.toUpperCase().startsWith("CHECKOUT")) {
                    String strCSId = sChangeState.substring(sChangeState.indexOf(":") + 2);
                    SimpleObjectImpl simplePrimaryObject = new SimpleObjectImpl("", strCSId, logicalObject.getTypeInterface().getMetadataType(), logicalObject.getTypeInterface().getPublicType());
                    LogicalObjectInterface logicalPrimaryObject = this.getLogicalObject((SimpleObject)simplePrimaryObject);
                    CopyPasteUtil.removeItemFromCopyList((SimpleLogicalObjectInterface)logicalPrimaryObject);
                }
                return true;
            }
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return false;
    }
}

