/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model.tree;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.model.tree.AbstractListenerTreeModel;
import com.sas.wadmin.model.tree.DefaultInventoryNodeFactory;
import com.sas.wadmin.model.tree.DefaultRootNode;
import com.sas.wadmin.model.tree.InventoryFolderNode;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDataTreeNode;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.tree.WsNodeFactory;
import com.sas.workspace.tree.WsNodeFilter;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class InventoryTreeModel
extends AbstractListenerTreeModel {
    public InventoryTreeModel() {
        this(new DefaultRootNode(), null);
    }

    public InventoryTreeModel(WsTreeNode nodeRoot) {
        this(nodeRoot, null);
    }

    public InventoryTreeModel(WsNodeFactory factory) {
        this(new DefaultRootNode(), factory);
    }

    public InventoryTreeModel(WsTreeNode nodeRoot, WsNodeFactory factory) {
        super(nodeRoot);
        this.setListenForChanges(false);
        if (factory == null) {
            factory = this.createDefaultNodeFactory();
        }
        this.setNodeFactory(factory);
        this.setRepositories(this.createDefaultRepositoryList());
    }

    protected WsNodeFactory createDefaultNodeFactory() {
        return new DefaultInventoryNodeFactory();
    }

    @Override
    protected void updateCreatedObjects(AbstractListenerTreeModel.BasicObject[] aBasicObjects) {
        this.updateChangedObjects(aBasicObjects);
    }

    @Override
    protected void updateCheckedInObjects(AbstractListenerTreeModel.BasicObject[] aBasicObjects) {
        this.updateChangedObjects(aBasicObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateChangedObjects(AbstractListenerTreeModel.BasicObject[] aBasicObjects) {
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "InventoryTreeModel:updateChangedObjects");
            try {
                this.populateStore(store, aBasicObjects);
                for (int iBasicObject = 0; iBasicObject < aBasicObjects.length; ++iBasicObject) {
                    String sFQID = aBasicObjects[iBasicObject].getFQID();
                    Root mdo = (Root)store.getObject(sFQID);
                    ArrayList lNodes = this.findNodes("A0000001." + sFQID.substring(0, 8));
                    if (lNodes.isEmpty()) continue;
                    WsTreeNode nodeRepository = (WsTreeNode)lNodes.get(0);
                    for (int iFolder = 0; iFolder < nodeRepository.getChildCount(); ++iFolder) {
                        WsTreeNode nodeFolder = (WsTreeNode)nodeRepository.getChildAt(iFolder);
                        if (!nodeFolder.hasExpanded()) continue;
                        if (((InventoryFolderNode)nodeFolder).isValidMember(mdo)) {
                            this.addOrUpdateNode(nodeFolder, mdo);
                        }
                        if (!nodeFolder.isValidAncestorFor((CMetadata)mdo)) continue;
                        this.updateGrandChildren(nodeFolder, mdo);
                    }
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private void updateGrandChildren(WsTreeNode nodeFolder, Root mdo) throws MdException, RemoteException {
        for (int iChild = 0; iChild < nodeFolder.getChildCount(); ++iChild) {
            WsTreeNode nodeChild = (WsTreeNode)nodeFolder.getChildAt(iChild);
            if (!nodeChild.hasExpanded()) continue;
            if (nodeChild.isValidParentFor((CMetadata)mdo)) {
                this.addOrUpdateNode(nodeChild, mdo);
                continue;
            }
            WsDataTreeNode node = this.findInChildren(nodeChild, mdo.getFQID());
            if (node == null) continue;
            this.removeChild((WsTreeNode)node);
        }
    }

    private void addOrUpdateNode(WsTreeNode nodeParent, Root mdo) throws MdException, RemoteException {
        WsDataTreeNode node = this.findInChildren(nodeParent, mdo.getFQID());
        if (node == null) {
            WsNodeFilter filter = this.getNodeFilter();
            if (filter == null || filter.accept(mdo, nodeParent)) {
                node = this.getNodeFactory().createObjectNode(mdo, nodeParent);
                this.addChild((WsTreeNode)node, nodeParent);
            }
        } else {
            node.updateMetadata((CMetadata)mdo);
        }
    }

    private void populateStore(MdObjectStore store, AbstractListenerTreeModel.BasicObject[] aBasicObjects) throws MdException, RemoteException {
        StringBuffer sbXML = new StringBuffer();
        int fFlags = 256;
        for (int iBasicObject = 0; iBasicObject < aBasicObjects.length; ++iBasicObject) {
            AbstractListenerTreeModel.BasicObject basic = aBasicObjects[iBasicObject];
            if (basic == null) continue;
            String sType = basic.getType();
            sbXML.append("<");
            sbXML.append(sType);
            sbXML.append(" Id=\"");
            sbXML.append(basic.getFQID());
            sbXML.append("\" Name=\"\" ChangeState=\"\" LockedBy = \"\" PublicType=\"\" >");
            sbXML.append("</");
            sbXML.append(sType);
            sbXML.append(">");
        }
        Workspace.getMdFactory().getOMIUtil().getMetadataObjects((MdStore)store, sbXML.toString(), "", fFlags);
    }
}

