/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model.tree;

import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.model.tree.AbstractInventoryFolderNode;
import com.sas.wadmin.model.tree.InventoryNodeFactory;
import com.sas.wadmin.visuals.NewObjectWizard;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class InventoryLogicalObjectsFolderNode
extends AbstractInventoryFolderNode {
    private static WAdminResource bundle = WAdminResource.getBundle(InventoryLogicalObjectsFolderNode.class);
    private TypeInterface m_type;
    private WsAbstractAction m_actNew;

    public InventoryLogicalObjectsFolderNode(TypeInterface type, String sRepositoryFQID) {
        super(type.getDisplayType(), sRepositoryFQID);
        this.m_type = type;
        this.m_actNew = this.createNewAction();
    }

    @Override
    public boolean isValidMember(Root mdo) {
        try {
            if (mdo instanceof PrimaryType) {
                return this.m_type.getPublicType().equals(((PrimaryType)mdo).getPublicType());
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return false;
    }

    public void addChildren() {
        InventoryNodeFactory factory = (InventoryNodeFactory)this.getTreeModel().getNodeFactory();
        try {
            List lObjects = this.m_type.getObjectFactory().getAllObjects(this.getRepositoryFQID());
            for (int iObject = 0; iObject < lObjects.size(); ++iObject) {
                LogicalObjectInterface lob = (LogicalObjectInterface)lObjects.get(iObject);
                this.addChild(factory.createObjectNode(lob, this));
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        this.m_actNew.setActive(bActive);
    }

    public JPopupMenu getPopupMenu(WAdminResource abundle) {
        JPopupMenu menuPopup = super.getPopupMenu(abundle);
        menuPopup.add(new JMenuItem((Action)this.m_actNew));
        return menuPopup;
    }

    private void onNew() {
        new NewObjectWizard((Frame)Workspace.getWorkspace(), bundle.getString("InventoryLogicalObjectsFolderNode.NewObjectWizard.Title.txt"), this.m_type.getMetadataType(), "");
    }

    protected WsAbstractAction createNewAction() {
        return new NewAction();
    }

    private class NewAction
    extends WsAbstractAction {
        public NewAction() {
            super(bundle, "InventoryLogicalObjectsFolderNode.Action.New", 258);
            this.setMenuSupportId("new");
            this.setEnabled(NewObjectWizard.isTypeSupported(InventoryLogicalObjectsFolderNode.this.m_type.getMetadataType()));
        }

        public void actionPerformed(ActionEvent e) {
            InventoryLogicalObjectsFolderNode.this.onNew();
        }
    }
}

