/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model.tree;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.model.tree.CustomTreeModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDataTreeNode;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.tree.WsNodeFactory;
import com.sas.workspace.tree.WsNodeFilter;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JPopupMenu;

public class DefaultRepositoryFolderNode
extends WsDataTreeNode {
    private static WAdminResource bundle = WAdminResource.getBundle(DefaultRepositoryFolderNode.class);

    public DefaultRepositoryFolderNode(Root mdoRepository) {
        super((CMetadata)mdoRepository);
        this.setRenameable(false);
        this.setDeleteable(false);
        this.setDragSource(false);
    }

    public Root getRepository() {
        return (Root)this.getMetadata();
    }

    public void doDefaultAction() {
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
    }

    public JPopupMenu getPopupMenu(WAdminResource aBundle) {
        return new JPopupMenu();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildren() {
        CustomTreeModel model = (CustomTreeModel)this.getTreeModel();
        WsNodeFilter filter = model.getNodeFilter();
        WsNodeFactory factory = model.getNodeFactory();
        String sFQID = this.getFQID();
        try {
            if (model.isReportingUnconvertedRepositories()) {
                if (!CustomTreeModel.isConvertedRepository(this.getFQID())) {
                    Workspace wksp = Workspace.getWorkspace();
                    String sTitle = bundle.getString("DefaultRepositoryFolderNode.Warning.UnconvertedRepository.Title.txt");
                    String sMessage = bundle.formatString("DefaultRepositoryFolderNode.Warning.UnconvertedRepository.fmt.txt", (Object)this.getName(), (Object)wksp.getApplicationName(), (Object)new Double(wksp.getApplicationVersionNumber()));
                    MessageUtil.displayMessage((String)sMessage, (String)sTitle, (int)2);
                }
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            return;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        MdObjectStore store = model.acquireStore();
        try {
            List lRootFolders = model.getRootFolders(sFQID, store);
            for (int iRootFolder = 0; iRootFolder < lRootFolders.size(); ++iRootFolder) {
                WsTreeNode nodeRootFolder;
                Root mdoRootFolder = (Root)lRootFolders.get(iRootFolder);
                if (filter != null && !filter.accept(mdoRootFolder, (WsTreeNode)this) || (nodeRootFolder = factory.createRootFolderNode(mdoRootFolder, (WsTreeNode)this)) == null) continue;
                this.addChild(nodeRootFolder);
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        finally {
            model.disposeStore(store);
        }
    }
}

