/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.model.tree;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.model.tree.DefaultFolderNode;
import com.sas.wadmin.model.tree.DefaultLogicalObjectNode;
import com.sas.wadmin.model.tree.DefaultRepositoryFolderNode;
import com.sas.wadmin.model.tree.GeneratedTransformNode;
import com.sas.wadmin.model.tree.MessageQueueNode;
import com.sas.wadmin.model.tree.RootFolderNode;
import com.sas.wadmin.model.tree.TempLogicalObjectNode;
import com.sas.wadmin.model.tree.UnknownTypeNode;
import com.sas.wadmin.visuals.DocumentTreeNode;
import com.sas.wadmin.visuals.ExternalTableTreeNode;
import com.sas.wadmin.visuals.JobTreeNode;
import com.sas.wadmin.visuals.NoteTreeNode;
import com.sas.wadmin.visuals.PhysicalTableTreeNode;
import com.sas.wadmin.visuals.SASLibraryTreeNode;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.plugins.TreeNodeInterface;
import com.sas.workspace.tree.WsNodeFactory;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class DefaultNodeFactory
implements WsNodeFactory {
    private boolean m_bPluginsEnabled = true;
    private boolean m_bCreateTypeNodes = false;

    public void setPluginsEnabled(boolean bEnabled) {
        this.m_bPluginsEnabled = bEnabled;
    }

    public boolean isPluginsEnabled() {
        return this.m_bPluginsEnabled;
    }

    public void setCreateTypeNodes(boolean bCreate) {
        this.m_bCreateTypeNodes = bCreate;
    }

    public boolean isCreateTypeNodes() {
        return this.m_bCreateTypeNodes;
    }

    public WsTreeNode createRepositoryFolderNode(Root mdo, WsTreeNode nodeParent) {
        return new DefaultRepositoryFolderNode(mdo);
    }

    public WsTreeNode createRootFolderNode(Root mdoRootFolder, WsTreeNode nodeParent) throws MdException, RemoteException {
        try {
            LogicalObjectInterface lob = Factory.getInstance().getObject(mdoRootFolder);
            mdoRootFolder = nodeParent.getTreeModel().acquirePermanentObject(mdoRootFolder);
            return new RootFolderNode((FolderInterface)lob, mdoRootFolder);
        }
        catch (LogicalTypeException ex) {
            throw new MdException(ex.getMessage());
        }
    }

    public WsTreeNode createFolderNode(Root mdoFolder, WsTreeNode nodeParent) throws MdException, RemoteException {
        try {
            LogicalObjectInterface lob = Factory.getInstance().getObject(mdoFolder);
            mdoFolder = nodeParent.getTreeModel().acquirePermanentObject(mdoFolder);
            return new DefaultFolderNode((FolderInterface)lob, mdoFolder);
        }
        catch (LogicalTypeException ex) {
            throw new MdException(ex.getMessage());
        }
    }

    public WsTreeNode createObjectNode(LogicalObjectInterface lobData, WsTreeNode nodeParent) throws MdException, RemoteException {
        String sType = lobData.getTypeInterface().getMetadataType();
        String sName = lobData.getName();
        String sFQID = lobData.getID();
        String sChangeState = lobData.getAttributeValue("ChangeState");
        String sLockedBy = lobData.getAttributeValue("LockedBy");
        Root mdoPermanent = nodeParent.getTreeModel().acquirePermanentObject(sName, sType, sFQID, sChangeState, sLockedBy);
        return this.createObjectNode(lobData, mdoPermanent, nodeParent);
    }

    public WsTreeNode createObjectNode(Root mdo, WsTreeNode nodeParent) throws MdException, RemoteException {
        Root mdoPermanent = nodeParent.getTreeModel().acquirePermanentObject(mdo);
        return this.createObjectNode(this.createLogicalObject(mdo), mdoPermanent, nodeParent);
    }

    private WsTreeNode createObjectNode(LogicalObjectInterface lobData, Root mdoPermanent, WsTreeNode nodeParent) throws MdException, RemoteException {
        Object node = this.createNodeUsingPlugins(mdoPermanent);
        if (node == null) {
            node = lobData != null ? this.createTypeNode(lobData, mdoPermanent) : new UnknownTypeNode((CMetadata)mdoPermanent);
        }
        node.setAllowsChildren(false);
        return node;
    }

    private LogicalObjectInterface createLogicalObject(Root mdo) throws MdException, RemoteException {
        try {
            return Factory.getInstance().getObject(mdo);
        }
        catch (LogicalTypeException ex) {
            throw new MdException(ex.getMessage());
        }
    }

    private WsTreeNode createNodeUsingPlugins(Root mdoPermanent) throws MdException, RemoteException {
        if (!this.m_bPluginsEnabled) {
            return null;
        }
        try {
            String sType = mdoPermanent.getCMetadataType();
            ArrayList lPlugins = Workspace.getWorkspace().getPluginLoader().getPlugins("com.sas.workspace.plugins.TreeNodeInterface");
            for (int iPlugin = 0; iPlugin < lPlugins.size(); ++iPlugin) {
                TreeNodeInterface plugin = (TreeNodeInterface)lPlugins.get(iPlugin);
                String sPluginType = plugin.getCMetadataType();
                if (!sType.equals(sPluginType)) continue;
                return plugin.getDataTreeNode((CMetadata)mdoPermanent);
            }
        }
        catch (Exception ex) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
        }
        return null;
    }

    private WsTreeNode createTypeNode(LogicalObjectInterface lobData, Root mdoPermanent) {
        TempLogicalObjectNode node;
        if (!this.m_bCreateTypeNodes) {
            return new DefaultLogicalObjectNode(lobData, mdoPermanent);
        }
        String sPublicType = lobData.getTypeInterface().getPublicType();
        if (sPublicType.equals("GeneratedTransform")) {
            return new GeneratedTransformNode(lobData, mdoPermanent);
        }
        if (sPublicType.equals("Note")) {
            return new NoteTreeNode(lobData, mdoPermanent);
        }
        if (sPublicType.equals("Folder")) {
            FolderInterface folder = (FolderInterface)lobData;
            if (folder.isTopLevel()) {
                return new RootFolderNode(folder, mdoPermanent);
            }
            return new DefaultFolderNode(folder, mdoPermanent);
        }
        if (sPublicType.equals("MessageQueue")) {
            return new MessageQueueNode(lobData, mdoPermanent);
        }
        if (sPublicType.equals("Document")) {
            node = new DocumentTreeNode((CMetadata)mdoPermanent);
        } else if (sPublicType.equals("ExternalFile")) {
            node = new ExternalTableTreeNode((CMetadata)mdoPermanent);
        } else if (sPublicType.equals("Job")) {
            node = new JobTreeNode((CMetadata)mdoPermanent);
        } else if (sPublicType.equals("Table")) {
            node = new PhysicalTableTreeNode(mdoPermanent);
        } else if (sPublicType.equals("Library")) {
            node = new SASLibraryTreeNode((CMetadata)mdoPermanent);
        } else {
            return new DefaultLogicalObjectNode(lobData, mdoPermanent);
        }
        node.setLogicalObject(lobData);
        return node;
    }
}

